/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathExpressionList;
import com.klg.jclass.util.formulae.MathMatrix;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.MathVector;
import com.klg.jclass.util.formulae.OperandMismatchException;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.Result;
import java.util.Iterator;

public class Multiply
extends Operation {
    public Multiply() {
    }

    public Multiply(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Multiply(Expression expression, Number number) {
        super(expression, number);
    }

    public Multiply(Number number, Expression expression) {
        super(number, expression);
    }

    public Multiply(Number number, Number number2) {
        super(number, number2);
    }

    private MathValue doMultiply(MathValue mathValue, MathValue mathValue2) {
        if (mathValue instanceof MathScalar && mathValue2 instanceof MathScalar) {
            MathScalar mathScalar = (MathScalar)mathValue;
            MathScalar mathScalar2 = (MathScalar)mathValue2;
            Number number = this.multiplySimple(mathScalar.realValue, mathScalar2.realValue);
            return new MathScalar(number);
        }
        if (mathValue instanceof MathVector && mathValue2 instanceof MathScalar || mathValue instanceof MathScalar && mathValue2 instanceof MathVector) {
            MathVector mathVector;
            MathScalar mathScalar;
            if (mathValue instanceof MathVector) {
                mathScalar = (MathScalar)mathValue;
                mathVector = (MathVector)mathValue2;
            } else {
                mathScalar = (MathScalar)mathValue2;
                mathVector = (MathVector)mathValue;
            }
            Number[] numberArray = new Number[mathVector.size];
            int n = 0;
            while (n < mathVector.size) {
                numberArray[n] = this.multiplySimple(mathVector.realValues[n], mathScalar.realValue);
                ++n;
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathMatrix && mathValue2 instanceof MathScalar) {
            MathMatrix mathMatrix;
            MathScalar mathScalar;
            if (mathValue instanceof MathVector) {
                mathScalar = (MathScalar)mathValue;
                mathMatrix = (MathMatrix)mathValue2;
            } else {
                mathScalar = (MathScalar)mathValue2;
                mathMatrix = (MathMatrix)mathValue;
            }
            Number[][] numberArray = new Number[mathMatrix.rows][mathMatrix.columns];
            int n = 0;
            while (n < mathMatrix.rows) {
                int n2 = 0;
                while (n2 < mathMatrix.columns) {
                    numberArray[n][n2] = this.multiplySimple(mathMatrix.realValues[n][n2], mathScalar.realValue);
                    ++n2;
                }
                ++n;
            }
            return new MathMatrix(numberArray);
        }
        if (mathValue instanceof MathVector && mathValue2 instanceof MathVector) {
            MathVector mathVector = (MathVector)mathValue;
            MathVector mathVector2 = (MathVector)mathValue2;
            if (mathVector.size != mathVector2.size) {
                throw new OperandMismatchException("Cannot compute the dot product of different-sized vectors");
            }
            Number number = new Integer(0);
            int n = 0;
            while (n < mathVector.size) {
                number = this.sum(number, this.multiplySimple(mathVector.realValues[n], mathVector2.realValues[n]));
                ++n;
            }
            return new MathScalar(number);
        }
        if (mathValue instanceof MathVector && mathValue2 instanceof MathMatrix) {
            MathVector mathVector = (MathVector)mathValue;
            MathMatrix mathMatrix = (MathMatrix)mathValue2;
            if (mathVector.size != mathMatrix.rows) {
                throw new OperandMismatchException("Vector and matrix sizes do not match");
            }
            Number[] numberArray = new Number[mathMatrix.columns];
            int n = 0;
            while (n < mathMatrix.columns) {
                numberArray[n] = new Integer(0);
                int n3 = 0;
                while (n3 < mathVector.size) {
                    numberArray[n] = this.sum(numberArray[n], this.multiplySimple(mathVector.realValues[n3], mathMatrix.realValues[n3][n]));
                    ++n3;
                }
                ++n;
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathMatrix && mathValue2 instanceof MathVector) {
            MathMatrix mathMatrix = (MathMatrix)mathValue;
            MathVector mathVector = (MathVector)mathValue2;
            if (mathVector.size != mathMatrix.columns) {
                throw new OperandMismatchException("Vector and matrix sizes do not match");
            }
            Number[] numberArray = new Number[mathMatrix.rows];
            int n = 0;
            while (n < mathMatrix.rows) {
                numberArray[n] = new Integer(0);
                int n4 = 0;
                while (n4 < mathVector.size) {
                    numberArray[n] = this.sum(numberArray[n], this.multiplySimple(mathMatrix.realValues[n][n4], mathVector.realValues[n4]));
                    ++n4;
                }
                ++n;
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathMatrix && mathValue2 instanceof MathMatrix) {
            MathMatrix mathMatrix = (MathMatrix)mathValue;
            MathMatrix mathMatrix2 = (MathMatrix)mathValue2;
            if (mathMatrix.columns != mathMatrix2.rows) {
                throw new OperandMismatchException("Cannot multiply matrices of non-complementary sizes");
            }
            Number[][] numberArray = new Number[mathMatrix.rows][mathMatrix2.columns];
            int n = 0;
            while (n < mathMatrix.rows) {
                int n5 = 0;
                while (n5 < mathMatrix2.columns) {
                    numberArray[n][n5] = this.multiplySimple(mathMatrix.realValues[n][n5], mathMatrix2.realValues[n][n5]);
                    numberArray[n][n5] = new Integer(0);
                    int n6 = 0;
                    while (n6 < mathMatrix.columns) {
                        numberArray[n][n5] = this.sum(numberArray[n][n5], this.multiplySimple(mathMatrix.realValues[n][n6], mathMatrix2.realValues[n6][n5]));
                        ++n6;
                    }
                    ++n5;
                }
                ++n;
            }
            return new MathMatrix(numberArray);
        }
        throw new OperandMismatchException("Cannot multiply the given data types");
    }

    public Result evaluate() {
        if (this.leftOperand == null && this.rightOperand == null) {
            throw new IllegalArgumentException("Multiplication is not defined on zero operands");
        }
        if (this.leftOperand == null) {
            return this.rightOperand.evaluate();
        }
        if (this.rightOperand == null) {
            return this.leftOperand.evaluate();
        }
        return this.getResult(this.leftOperand, this.rightOperand);
    }

    private Result getResult(Expression expression, Expression expression2) {
        if (expression instanceof Operation || expression instanceof ExpressionReference) {
            expression = expression.evaluate();
        }
        if (expression2 instanceof Operation || expression2 instanceof ExpressionReference) {
            expression2 = expression2.evaluate();
        }
        if (expression instanceof MathValue && expression2 instanceof MathValue) {
            MathValue mathValue = (MathValue)expression;
            MathValue mathValue2 = (MathValue)expression2;
            return this.doMultiply(mathValue, mathValue2);
        }
        if (expression instanceof ExpressionList && expression2 instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expression;
            ExpressionList expressionList2 = (ExpressionList)expression2;
            if (expressionList.size() != expressionList2.size()) {
                throw new OperandMismatchException("Cannot multiply lists of different sizes");
            }
            Iterator iterator = expressionList.iterator();
            Iterator iterator2 = expressionList2.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression3 = (Expression)iterator.next();
                Expression expression4 = (Expression)iterator2.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression3, expression4));
            }
            return mathExpressionList;
        }
        if (expression instanceof MathValue && expression2 instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expression2;
            Iterator iterator = expressionList.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression5 = (Expression)iterator.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression, expression5));
            }
            return mathExpressionList;
        }
        if (expression instanceof ExpressionList && expression2 instanceof MathValue) {
            ExpressionList expressionList = (ExpressionList)expression;
            Iterator iterator = expressionList.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression6 = (Expression)iterator.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression6, expression2));
            }
            return mathExpressionList;
        }
        throw new OperandMismatchException("Cannot multiply given data types");
    }

    private Number multiplySimple(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return new Double(number.doubleValue() * number2.doubleValue());
        }
        return new Integer(number.intValue() * number2.intValue());
    }

    private Number sum(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return new Double(number.doubleValue() + number2.doubleValue());
        }
        return new Integer(number.intValue() + number2.intValue());
    }
}

