/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.ExpressionList;
import com.klg.jclass.util.formulae.ExpressionReference;
import com.klg.jclass.util.formulae.MathExpressionList;
import com.klg.jclass.util.formulae.MathMatrix;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;
import com.klg.jclass.util.formulae.MathVector;
import com.klg.jclass.util.formulae.Multiply;
import com.klg.jclass.util.formulae.OperandMismatchException;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.Result;
import java.util.Iterator;

public class Subtract
extends Operation {
    public Subtract(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public Subtract(Expression expression, Number number) {
        super(expression, number);
    }

    public Subtract(Number number, Expression expression) {
        super(number, expression);
    }

    public Subtract(Number number, Number number2) {
        super(number, number2);
    }

    private MathValue doDifference(MathValue mathValue, MathValue mathValue2) {
        if (mathValue instanceof MathScalar && mathValue2 instanceof MathScalar) {
            MathScalar mathScalar = (MathScalar)mathValue;
            MathScalar mathScalar2 = (MathScalar)mathValue2;
            Number number = this.subtractSimple(mathScalar.realValue, mathScalar2.realValue);
            return new MathScalar(number);
        }
        if (mathValue instanceof MathVector && mathValue2 instanceof MathVector) {
            MathVector mathVector = (MathVector)mathValue;
            MathVector mathVector2 = (MathVector)mathValue2;
            if (mathVector.size != mathVector2.size) {
                throw new OperandMismatchException("Cannot subtract different-sized vectors");
            }
            Number[] numberArray = new Number[mathVector.size];
            int n = 0;
            while (n < mathVector.size) {
                numberArray[n] = this.subtractSimple(mathVector.realValues[n], mathVector2.realValues[n]);
                ++n;
            }
            return new MathVector(numberArray);
        }
        if (mathValue instanceof MathMatrix && mathValue2 instanceof MathMatrix) {
            MathMatrix mathMatrix = (MathMatrix)mathValue;
            MathMatrix mathMatrix2 = (MathMatrix)mathValue2;
            if (mathMatrix.rows != mathMatrix2.rows || mathMatrix.columns != mathMatrix2.columns) {
                throw new OperandMismatchException("Cannot subtract different-sized matrices");
            }
            Number[][] numberArray = new Number[mathMatrix.rows][mathMatrix.columns];
            int n = 0;
            while (n < mathMatrix.rows) {
                int n2 = 0;
                while (n2 < mathMatrix.columns) {
                    numberArray[n][n2] = this.subtractSimple(mathMatrix.realValues[n][n2], mathMatrix2.realValues[n][n2]);
                    ++n2;
                }
                ++n;
            }
            return new MathMatrix(numberArray);
        }
        throw new OperandMismatchException("Cannot subtract differently-dimensioned data types");
    }

    public Result evaluate() {
        if (this.leftOperand == null && this.rightOperand == null) {
            throw new IllegalArgumentException("Subtraction is not defined on zero operands");
        }
        if (this.leftOperand == null) {
            Multiply multiply = new Multiply((Expression)new MathScalar(new Integer(-1)), this.rightOperand);
            return ((Operation)multiply).evaluate();
        }
        if (this.rightOperand == null) {
            Multiply multiply = new Multiply((Expression)new MathScalar(new Integer(-1)), this.leftOperand);
            return ((Operation)multiply).evaluate();
        }
        return this.getResult(this.leftOperand, this.rightOperand);
    }

    private Result getResult(Expression expression, Expression expression2) {
        if (expression instanceof Operation || expression instanceof ExpressionReference) {
            expression = expression.evaluate();
        }
        if (expression2 instanceof Operation || expression2 instanceof ExpressionReference) {
            expression2 = expression2.evaluate();
        }
        if (expression instanceof MathValue && expression2 instanceof MathValue) {
            MathValue mathValue = (MathValue)expression;
            MathValue mathValue2 = (MathValue)expression2;
            return this.doDifference(mathValue, mathValue2);
        }
        if (expression instanceof ExpressionList && expression2 instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expression;
            ExpressionList expressionList2 = (ExpressionList)expression2;
            if (expressionList.size() != expressionList2.size()) {
                throw new OperandMismatchException("Cannot subtract lists of different sizes");
            }
            Iterator iterator = expressionList.iterator();
            Iterator iterator2 = expressionList2.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression3 = (Expression)iterator.next();
                Expression expression4 = (Expression)iterator2.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression3, expression4));
            }
            return mathExpressionList;
        }
        if (expression instanceof MathValue && expression2 instanceof ExpressionList) {
            ExpressionList expressionList = (ExpressionList)expression2;
            Iterator iterator = expressionList.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression5 = (Expression)iterator.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression, expression5));
            }
            return mathExpressionList;
        }
        if (expression instanceof ExpressionList && expression2 instanceof MathValue) {
            ExpressionList expressionList = (ExpressionList)expression;
            Iterator iterator = expressionList.iterator();
            MathExpressionList mathExpressionList = new MathExpressionList();
            while (iterator.hasNext()) {
                Expression expression6 = (Expression)iterator.next();
                ((ExpressionList)mathExpressionList).add(this.getResult(expression6, expression2));
            }
            return mathExpressionList;
        }
        throw new OperandMismatchException("Cannot subtract given data types");
    }

    private Number subtractSimple(Number number, Number number2) {
        if (number instanceof Double || number2 instanceof Double) {
            return new Double(number.doubleValue() - number2.doubleValue());
        }
        return new Integer(number.intValue() - number2.intValue());
    }
}

