/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.control.ColorChooserDialog;
import com.borland.jbcl.control.Res;
import com.borland.jbcl.util.ActionMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.Serializable;

public class ColorChooser
implements WindowListener,
Serializable {
    public static final int OK = 1;
    public static final int CANCEL = 8;
    protected transient ActionMulticaster actionMulticaster = new ActionMulticaster();
    protected ColorChooserDialog dialog;
    protected Frame frame;
    protected String title;
    protected Color value;
    protected Component focus;
    protected int result;

    public ColorChooser(Frame frame, String title, Color value) {
        this.frame = frame;
        this.title = title;
        this.value = value;
        if (frame != null) {
            this.dialog = new ColorChooserDialog(frame, title, value);
        }
    }

    public ColorChooser(Frame frame, String title) {
        this(frame, title, null);
    }

    public ColorChooser(Frame frame) {
        this(frame, "", null);
    }

    public ColorChooser() {
        this(null, "", null);
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setTitle(String title) {
        this.title = title;
        if (this.dialog != null) {
            this.dialog.setTitle(title);
        }
    }

    public String getTitle() {
        if (this.dialog != null) {
            this.title = this.dialog.getTitle();
        }
        return this.title;
    }

    public void setValue(Color value) {
        this.value = value;
        if (this.dialog != null) {
            this.dialog.setValue(value);
        }
    }

    public Color getValue() {
        if (this.dialog != null) {
            this.value = this.dialog.getValue();
        }
        return this.value;
    }

    public void setResult(int i) {
        this.result = i;
        if (this.dialog != null) {
            this.dialog.setResult(this.result);
        }
    }

    public int getResult() {
        if (this.dialog != null) {
            this.result = this.dialog.getResult();
        }
        return this.result;
    }

    public void show() {
        this.setVisible(true);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.dialog == null) {
                if (this.frame == null) {
                    throw new IllegalStateException(Res.bundle.getString(73));
                }
                this.dialog = new ColorChooserDialog(this.frame, this.title, this.value);
                this.dialog.setResult(this.result);
                this.dialog.addWindowListener(this);
                this.dialog.addActionListener(this.actionMulticaster);
            }
            if (this.frame.isShowing()) {
                this.focus = this.frame.getFocusOwner();
            }
            this.dialog.show();
        } else if (this.dialog != null) {
            ((Component)this.dialog).setVisible(false);
        }
    }

    public boolean isVisible() {
        return this.dialog != null ? this.dialog.isVisible() : false;
    }

    public void addActionListener(ActionListener l) {
        this.actionMulticaster.add(l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionMulticaster.remove(l);
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.value = this.dialog.getValue();
        this.result = this.dialog.getResult();
    }

    public void windowClosed(WindowEvent e) {
        if (this.dialog != null) {
            this.value = this.dialog.getValue();
            this.result = this.dialog.getResult();
        }
        this.dialog = null;
        if (this.frame.isShowing()) {
            if (this.focus != null) {
                this.focus.requestFocus();
            } else {
                this.frame.requestFocus();
            }
        }
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    static {
        OK = 1;
        CANCEL = 8;
    }
}

