/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.control;

import com.borland.jbcl.util.BlackBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;

public class TextControl
extends JComponent
implements Serializable,
BlackBox {
    protected String text;
    protected Color edgeColor = Color.black;
    protected boolean drawEdge = false;
    protected boolean transparent = true;
    protected int alignment = 33;
    protected Insets margins;

    public TextControl() {
        this.setSize(150, 20);
    }

    public TextControl(String text) {
        this.text = text;
        this.setSize(150, 20);
    }

    public void setText(String text) {
        this.text = text;
        this.repaint(100L);
    }

    public String getText() {
        return this.text;
    }

    public void setAlignment(int align) {
        this.alignment = align;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setMargins(Insets margins) {
        this.margins = margins;
    }

    public Insets getMargins() {
        return this.margins;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        this.repaint(100L);
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
        this.repaint(100L);
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setDrawEdge(boolean drawEdge) {
        this.drawEdge = drawEdge;
        this.repaint(100L);
    }

    public boolean isDrawEdge() {
        return this.drawEdge;
    }

    public Dimension getPreferredSize() {
        Graphics g = this.getGraphics();
        if (g == null || this.text == null || this.text.equals("")) {
            return new Dimension(150, 20);
        }
        Font f = this.getFont();
        FontMetrics fm = g.getFontMetrics(f);
        Insets m = this.margins != null ? this.margins : new Insets(0, 0, 0, 0);
        return new Dimension(m.left + m.right + fm.stringWidth(this.text), m.top + m.bottom + fm.getHeight());
    }

    public void update(Graphics g) {
        boolean t = this.transparent;
        this.transparent = false;
        this.paint(g);
        this.transparent = t;
    }

    public void paintComponent(Graphics g) {
        Insets m;
        super.paintComponent(g);
        Dimension size = this.getSize();
        g.clipRect(0, 0, size.width, size.height);
        Color oc = g.getColor();
        Font of = g.getFont();
        Insets insets = m = this.margins != null ? this.margins : new Insets(0, 0, 0, 0);
        if (!this.transparent) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, size.width, size.height);
        }
        if (this.text != null && !this.text.equals("")) {
            int xOffset;
            Font f = this.getFont();
            g.setFont(f);
            FontMetrics fm = g.getFontMetrics(f);
            switch (this.alignment & 0xF) {
                default: {
                    xOffset = m.left;
                    break;
                }
                case 2: {
                    xOffset = (size.width - fm.stringWidth(this.text)) / 2;
                    break;
                }
                case 3: {
                    xOffset = size.width - fm.stringWidth(this.text) - m.right;
                }
            }
            switch (this.alignment & 0xF0) {
                default: {
                    int yOffset = m.top;
                    break;
                }
                case 32: {
                    int yOffset = (size.height - fm.getHeight()) / 2;
                    break;
                }
                case 48: {
                    int yOffset = size.height - m.bottom - fm.getHeight();
                }
            }
            g.setColor(this.getForeground());
            g.drawString(this.text, xOffset, yOffset += fm.getLeading() + fm.getAscent());
        }
        if (this.drawEdge) {
            g.setColor(this.edgeColor);
            g.drawRect(0, 0, size.width - 1, size.height - 1);
        }
        g.setFont(of);
        g.setColor(oc);
    }
}

