/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jbcl.model.LinkedTreeNode;
import java.io.Serializable;
import java.util.Enumeration;

public class LinkedTreeIterator
implements Enumeration,
Serializable {
    protected LinkedTreeNode firstSibling;
    protected LinkedTreeNode sibling;

    public LinkedTreeIterator(LinkedTreeNode firstSibling) {
        this.firstSibling = firstSibling;
        this.sibling = firstSibling;
    }

    public Object nextElement() {
        LinkedTreeNode cur = this.sibling;
        this.advance();
        return cur;
    }

    public boolean hasMoreElements() {
        return this.sibling != null;
    }

    public boolean atBegin() {
        return this.sibling == this.firstSibling;
    }

    public boolean atEnd() {
        return this.sibling == null;
    }

    public Object get() {
        return this.sibling;
    }

    public void advance() {
        if (this.sibling != null) {
            this.sibling = this.sibling.nextSibling;
        }
    }

    public void advance(int offset) {
        for (int i = 0; i < offset && this.sibling != null; ++i) {
            this.advance();
        }
    }

    public Object clone() {
        LinkedTreeIterator that = new LinkedTreeIterator(this.firstSibling);
        that.sibling = this.sibling;
        return that;
    }

    public boolean equals(LinkedTreeIterator that) {
        return that.sibling == this.sibling && that.firstSibling == this.firstSibling;
    }

    public void put(Object data) {
        if (this.sibling == null) {
            this.firstSibling.appendChild((LinkedTreeNode)data);
        } else {
            this.firstSibling.insertChild((LinkedTreeNode)data, this.sibling);
        }
    }

    public int distance(LinkedTreeIterator that) {
        int d = 0;
        LinkedTreeNode c = that.sibling;
        while (c != this.sibling && c != null) {
            c = c.nextSibling;
            ++d;
        }
        return c == this.sibling ? d : -1;
    }

    public void put(int offset, Object object) {
        this.advance(offset);
        this.put(object);
    }

    public Object get(int offset) {
        this.advance(offset);
        return this.get();
    }
}

