/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.dx.dataset.CustomPaintSite;
import com.borland.dx.dataset.Variant;
import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jb.util.VetoableDispatch;
import com.borland.jbcl.model.BasicMatrixSelection;
import com.borland.jbcl.model.ItemEditSite;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.MatrixLocation;
import com.borland.jbcl.model.MatrixModel;
import com.borland.jbcl.model.MatrixModelEvent;
import com.borland.jbcl.model.MatrixModelListener;
import com.borland.jbcl.model.MatrixModelMulticaster;
import com.borland.jbcl.model.MatrixSelectionEvent;
import com.borland.jbcl.model.MatrixSelectionListener;
import com.borland.jbcl.model.MatrixSelectionMulticaster;
import com.borland.jbcl.model.MatrixSubfocusEvent;
import com.borland.jbcl.model.MatrixSubfocusListener;
import com.borland.jbcl.model.MatrixViewManager;
import com.borland.jbcl.model.NullMatrixSelection;
import com.borland.jbcl.model.ToggleItemEditor;
import com.borland.jbcl.model.WritableMatrixModel;
import com.borland.jbcl.model.WritableMatrixSelection;
import com.borland.jbcl.util.ColorWheel;
import com.borland.jbcl.util.ImageTexture;
import com.borland.jbcl.util.KeyMulticaster;
import com.borland.jbcl.view.BeanPanel;
import com.borland.jbcl.view.ColumnView;
import com.borland.jbcl.view.CustomItemEditor;
import com.borland.jbcl.view.CustomItemListener;
import com.borland.jbcl.view.CustomItemPainter;
import com.borland.jbcl.view.DataToolTip;
import com.borland.jbcl.view.FixedSizeVector;
import com.borland.jbcl.view.GridCore_Divider;
import com.borland.jbcl.view.MatrixView;
import com.borland.jbcl.view.Res;
import com.borland.jbcl.view.SizeVector;
import com.borland.jbcl.view.VariableSizeVector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JToolTip;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

class GridCore
extends BeanPanel
implements ItemEditSite,
KeyListener,
FocusListener,
MatrixModelListener,
MatrixSelectionListener,
MatrixView,
Serializable {
    private static final long serialVersionUID = 200L;
    boolean doStartEdit = false;
    private boolean lockSubfocus = false;
    private static ColorWheel colorWheel;
    private static int debugRectInc;
    private static boolean debugRectHashLeft;
    private transient MatrixModel model;
    private transient WritableMatrixModel writeModel;
    private transient MatrixViewManager viewManager;
    private transient WritableMatrixSelection selection = new NullMatrixSelection();
    private transient SizeVector columnSizes = new VariableSizeVector();
    private transient SizeVector rowSizes = new VariableSizeVector();
    private transient JScrollPane scroller;
    private transient Object actionSource;
    private ColumnView[] columnViews;
    private MatrixLocation[] oldSelected = new MatrixLocation[0];
    private boolean readOnly = false;
    private boolean liveResize = false;
    private boolean visibleGrid = true;
    private boolean hGridLines = true;
    private boolean vGridLines = true;
    private boolean postOnEndEdit = true;
    private boolean hasFocus = false;
    private boolean showFocus = true;
    private GridCore_Divider divider = new GridCore_Divider();
    private int dividerWidth = 4;
    private int dividerDelta;
    private Point editClickPoint;
    private ItemEditor editor;
    private MatrixLocation subfocus = new MatrixLocation(0, 0);
    private MatrixLocation editorLocation;
    private boolean growEditor = true;
    private MatrixLocation selectAnchor = new MatrixLocation(0, 0);
    private MatrixLocation resize;
    private MatrixLocation resize1;
    private MatrixLocation movingLocation;
    private MatrixLocation rollover;
    private MatrixLocation mouseDown;
    private int moveIndex;
    private boolean rangeSelecting;
    private boolean resizingGrid;
    private boolean resizeColumn;
    private boolean dumpingRange = false;
    private boolean snapOrigin = true;
    private Insets margins = new Insets(2, 2, 2, 2);
    private int defaultColWidth = 100;
    private Color lineColor = SystemColor.control;
    private boolean editInPlace = true;
    private boolean autoEdit = true;
    private boolean autoAppend = false;
    private boolean navigateOnEnter = true;
    private boolean navigateOnTab = true;
    private boolean dragSubfocus = true;
    private boolean debugPaint = false;
    private boolean batchMode = false;
    private boolean showRollover = false;
    private DataToolTip toolTip = new DataToolTip(this);
    private boolean useBackingStore = false;
    public static final int MIN_CELL_SIZE = 4;
    private transient CustomItemPainter customPainter = new CustomItemPainter();
    private transient CustomItemEditor customEditor = new CustomItemEditor();
    private transient Vector customizeListeners;
    private transient KeyMulticaster keyMulticaster = new KeyMulticaster();
    private transient MatrixModelMulticaster modelMulticaster = new MatrixModelMulticaster();
    private transient MatrixSelectionMulticaster selectionMulticaster = new MatrixSelectionMulticaster();
    private transient EventMulticaster subfocusMulticaster = new EventMulticaster();
    private static int TRACE_MOUSE;
    private static Cursor CURSOR_DEFAULT;
    private static Cursor CURSOR_MOVE;
    private static Cursor CURSOR_SIZE_V;
    private static Cursor CURSOR_SIZE_H;

    public GridCore(JScrollPane scroller) {
        this.scroller = scroller;
        this.actionSource = scroller;
        this.divider.setVisible(false);
        this.add(this.divider);
        super.addKeyListener(this.keyMulticaster);
        scroller.getVerticalScrollBar().setUnitIncrement(20);
        scroller.getHorizontalScrollBar().setUnitIncrement(20);
        scroller.getViewport().setBackingStoreEnabled(this.useBackingStore);
        super.setBackground(UIManager.getColor("Table.background"));
        super.setForeground(UIManager.getColor("Table.foreground"));
        this.setGridLineColor(UIManager.getColor("Table.gridColor"));
    }

    public void updateUI() {
        super.updateUI();
        super.setBackground(UIManager.getColor("Table.background"));
        super.setForeground(UIManager.getColor("Table.foreground"));
        this.setGridLineColor(UIManager.getColor("Table.gridColor"));
    }

    public MatrixModel getModel() {
        return this.model;
    }

    public void setModel(MatrixModel mm) {
        if (this.editor != null) {
            this.safeEndEdit();
        }
        if (this.model != null) {
            this.model.removeModelListener(this);
            this.model.removeModelListener(this.modelMulticaster);
        }
        this.model = mm;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.model.addModelListener(this.modelMulticaster);
        }
        this.writeModel = this.model instanceof WritableMatrixModel ? (WritableMatrixModel)this.model : null;
        if (this.model != null) {
            this.invalidate();
            this.reset();
        }
    }

    public WritableMatrixModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
    }

    public MatrixViewManager getViewManager() {
        return this.viewManager;
    }

    public void setViewManager(MatrixViewManager newViewManager) {
        if (this.editor != null) {
            this.safeEndEdit();
        }
        this.viewManager = newViewManager;
        this.invalidate();
        this.reset();
    }

    public WritableMatrixSelection getSelection() {
        return this.selection;
    }

    public void setSelection(WritableMatrixSelection wms) {
        if (this.selection != null) {
            this.selection.removeSelectionListener(this);
            this.selection.removeSelectionListener(this.selectionMulticaster);
        }
        this.selection = wms;
        if (this.selection != null) {
            this.selection.addSelectionListener(this);
            this.selection.addSelectionListener(this.selectionMulticaster);
        }
        this.oldSelected = this.selection.getAll();
        this.repaintCells();
    }

    public void setActionSource(Object actionSource) {
        this.actionSource = actionSource;
    }

    protected void registerColumnViews() {
        if (this.columnViews == null) {
            return;
        }
        for (int i = 0; i < this.columnViews.length; ++i) {
            this.columnViews[i].setGridCore(this);
        }
    }

    public void columnViewChanged(ColumnView cv, int prop) {
        int cvIndex = -1;
        for (int i = 0; i < this.columnViews.length; ++i) {
            if (cv != this.columnViews[i]) continue;
            cvIndex = i;
            break;
        }
        if (cvIndex == -1) {
            return;
        }
        if (prop == 2 || prop == 3 || prop == 4 || prop == 5 || prop == 8 || prop == 9) {
            this.repaintCells(new MatrixLocation(0, cvIndex), new MatrixLocation(this.getRowCount() - 1, cvIndex));
            return;
        }
        if (prop == 7) {
            int width = cv.getWidth();
            this.columnSizes.setSize(cvIndex, width > 4 ? width : 4);
            this.invalidate();
            this.processActionEvent(new ActionEvent(this, 1001, cv.getName(), 7));
            this.scroller.validate();
            this.repaintCells();
        } else if (prop == 6) {
            this.processActionEvent(new ActionEvent(this, 1001, cv.getName(), 6));
        }
    }

    public ColumnView[] getColumnViews() {
        return this.columnViews;
    }

    public void setColumnViews(ColumnView[] columnViews) {
        this.columnViews = columnViews == null ? new ColumnView[0] : columnViews;
        this.registerColumnViews();
        this.resetColumnSizes();
    }

    public ColumnView getColumnView(int index) {
        return this.columnViews != null && this.columnViews.length > index ? this.columnViews[index] : null;
    }

    public void setColumnView(int index, ColumnView col) {
        int width;
        if (this.columnViews.length > index) {
            this.columnViews[index] = col;
            this.columnViews[index].setGridCore(this);
            width = col.getWidth();
            if (width == 0) {
                width = this.defaultColWidth;
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.columnSizes.setSize(index, width > 4 ? width : 4);
        col.setWidth(this.columnSizes.getSize(index));
    }

    public Insets getItemMargins() {
        if (this.subfocus != null && this.columnViews != null && this.columnViews.length > this.subfocus.column) {
            return this.columnViews[this.subfocus.column].getItemMargins();
        }
        return null;
    }

    public int getAlignment() {
        if (this.subfocus != null && this.columnViews != null && this.columnViews.length > this.subfocus.column) {
            return this.columnViews[this.subfocus.column].getAlignment();
        }
        return 0;
    }

    public void addModelListener(MatrixModelListener l) {
        this.modelMulticaster.add(l);
    }

    public void removeModelListener(MatrixModelListener l) {
        this.modelMulticaster.remove(l);
    }

    public void addSelectionListener(MatrixSelectionListener l) {
        this.selectionMulticaster.add(l);
    }

    public void removeSelectionListener(MatrixSelectionListener l) {
        this.selectionMulticaster.remove(l);
    }

    public void addSubfocusListener(MatrixSubfocusListener l) {
        this.subfocusMulticaster.add((EventListener)l);
    }

    public void removeSubfocusListener(MatrixSubfocusListener l) {
        this.subfocusMulticaster.remove((EventListener)l);
    }

    public void addKeyListener(KeyListener l) {
        this.keyMulticaster.add(l);
    }

    public void removeKeyListener(KeyListener l) {
        this.keyMulticaster.remove(l);
    }

    public void modelContentChanged(MatrixModelEvent e) {
        MatrixLocation ml = e.getLocation();
        switch (e.getChange()) {
            case 1: {
                this.repaintCells();
                break;
            }
            case 17: 
            case 33: {
                if (this.editor != null && this.editorLocation != null && this.editorLocation.equals(ml)) {
                    this.safeEndEdit(false);
                }
                this.repaintCell(ml);
                break;
            }
            case 49: {
                if (this.editor != null && this.editorLocation != null && this.editorLocation.row == ml.row) {
                    this.safeEndEdit(false);
                }
                this.repaintCells(new MatrixLocation(ml.row, 0), new MatrixLocation(this.getRowCount() - 1, this.getColumnCount() - 1));
                break;
            }
            case 65: {
                if (this.editor != null && this.editorLocation != null && this.editorLocation.column == ml.column) {
                    this.safeEndEdit(false);
                }
                this.repaintCells(new MatrixLocation(0, ml.column), new MatrixLocation(this.getRowCount() - 1, this.getColumnCount() - 1));
            }
        }
    }

    public void modelStructureChanged(MatrixModelEvent e) {
        MatrixLocation ml = e.getLocation();
        switch (e.getChange()) {
            case 2: {
                if (this.editor != null) {
                    this.safeEndEdit(false);
                }
                this.invalidate();
                this.repaintCells();
                if (!this.isShowing() || this.batchMode) break;
                this.scroller.validate();
                this.scrollView();
                break;
            }
            case 18: 
            case 34: {
                int rows = e.getModel().getRowCount();
                if (this.editor != null && this.editorLocation != null && (ml != null && ml.row == this.editorLocation.row || this.editorLocation.row >= rows)) {
                    this.safeEndEdit(false);
                }
                this.invalidate();
                if (e.getChange() == 34 && this.subfocus != null && rows <= this.subfocus.row && rows > 0) {
                    this.setSubfocus(rows - 1, this.subfocus.column);
                }
                this.repaintCells();
                if (!this.isShowing() || this.batchMode) break;
                this.scroller.validate();
                this.scrollView();
                break;
            }
            case 50: {
                this.addColumnView(ml.column);
                this.invalidate();
                this.repaintCells();
                if (!this.isShowing() || this.batchMode) break;
                this.scroller.validate();
                this.scrollView();
                break;
            }
            case 66: {
                int cols = e.getModel().getColumnCount();
                if (this.subfocus != null && cols <= this.subfocus.column && cols > 0) {
                    this.setSubfocus(this.subfocus.row, cols - 1);
                }
                this.dropColumnView(ml.column);
                this.invalidate();
                this.repaintCells();
                if (!this.isShowing() || this.batchMode) break;
                this.scroller.validate();
                this.scrollView();
                break;
            }
        }
    }

    protected void addColumnView(int newColumn) {
        ColumnView[] newViews = new ColumnView[this.columnViews.length + 1];
        if (newColumn == 0) {
            System.arraycopy(this.columnViews, 0, newViews, 1, this.columnViews.length);
        } else if (newColumn >= this.columnViews.length) {
            System.arraycopy(this.columnViews, 0, newViews, 0, this.columnViews.length);
        } else {
            System.arraycopy(this.columnViews, 0, newViews, 0, newColumn);
            System.arraycopy(this.columnViews, newColumn, newViews, newColumn + 1, this.columnViews.length - newColumn);
        }
        newViews[newColumn] = new ColumnView();
        this.defaultColumnView(newColumn, newViews[newColumn]);
        for (int i = 0; i < newViews.length; ++i) {
            int w = newViews[i].getWidth();
            this.columnSizes.setSize(i, w > 4 ? w : 4);
            newViews[i].setWidth(this.columnSizes.getSize(i));
        }
        this.columnViews = newViews;
        this.registerColumnViews();
    }

    protected void defaultColumnView(int col, ColumnView c) {
        String name = Res.bundle.format(5, (Object[])new String[]{String.valueOf(col)});
        c.setName(name);
        c.setAlignment(33);
        c.setItemMargins(new Insets(0, 2, 0, 2));
        c.setWidth(this.defaultColWidth);
    }

    protected void dropColumnView(int dropColumn) {
        ColumnView[] newViews = new ColumnView[this.columnViews.length - 1];
        if (dropColumn == 0) {
            System.arraycopy(this.columnViews, 1, newViews, 0, this.columnViews.length - 1);
        } else if (dropColumn == newViews.length) {
            System.arraycopy(this.columnViews, 0, newViews, 0, newViews.length);
        } else {
            System.arraycopy(this.columnViews, 0, newViews, 0, dropColumn);
            System.arraycopy(this.columnViews, dropColumn + 1, newViews, dropColumn, newViews.length - dropColumn);
        }
        for (int i = dropColumn; i < newViews.length; ++i) {
            int w = newViews[i].getWidth();
            this.columnSizes.setSize(i, w > 4 ? w : 4);
            newViews[i].setWidth(this.columnSizes.getSize(i));
        }
        this.columnViews = newViews;
        this.registerColumnViews();
    }

    public void selectionItemChanged(MatrixSelectionEvent e) {
        this.repaintCell(e.getLocation());
        this.oldSelected = e.getSelection().getAll();
    }

    public void selectionRangeChanged(MatrixSelectionEvent e) {
        switch (e.getChange()) {
            case 8193: {
                if (this.dumpingRange) {
                    this.selectionChanged(e);
                    this.dumpingRange = false;
                    break;
                }
                this.repaintCells(e.getRangeStart(), e.getRangeEnd());
                this.oldSelected = e.getSelection().getAll();
                break;
            }
            case 8194: {
                if (this.dumpingRange) break;
                this.repaintCells(e.getRangeStart(), e.getRangeEnd());
                this.oldSelected = e.getSelection().getAll();
            }
        }
    }

    public void selectionChanged(MatrixSelectionEvent e) {
        switch (e.getChange()) {
            case 12289: {
                this.repaintSelection();
                break;
            }
            default: {
                int i;
                MatrixLocation[] selected = e.getSelection().getAll();
                BasicMatrixSelection old = new BasicMatrixSelection(this.oldSelected);
                for (i = 0; i < selected.length; ++i) {
                    if (!old.contains(selected[i])) {
                        this.repaintCell(selected[i]);
                        continue;
                    }
                    old.remove(selected[i]);
                }
                this.oldSelected = old.getAll();
                for (i = 0; i < this.oldSelected.length; ++i) {
                    this.repaintCell(this.oldSelected[i]);
                }
            }
        }
        this.oldSelected = e.getSelection().getAll();
    }

    public void windowActiveChanged(boolean active) {
        super.windowActiveChanged(active);
        this.repaintSelection();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (this.hasFocus) {
            this.hasFocus = false;
            this.repaintCell(this.subfocus);
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        switch (e.getID()) {
            case 1004: {
                if (this.editor != null && this.editor.getComponent() != null) {
                    this.editor.getComponent().requestFocus();
                }
                if (this.hasFocus) break;
                this.hasFocus = true;
                this.repaintCell(this.subfocus);
                break;
            }
            case 1005: {
                if (this.editor != null) break;
                this.hasFocus = false;
                this.repaintCell(this.subfocus);
            }
        }
        super.processFocusEvent(e);
    }

    public int getVisibleRows() {
        return this.getVisibleCount(true);
    }

    public int getVisibleColumns() {
        return this.getVisibleCount(false);
    }

    int getVisibleCount(boolean rows) {
        MatrixLocation last;
        MatrixLocation first = this.hitTest(1, 1);
        if (first == null) {
            first = new MatrixLocation();
        }
        if ((last = this.hitTest(this.getSize().width, this.getSize().height)) == null) {
            last = new MatrixLocation(this.getRowCount() - 1, this.getColumnCount() - 1);
        }
        return rows ? last.row - first.row + 1 : last.column - first.column + 1;
    }

    public boolean isGridVisible() {
        return this.visibleGrid;
    }

    public void setGridVisible(boolean visible) {
        if (this.visibleGrid != visible) {
            this.visibleGrid = visible;
            this.repaintCells();
        }
    }

    public boolean isHorizontalLines() {
        return this.hGridLines;
    }

    public void setHorizontalLines(boolean visible) {
        if (this.hGridLines != visible) {
            this.hGridLines = visible;
            this.repaintCells();
        }
    }

    public boolean isVerticalLines() {
        return this.vGridLines;
    }

    public void setVerticalLines(boolean visible) {
        if (this.vGridLines != visible) {
            this.vGridLines = visible;
            this.repaintCells();
        }
    }

    public Color getGridLineColor() {
        return this.lineColor;
    }

    public void setGridLineColor(Color gridLineColor) {
        if (gridLineColor == null) {
            throw new IllegalArgumentException();
        }
        this.lineColor = gridLineColor;
        this.repaintCells();
    }

    public boolean isShowFocus() {
        return this.showFocus;
    }

    public void setShowFocus(boolean visible) {
        if (this.showFocus != visible) {
            this.showFocus = visible;
            this.repaintCell(this.getSubfocus());
        }
    }

    public int getDefaultColumnWidth() {
        return this.defaultColWidth;
    }

    public void setDefaultColumnWidth(int defaultWidth) {
        if (defaultWidth <= 0) {
            throw new IllegalArgumentException();
        }
        this.defaultColWidth = defaultWidth;
    }

    public boolean isPostOnEndEdit() {
        return this.postOnEndEdit;
    }

    public void setPostOnEndEdit(boolean post) {
        this.postOnEndEdit = post;
    }

    public boolean isEditing() {
        return this.editor != null;
    }

    public ItemEditor getEditor() {
        return this.editor;
    }

    public void setAutoEdit(boolean autoEdit) {
        this.autoEdit = autoEdit;
    }

    public boolean isAutoEdit() {
        return this.autoEdit;
    }

    public void setGrowEditor(boolean growEditor) {
        this.growEditor = growEditor;
    }

    public boolean isGrowEditor() {
        return this.growEditor;
    }

    public void setAutoAppend(boolean autoAppend) {
        this.autoAppend = autoAppend;
    }

    public boolean isAutoAppend() {
        return this.autoAppend;
    }

    public void setNavigateOnEnter(boolean navigateOnEnter) {
        this.navigateOnEnter = navigateOnEnter;
    }

    public boolean isNavigateOnEnter() {
        return this.navigateOnEnter;
    }

    public void setNavigateOnTab(boolean navigateOnTab) {
        this.navigateOnTab = navigateOnTab;
    }

    public boolean isNavigateOnTab() {
        return this.navigateOnTab;
    }

    public void setDragSubfocus(boolean dragSubfocus) {
        this.dragSubfocus = dragSubfocus;
    }

    public boolean isDragSubfocus() {
        return this.dragSubfocus;
    }

    public void setSnapOrigin(boolean snapOrigin) {
        this.snapOrigin = snapOrigin;
    }

    public boolean isSnapOrigin() {
        return this.snapOrigin;
    }

    public void setShowRollover(boolean showRollover) {
        this.showRollover = showRollover;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public void setDataToolTip(boolean dataTip) {
        this.toolTip.active = dataTip;
        ToolTipManager ttm = ToolTipManager.sharedInstance();
        if (this.toolTip.active) {
            ttm.registerComponent(this);
        } else if (this.getToolTipText() == null) {
            ttm.unregisterComponent(this);
        }
    }

    public boolean isDataToolTip() {
        return this.toolTip.active;
    }

    public void setEditInPlace(boolean editInPlace) {
        this.editInPlace = editInPlace;
    }

    public boolean isEditInPlace() {
        return this.editInPlace;
    }

    public void setBatchMode(boolean batchMode) {
        if (this.batchMode != batchMode) {
            this.batchMode = batchMode;
            if (!this.batchMode) {
                this.repaintCells();
                if (this.isShowing()) {
                    this.scroller.validate();
                }
            }
        }
    }

    public boolean isBatchMode() {
        return this.batchMode;
    }

    public Point getEditClickPoint() {
        return this.editClickPoint;
    }

    public boolean isTransparent() {
        return this.texture != null ? true : !this.isOpaque();
    }

    public Graphics getSiteGraphics() {
        return this.getGraphics();
    }

    public Component getSiteComponent() {
        return this;
    }

    public SizeVector getRowSizes() {
        return this.rowSizes;
    }

    public void setRowSizes(SizeVector newRowSizes) {
        this.rowSizes = newRowSizes;
        this.invalidate();
        this.repaintCells();
    }

    public SizeVector getColumnSizes() {
        return this.columnSizes;
    }

    public void setColumnSizes(SizeVector newColumnSizes) {
        this.columnSizes = newColumnSizes;
        this.invalidate();
        this.repaintCells();
    }

    private void scrollView() {
        Rectangle fRect = this.getCellRect(this.subfocus);
        Rectangle vRect = this.scroller.getViewport().getViewRect();
        int x = vRect.x;
        int y = vRect.y;
        if (fRect != null) {
            MatrixLocation o;
            boolean offRight = false;
            boolean offBottom = false;
            if (fRect.width > vRect.width || fRect.x < vRect.x) {
                x = fRect.x;
            } else if (fRect.x + fRect.width > vRect.x + vRect.width) {
                x = this.getSize().width - vRect.width < fRect.x + fRect.width - vRect.width ? this.getSize().width - vRect.width : fRect.x + fRect.width - vRect.width;
                offRight = true;
            }
            if (fRect.y < vRect.y) {
                y = fRect.y;
            } else if (fRect.y + fRect.height > vRect.y + vRect.height) {
                y = this.getSize().height - vRect.height < fRect.y + fRect.height - vRect.height ? this.getSize().height - vRect.height : fRect.y + fRect.height - vRect.height;
                offBottom = true;
            }
            if (this.snapOrigin && (o = this.hitTest(x, y)) != null) {
                if (offRight && offBottom) {
                    ++o.row;
                    ++o.column;
                    Rectangle oRect = this.getCellRect(o);
                    x = oRect.x;
                    y = oRect.y;
                } else if (offRight) {
                    ++o.column;
                    Rectangle oRect = this.getCellRect(o);
                    x = oRect.x;
                } else if (offBottom) {
                    ++o.row;
                    Rectangle oRect = this.getCellRect(o);
                    y = oRect.y;
                }
            }
            if (vRect.x != x || vRect.y != y) {
                JViewport jvp = this.scroller.getViewport();
                jvp.setViewPosition(new Point(x, y));
                this.repaint();
            }
            this.scroller.getHorizontalScrollBar().setUnitIncrement(fRect.width);
            this.scroller.getVerticalScrollBar().setUnitIncrement(fRect.height);
        }
    }

    private int getState(int row, int column) {
        int state = 0;
        if (this.selection.contains(row, column)) {
            state |= 4;
        }
        if (!this.isEnabled()) {
            state |= 0x21;
        } else {
            if (this.showFocus && this.hasFocus && this.subfocus.row == row && this.subfocus.column == column) {
                state |= 2;
            }
            if ((this.focusState & 0x20) != 0) {
                state |= 0x20;
            }
            if (this.showRollover && this.rollover != null && this.rollover.row == row && this.rollover.column == column) {
                state |= 0x40;
            }
        }
        if (!this.hasFocus) {
            state |= 0x80;
        }
        return state;
    }

    public int getColumnOrdinal(int column) {
        int ordinal;
        if (this.columnViews != null && this.columnViews.length > column && (ordinal = this.columnViews[column].getOrdinal()) >= 0) {
            return ordinal;
        }
        return column;
    }

    private ItemPainter getPainter(int row, int column, Object data, int state) {
        ItemPainter painter = this.columnViews != null && column < this.columnViews.length ? (this.columnViews[column] != null ? this.columnViews[column].getItemPainter() : null) : null;
        column = this.getColumnOrdinal(column);
        if (painter == null) {
            painter = this.viewManager.getPainter(row, column, data, state);
        }
        if (painter != null && this.customizeListeners != null) {
            this.customPainter.setPainter(painter);
            this.fireCustomizeItemEvent(new MatrixLocation(row, column), data, state, this.customPainter);
            return this.customPainter;
        }
        return painter;
    }

    private ItemEditor getEditor(int row, int column, Object data, int state) {
        ItemEditor editor = this.columnViews != null && column < this.columnViews.length ? this.columnViews[column].getItemEditor() : null;
        column = this.getColumnOrdinal(column);
        if (editor == null) {
            editor = this.viewManager.getEditor(row, column, data, state);
        }
        if (editor != null && this.customizeListeners != null) {
            this.customEditor.setEditor(editor);
            this.fireCustomizeItemEvent(new MatrixLocation(row, column), data, state, this.customEditor);
            return this.customEditor;
        }
        return editor;
    }

    public void repaintSelection() {
        for (int i = 0; i < this.oldSelected.length; ++i) {
            this.repaintCell(this.oldSelected[i]);
        }
    }

    public void repaintCell(MatrixLocation cell) {
        Rectangle rect;
        if (this.batchMode || cell == null) {
            return;
        }
        if (cell.row < this.getRowCount() && cell.column < this.getColumnCount() && (rect = this.getCellRect(cell)) != null) {
            this.repaint(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void repaintCells() {
        if (this.batchMode) {
            return;
        }
        this.repaint(100L);
    }

    public void repaintCells(MatrixLocation s, MatrixLocation e) {
        if (this.batchMode) {
            return;
        }
        Rectangle rect = this.getCellRangeRect(s, e);
        if (rect != null) {
            this.repaint(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paintComponent(Graphics g) {
        if (this.batchMode) {
            return;
        }
        super.paintComponent(g);
        g.clipRect(0, 0, this.getSize().width, this.getSize().height);
        Rectangle vRect = this.scroller.getViewport().getViewRect();
        Rectangle c = g.getClipBounds();
        if (c == null) {
            return;
        }
        Rectangle clip = c.width > vRect.width || c.height > vRect.height ? c.intersection(vRect) : c;
        if (clip.width <= 0 || clip.height <= 0 || vRect.width <= 0 || vRect.height <= 0) {
            return;
        }
        g.setClip(clip.x, clip.y, clip.width, clip.height);
        int lastX = clip.x;
        int lastY = clip.y;
        MatrixLocation hit = this.hitTest(clip.x, clip.y);
        if (hit != null) {
            int column;
            g.setFont(this.getFont());
            MatrixLocation ur = this.hitTest(clip.x + clip.width - 1, clip.y);
            int lastColumn = ur != null ? ur.column : this.getColumnCount() - 1;
            MatrixLocation ll = this.hitTest(clip.x, clip.y + clip.height - 1);
            int lastRow = ll != null ? ll.row : this.getRowCount() - 1;
            Rectangle r = this.getCellRect(hit);
            int xStart = r.x;
            for (int row = hit.row; row <= lastRow; ++row) {
                r.x = xStart;
                r.height = this.rowSizes.getSize(row);
                if (r.height <= 0) continue;
                for (column = hit.column; column <= lastColumn; ++column) {
                    ColumnView cview;
                    r.width = this.columnSizes.getSize(column);
                    if (r.width <= 0) continue;
                    Object value = this.model.get(row, this.getColumnOrdinal(column));
                    if (value instanceof Variant) {
                        value = ((Variant)value).clone();
                    }
                    int state = this.getState(row, column);
                    ItemPainter painter = this.getPainter(row, column, value, state);
                    ColumnView columnView = cview = this.columnViews != null && this.columnViews.length > column ? this.columnViews[column] : null;
                    if (this.texture != null) {
                        ImageTexture.texture(this.texture, g, r.x, r.y, r.width, r.height);
                    }
                    if (painter != null) {
                        g.setColor(this.getBackground());
                        if (this.visibleGrid) {
                            Rectangle rect = new Rectangle(r);
                            if (this.vGridLines) {
                                --rect.width;
                            }
                            if (this.hGridLines) {
                                --rect.height;
                            }
                            g.clipRect(rect.x, rect.y, rect.width, rect.height);
                            painter.paint(value, g, rect, state, cview);
                        } else {
                            g.clipRect(r.x, r.y, r.width, r.height);
                            painter.paint(value, g, r, state, cview);
                        }
                        g.setClip(clip.x, clip.y, clip.width, clip.height);
                    }
                    r.x += r.width;
                }
                r.y += r.height;
            }
            lastX = r.x;
            lastY = r.y;
            if (lastX < clip.x + clip.width) {
                if (this.texture != null) {
                    ImageTexture.texture(this.texture, g, lastX, clip.y, clip.x + clip.width - lastX, clip.height);
                } else if (this.isOpaque()) {
                    g.setColor(this.getBackground());
                    g.fillRect(lastX, clip.y, clip.x + clip.width - lastX, clip.height);
                }
            }
            if (lastY < clip.y + clip.height) {
                if (this.texture != null) {
                    ImageTexture.texture(this.texture, g, clip.x, lastY, clip.width, clip.y + clip.height - lastY);
                } else if (this.isOpaque()) {
                    g.setColor(this.getBackground());
                    g.fillRect(clip.x, lastY, clip.width, clip.y + clip.height - lastY);
                }
            }
            if (this.visibleGrid) {
                g.setColor(this.isEnabled() ? this.lineColor : this.lineColor.brighter());
                r = this.getCellRect(hit);
                --r.x;
                --r.y;
                --lastX;
                --lastY;
                Dimension d = new Dimension(r.x, r.y);
                if (this.vGridLines) {
                    g.drawLine(d.width, d.height, d.width, lastY);
                    for (column = hit.column; column <= lastColumn; ++column) {
                        d.width += this.columnSizes.getSize(column);
                        g.drawLine(d.width, d.height, d.width, lastY);
                    }
                }
                if (this.hGridLines) {
                    d.width = r.x;
                    d.height = r.y;
                    g.drawLine(d.width, d.height, lastX, d.height);
                    for (int row = hit.row; row <= lastRow; ++row) {
                        d.height += this.rowSizes.getSize(row);
                        g.drawLine(d.width, d.height, lastX, d.height);
                    }
                }
            }
        } else if (this.texture != null) {
            ImageTexture.texture(this.texture, g, clip.x, clip.y, clip.width, clip.height);
        } else if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
        }
        if (this.debugPaint) {
            GridCore.debugRect(g, clip.x, clip.y, clip.width, clip.height);
        }
    }

    public Dimension getPreferredSize() {
        Dimension d = new Dimension(10, 10);
        if (this.columnSizes != null) {
            d.width = this.columnSizes.getSizeUpTo(this.getColumnCount());
        }
        if (this.rowSizes != null) {
            d.height = this.rowSizes.getSizeUpTo(this.getRowCount());
        }
        return d;
    }

    public Dimension getMinimumSize() {
        Dimension d = new Dimension(10, 10);
        if (this.columnSizes != null) {
            d.width = this.columnSizes.getSize(0);
        }
        if (this.rowSizes != null) {
            d.height = this.rowSizes.getSize(0);
        }
        return d;
    }

    public MatrixLocation hitTest(Point p) {
        return this.hitTest(p.x, p.y);
    }

    public MatrixLocation hitTest(int x, int y) {
        int h;
        int w;
        if (this.getRowCount() <= 0 || this.getColumnCount() <= 0) {
            return null;
        }
        int c = 0;
        if (this.columnSizes instanceof FixedSizeVector) {
            c = x / w;
            if (c >= this.getColumnCount()) {
                c = this.getColumnCount() - 1;
            }
            w *= c + 1;
        } else {
            for (w = this.columnSizes.getSize(0); x >= w && ++c < this.getColumnCount(); w += this.columnSizes.getSize(c)) {
            }
        }
        int r = 0;
        if (this.rowSizes instanceof FixedSizeVector) {
            r = y / h;
            if (r >= this.getRowCount()) {
                r = this.getRowCount() - 1;
            }
            h *= r + 1;
        } else {
            for (h = this.rowSizes.getSize(0); y >= h && ++r < this.getRowCount(); h += this.rowSizes.getSize(r)) {
            }
        }
        MatrixLocation hit = null;
        if (x >= 0 && x < w && y >= 0 && y < h) {
            hit = new MatrixLocation(r, c);
        }
        return hit;
    }

    public Rectangle getCellRect(int row, int column) {
        return this.getCellRect(new MatrixLocation(row, column));
    }

    public Rectangle getCellRect(MatrixLocation cell) {
        Rectangle rect = new Rectangle();
        for (int c = 0; c < cell.column; ++c) {
            rect.x += this.columnSizes.getSize(c);
        }
        for (int r = 0; r < cell.row; ++r) {
            rect.y += this.rowSizes.getSize(r);
        }
        rect.width = this.columnSizes.getSize(cell.column);
        rect.height = this.rowSizes.getSize(cell.row);
        return rect;
    }

    private boolean canSet(int row, int column, boolean startingEdit) {
        return this.isReadOnly() ? false : this.writeModel.canSet(row, this.getColumnOrdinal(column), startingEdit);
    }

    public int getRowCount() {
        return this.model == null ? 0 : this.model.getRowCount();
    }

    public int getColumnCount() {
        return this.model == null ? 0 : this.model.getColumnCount();
    }

    public MatrixLocation getSubfocus() {
        return this.subfocus;
    }

    public void setSubfocus(MatrixLocation newSubfocus) {
        this.setSubfocus(newSubfocus.row, newSubfocus.column);
    }

    public void setSubfocus(int row, int column) {
        this.setSubfocus(row, column, 67);
    }

    protected void setSubfocus(int row, int column, int flags) {
        if (this.getRowCount() < 1 || this.getColumnCount() < 1) {
            return;
        }
        if (row < 0 || column < 0 || row > this.getRowCount() || column > this.getColumnCount()) {
            if (this.batchMode) {
                return;
            }
            throw new IllegalArgumentException(Res.bundle.getString(8));
        }
        if (this.editor != null) {
            if (this.lockSubfocus) {
                return;
            }
            this.safeEndEdit();
            if (this.lockSubfocus) {
                return;
            }
        }
        if (row > this.getRowCount() - 1 || row < 0 || column > this.getColumnCount() - 1 || column < 0 || this.subfocus != null && this.subfocus.row == row && this.subfocus.column == column) {
            if (row == this.getRowCount()) {
                if (!this.isReadOnly() && this.writeModel.isVariableRows()) {
                    this.writeModel.addRow();
                }
            } else if (column == this.getColumnCount()) {
                if (!this.isReadOnly() && this.writeModel.isVariableColumns()) {
                    this.writeModel.addColumn();
                }
            } else {
                return;
            }
        }
        if (!this.preprocessSubfocusEvent(new MatrixSubfocusEvent(this, 1, new MatrixLocation(row, column)))) {
            return;
        }
        if (this.subfocus == null) {
            this.subfocus = new MatrixLocation(row, column);
            this.selectAnchor = new MatrixLocation(row, column);
            if ((flags & 2) != 0) {
                this.selection.add(this.subfocus);
            }
            this.scrollView();
            this.processSubfocusEvent(new MatrixSubfocusEvent(this, 2, new MatrixLocation(this.subfocus)));
            return;
        }
        if (row != this.subfocus.row || column != this.subfocus.column) {
            if (this.selectAnchor == null) {
                this.selectAnchor = new MatrixLocation(row, column);
            }
            MatrixLocation oldFocus = new MatrixLocation(this.subfocus);
            this.subfocus = new MatrixLocation(row, column);
            if ((flags & 1) != 0) {
                this.selection.removeAll();
            }
            if ((flags & 2) != 0) {
                this.selection.add(new MatrixLocation(this.subfocus));
            }
            if ((flags & 8) != 0) {
                if (this.selection.contains(this.subfocus)) {
                    this.selection.remove(this.subfocus);
                } else {
                    this.selection.add(new MatrixLocation(this.subfocus));
                }
            }
            if ((flags & 0x10) != 0) {
                this.dumpingRange = true;
                this.selection.removeRange(this.selectAnchor, oldFocus);
                this.selection.addRange(this.selectAnchor, this.subfocus);
            }
            if ((flags & 0x40) != 0) {
                this.selectAnchor = new MatrixLocation(this.subfocus);
            }
            this.repaintCell(oldFocus);
            this.scrollView();
            this.repaintCell(this.subfocus);
            this.processSubfocusEvent(new MatrixSubfocusEvent(this, 2, new MatrixLocation(this.subfocus)));
        }
    }

    protected void moveFocus(int deltaRows, int deltaColumns, int flags) {
        int rows = this.getRowCount() - 1;
        int cols = this.getColumnCount() - 1;
        int minRows = this.subfocus.row + deltaRows < rows ? this.subfocus.row + deltaRows : rows;
        int minCols = this.subfocus.column + deltaColumns < cols ? this.subfocus.column + deltaColumns : cols;
        int row = minRows < 0 ? 0 : minRows;
        int column = minCols < 0 ? 0 : minCols;
        this.setSubfocus(row, column, flags);
    }

    public void keyPressed(KeyEvent e) {
        boolean alt = e.isAltDown();
        boolean control = e.isControlDown();
        boolean shift = e.isShiftDown();
        if (this.editor == null || e.isConsumed()) {
            return;
        }
        switch (e.getKeyCode()) {
            case 10: {
                if (control || alt || shift) break;
                this.safeEndEdit(true);
                if (this.lockSubfocus) break;
                e.consume();
                this.fireActionEvent();
                this.processKeyPressed(e);
                break;
            }
            case 27: {
                this.safeEndEdit(false);
                e.consume();
                break;
            }
            case 33: 
            case 34: 
            case 38: 
            case 40: {
                if (alt) break;
                this.safeEndEdit();
                this.processKeyPressed(e);
                break;
            }
            case 37: 
            case 39: {
                if (!control || alt || shift) break;
                this.safeEndEdit();
                this.processKeyPressed(e);
                break;
            }
            case 9: {
                if (alt) break;
                this.safeEndEdit();
                this.doTabKey(e);
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    protected void processKeyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        boolean control = e.isControlDown();
        boolean shift = e.isShiftDown();
        boolean alt = e.isAltDown();
        int flags = shift && control ? 16 : (shift ? 16 : (control ? 64 : 67));
        switch (key) {
            case 40: {
                if ((this.autoAppend || control) && this.subfocus.row == this.getRowCount() - 1 && !this.isReadOnly() && this.writeModel.isVariableRows()) {
                    this.writeModel.addRow();
                    this.setSubfocus(this.getRowCount() - 1, this.subfocus.column, flags);
                    e.consume();
                    break;
                }
                if (this.subfocus.row >= this.getRowCount() - 1 || alt) break;
                this.moveFocus(1, 0, flags);
                e.consume();
                break;
            }
            case 39: {
                if (control && this.subfocus.column == this.getColumnCount() - 1 && !this.isReadOnly() && this.writeModel.isVariableColumns()) {
                    this.writeModel.addColumn();
                    this.setSubfocus(this.subfocus.row, this.getColumnCount() - 1, flags);
                    e.consume();
                    break;
                }
                if (this.subfocus.column >= this.getColumnCount() - 1 || alt) break;
                this.moveFocus(0, 1, flags);
                e.consume();
                break;
            }
            case 38: {
                if (this.subfocus.row <= 0 || alt) break;
                this.moveFocus(-1, 0, flags);
                e.consume();
                break;
            }
            case 37: {
                if (this.subfocus.column <= 0 || alt) break;
                this.moveFocus(0, -1, flags);
                e.consume();
                break;
            }
            case 33: {
                if (this.subfocus.row <= 0 || alt) break;
                this.pageJump(false, flags);
                e.consume();
                break;
            }
            case 34: {
                if (this.subfocus.row >= this.getRowCount() - 1 || alt) break;
                this.pageJump(true, flags);
                e.consume();
                break;
            }
            case 32: {
                if (alt || shift) break;
                if (control && this.selection.contains(this.subfocus)) {
                    this.selection.remove(this.subfocus);
                } else {
                    this.selection.add(this.subfocus);
                }
                e.consume();
                if (!this.isToggleItem(this.subfocus.row, this.subfocus.column)) break;
                this.startEdit(this.subfocus);
                break;
            }
            case 36: {
                if (alt) break;
                if (control && shift) {
                    if (this.subfocus.row == 0 && this.subfocus.column == 0) break;
                    this.setSubfocus(0, 0, 16);
                    e.consume();
                    break;
                }
                if (control) {
                    if (this.subfocus.row == 0 && this.subfocus.column == 0) break;
                    this.setSubfocus(0, 0, 67);
                    e.consume();
                    break;
                }
                if (this.subfocus.column == 0) break;
                this.moveFocus(0, -this.subfocus.column, flags);
                e.consume();
                break;
            }
            case 35: {
                if (alt) break;
                if (control && shift) {
                    if (this.subfocus.row == this.getRowCount() - 1 && this.subfocus.column == this.getColumnCount() - 1) break;
                    this.setSubfocus(this.getRowCount() - 1, this.getColumnCount() - 1, 16);
                    e.consume();
                    break;
                }
                if (control) {
                    if (this.subfocus.row == this.getRowCount() - 1 && this.subfocus.column == this.getColumnCount() - 1) break;
                    this.setSubfocus(this.getRowCount() - 1, this.getColumnCount() - 1, 67);
                    e.consume();
                    break;
                }
                if (this.subfocus.column == this.getColumnCount() - 1) break;
                this.setSubfocus(this.subfocus.row, this.getColumnCount() - 1, flags);
                e.consume();
                break;
            }
            case 155: {
                if (shift && control) {
                    if (this.isReadOnly() || !this.writeModel.isVariableColumns()) break;
                    this.writeModel.addColumn(this.getColumnOrdinal(this.subfocus.column));
                    e.consume();
                    break;
                }
                if (this.isReadOnly() || !this.writeModel.isVariableRows()) break;
                this.writeModel.addRow(this.subfocus.row);
                e.consume();
                break;
            }
            case 127: {
                if (shift && control) {
                    if (this.isReadOnly() || !this.writeModel.isVariableColumns() || this.writeModel.getColumnCount() <= 0) break;
                    this.writeModel.removeColumn(this.getColumnOrdinal(this.subfocus.column));
                    e.consume();
                    if (this.subfocus.column != this.getColumnCount()) break;
                    this.moveFocus(0, -1, 67);
                    break;
                }
                if (!control || this.isReadOnly() || !this.writeModel.isVariableRows() || this.writeModel.getRowCount() <= 0) break;
                this.writeModel.removeRow(this.subfocus.row);
                e.consume();
                if (this.subfocus.row != this.getRowCount()) break;
                this.moveFocus(-1, 0, 67);
                break;
            }
            case 10: {
                if (control && !shift && !alt && this.editor == null && this.canSet(this.subfocus.row, this.subfocus.column, false)) {
                    this.startEdit(this.subfocus);
                    e.consume();
                    break;
                }
                if (this.navigateOnEnter && this.subfocus.column < this.getColumnCount() - 1) {
                    this.moveFocus(0, 1, 67);
                    e.consume();
                    break;
                }
                if (!this.navigateOnEnter || this.subfocus.row >= this.getRowCount() - 1) break;
                this.moveFocus(1, -this.subfocus.column, 67);
                e.consume();
                break;
            }
            case 113: {
                if (this.editor != null || this.isToggleItem(this.subfocus.row, this.subfocus.column) || !this.canSet(this.subfocus.row, this.subfocus.column, false)) break;
                this.startEdit(this.subfocus);
                e.consume();
                break;
            }
            case 68: {
                if (!control || this.editor != null || this.subfocus.row <= 0 || !this.canSet(this.subfocus.row, this.subfocus.column, true)) break;
                this.writeModel.set(this.subfocus.row, this.getColumnOrdinal(this.subfocus.column), this.model.get(this.subfocus.row - 1, this.getColumnOrdinal(this.subfocus.column)));
                e.consume();
                break;
            }
            case 74: {
                if (!shift || !control || !alt) break;
                this.debugPaint = !this.debugPaint;
                break;
            }
            case 25: 
            case 229: {
                if (this.editor != null || !this.canSet(this.subfocus.row, this.subfocus.column, false)) break;
                this.startEdit(this.subfocus);
                e.consume();
            }
        }
    }

    protected void doTabKey(KeyEvent e) {
        if (!e.isShiftDown()) {
            if (this.subfocus.column < this.getColumnCount() - 1) {
                this.moveFocus(0, 1, 67);
                e.consume();
            } else if (this.subfocus.row < this.getRowCount() - 1) {
                this.moveFocus(1, -this.subfocus.column, 67);
                e.consume();
            } else if (this.subfocus.row == this.getRowCount() - 1 && this.subfocus.column == this.getColumnCount() - 1) {
                this.setSubfocus(0, 0, 67);
                e.consume();
            }
        } else if (this.subfocus.column > 0) {
            this.moveFocus(0, -1, 67);
            e.consume();
        } else if (this.subfocus.row > 0) {
            this.moveFocus(-1, this.getColumnCount() - 1, 67);
            e.consume();
        } else if (this.subfocus.row == 0 && this.subfocus.column == 0) {
            this.setSubfocus(this.getRowCount() - 1, this.getColumnCount() - 1, 67);
            e.consume();
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 401 && e.getKeyCode() == 9 && this.navigateOnTab && !e.isControlDown() && !e.isAltDown() && this.editor == null) {
            this.doTabKey(e);
            return;
        }
        super.processKeyEvent(e);
    }

    protected void processKeyTyped(KeyEvent e) {
        char kChar = e.getKeyChar();
        if (this.editor != null || !this.autoEdit || e.isConsumed() || this.isReadOnly() || kChar == '\u0000' || kChar == '\t' || kChar == '\r' || kChar == '\n' || kChar == ' ' || kChar == '\u001b' || this.isToggleItem(this.subfocus.row, this.subfocus.column) || e.isAltDown() ^ e.isControlDown() || !this.writeModel.canSet(this.subfocus.row, this.getColumnOrdinal(this.subfocus.column), false)) {
            return;
        }
        this.startEdit(this.subfocus);
        Component eComp = null;
        if (this.editor != null && (eComp = this.editor.getComponent()) != null) {
            eComp.dispatchEvent(e);
        }
    }

    private void pageJump(boolean pageDown, int flags) {
        int jump = 10;
        if (this.rowSizes instanceof FixedSizeVector) {
            int avHeight;
            int count = this.getRowCount();
            if (count == 0) {
                ++count;
            }
            if ((avHeight = this.getPreferredSize().height / count) == 0) {
                ++avHeight;
            }
            jump = this.scroller.getViewport().getExtentSize().height / avHeight - 1;
        }
        jump = pageDown ? jump : -jump;
        this.moveFocus(jump, 0, flags);
    }

    protected boolean preprocessSubfocusEvent(MatrixSubfocusEvent e) {
        return this.subfocusMulticaster.hasListeners() ? this.subfocusMulticaster.vetoableDispatch((VetoableDispatch)e) : true;
    }

    protected void processSubfocusEvent(MatrixSubfocusEvent e) {
        if (this.subfocusMulticaster.hasListeners()) {
            this.subfocusMulticaster.dispatch((DispatchableEvent)e);
        }
    }

    protected void processMousePressed(MouseEvent e) {
        super.processMousePressed(e);
        int x = e.getX();
        int y = e.getY();
        boolean shift = e.isShiftDown();
        boolean control = e.isControlDown();
        boolean right = e.isMetaDown();
        this.rollover = null;
        int flags = shift && control ? 16 : (shift ? 17 : (control ? 72 : 67));
        MatrixLocation current = this.hitTest(x, y);
        MatrixLocation matrixLocation = this.mouseDown = current != null ? new MatrixLocation(current) : null;
        if (this.editor != null) {
            if (this.editorLocation.equals(current)) {
                return;
            }
            this.safeEndEdit();
        }
        this.resize = null;
        if (current != null) {
            if (current.equals(this.subfocus)) {
                if (!right && e.getClickCount() == 2) {
                    this.fireActionEvent();
                }
                if (!(right || control || shift || this.isToggleItem(current.row, current.column) || !this.canSet(current.row, current.column, false))) {
                    this.doStartEdit = true;
                    return;
                }
                if (control && !shift) {
                    if (this.selection.contains(current)) {
                        this.selection.remove(current);
                    } else {
                        this.selection.add(new MatrixLocation(current));
                    }
                }
            }
            this.rangeSelecting = true;
            this.setSubfocus(current.row, current.column, flags);
        }
        if (this.resizingGrid && !this.liveResize) {
            this.resize1 = this.resize;
            this.startResize(this.resizeColumn, this.resize1, x, y);
        }
    }

    protected void processMouseDragged(MouseEvent e) {
        this.rollover = null;
        if (this.dragSubfocus && !e.isMetaDown() && this.rangeSelecting) {
            int x = e.getX();
            int y = e.getY();
            int flags = e.isControlDown() ? 64 : 16;
            MatrixLocation current = this.hitTest(x, y);
            if (current != null) {
                this.setSubfocus(current.row, current.column, flags);
            }
        }
    }

    protected void processMouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        boolean shift = e.isShiftDown();
        boolean control = e.isControlDown();
        boolean right = e.isMetaDown();
        MatrixLocation current = this.hitTest(x, y);
        if (current != null && current.equals(this.mouseDown)) {
            this.editClickPoint = new Point(x, y);
            if (!right && (this.doStartEdit || this.isToggleItem(current.row, current.column))) {
                this.startEdit(current);
                this.doStartEdit = false;
            }
            this.editClickPoint = null;
        }
        if (this.resizingGrid && !this.liveResize) {
            this.stopResize(this.resizeColumn, this.resize, x, y);
            this.resize = null;
        }
        this.rangeSelecting = false;
        this.resizingGrid = false;
        this.mouseDown = null;
    }

    protected Dimension getPreferredCellSize(MatrixLocation cell, Object data) {
        int state = this.getState(cell.row, cell.column);
        ColumnView cv = this.getColumnView(cell.column);
        ItemPainter painter = this.getPainter(cell.row, cell.column, data, state);
        Dimension size = new Dimension(0, 0);
        if (painter != null) {
            size = painter.getPreferredSize(data, this.getSiteGraphics(), state, cv);
        }
        return size;
    }

    protected void processMouseMoved(MouseEvent e) {
        MatrixLocation hit;
        if (this.showRollover && (hit = this.hitTest(e.getX(), e.getY())) != null && !hit.equals(this.rollover)) {
            MatrixLocation oldRollover = this.rollover;
            this.rollover = hit;
            this.repaintCell(oldRollover);
            this.repaintCell(this.rollover);
        }
    }

    public JToolTip createToolTip() {
        return this.toolTip;
    }

    public String getToolTipText(MouseEvent e) {
        if (this.toolTip.active) {
            Object data;
            MatrixLocation hit = this.hitTest(e.getX(), e.getY());
            if (hit != null && this.model != null && this.viewManager != null && (data = this.model.get(hit.row, this.getColumnOrdinal(hit.column))) != null) {
                Rectangle r = this.getCellRect(hit);
                Dimension size = this.getPreferredCellSize(hit, data);
                Rectangle vp = this.scroller.getViewport().getViewRect();
                if (!(r == null || r.contains(r.x + size.width - 1, r.y + size.height - 1) && vp.contains(r.x, r.y) && vp.contains(r.x + size.width - 1, r.y + size.width - 1))) {
                    int state = this.getState(hit.row, hit.column);
                    this.toolTip.data = data;
                    this.toolTip.painter = this.getPainter(hit.row, hit.column, data, state);
                    this.toolTip.state = state;
                    return data.toString();
                }
            }
            return null;
        }
        this.toolTip.painter = null;
        return this.getToolTipText();
    }

    public Point getToolTipLocation(MouseEvent e) {
        Rectangle r;
        MatrixLocation hit;
        if (this.toolTip.active && this.getToolTipText(e) != null && (hit = this.hitTest(e.getX(), e.getY())) != null && (r = this.getCellRect(hit)) != null && this.model != null) {
            Object data = this.model.get(hit.row, hit.column);
            int state = this.getState(hit.row, hit.column);
            this.toolTip.data = data;
            this.toolTip.painter = this.getPainter(hit.row, hit.column, data, state);
            this.toolTip.state = state;
            return new Point(r.x - 1, r.y - 1);
        }
        this.toolTip.painter = null;
        return null;
    }

    protected void processMouseExited(MouseEvent e) {
        if (this.showRollover) {
            MatrixLocation oldRollover = this.rollover;
            this.rollover = null;
            this.repaintCell(oldRollover);
        }
    }

    protected void startEdit(MatrixLocation newEditorLocation) {
        if (this.model == null || this.viewManager == null || !this.editInPlace || !this.canSet(newEditorLocation.row, newEditorLocation.column, true) || this.batchMode) {
            return;
        }
        this.rollover = null;
        this.editorLocation = new MatrixLocation(newEditorLocation);
        this.selection.removeAll();
        this.selection.add(new MatrixLocation(this.editorLocation));
        Object data = this.model.get(this.editorLocation.row, this.getColumnOrdinal(this.editorLocation.column));
        int state = this.getState(this.editorLocation.row, this.editorLocation.column);
        this.editor = this.getEditor(this.editorLocation.row, this.editorLocation.column, data, state);
        if (this.editor != null) {
            Component editorComponent = this.editor.getComponent();
            if (editorComponent != null) {
                editorComponent.setVisible(false);
                this.add(editorComponent);
            }
            Rectangle r = this.getEditorRect();
            ItemEditSite site = this;
            if (this.columnViews != null && this.columnViews.length > this.editorLocation.column) {
                site = this.columnViews[this.editorLocation.column];
            }
            this.editor.addKeyListener(this);
            this.editor.addKeyListener(this.keyMulticaster);
            this.editor.startEdit(data, r, site);
            this.resyncEditor();
            if (this.editor != null && this.editor.getComponent() != null) {
                this.editor.getComponent().addFocusListener(this);
            }
            this.editClickPoint = null;
        }
    }

    private boolean isToggleItem(int row, int column) {
        int state;
        if (this.model == null || this.viewManager == null || !this.editInPlace || this.batchMode) {
            return false;
        }
        Object data = this.model.get(row, this.getColumnOrdinal(column));
        ItemEditor ie = this.getEditor(row, column, data, state = this.getState(row, column));
        if (ie instanceof ToggleItemEditor) {
            Rectangle rect = this.getCellRect(row, column);
            ItemEditSite site = this;
            if (this.columnViews != null && column < this.columnViews.length) {
                site = this.columnViews[column];
            }
            return ((ToggleItemEditor)ie).isToggle(data, rect, site) && this.canSet(row, column, false);
        }
        return false;
    }

    public void endEdit() throws Exception {
        this.endEdit(this.postOnEndEdit);
    }

    public void endEdit(boolean post) throws Exception {
        ItemEditor editor = this.editor;
        this.editor = null;
        if (editor != null) {
            Component editorComponent = editor.getComponent();
            if (post) {
                try {
                    boolean okToEnd = editor.canPost();
                    if (!okToEnd) {
                        throw new IllegalStateException(Res.bundle.getString(10));
                    }
                    if (post && okToEnd && this.canSet(this.editorLocation.row, this.editorLocation.column, true)) {
                        this.writeModel.set(this.editorLocation.row, this.getColumnOrdinal(this.editorLocation.column), editor.getValue());
                    }
                    editor.endEdit(post);
                }
                catch (Exception x) {
                    this.lockSubfocus = true;
                    this.editor = editor;
                    throw x;
                }
            }
            editor.removeKeyListener(this);
            editor.removeKeyListener(this.keyMulticaster);
            if (editorComponent != null) {
                this.remove(editorComponent);
                editorComponent.removeFocusListener(this);
            }
            this.lockSubfocus = false;
            this.repaintCell(this.editorLocation);
            this.editorLocation = null;
            this.editClickPoint = null;
            this.requestFocus();
        }
    }

    public void safeEndEdit() {
        this.safeEndEdit(this.postOnEndEdit);
    }

    public void safeEndEdit(boolean post) {
        try {
            this.endEdit(post);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Rectangle getCellRangeRect(MatrixLocation start, MatrixLocation end) {
        Rectangle sr;
        MatrixLocation s = new MatrixLocation(start.row < end.row ? start.row : end.row, start.column < end.column ? start.column : end.column);
        MatrixLocation e = new MatrixLocation(start.row > end.row ? start.row : end.row, start.column > end.column ? start.column : end.column);
        if (s.row <= e.row && s.column <= e.column && (sr = this.getCellRect(s)) != null) {
            Rectangle er = this.getCellRect(e);
            if (er != null) {
                return sr.union(er);
            }
            Dimension sz = this.getSize();
            Rectangle top = this.getCellRect(new MatrixLocation(0, e.column));
            int xmax = top != null ? top.x + top.width - 1 : sz.width - 1;
            Rectangle left = this.getCellRect(new MatrixLocation(e.row, 0));
            int ymax = left != null ? left.y + left.height - 1 : sz.height - 1;
            sr.add(xmax, ymax);
            return sr;
        }
        return null;
    }

    protected Rectangle getEditorRect() {
        Rectangle rect = null;
        if (this.editorLocation != null && this.editor != null && (rect = this.getCellRect(this.editorLocation)) != null) {
            Component c;
            if (this.visibleGrid) {
                --rect.x;
                ++rect.width;
                --rect.y;
                ++rect.height;
            }
            if (this.growEditor && (c = this.editor.getComponent()) != null) {
                Dimension ps = c.getPreferredSize();
                if (ps.height > rect.height) {
                    rect.height = ps.height;
                }
            }
        }
        return rect;
    }

    public void doLayout() {
        this.resyncEditor();
    }

    protected void resyncEditor() {
        if (this.editorLocation != null && this.editor != null) {
            Rectangle er = this.getEditorRect();
            this.editor.changeBounds(er != null ? er : new Rectangle());
        }
    }

    public void reset() {
        this.safeEndEdit(false);
        this.resize = null;
        this.setSubfocus(0, 0, 67);
        this.scroller.getViewport().setViewPosition(new Point());
        this.repaintCells();
    }

    public boolean startResize(boolean column, int index, int mouseX, int mouseY) {
        this.resize1 = column ? new MatrixLocation(0, index) : new MatrixLocation(index, 0);
        return this.startResize(column, this.resize1, mouseX, mouseY);
    }

    boolean startResize(boolean column, MatrixLocation location, int mouseX, int mouseY) {
        if (this.editorLocation != null) {
            this.safeEndEdit();
        }
        Rectangle outerRect = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        if (column) {
            Rectangle r = this.getCellRect(location);
            this.dividerDelta = mouseX - (r.x + r.width);
        } else {
            Rectangle r = this.getCellRect(location);
            this.dividerDelta = mouseY - (r.y + r.height);
        }
        this.resizingGrid = true;
        return true;
    }

    public boolean stopResize(boolean column, int index, int mouseX, int mouseY) {
        boolean retVal = this.stopResize(column, this.resize1, mouseX, mouseY);
        this.resize1 = null;
        this.invalidate();
        this.repaintCells();
        if (this.isShowing() && !this.batchMode) {
            Point vp = this.scroller.getViewport().getViewPosition();
            this.scroller.validate();
            this.scroller.getViewport().setViewPosition(vp);
        }
        return retVal;
    }

    public boolean stopResize(boolean column, MatrixLocation location, int mouseX, int mouseY) {
        if (location != null) {
            Rectangle r = this.getCellRect(location);
            if (column) {
                if (mouseX - this.dividerDelta - r.x > 1) {
                    this.columnSizes.setSize(location.column, mouseX - this.dividerDelta - r.x);
                    if (this.columnViews != null && this.columnViews.length > location.column) {
                        this.columnViews[location.column].setWidth(this.columnSizes.getSize(location.column));
                    }
                }
            } else if (mouseY - this.dividerDelta - r.y > 1) {
                this.rowSizes.setSize(location.row, mouseY - this.dividerDelta - r.y);
            }
        }
        this.resizingGrid = false;
        return true;
    }

    public boolean whileResize(boolean column, int index, int mouseX, int mouseY) {
        if (column) {
            // empty if block
        }
        this.invalidate();
        Point vp = this.scroller.getViewport().getViewPosition();
        this.scroller.validate();
        this.scroller.getViewport().setViewPosition(vp);
        this.repaintCells();
        return true;
    }

    public void startMove(boolean column, int index, int mouseX, int mouseY) {
        block0: {
            if (!column) break block0;
            this.moveIndex = index;
            this.resize1 = this.movingLocation = this.hitTest(mouseX, 0);
            Rectangle r = this.getCellRect(0, index);
            Rectangle vRect = this.scroller.getViewport().getViewRect();
            this.divider.setBounds(r.x - this.dividerWidth / 2, vRect.y, this.dividerWidth, vRect.height);
        }
    }

    public void whileMove(boolean column, int index, int mouseX, int mouseY) {
        block2: {
            int lastCol;
            MatrixLocation hit;
            block3: {
                this.divider.setVisible(true);
                if (!column) break block2;
                hit = this.hitTest(mouseX, 0);
                if (hit == this.resize1 || hit == null) break block3;
                Rectangle r = this.getCellRect(hit);
                Rectangle vRect = this.scroller.getViewport().getViewRect();
                if (mouseX - r.x > r.width / 2) {
                    this.divider.setLocation(r.x + r.width - this.dividerWidth / 2, vRect.y);
                } else {
                    this.divider.setLocation(r.x - this.dividerWidth / 2, vRect.y);
                }
                this.resize1 = hit;
                break block2;
            }
            if (hit != null || mouseX < this.columnSizes.getSizeUpTo(lastCol = this.getColumnCount() - 1)) break block2;
            Rectangle r = this.getCellRect(0, lastCol);
            this.divider.setLocation(r.x + r.width - this.dividerWidth / 2, this.scroller.getViewport().getViewPosition().y);
            this.resize1 = hit;
        }
    }

    private void moveColumnView(int index, int target) {
        if (index >= this.columnViews.length || target > this.columnViews.length) {
            return;
        }
        for (int i = 0; i < this.columnViews.length; ++i) {
            this.columnViews[i].setOrdinal(this.getColumnOrdinal(i));
        }
        int newIndex = index > target ? target : target - 1;
        ColumnView indexView = this.columnViews[index];
        int indexSize = this.columnSizes.getSize(index);
        if (newIndex < index) {
            for (int i = index; i > newIndex; --i) {
                this.columnViews[i] = this.columnViews[i - 1];
                this.columnSizes.setSize(i, this.columnSizes.getSize(i - 1));
            }
        } else {
            for (int i = index; i < newIndex; ++i) {
                this.columnViews[i] = this.columnViews[i + 1];
                this.columnSizes.setSize(i, this.columnSizes.getSize(i + 1));
            }
        }
        this.columnViews[newIndex] = indexView;
        this.columnSizes.setSize(newIndex, indexSize);
    }

    public void stopMove(boolean column, int index, int mouseX, int mouseY) {
        this.divider.setVisible(false);
        if (column) {
            MatrixLocation hit = this.hitTest(mouseX, 0);
            int target = -1;
            if (hit != null) {
                if (hit.column != this.movingLocation.column) {
                    Rectangle r = this.getCellRect(hit);
                    target = hit.column;
                    if (mouseX - r.x > r.width / 2) {
                        ++target;
                    }
                }
            } else if (mouseX >= this.columnSizes.getSizeUpTo(this.columnViews.length - 1)) {
                target = this.columnViews.length;
            } else if (mouseX < 0) {
                target = 0;
            }
            if (target != this.moveIndex && target - 1 != this.moveIndex && target != -1) {
                this.moveColumnView(this.moveIndex, target);
                this.repaintCells();
            }
        }
        this.movingLocation = null;
    }

    public void checkParentWindow() {
        this.findParentWindow();
    }

    private void fireActionEvent() {
        Object item = this.model != null ? this.model.get(this.subfocus.row, this.getColumnOrdinal(this.subfocus.column)) : null;
        String action = item != null ? item.toString() : "";
        this.processActionEvent(new ActionEvent(this.actionSource, 1001, action));
    }

    private void resetColumnSizes() {
        for (int i = 0; i < this.columnViews.length; ++i) {
            int width = this.columnViews[i].getWidth();
            if (width == 0) {
                width = this.defaultColWidth;
            }
            this.columnSizes.setSize(i, width > 4 ? width : 4);
            this.columnViews[i].setWidth(this.columnSizes.getSize(i));
        }
    }

    protected void fireCustomizeItemEvent(Object address, Object data, int state, CustomPaintSite cps) {
        if (this.customizeListeners != null) {
            cps.reset();
            for (int i = 0; i < this.customizeListeners.size(); ++i) {
                ((CustomItemListener)this.customizeListeners.elementAt(i)).customizeItem(address, data, state, cps);
            }
        }
    }

    public synchronized void addCustomItemListener(CustomItemListener l) {
        if (this.customizeListeners == null) {
            this.customizeListeners = new Vector();
        }
        this.customizeListeners.addElement(l);
    }

    public synchronized void removeCustomItemListener(CustomItemListener l) {
        if (this.customizeListeners != null) {
            this.customizeListeners.removeElement(l);
        }
        if (this.customizeListeners.size() == 0) {
            this.customizeListeners = null;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Hashtable<String, Object> hash = new Hashtable<String, Object>(8);
        if (this.model instanceof Serializable) {
            hash.put("mo", this.model);
        }
        if (this.viewManager instanceof Serializable) {
            hash.put("vm", this.viewManager);
        }
        if (this.selection instanceof Serializable) {
            hash.put("se", this.selection);
        }
        if (this.columnSizes instanceof Serializable) {
            hash.put("cs", this.columnSizes);
        }
        if (this.rowSizes instanceof Serializable) {
            hash.put("rs", this.rowSizes);
        }
        if (this.actionSource instanceof Serializable) {
            hash.put("as", this.actionSource);
        }
        s.writeObject(hash);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Hashtable hash = (Hashtable)s.readObject();
        Object data = hash.get("mo");
        if (data != null) {
            this.model = (MatrixModel)data;
        }
        if (this.model instanceof WritableMatrixModel) {
            this.writeModel = (WritableMatrixModel)this.model;
        }
        if ((data = hash.get("vm")) instanceof MatrixViewManager) {
            this.viewManager = (MatrixViewManager)data;
        }
        if ((data = hash.get("se")) instanceof WritableMatrixSelection) {
            this.selection = (WritableMatrixSelection)data;
        }
        if ((data = hash.get("cs")) instanceof SizeVector) {
            this.columnSizes = (SizeVector)data;
        }
        if ((data = hash.get("rs")) instanceof SizeVector) {
            this.rowSizes = (SizeVector)data;
        }
        this.actionSource = hash.get("as");
    }

    public static void debugRect(Graphics g, int x, int y, int width, int height) {
        if (g == null) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            return;
        }
        g.setClip(x, y, width, height);
        Color c = g.getColor();
        g.setColor(colorWheel.next());
        g.drawRect(x, y, width - 1, height - 1);
        g.drawRect(x + 1, y + 1, width - 3, height - 3);
        if (debugRectHashLeft) {
            for (int i = 0; i < x + width + height; i += debugRectInc) {
                g.drawLine(x, y + i, x + i, y);
            }
        } else {
            for (int i = 0; i < x + width + height; i += debugRectInc) {
                g.drawLine(x + width, y + i, x + width - i, y);
            }
        }
        boolean bl = debugRectHashLeft = !debugRectHashLeft;
        debugRectInc = debugRectInc > 15 ? 5 : (debugRectInc += 2);
        g.setColor(c);
        if (clip != null) {
            g.setClip(clip.x, clip.y, clip.width, clip.height);
        }
    }

    static {
        serialVersionUID = 200L;
        colorWheel = new ColorWheel(Color.red, 1, 100);
        debugRectInc = 10;
        debugRectHashLeft = true;
        MIN_CELL_SIZE = 4;
        TRACE_MOUSE = 23;
        CURSOR_DEFAULT = Cursor.getDefaultCursor();
        CURSOR_MOVE = new Cursor(13);
        CURSOR_SIZE_V = new Cursor(8);
        CURSOR_SIZE_H = new Cursor(10);
    }
}

