/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.DefaultLegendPopulatorRenderer;
import com.klg.jclass.swing.gauge.JCAbstractScale;
import com.klg.jclass.swing.gauge.JCCircularScale;
import com.klg.jclass.swing.gauge.JCGauge;
import com.klg.jclass.swing.gauge.JCLinearScale;
import com.klg.jclass.swing.gauge.JCPolygon;
import com.klg.jclass.swing.gauge.JCScale;
import com.klg.jclass.util.legend.JCLegend;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;

public class GaugeUtil {
    public static double angleToValue(double d, double d2, double d3, double d4, double d5) {
        if (d4 >= d5) {
            d5 += 360.0;
        }
        double d6 = d5 - d4;
        double d7 = Math.max(d3, d2) - Math.min(d2, d3);
        double d8 = d7 / d6;
        double d9 = d8 * (d - d4) + Math.min(d2, d3);
        return d9;
    }

    public static double arcAngle(double d, double d2) {
        double d3 = 0.0;
        d3 = d == d2 ? 360.0 : (d < d2 ? d2 - d : d2 + 180.0);
        return d3;
    }

    public static double clamp(double d, double d2, double d3) {
        if (d < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        return d;
    }

    public static void createLegendPopulatorRenderer(JCGauge jCGauge, JCScale jCScale) {
        JCLegend jCLegend = jCGauge.getLegend();
        DefaultLegendPopulatorRenderer defaultLegendPopulatorRenderer = new DefaultLegendPopulatorRenderer(jCLegend, jCScale.getRanges());
        jCLegend.setLegendPopulator(defaultLegendPopulatorRenderer);
        jCLegend.setLegendRenderer(defaultLegendPopulatorRenderer);
    }

    public static double distanceBetweenAngles(double d, double d2) {
        double d3 = Math.abs(d - d2);
        if (Math.abs(360.0 - d3) < d3) {
            d3 = Math.abs(360.0 - d3);
        }
        return d3;
    }

    public static void drawCircleForCircularScale(Graphics graphics, JCCircularScale jCCircularScale, Color color, double d, double d2, double d3) {
        int[] nArray = GaugeUtil.getCircleForCircularScale(jCCircularScale, d, d2, d3);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        Graphics graphics2 = graphics.create();
        graphics2.setColor(color);
        int n4 = 2 * n3;
        graphics2.fillArc(n -= n3, n2 -= n3, n4, n4, 0, 360);
        graphics2.dispose();
    }

    public static void drawCircleForLinearScale(Graphics graphics, JCLinearScale jCLinearScale, Color color, double d, double d2, double d3) {
        int[] nArray = GaugeUtil.getCircleForLinearScale(jCLinearScale, d, d2, d3, jCLinearScale.getScaleSize());
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray[2];
        Graphics graphics2 = graphics.create();
        graphics2.setColor(color);
        int n4 = 2 * n3;
        graphics2.fillArc(n -= n3, n2 -= n3, n4, n4, 0, 360);
        graphics2.dispose();
    }

    public static void drawCircularPolygon(Graphics graphics, JCCircularScale jCCircularScale, Color color, double d, double d2, double d3, double d4, boolean bl, boolean bl2, JCPolygon jCPolygon) {
        Polygon polygon = GaugeUtil.getCircularPolygon(jCCircularScale, d, d2, d3, d4, bl, bl2, jCPolygon);
        int n = polygon.npoints;
        Polygon polygon2 = new Polygon(new int[n - 1], new int[n - 1], n - 1);
        int n2 = 1;
        while (n2 < n) {
            polygon2.xpoints[n2 - 1] = polygon.xpoints[n2];
            polygon2.ypoints[n2 - 1] = polygon.ypoints[n2];
            ++n2;
        }
        Graphics graphics2 = graphics.create();
        graphics2.setColor(color);
        graphics2.translate(polygon.xpoints[0], polygon.ypoints[0]);
        graphics2.fillPolygon(polygon2);
        graphics2.dispose();
    }

    public static void drawLinearPolygon(Graphics graphics, JCLinearScale jCLinearScale, Color color, double d, double d2, double d3, double d4, boolean bl, boolean bl2, JCPolygon jCPolygon) {
        Polygon polygon = GaugeUtil.getLinearPolygon(jCLinearScale, d, d2, d3, d4, bl, bl2, jCPolygon, jCLinearScale.getScaleSize());
        int n = polygon.npoints;
        Polygon polygon2 = new Polygon(new int[n - 1], new int[n - 1], n - 1);
        int n2 = 1;
        while (n2 < n) {
            polygon2.xpoints[n2 - 1] = polygon.xpoints[n2];
            polygon2.ypoints[n2 - 1] = polygon.ypoints[n2];
            ++n2;
        }
        Graphics graphics2 = graphics.create();
        graphics2.setColor(color);
        graphics2.translate(polygon.xpoints[0], polygon.ypoints[0]);
        graphics2.fillPolygon(polygon2);
        graphics2.dispose();
    }

    public static double fromRadians(double d) {
        return d * 57.29577951308232;
    }

    public static int[] getCircleForCircularScale(JCCircularScale jCCircularScale, double d, double d2, double d3) {
        Rectangle rectangle = jCCircularScale.getCircularGauge().getArcBounds();
        double d4 = jCCircularScale.getRadius();
        double d5 = (double)rectangle.x + d4;
        double d6 = (double)rectangle.y + d4;
        double d7 = (d3 *= d4) - (d2 *= d4);
        double d8 = d7 / 2.0;
        double d9 = d2 + d8;
        double d10 = jCCircularScale.getMin();
        double d11 = jCCircularScale.getMax();
        double d12 = GaugeUtil.clamp(d, d10, d11);
        if (jCCircularScale.getDirection().equals(JCAbstractScale.Direction.BACKWARD)) {
            d12 = d11 - d12 + d10;
        }
        double d13 = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
        double d14 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
        double d15 = GaugeUtil.valueToAngle(d12, d10, d11, d13, d14);
        double d16 = GaugeUtil.toRadians(d15);
        int n = (int)d5 + (int)(d9 * Math.cos(d16));
        int n2 = (int)d6 - (int)(d9 * Math.sin(d16));
        int[] nArray = new int[]{n, n2, (int)d8};
        return nArray;
    }

    public static int[] getCircleForLinearScale(JCLinearScale jCLinearScale, double d, double d2, double d3, Rectangle rectangle) {
        int n;
        int n2;
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        JCAbstractScale.Direction direction = jCLinearScale.getDirection();
        double d4 = jCLinearScale.getMin();
        double d5 = jCLinearScale.getMax();
        d = GaugeUtil.clamp(d, d4, d5);
        if (direction.equals(JCAbstractScale.Direction.BACKWARD) ^ orientation == JCLinearScale.Orientation.VERTICAL) {
            d = d5 - d + d4;
        }
        if (orientation == JCLinearScale.Orientation.VERTICAL) {
            d2 *= (double)rectangle.width;
            d3 *= (double)rectangle.width;
        } else {
            d2 *= (double)rectangle.height;
            d3 *= (double)rectangle.height;
        }
        double d6 = d3 - d2;
        double d7 = d6 / 2.0;
        double d8 = d2 + d7;
        int n3 = orientation == JCLinearScale.Orientation.VERTICAL ? GaugeUtil.valueToPosition(d, d4, d5, rectangle.y, rectangle.y + rectangle.height) : GaugeUtil.valueToPosition(d, d4, d5, rectangle.x, rectangle.x + rectangle.width);
        if (orientation == JCLinearScale.Orientation.VERTICAL) {
            n2 = rectangle.x + (int)d8;
            n = n3;
        } else {
            n2 = n3;
            n = rectangle.y + (int)d8;
        }
        int[] nArray = new int[]{n2, n, (int)d7};
        return nArray;
    }

    public static Polygon getCircularPolygon(JCCircularScale jCCircularScale, double d, double d2, double d3, double d4, boolean bl, boolean bl2, JCPolygon jCPolygon) {
        int n;
        int n2;
        double d5 = jCCircularScale.getRadius();
        double d6 = (d2 *= d5) - (d *= d5);
        Rectangle rectangle = jCPolygon.getExtrema();
        double d7 = d6 / (double)(rectangle.x - rectangle.width);
        double d8 = d3 / (double)(rectangle.y - rectangle.height);
        Polygon polygon = GaugeUtil.scale(jCPolygon, Math.abs(d7), Math.abs(d8));
        double d9 = jCCircularScale.getMin();
        double d10 = jCCircularScale.getMax();
        double d11 = GaugeUtil.clamp(d4, d9, d10);
        if (jCCircularScale.getDirection().equals(JCAbstractScale.Direction.BACKWARD)) {
            d11 = d10 - d11 + d9;
        }
        double d12 = GaugeUtil.normalizeAngle(jCCircularScale.getStartAngle());
        double d13 = GaugeUtil.normalizeAngle(jCCircularScale.getStopAngle());
        double d14 = GaugeUtil.valueToAngle(d11, d9, d10, d12, d13);
        if (bl) {
            d14 = GaugeUtil.normalizeAngle(d14 + 180.0);
        }
        double d15 = GaugeUtil.toRadians(d14);
        Polygon polygon2 = GaugeUtil.rotate(polygon, d14);
        double d16 = d + d6 / 2.0;
        double d17 = bl2 ? d16 : d;
        Rectangle rectangle2 = jCCircularScale.getCircularGauge().getArcBounds();
        double d18 = (double)rectangle2.x + d5;
        double d19 = (double)rectangle2.y + d5;
        if (bl) {
            if (!bl2) {
                d17 += d6;
            }
            n2 = (int)d18 - (int)(d17 * Math.cos(d15));
            n = (int)d19 + (int)(d17 * Math.sin(d15));
        } else {
            n2 = (int)d18 + (int)(d17 * Math.cos(d15));
            n = (int)d19 - (int)(d17 * Math.sin(d15));
        }
        int n3 = polygon2.npoints + 1;
        Polygon polygon3 = new Polygon(new int[n3], new int[n3], n3);
        polygon3.xpoints[0] = n2;
        polygon3.ypoints[0] = n;
        int n4 = 1;
        while (n4 < polygon3.npoints) {
            polygon3.xpoints[n4] = polygon2.xpoints[n4 - 1];
            polygon3.ypoints[n4] = polygon2.ypoints[n4 - 1];
            ++n4;
        }
        return polygon3;
    }

    public static Polygon getLinearPolygon(JCLinearScale jCLinearScale, double d, double d2, double d3, double d4, boolean bl, boolean bl2, JCPolygon jCPolygon, Rectangle rectangle) {
        int n;
        int n2;
        double d5;
        JCLinearScale.Orientation orientation = jCLinearScale.getOrientation();
        JCAbstractScale.Direction direction = jCLinearScale.getDirection();
        double d6 = jCLinearScale.getMin();
        double d7 = jCLinearScale.getMax();
        d4 = GaugeUtil.clamp(d4, d6, d7);
        if (direction.equals(JCAbstractScale.Direction.BACKWARD) ^ orientation == JCLinearScale.Orientation.VERTICAL) {
            d4 = d7 - d4 + d6;
        }
        if (orientation == JCLinearScale.Orientation.VERTICAL) {
            d *= (double)rectangle.width;
            d2 *= (double)rectangle.width;
        } else {
            d *= (double)rectangle.height;
            d2 *= (double)rectangle.height;
        }
        double d8 = Math.abs(d2 - d);
        Rectangle rectangle2 = jCPolygon.getExtrema();
        double d9 = d8 / (double)(rectangle2.x - rectangle2.width);
        double d10 = d3 / (double)(rectangle2.y - rectangle2.height);
        Polygon polygon = GaugeUtil.scale(jCPolygon, Math.abs(d9), Math.abs(d10));
        double d11 = orientation == JCLinearScale.Orientation.VERTICAL ? (double)(bl ? 180 : 0) : (double)(bl ? 90 : 270);
        double d12 = GaugeUtil.toRadians(d11);
        Polygon polygon2 = GaugeUtil.rotate(polygon, d11);
        double d13 = d + d8 / 2.0;
        double d14 = d5 = bl2 ? d13 : d;
        if (bl && !bl2) {
            d5 += d8;
        }
        if (orientation == JCLinearScale.Orientation.VERTICAL) {
            n2 = GaugeUtil.valueToPosition(d4, d6, d7, rectangle.y, rectangle.y + rectangle.height);
            n = rectangle.x + (int)d5;
        } else {
            n = GaugeUtil.valueToPosition(d4, d6, d7, rectangle.x, rectangle.x + rectangle.width);
            n2 = rectangle.y + (int)d5;
        }
        int n3 = polygon2.npoints + 1;
        Polygon polygon3 = new Polygon(new int[n3], new int[n3], n3);
        polygon3.xpoints[0] = n;
        polygon3.ypoints[0] = n2;
        int n4 = 1;
        while (n4 < polygon3.npoints) {
            polygon3.xpoints[n4] = polygon2.xpoints[n4 - 1];
            polygon3.ypoints[n4] = polygon2.ypoints[n4 - 1];
            ++n4;
        }
        return polygon3;
    }

    public static double normalizeAngle(double d) {
        while (d >= 360.0) {
            d -= 360.0;
        }
        while (d < 0.0) {
            d += 360.0;
        }
        return d;
    }

    public static double pointToAngle(double d, double d2, double d3, double d4) {
        double d5 = d - d3;
        double d6 = d2 - d4;
        double d7 = d6 < 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        double d8 = Math.abs(d5) > 0.0 ? Math.atan2(-d6, d5) : d7;
        return GaugeUtil.fromRadians(d8);
    }

    public static double positionToValue(int n, double d, double d2, int n2, int n3) {
        double d3 = Math.max(n3, n2) - Math.min(n2, n3);
        double d4 = Math.max(d2, d) - Math.min(d, d2);
        double d5 = d4 / d3;
        double d6 = d5 * (double)(n - n2) + d;
        return d6;
    }

    public static Polygon rotate(Polygon polygon, double d) {
        if (d == 0.0) {
            return polygon;
        }
        Polygon polygon2 = new Polygon();
        int[] nArray = polygon.xpoints;
        int[] nArray2 = polygon.ypoints;
        double d2 = GaugeUtil.toRadians(d);
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            int n3 = nArray2[n];
            int n4 = (int)((double)n2 * d4 + (double)n3 * d3);
            int n5 = (int)((double)n3 * d4 - (double)n2 * d3);
            polygon2.addPoint(n4, n5);
            ++n;
        }
        return polygon2;
    }

    public static Polygon scale(Polygon polygon, double d, double d2) {
        Polygon polygon2 = new Polygon();
        int[] nArray = polygon.xpoints;
        int[] nArray2 = polygon.ypoints;
        int n = 0;
        while (n < nArray.length) {
            polygon2.addPoint((int)((double)nArray[n] * d), (int)((double)nArray2[n] * d2));
            ++n;
        }
        return polygon2;
    }

    public static double toRadians(double d) {
        return d * (Math.PI / 180);
    }

    public static Polygon translate(Polygon polygon, int n, int n2) {
        Polygon polygon2 = new Polygon();
        int n3 = 0;
        while (n3 < polygon.xpoints.length) {
            int n4 = polygon.xpoints[n3] + n;
            int n5 = polygon.ypoints[n3] + n2;
            polygon2.addPoint(n4, n5);
            ++n3;
        }
        return polygon2;
    }

    public static Polygon translateContour(Polygon polygon) {
        int n = polygon.npoints;
        Polygon polygon2 = new Polygon(new int[n - 1], new int[n - 1], n - 1);
        int n2 = 0;
        while (n2 < polygon2.npoints) {
            polygon2.xpoints[n2] = polygon.xpoints[n2 + 1] + polygon.xpoints[0];
            polygon2.ypoints[n2] = polygon.ypoints[n2 + 1] + polygon.ypoints[0];
            ++n2;
        }
        return polygon2;
    }

    public static double valueToAngle(double d, double d2, double d3, double d4, double d5) {
        if (d4 >= d5) {
            d5 += 360.0;
        }
        double d6 = d5 - d4;
        double d7 = Math.max(d3, d2) - Math.min(d2, d3);
        double d8 = d6 / d7;
        double d9 = d8 * (d - d2) + d4;
        d9 = GaugeUtil.normalizeAngle(d9);
        return d9;
    }

    public static int valueToPosition(double d, double d2, double d3, int n, int n2) {
        double d4 = Math.max(n2, n) - Math.min(n, n2);
        double d5 = Math.max(d3, d2) - Math.min(d2, d3);
        double d6 = d4 / d5;
        int n3 = (int)(d6 * (d - d2)) + n;
        return n3;
    }
}

