/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.Component;
import java.awt.Container;
import java.beans.Beans;

public class JCEnvironment {
    public static final int WORKING_UNKNOWN = 0;
    public static final int WORKING_YES = 1;
    public static final int WORKING_NO = 2;
    public static final String FILE_CHOOSER_MULTI_SELECTS = "FileChooserMultiSelects";
    public static final String MOTIF_TREE_LEAF_ICON = "MotifTreeLeafIcon";
    public static final String SET_RESIZABLE_TO_FALSE_ON_DIALOGS = "SetResizableToFalseOnDialogs";
    public static final String MOTIF_PREFERED_WIDTH_AJUSTMENT = "MotifPreferedWidthAjustment";
    public static final String HTML_IN_COMPONENTS = "HTMLInComponents";
    protected static String javaVersionString = null;
    protected static String vendorString = null;
    protected static int javaVersion = -1;

    private static int canSetResizableToFalseOnDialogs() {
        if (JCEnvironment.isMotif()) {
            return 2;
        }
        return 1;
    }

    private static int fileChooserMultiSelects() {
        if (JCEnvironment.getJavaVersion() < 130) {
            return 2;
        }
        return 1;
    }

    public static Applet getApplet(Component component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Applet) {
            return (Applet)component;
        }
        Container container = component.getParent();
        Container container2 = component.getParent();
        while (container2 != null && !(container2 instanceof Applet)) {
            container2 = container;
            container = container == null ? null : container.getParent();
        }
        return (Applet)container2;
    }

    public static AppletContext getAppletContext(Applet applet) {
        if (applet != null) {
            try {
                return applet.getAppletContext();
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public static int getJavaVersion() {
        if (javaVersion != -1) {
            return javaVersion;
        }
        String string = JCEnvironment.getVersionString();
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isDigit(c)) {
                string2 = String.valueOf(string2) + c;
            }
            ++n;
        }
        try {
            javaVersion = Integer.parseInt(string2);
            if (javaVersion > 0 && javaVersion < 100) {
                javaVersion *= 10;
            }
        }
        catch (NumberFormatException numberFormatException) {
            javaVersion = -1;
        }
        return javaVersion;
    }

    public static String getVendorString() {
        block2: {
            if (vendorString != null) break block2;
            try {
                vendorString = System.getProperty("java.vendor");
            }
            catch (Exception exception) {
                vendorString = null;
            }
        }
        return vendorString;
    }

    protected static String getVersionString() {
        block2: {
            if (javaVersionString != null) break block2;
            try {
                javaVersionString = System.getProperty("java.version");
            }
            catch (Exception exception) {
                javaVersionString = null;
            }
        }
        return javaVersionString;
    }

    private static int htmlInComponents() {
        String string = JCEnvironment.getVendorString();
        if (string.indexOf("Netscape") != -1) {
            return 2;
        }
        return 1;
    }

    public static boolean inBrowser(Component component) {
        return JCEnvironment.getAppletContext(JCEnvironment.getApplet(component)) != null;
    }

    public static boolean isDesignTime() {
        if (JCEnvironment.getVendorString().indexOf("Microsoft") != -1) {
            return false;
        }
        return Beans.isDesignTime() || JCEnvironment.isNetBeansDesignTime();
    }

    private static boolean isMotif() {
        String string = System.getProperty("os.name");
        String string2 = string.toLowerCase();
        return !string2.startsWith("win") && !string2.startsWith("mac") && !string2.startsWith("apple");
    }

    public static boolean isNetBeansDesignTime() {
        try {
            String string = System.getProperty("netbeans.design.time");
            return string != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean isVisualCafe() {
        String string = JCEnvironment.getVendorString();
        return string.indexOf("Symantec") != -1;
    }

    public static int isWorking(String string) {
        if (string == null) {
            throw new NullPointerException("Feature may not be null");
        }
        if (string.equals(MOTIF_TREE_LEAF_ICON)) {
            return 2;
        }
        if (string.equals(SET_RESIZABLE_TO_FALSE_ON_DIALOGS)) {
            return JCEnvironment.canSetResizableToFalseOnDialogs();
        }
        if (string.equals(MOTIF_PREFERED_WIDTH_AJUSTMENT)) {
            return JCEnvironment.motifPreferedWidthAjustment();
        }
        if (string.equals(HTML_IN_COMPONENTS)) {
            return JCEnvironment.htmlInComponents();
        }
        if (string.equals(FILE_CHOOSER_MULTI_SELECTS)) {
            return JCEnvironment.fileChooserMultiSelects();
        }
        return 0;
    }

    private static int motifPreferedWidthAjustment() {
        if (JCEnvironment.isMotif()) {
            return 4;
        }
        return 0;
    }
}

