/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.Version;
import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.CalendarContainer;
import com.klg.jclass.util.calendar.DayTable;
import com.klg.jclass.util.calendar.MonthLabel;
import com.klg.jclass.util.calendar.MonthPopdown;
import com.klg.jclass.util.calendar.MonthSpin;
import com.klg.jclass.util.calendar.MonthTable;
import com.klg.jclass.util.calendar.YearLabel;
import com.klg.jclass.util.calendar.YearSpin;
import com.klg.jclass.util.value.CalendarValueModel;
import com.klg.jclass.util.value.JCValueEvent;
import com.klg.jclass.util.value.JCValueListener;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Toolkit;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class JCDateChooser
extends CalendarContainer
implements Serializable {
    public static final int QUICK_SELECT = 1;
    public static final int DUAL_SPIN = 2;
    public static final int SPIN_POPDOWN = 3;
    public static final int READ_ONLY = 4;
    protected int chooserType;
    protected CalendarComponent year;
    protected CalendarComponent month;
    protected CalendarComponent day;
    protected Calendar maximumDate;
    protected Calendar minimumDate;
    protected int componentSpacing = 4;
    private BoundsValidator boundsValidator = new BoundsValidator();
    protected String version = "????";
    protected String about = "????";

    public JCDateChooser() {
        this(new CalendarValueModel(Calendar.getInstance()), Locale.getDefault(), 1);
    }

    public JCDateChooser(JCValueModel jCValueModel, Locale locale) {
        this(jCValueModel, locale, 1);
    }

    public JCDateChooser(JCValueModel jCValueModel, Locale locale, int n) {
        this.setCalendarModel(jCValueModel);
        this.setLocale(locale);
        this.setLayout(new Layout());
        this.setChooserType(n);
    }

    protected void forceRelayout() {
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    public String getAbout() {
        return Version.getVersionString();
    }

    public int getChooserType() {
        return this.chooserType;
    }

    public CalendarComponent getDayComponent() {
        return this.day;
    }

    public Calendar getMaximumDate() {
        return this.maximumDate;
    }

    public Calendar getMinimumDate() {
        return this.minimumDate;
    }

    public CalendarComponent getMonthComponent() {
        return this.month;
    }

    public Calendar getValue() {
        return (Calendar)this.model.getValue();
    }

    public String getVersion() {
        return this.version;
    }

    public CalendarComponent getYearComponent() {
        return this.year;
    }

    public synchronized void setAbout(String string) {
    }

    public void setCalendarModel(JCValueModel jCValueModel) {
        JCValueModel jCValueModel2 = this.model;
        super.setCalendarModel(jCValueModel);
        if (jCValueModel2 != null) {
            jCValueModel2.removeValueListener(this.boundsValidator);
        }
        if (jCValueModel != null) {
            jCValueModel.addValueListener(this.boundsValidator);
        }
    }

    public void setChooserType(int n) {
        if (this.chooserType == n) {
            return;
        }
        JComponent jComponent = (JComponent)((Object)this.year);
        JComponent jComponent2 = (JComponent)((Object)this.month);
        JComponent jComponent3 = (JComponent)((Object)this.day);
        switch (n) {
            case 3: {
                this.year = new YearSpin(this.model, this.locale);
                this.month = new MonthPopdown(this.model, this.locale);
                this.day = new DayTable(this.model, this.specialDates, this.locale);
                break;
            }
            case 2: {
                this.year = new YearSpin(this.model, this.locale);
                this.month = new MonthSpin(this.model, this.locale);
                this.day = new DayTable(this.model, this.specialDates, this.locale);
                break;
            }
            case 1: {
                this.year = new YearSpin(this.model, this.locale);
                this.month = new MonthTable(this.model, this.locale);
                this.day = new DayTable(this.model, this.specialDates, this.locale);
                break;
            }
            case 4: {
                this.year = new YearLabel(this.model, this.locale);
                this.month = new MonthLabel(this.model, this.locale);
                this.day = new DayTable(this.model, this.specialDates, this.locale);
                ((DayTable)this.day).setEditable(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid value for ChooserType");
            }
        }
        if (this.getComponentCount() != 0) {
            this.removeAll();
        }
        this.add((Component)((Object)this.year));
        this.add((Component)((Object)this.month));
        this.add((Component)((Object)this.day));
        if (jComponent != null) {
            this.remove(jComponent);
        }
        if (jComponent2 != null) {
            this.remove(jComponent2);
        }
        if (jComponent3 != null) {
            this.remove(jComponent3);
        }
        this.chooserType = n;
    }

    public void setMaximumDate(Calendar calendar) {
        this.maximumDate = calendar;
    }

    public void setMinimumDate(Calendar calendar) {
        this.minimumDate = calendar;
    }

    public void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
    }

    public void setValue(Calendar calendar) {
        this.model.setValue(calendar);
    }

    public void setVersion(String string) {
    }

    private class BoundsValidator
    implements JCValueListener,
    Serializable {
        BoundsValidator() {
        }

        public void valueChanged(JCValueEvent jCValueEvent) {
        }

        public void valueChanging(JCValueEvent jCValueEvent) {
            if (JCDateChooser.this.maximumDate != null && JCDateChooser.this.maximumDate.before(jCValueEvent.getNewValue()) || JCDateChooser.this.minimumDate != null && JCDateChooser.this.minimumDate.after(jCValueEvent.getNewValue())) {
                jCValueEvent.setAllowChange(false);
                Toolkit toolkit = JCDateChooser.this.getToolkit();
                if (toolkit != null) {
                    toolkit.beep();
                }
            }
        }
    }

    private class Layout
    implements LayoutManager2,
    Serializable {
        Layout() {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }

        public void layoutContainer(Container container) {
            int n;
            int n2;
            int n3;
            int n4;
            Component component = (Component)((Object)JCDateChooser.this.year);
            Component component2 = (Component)((Object)JCDateChooser.this.month);
            Component component3 = (Component)((Object)JCDateChooser.this.day);
            Dimension dimension = component.getPreferredSize();
            Dimension dimension2 = component2.getPreferredSize();
            Dimension dimension3 = component3.getPreferredSize();
            Dimension dimension4 = container.getSize();
            if (JCDateChooser.this.chooserType == 1) {
                n4 = JCDateChooser.this.componentSpacing;
                n3 = dimension.height;
                if (dimension4.width > dimension.width) {
                    n2 = (dimension4.width - dimension.width) / 2;
                    n = dimension.width;
                } else {
                    n2 = 0;
                    n = dimension4.width;
                }
                component.setBounds(n2, n4, n, n3);
                n4 += n3;
                n3 = dimension2.height;
                n2 = 0;
                n = dimension4.width;
                component2.setBounds(n2, n4 += JCDateChooser.this.componentSpacing, n, n3);
            } else {
                n4 = JCDateChooser.this.componentSpacing;
                n3 = Math.max(dimension.height, dimension2.height);
                if (dimension4.width > dimension.width + dimension2.width) {
                    n2 = (dimension4.width - (dimension.width + dimension2.width)) / 2;
                    n = -1;
                } else {
                    n2 = 0;
                    n = dimension4.width / 2;
                }
                int n5 = n == -1 ? dimension.width : n;
                component.setBounds(n2, n4, n5, n3);
                n2 += n5;
                n5 = n == -1 ? dimension2.width : dimension4.width - n;
                component2.setBounds(n2 += JCDateChooser.this.componentSpacing, n4, n5, n3);
            }
            n4 += n3;
            n3 = dimension3.height;
            n2 = 0;
            n = dimension4.width;
            component3.setBounds(n2, n4 += JCDateChooser.this.componentSpacing, n, n3);
        }

        public Dimension maximumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            Component component = (Component)((Object)JCDateChooser.this.year);
            Component component2 = (Component)((Object)JCDateChooser.this.month);
            Component component3 = (Component)((Object)JCDateChooser.this.day);
            Dimension dimension = component.getMinimumSize();
            Dimension dimension2 = component2.getMinimumSize();
            Dimension dimension3 = component3.getMinimumSize();
            if (JCDateChooser.this.chooserType == 1) {
                return new Dimension(Math.max(dimension3.width, Math.max(dimension.width, dimension2.width)), dimension2.height + dimension.height + dimension3.height + JCDateChooser.this.componentSpacing);
            }
            return new Dimension(Math.max(dimension3.width, dimension.width + dimension2.width), Math.max(dimension2.height, dimension.height) + dimension3.height + JCDateChooser.this.componentSpacing);
        }

        public Dimension preferredLayoutSize(Container container) {
            Component component = (Component)((Object)JCDateChooser.this.year);
            Component component2 = (Component)((Object)JCDateChooser.this.month);
            Component component3 = (Component)((Object)JCDateChooser.this.day);
            Dimension dimension = component.getPreferredSize();
            Dimension dimension2 = component2.getPreferredSize();
            Dimension dimension3 = component3.getPreferredSize();
            if (JCDateChooser.this.chooserType == 1) {
                return new Dimension(Math.max(dimension3.width, Math.max(dimension.width, dimension2.width)), dimension2.height + dimension.height + dimension3.height + 3 * JCDateChooser.this.componentSpacing);
            }
            return new Dimension(Math.max(dimension3.width, dimension.width + dimension2.width + JCDateChooser.this.componentSpacing), Math.max(dimension2.height, dimension.height) + 2 * JCDateChooser.this.componentSpacing + dimension3.height);
        }

        public void removeLayoutComponent(Component component) {
        }
    }
}

