/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.build;

import com.borland.compiler.interfaces.Storage;
import com.borland.compiler.util.Host;
import com.borland.primetime.util.AssertionException;
import com.borland.primetime.util.Streams;
import com.borland.primetime.vfs.Buffer;
import com.borland.primetime.vfs.FileFilesystem;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class UrlStorage
implements Storage {
    private Url a;

    public String toString() {
        if (this.a.getFilesystem() == FileFilesystem.FILESYSTEM) {
            return this.a.getFileObject().toString();
        }
        return this.a.toString();
    }

    public int hashCode() {
        return this.a.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof UrlStorage) {
            return this.a.equals(((UrlStorage)object).a);
        }
        return false;
    }

    public void close() {
    }

    public Storage createDir(String string) throws IOException {
        throw new AssertionException();
    }

    public Storage create(String string) throws IOException {
        throw new AssertionException();
    }

    public Storage openDir(String string) {
        Url url = this.a.getRelativeUrl(string.replace('\\', '/'));
        return new UrlStorage(url);
    }

    public Storage open(String string) {
        Url url = this.a.getRelativeUrl(string.replace('\\', '/'));
        return new UrlStorage(url);
    }

    public String[] list() throws IOException {
        Url[] urlArray = VFS.getChildren(this.a, 3);
        String[] stringArray = new String[urlArray.length];
        for (int i2 = 0; i2 < urlArray.length; ++i2) {
            stringArray[i2] = urlArray[i2].getName().replace('/', '\\');
        }
        return stringArray;
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        throw new AssertionException();
    }

    public int read(byte[] byArray) throws IOException {
        byte[] byArray2;
        System.arraycopy(byArray2, 0, byArray, 0, byArray.length < (byArray2 = this.read()).length ? byArray.length : byArray2.length);
        return byArray2.length;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte[] read() throws IOException {
        byte[] byArray;
        Buffer buffer = VFS.findBuffer(this.a);
        if (buffer != null) {
            buffer.check();
            return buffer.getContent();
        }
        InputStream inputStream = null;
        try {
            inputStream = VFS.getInputStream(this.a);
            byArray = Streams.read(inputStream);
            Object var5_4 = null;
            if (inputStream == null) return byArray;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return byArray;
    }

    public boolean isDirectory() {
        return VFS.isDirectory(this.a);
    }

    public String getParent() {
        Url url = this.a.getParent();
        File file = url.getFileObject();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return url.toString();
    }

    public String getCanonicalPath() {
        return this.getPath();
    }

    public String getPath() {
        File file = this.a.getFileObject();
        if (file != null) {
            return file.getAbsolutePath();
        }
        return this.a.toString();
    }

    public String getName() {
        return this.a.getName();
    }

    public long modDate() {
        long l2 = VFS.getLastModified(this.a);
        return Host.javaTimeToTimeStamp(l2);
    }

    public Url getUrl() {
        return this.a;
    }

    public UrlStorage(Url url) {
        this.a = VFS.getCanonicalUrl(url);
    }
}

