/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.debugger;

import com.borland.jbuilder.debugger.BreakpointTreeNode;
import com.borland.jbuilder.debugger.ClassBreakpointTreeNode;
import com.borland.jbuilder.debugger.CrossProcessBreakpointTreeNode;
import com.borland.jbuilder.debugger.DebugInfoManager;
import com.borland.jbuilder.debugger.DebugJavaProcessTracker;
import com.borland.jbuilder.debugger.DebugSaveTreeModel;
import com.borland.jbuilder.debugger.DebugSaveTreeNode;
import com.borland.jbuilder.debugger.ExceptionBreakpointTreeNode;
import com.borland.jbuilder.debugger.FieldBreakpointTreeNode;
import com.borland.jbuilder.debugger.LineBreakpointTreeNode;
import com.borland.jbuilder.debugger.MethodBreakpointTreeNode;
import com.borland.jbuilder.debugger.c;
import com.borland.jbuilder.debugger.fc;
import com.borland.jbuilder.debugger.th;
import com.borland.jbuilder.info.JBuilderInfo;
import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.node.JavaFileNode;
import com.borland.jbuilder.node.JspFileNode;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.Gutter;
import com.borland.primetime.editor.GutterMark;
import com.borland.primetime.ide.GutterIcons;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.TextFileNode;
import com.borland.primetime.ui.LazyTreeNode;
import com.borland.primetime.util.Platform;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.viewer.NodeViewMap;
import com.sun.jdi.Field;
import com.sun.jdi.VirtualMachine;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.List;

public class BreakpointTreeModel
extends DebugSaveTreeModel {
    private DebugJavaProcessTracker a = null;
    private JBProject b;
    private ArrayList c = new ArrayList();

    static ArrayList a(BreakpointTreeModel breakpointTreeModel) {
        return breakpointTreeModel.c;
    }

    public void addFromArray(String[] stringArray) {
        if (stringArray != null) {
            int n2 = stringArray.length;
            block11: for (int i2 = 0; i2 < n2; ++i2) {
                ArrayList arrayList = DebugSaveTreeNode.parseSaveString(stringArray[i2]);
                if (arrayList.size() <= 0) continue;
                String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
                int n3 = BreakpointTreeNode.getBreakpointType(stringArray2[0]);
                switch (n3) {
                    case 0: {
                        LineBreakpointTreeNode.createFromString(stringArray2, this);
                        continue block11;
                    }
                    default: {
                        if (!JBuilderInfo.isProEnabled()) continue block11;
                        switch (n3) {
                            case 1: {
                                ExceptionBreakpointTreeNode.createFromString(stringArray2, this);
                                continue block11;
                            }
                            case 3: {
                                ClassBreakpointTreeNode.createFromString(stringArray2, this);
                                continue block11;
                            }
                            case 2: {
                                MethodBreakpointTreeNode.createFromString(stringArray2, this);
                                continue block11;
                            }
                        }
                        if (!JBuilderInfo.isEnterpriseEnabled()) continue block11;
                        switch (n3) {
                            case 4: {
                                CrossProcessBreakpointTreeNode.createFromString(stringArray2, this);
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean haveBreakpoints() {
        return this.getBreakpointList().size() > 0;
    }

    public void resetBreakpoints(VirtualMachine virtualMachine) {
        int n2 = this.c.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            BreakpointTreeNode breakpointTreeNode = (BreakpointTreeNode)this.c.get(i2);
            breakpointTreeNode.reset();
            breakpointTreeNode.cleanUp(virtualMachine);
        }
    }

    public String getClassNameFromLine(Gutter gutter, int n2) {
        return DebugJavaProcessTracker.getClassNameFromLine(gutter.getEditor(), n2);
    }

    public LineBreakpointTreeNode[] findLineBreakpoints(Url url, int n2) {
        if (url != null) {
            String string = url.getFile();
            ArrayList<BreakpointTreeNode> arrayList = new ArrayList<BreakpointTreeNode>();
            boolean bl = false;
            int n3 = this.c.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                BreakpointTreeNode breakpointTreeNode = (BreakpointTreeNode)this.c.get(i2);
                if (!(breakpointTreeNode instanceof LineBreakpointTreeNode) || !((LineBreakpointTreeNode)breakpointTreeNode).equalsFileName(n2, string)) continue;
                bl = true;
                arrayList.add(breakpointTreeNode);
            }
            if (bl) {
                return arrayList.toArray(new LineBreakpointTreeNode[arrayList.size()]);
            }
        }
        return null;
    }

    public void showLineBreakpointProperties(Gutter gutter, int n2) {
        Url url;
        LineBreakpointTreeNode[] lineBreakpointTreeNodeArray;
        EditorPane editorPane = gutter.getEditor();
        FileNode fileNode = NodeViewMap.getNode(editorPane);
        if (fileNode != null && DebugInfoManager.isDebuggableTextFileNode(fileNode) && (lineBreakpointTreeNodeArray = this.findLineBreakpoints(url = ((TextFileNode)fileNode).getUrl(), n2)) != null) {
            lineBreakpointTreeNodeArray[0].showBreakpointPropertiesReadOnly(gutter.getEditor(), com.borland.jbuilder.debugger.c.a(77));
        }
    }

    public void toggleBreakpoint(Gutter gutter, int n2) {
        EditorPane editorPane = gutter.getEditor();
        FileNode fileNode = NodeViewMap.getNode(editorPane);
        if (fileNode != null && DebugInfoManager.isDebuggableTextFileNode(fileNode)) {
            Url url = ((TextFileNode)fileNode).getUrl();
            LineBreakpointTreeNode[] lineBreakpointTreeNodeArray = this.findLineBreakpoints(url, n2);
            if (lineBreakpointTreeNodeArray == null) {
                if (fileNode instanceof JavaFileNode || fileNode instanceof JspFileNode) {
                    String string = this.getClassNameFromLine(gutter, n2);
                    if (string != null && !string.equals("")) {
                        this.createLineBreakpoint((Component)editorPane, string, n2, url, gutter);
                    }
                } else {
                    this.createLineBreakpoint((Component)editorPane, "", n2, url, gutter);
                }
            } else {
                for (int i2 = 0; i2 < lineBreakpointTreeNodeArray.length; ++i2) {
                    this.a(lineBreakpointTreeNodeArray[i2], gutter);
                }
            }
        }
    }

    public void linesChanged(Gutter gutter, String string) {
        ArrayList arrayList = this.c;
        synchronized (arrayList) {
            int n2 = this.c.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                boolean bl;
                LineBreakpointTreeNode lineBreakpointTreeNode;
                BreakpointTreeNode breakpointTreeNode = (BreakpointTreeNode)this.c.get(i2);
                if (!(breakpointTreeNode instanceof LineBreakpointTreeNode) || !string.equals((lineBreakpointTreeNode = (LineBreakpointTreeNode)breakpointTreeNode).getFileName()) || !(bl = lineBreakpointTreeNode.checkLineChanged())) continue;
                this.a(lineBreakpointTreeNode, gutter);
                --n2;
                --i2;
            }
        }
    }

    public void lineClicked(Gutter gutter, int n2, MouseEvent mouseEvent) {
        if (Platform.isSpecialDown(mouseEvent)) {
            this.showLineBreakpointProperties(gutter, n2);
        } else {
            this.toggleBreakpoint(gutter, n2);
        }
    }

    public void setProject(JBProject jBProject) {
        this.b = jBProject;
    }

    public JBProject getProject() {
        return this.b;
    }

    public VirtualMachine getVirtualMachine() {
        VirtualMachine virtualMachine = null;
        if (this.a != null) {
            virtualMachine = this.a.virtualMachine();
        }
        return virtualMachine;
    }

    public DebugJavaProcessTracker getTracker() {
        return this.a;
    }

    public void setTracker(DebugJavaProcessTracker debugJavaProcessTracker) {
        this.a = debugJavaProcessTracker;
    }

    public List getBreakpointList() {
        return this.c;
    }

    public void enableAllBreakpoints(boolean bl) {
        int n2 = this.c.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            BreakpointTreeNode breakpointTreeNode = (BreakpointTreeNode)this.c.get(i2);
            breakpointTreeNode.enableBreakpointAllProcesses(bl);
        }
        this.rebuildModel();
    }

    public void deleteAllBreakpoints() {
        BreakpointTreeNode breakpointTreeNode = null;
        int n2 = this.c.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            BreakpointTreeNode breakpointTreeNode2 = (BreakpointTreeNode)this.c.get(i2);
            if (breakpointTreeNode2 instanceof fc) {
                breakpointTreeNode = breakpointTreeNode2;
                continue;
            }
            breakpointTreeNode2.clearVisualBreakpoint(null);
            breakpointTreeNode2.deleteBreakpointAllProcesses();
        }
        this.c.clear();
        if (breakpointTreeNode != null) {
            this.c.add(breakpointTreeNode);
        }
        this.rebuildModel();
    }

    public void disconnectAllBreakpoints(VirtualMachine virtualMachine) {
        int n2 = this.c.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((BreakpointTreeNode)this.c.get(i2)).disconnect(virtualMachine);
        }
    }

    public void connectAllBreakpoints(VirtualMachine virtualMachine) {
        int n2 = this.c.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            ((BreakpointTreeNode)this.c.get(i2)).connect(virtualMachine);
        }
    }

    private void a(BreakpointTreeNode breakpointTreeNode, Gutter gutter) {
        breakpointTreeNode.clearVisualBreakpoint(gutter);
        breakpointTreeNode.deleteBreakpointAllProcesses();
        ((AbstractCollection)this.c).remove(breakpointTreeNode);
        this.rebuildModel();
    }

    public void deleteBreakpoint(BreakpointTreeNode breakpointTreeNode) {
        this.a(breakpointTreeNode, null);
    }

    private LineBreakpointTreeNode a(Component component, LineBreakpointTreeNode lineBreakpointTreeNode, Gutter gutter) {
        if (!lineBreakpointTreeNode.hasAllNecessaryInfo()) {
            lineBreakpointTreeNode.showBreakpointProperties(component, com.borland.jbuilder.debugger.c.a(20));
        }
        if (lineBreakpointTreeNode.hasAllNecessaryInfo()) {
            lineBreakpointTreeNode.connectBreakpointAllProcesses();
            this.c.add(lineBreakpointTreeNode);
            this.rebuildModel();
            if (lineBreakpointTreeNode.getLineMark() == null) {
                lineBreakpointTreeNode.markLine(true, gutter, false);
            }
        } else {
            lineBreakpointTreeNode = null;
        }
        return lineBreakpointTreeNode;
    }

    public LineBreakpointTreeNode createLineBreakpoint(Component component, String string, int n2, FileNode fileNode, Gutter gutter) {
        LineBreakpointTreeNode lineBreakpointTreeNode = new LineBreakpointTreeNode(string, n2, fileNode, this);
        return this.a(component, lineBreakpointTreeNode, gutter);
    }

    public LineBreakpointTreeNode createLineBreakpoint(Component component, String string, int n2, Url url, Gutter gutter) {
        LineBreakpointTreeNode lineBreakpointTreeNode = new LineBreakpointTreeNode(string, n2, url, this);
        return this.a(component, lineBreakpointTreeNode, gutter);
    }

    public void createFieldBreakpoint(Field field) {
        this.c.add(new FieldBreakpointTreeNode(field, this));
        this.rebuildModel();
    }

    public ExceptionBreakpointTreeNode createExceptionBreakpoint(Component component, String string, boolean bl, boolean bl2) {
        ExceptionBreakpointTreeNode exceptionBreakpointTreeNode = new ExceptionBreakpointTreeNode(string, bl, bl2, this);
        if (!exceptionBreakpointTreeNode.hasAllNecessaryInfo()) {
            exceptionBreakpointTreeNode.showBreakpointProperties(component, com.borland.jbuilder.debugger.c.a(16));
        }
        if (exceptionBreakpointTreeNode.hasAllNecessaryInfo()) {
            exceptionBreakpointTreeNode.connectBreakpointAllProcesses();
            this.c.add(exceptionBreakpointTreeNode);
            this.rebuildModel();
        } else {
            exceptionBreakpointTreeNode = null;
        }
        return exceptionBreakpointTreeNode;
    }

    public CrossProcessBreakpointTreeNode createCrossProcessBreakpoint(Component component, String string, String string2, String string3) {
        CrossProcessBreakpointTreeNode crossProcessBreakpointTreeNode = new CrossProcessBreakpointTreeNode(string, string2, string3, this);
        if (!crossProcessBreakpointTreeNode.hasAllNecessaryInfo()) {
            crossProcessBreakpointTreeNode.showBreakpointProperties(component, com.borland.jbuilder.debugger.c.a(11));
        }
        if (crossProcessBreakpointTreeNode.hasAllNecessaryInfo()) {
            crossProcessBreakpointTreeNode.connectBreakpointAllProcesses();
            this.c.add(crossProcessBreakpointTreeNode);
            this.rebuildModel();
        } else {
            crossProcessBreakpointTreeNode = null;
        }
        return crossProcessBreakpointTreeNode;
    }

    public MethodBreakpointTreeNode createMethodBreakpoint(Component component, String string, String string2, String string3) {
        MethodBreakpointTreeNode methodBreakpointTreeNode = new MethodBreakpointTreeNode(string, string2, string3, this);
        if (!methodBreakpointTreeNode.hasAllNecessaryInfo()) {
            methodBreakpointTreeNode.showBreakpointProperties(component, com.borland.jbuilder.debugger.c.a(24));
        }
        if (methodBreakpointTreeNode.hasAllNecessaryInfo()) {
            methodBreakpointTreeNode.connectBreakpointAllProcesses();
            this.c.add(methodBreakpointTreeNode);
            this.rebuildModel();
        } else {
            methodBreakpointTreeNode = null;
        }
        return methodBreakpointTreeNode;
    }

    public ClassBreakpointTreeNode createClassBreakpoint(Component component, String string) {
        ClassBreakpointTreeNode classBreakpointTreeNode = new ClassBreakpointTreeNode(string, this);
        if (!classBreakpointTreeNode.hasAllNecessaryInfo()) {
            classBreakpointTreeNode.showBreakpointProperties(component, com.borland.jbuilder.debugger.c.a(7));
        }
        if (classBreakpointTreeNode.hasAllNecessaryInfo()) {
            classBreakpointTreeNode.connectBreakpointAllProcesses();
            this.c.add(classBreakpointTreeNode);
            this.rebuildModel();
        } else {
            classBreakpointTreeNode = null;
        }
        return classBreakpointTreeNode;
    }

    public BreakpointTreeModel(JBProject jBProject) {
        super(new LazyTreeNode());
        this.setRoot(new th(this));
        this.b = jBProject;
        this.c.add(new fc(this));
    }

    public static class ExecLineMark
    extends GutterMark {
        public int getDisplayPriority() {
            return 800;
        }

        public ExecLineMark() {
            super(true, GutterIcons.ICON_EXECLINE);
        }
    }
}

