/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.debugger;

import com.borland.jbuilder.debugger.DebugTreeNode;
import com.borland.jbuilder.debugger.StaticFieldVariable;
import com.borland.jbuilder.debugger.WatchDescriptor;
import com.borland.jbuilder.debugger.ih;
import com.borland.jbuilder.node.java.JavaStructureConstants;
import com.borland.jbuilder.node.java.JavaStructureIcons;
import com.borland.primetime.ide.BrowserIcons;
import com.borland.primetime.ui.LazyTreeNode;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class ClassTreeNode
extends DebugTreeNode
implements JavaStructureConstants {
    private ReferenceType a;

    public String toString() {
        return this.a.name();
    }

    public TreeNode[] createNodes() {
        Object object;
        int n2;
        List<InterfaceType> list;
        if (!this.a.isPrepared()) {
            return LazyTreeNode.EMPTY_NODES;
        }
        ArrayList<DebugTreeNode> arrayList = new ArrayList<DebugTreeNode>();
        if (this.a instanceof ClassType && (list = ((ClassType)this.a).superclass()) != null) {
            arrayList.add(new ClassTreeNode((ReferenceType)((Object)list)));
        }
        list = null;
        if (this.a instanceof ClassType) {
            list = ((ClassType)this.a).interfaces();
        } else if (this.a instanceof InterfaceType) {
            list = ((InterfaceType)this.a).superinterfaces();
        }
        if (list != null) {
            int n3 = list.size();
            for (n2 = 0; n2 < n3; ++n2) {
                arrayList.add(new ClassTreeNode(list.get(n2)));
            }
        }
        List<Field> list2 = this.a.visibleFields();
        n2 = list2.size();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i2 = 0; i2 < n2; ++i2) {
            object = list2.get(i2);
            if (!object.isStatic() || !object.declaringType().equals(this.a)) continue;
            arrayList2.add(object);
        }
        Collections.sort(arrayList2, new ih());
        Map<Field, Value> map = null;
        try {
            map = this.a.getValues(arrayList2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new WatchDescriptor();
        int n4 = arrayList2.size();
        for (int i3 = 0; i3 < n4; ++i3) {
            Field field = (Field)arrayList2.get(i3);
            StaticFieldVariable staticFieldVariable = new StaticFieldVariable(this.a, field);
            Value value = map == null ? staticFieldVariable.getValue() : map.get(field);
            DebugTreeNode debugTreeNode = DebugTreeNode.createValueNode(staticFieldVariable, value, ((WatchDescriptor)object).duplicate(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.a.name()))).append('.').append(field.name())))), null);
            arrayList.add(debugTreeNode);
        }
        return arrayList.toArray(new TreeNode[arrayList.size()]);
    }

    public Icon getIcon() {
        int n2;
        Icon icon = BrowserIcons.ICON_OBJECTS;
        boolean bl = this.a instanceof ClassType;
        Icon[] iconArray = bl ? JavaStructureIcons.ICONS_CLASS : JavaStructureIcons.ICONS_INTERFACE;
        int n3 = n2 = this.a.isStatic() ? 4 : 0;
        if (this.a.isPrepared()) {
            if (this.a.isPublic()) {
                icon = iconArray[3 + n2];
            }
            if (this.a.isPackagePrivate()) {
                icon = iconArray[1 + n2];
            }
            if (this.a.isPrivate()) {
                icon = iconArray[0 + n2];
            }
            if (this.a.isProtected()) {
                icon = iconArray[2 + n2];
            }
        } else {
            icon = bl ? BrowserIcons.ICON_UNPREPAREDCLASS : BrowserIcons.ICON_UNPREPAREDINTERFACE;
        }
        return icon;
    }

    public ClassTreeNode(ReferenceType referenceType) {
        this.a = referenceType;
    }
}

