/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.debugger;

import com.borland.jbuilder.debugger.BreakpointMark;
import com.borland.jbuilder.debugger.BreakpointTreeModel;
import com.borland.jbuilder.debugger.BreakpointTreeNode;
import com.borland.jbuilder.debugger.DebugEventDelegate;
import com.borland.jbuilder.debugger.DebugInfoManager;
import com.borland.jbuilder.debugger.DebugJavaProcessTracker;
import com.borland.jbuilder.debugger.DebugPropertyGroup;
import com.borland.jbuilder.debugger.DebugSaveTreeNode;
import com.borland.jbuilder.debugger.DebugTree;
import com.borland.jbuilder.debugger.NonJavaLineBreakpointHelper;
import com.borland.jbuilder.debugger.c;
import com.borland.jbuilder.debugger.gd;
import com.borland.jbuilder.debugger.hd;
import com.borland.jbuilder.debugger.id;
import com.borland.jbuilder.jot.JotPackages;
import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.node.JavaFileNode;
import com.borland.primetime.actions.ActionGroup;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.Gutter;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserIcons;
import com.borland.primetime.ide.BrowserListener;
import com.borland.primetime.ide.NodeViewer;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.node.TextFileNode;
import com.borland.primetime.util.Strings;
import com.borland.primetime.util.VetoException;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.viewer.NodeViewMap;
import com.borland.primetime.viewer.TextNodeViewer;
import com.borland.primetime.viewer.TextView;
import com.borland.primetime.viewer.TextViewerComponent;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;

public class LineBreakpointTreeNode
extends BreakpointTreeNode
implements BrowserListener {
    static Class k;
    private NonJavaLineBreakpointHelper e = null;
    private boolean f;
    private HashMap l;
    private boolean d = DebugPropertyGroup.supportMultipleClassLoader();
    private Url c = null;
    private boolean i = true;
    private BreakpointMark g = null;
    private boolean a = false;
    private boolean b = true;
    private int h = -1;
    private String j = "";

    static String a(LineBreakpointTreeNode lineBreakpointTreeNode) {
        return lineBreakpointTreeNode.j;
    }

    static boolean b(LineBreakpointTreeNode lineBreakpointTreeNode) {
        return lineBreakpointTreeNode.d;
    }

    static String c(LineBreakpointTreeNode lineBreakpointTreeNode) {
        return lineBreakpointTreeNode.c();
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void browserClosed(Browser browser) {
        this.removeBrowserListener(browser);
    }

    public void browserClosing(Browser browser) throws VetoException {
    }

    public void browserViewerActivated(Browser browser, Node node, NodeViewer nodeViewer) {
    }

    public void browserViewerDeactivating(Browser browser, Node node, NodeViewer nodeViewer) throws VetoException {
    }

    private boolean a(Browser browser, Node node) {
        boolean bl = false;
        Browser[] browserArray = Browser.getBrowsers();
        for (int i2 = 0; i2 < browserArray.length; ++i2) {
            Browser browser2 = browserArray[i2];
            if (browser2 == browser || !browser2.isOpenNode(node)) continue;
            bl = true;
        }
        return bl;
    }

    public void browserNodeClosed(Browser browser, Node node) {
        TextFileNode textFileNode;
        if (DebugInfoManager.isDebuggableTextFileNode(node) && (textFileNode = (TextFileNode)node).getUrl().getFile().equals(this.getFileName()) && this.getModel().getProject() == textFileNode.getProject() && this.getLineMark() != null && !this.a(browser, node)) {
            Gutter gutter = this.getGutterForClosedNode(browser);
            this.a(false, gutter, false, browser);
        }
    }

    public void browserNodeActivated(Browser browser, Node node) {
        TextFileNode textFileNode;
        if (DebugInfoManager.isDebuggableTextFileNode(node) && (textFileNode = (TextFileNode)node).getUrl().getFile().equals(this.getFileName())) {
            if (this.getModel().getProject() == textFileNode.getProject()) {
                if (this.getLineMark() == null) {
                    this.a(true, null, false, browser);
                }
            } else if (this.getLineMark() != null) {
                this.a(false, null, false, browser);
            }
        }
    }

    public void browserProjectClosed(Browser browser, Project project) {
        if (this.getModel().getProject() == project) {
            this.removeBrowserListener(browser);
        }
    }

    public void browserProjectActivated(Browser browser, Project project) {
    }

    public void browserDeactivated(Browser browser) {
    }

    public void browserActivated(Browser browser) {
    }

    public void browserOpened(Browser browser) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.f) {
            stringBuffer.append(com.borland.jbuilder.debugger.c.a(215));
            stringBuffer.append(this.getFileName());
        } else {
            stringBuffer.append(com.borland.jbuilder.debugger.c.a(112));
            stringBuffer.append(this.getClassName());
        }
        stringBuffer.append(com.borland.jbuilder.debugger.c.a(248));
        stringBuffer.append(this.getLine());
        if (!this.isValid()) {
            stringBuffer.append(com.borland.jbuilder.debugger.c.a(234));
        }
        if (!this.isVerified()) {
            stringBuffer.append(com.borland.jbuilder.debugger.c.a(414));
        }
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }

    public void updateListenersOnProjectActivated(Browser browser, Project project) {
        if (this.getModel().getProject() == project && !this.b(browser)) {
            this.addBrowserListener(browser);
            this.browserProjectActivated(browser, project);
            this.browserNodeActivated(browser, browser.getActiveNode());
        }
    }

    public ActionGroup getPopupActionGroup(DebugJavaProcessTracker debugJavaProcessTracker, DebugTree debugTree) {
        ActionGroup actionGroup = new ActionGroup();
        actionGroup.add(new gd(this));
        actionGroup.add(super.getPopupActionGroup(debugJavaProcessTracker, debugTree));
        return actionGroup;
    }

    public Icon getIcon() {
        Icon icon = !this.isEnabled() ? BrowserIcons.ICON_BREAKPOINTDISABLED : (this.isBreakpointDisabledForCurrentConfiguration() ? BrowserIcons.ICON_BREAKPOINT_DISABLED_FOR_PROCESS : (!this.isValid() ? BrowserIcons.ICON_BREAKPOINTINVALID : (this.isVerified() ? BrowserIcons.ICON_BREAKPOINTVERIFIED : BrowserIcons.ICON_BREAKPOINT)));
        return icon;
    }

    public static void createFromString(String[] stringArray, BreakpointTreeModel breakpointTreeModel) {
        int n2 = stringArray.length - 1;
        if (n2 >= LineBreakpointTreeNode.d()) {
            String string = stringArray[1];
            String string2 = stringArray[2];
            int n3 = BreakpointTreeNode.toIntValue(stringArray[3]);
            if (!string.equals("") && n3 > 0 && !string2.equals("")) {
                Url url = breakpointTreeModel.getProject().getUrl().getParent().getRelativeUrl(string2);
                LineBreakpointTreeNode lineBreakpointTreeNode = breakpointTreeModel.createLineBreakpoint(null, string, n3, url, null);
                lineBreakpointTreeNode.setCommonProperties(stringArray, LineBreakpointTreeNode.d());
            }
        }
    }

    private static int d() {
        return BreakpointTreeNode.getCommonMinItemCount() + 3;
    }

    public String createSaveString() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Integer.toString(0));
        arrayList.add(this.getClassName());
        arrayList.add(this.f());
        arrayList.add(Integer.toString(this.getLine()));
        this.addCommonSaveString(arrayList);
        return DebugSaveTreeNode.buildSaveString(arrayList);
    }

    public boolean hasAllNecessaryInfo() {
        if (this.getLine() > -1) {
            return this.f ? this.g() != null : !this.getClassName().equals("");
        }
        return false;
    }

    public void reset() {
        this.setValid(true);
        this.setVerified(false);
        this.updateVisualBreakpoint();
    }

    public void cleanUp(VirtualMachine virtualMachine) {
        this.removePassCount(virtualMachine);
        this.removeClassPrepareRequest(virtualMachine);
        if (this.d) {
            this.removeAllEventRequests(virtualMachine);
        } else {
            this.removeEventRequest(virtualMachine);
        }
    }

    public void disconnect(VirtualMachine virtualMachine) {
        if (this.d) {
            ClassPrepareRequest classPrepareRequest = this.getClassPrepareRequest(virtualMachine);
            if (classPrepareRequest != null) {
                virtualMachine.eventRequestManager().deleteEventRequest(classPrepareRequest);
            }
            if (this.isConnected(virtualMachine)) {
                virtualMachine.eventRequestManager().deleteEventRequests(this.getAllEventRequests(virtualMachine));
            }
        } else if (this.isConnected(virtualMachine)) {
            virtualMachine.eventRequestManager().deleteEventRequest(this.getEventRequest(virtualMachine));
        } else {
            ClassPrepareRequest classPrepareRequest = this.getClassPrepareRequest(virtualMachine);
            if (classPrepareRequest != null) {
                virtualMachine.eventRequestManager().deleteEventRequest(classPrepareRequest);
            }
        }
        this.cleanUp(virtualMachine);
    }

    public void connect(VirtualMachine virtualMachine) {
        if (virtualMachine != null && !this.isBreakpointDisabledForCurrentConfiguration()) {
            this.resetPassCount(virtualMachine);
            if (this.f) {
                this.e().nonJavaConnect(virtualMachine);
            } else {
                boolean bl = true;
                List<ReferenceType> list = virtualMachine.classesByName(this.j);
                int n2 = list.size();
                if (n2 > 0) {
                    for (int i2 = 0; i2 < n2; ++i2) {
                        ReferenceType referenceType = list.get(i2);
                        if (!referenceType.name().equals(this.j) || !referenceType.isPrepared()) continue;
                        this.addBreakpointRequest(referenceType, this.getLine());
                        if (this.d) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) {
                    this.addLoadedClassRequest(virtualMachine);
                }
            }
        }
    }

    public boolean isConnected(VirtualMachine virtualMachine) {
        return this.getEventRequest(virtualMachine) != null;
    }

    public boolean isBreakpointEnabled() {
        return this.isEnabled();
    }

    public void setBreakpointEnabled(VirtualMachine virtualMachine, boolean bl) {
        this.setEnabled(bl);
        if (this.isConnected(virtualMachine)) {
            if (this.d) {
                ArrayList arrayList = this.getAllEventRequests(virtualMachine);
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    BreakpointRequest breakpointRequest = (BreakpointRequest)arrayList.get(i2);
                    breakpointRequest.setEnabled(bl);
                }
            } else {
                BreakpointRequest breakpointRequest = (BreakpointRequest)this.getEventRequest(virtualMachine);
                breakpointRequest.setEnabled(bl);
            }
        }
        this.updateVisualBreakpoint();
    }

    public void delete(VirtualMachine virtualMachine) {
        this.removeBrowserListener(Browser.getActiveBrowser());
        this.disconnect(virtualMachine);
    }

    private NonJavaLineBreakpointHelper e() {
        if (this.e == null) {
            this.e = new NonJavaLineBreakpointHelper(this, this.g(), this.d);
        }
        return this.e;
    }

    public boolean checkLineChanged() {
        boolean bl = false;
        if (this.g != null) {
            int n2 = this.g.getMarkLine();
            if (n2 == -1) {
                bl = true;
            } else if (n2 != this.getLine()) {
                this.setLine(n2);
            }
        }
        return bl;
    }

    public void setCoreInfoModifiable(boolean bl) {
        this.i = bl;
    }

    public boolean isCoreInfoModifiable() {
        return this.i;
    }

    private String c() {
        return Strings.format(com.borland.jbuilder.debugger.c.a(247), this.getClassName(), Integer.toString(this.getLine()));
    }

    public void setLineMark(BreakpointMark breakpointMark) {
        this.g = breakpointMark;
        this.updateLineMark();
    }

    public BreakpointMark getLineMark() {
        return this.g;
    }

    public boolean isJava() {
        return !this.f;
    }

    public boolean isVerified() {
        return this.a;
    }

    public void setVerified(boolean bl) {
        this.a = bl;
    }

    public boolean isValid() {
        return this.b;
    }

    public void setValid(boolean bl) {
        this.b = bl;
    }

    public String getFileName() {
        return this.c != null ? this.c.getFile() : "";
    }

    private Url g() {
        return this.c;
    }

    public void setUrl(Url url) {
        if (url != null) {
            this.c = url;
            if (url.getFileExtension().equals("java")) {
                this.f = false;
            } else {
                this.f = true;
                this.e().setNonJavaInnerClassName(this.j);
            }
        }
    }

    private void a(FileNode fileNode) {
        if (fileNode != null) {
            this.c = fileNode.getUrl();
            if (fileNode instanceof JavaFileNode) {
                this.f = false;
            } else {
                this.f = true;
                this.e().setNonJavaInnerClassName(this.j);
            }
        }
    }

    public void setClassName(String string) {
        this.j = string;
    }

    public String getClassName() {
        return this.j;
    }

    public void setLine(int n2) {
        this.h = n2;
    }

    public int getLine() {
        return this.h;
    }

    public boolean equalsFileName(int n2, String string) {
        return this.h == n2 && this.getFileName().equals(string);
    }

    public boolean haveValidClassLine() {
        String string = this.getModel().getClassNameFromLine(this.a(false, true, null, false), this.getLine());
        return string != null && !string.equals("");
    }

    public void showBreakpointPropertiesReadOnly(EditorPane editorPane, String string) {
        boolean bl = this.isCoreInfoModifiable();
        this.setCoreInfoModifiable(false);
        this.showBreakpointProperties(editorPane, string);
        this.setCoreInfoModifiable(bl);
    }

    public String getClassNameFromUrl() {
        String string = null;
        Gutter gutter = this.a(false, true, Browser.getActiveBrowser(), false);
        if (gutter != null) {
            string = this.getModel().getClassNameFromLine(gutter, this.getLine());
        }
        return string;
    }

    public Url getUrlFromClassName() {
        int n2 = this.getClassName().indexOf(36);
        String string = n2 >= 0 ? this.getClassName().substring(0, n2) : this.getClassName();
        Url url = null;
        JBProject jBProject = this.getModel().getProject();
        if (jBProject != null) {
            JotPackages jotPackages = jBProject.getJotPackages();
            url = jotPackages.getUrl(string, 2);
        }
        return url;
    }

    protected void checkFileName(EditorPane editorPane) {
        if (this.g() == null) {
            if (editorPane != null) {
                FileNode fileNode = NodeViewMap.getNode(editorPane);
                if (fileNode != null && DebugInfoManager.isDebuggableTextFileNode(fileNode)) {
                    this.a(fileNode);
                }
            } else {
                Url url = this.getUrlFromClassName();
                if (url != null) {
                    this.setUrl(url);
                }
            }
        }
    }

    private String f() {
        this.checkFileName(null);
        Url url = this.getModel().getProject().getUrl().getParent();
        String string = url.getRelativePath(this.g());
        return string == null ? "" : string;
    }

    private Url h() {
        Url url = this.g();
        return url != null ? url : this.getUrlFromClassName();
    }

    public void goToBreakpointInFile() {
        FileNode fileNode;
        Browser browser = Browser.getActiveBrowser();
        Url url = this.h();
        if (url != null && browser != null && DebugInfoManager.isDebuggableTextFileNode(fileNode = this.getModel().getProject().getNode(url))) {
            if (this.g() == null) {
                this.a(fileNode);
            }
            try {
                browser.setActiveNode(fileNode, true);
                if (browser.isOpenNode(fileNode)) {
                    TextNodeViewer textNodeViewer = (TextNodeViewer)browser.getViewerOfType(fileNode, k == null ? (k = LineBreakpointTreeNode.a("com.borland.primetime.viewer.TextNodeViewer")) : k);
                    browser.setActiveViewer(fileNode, textNodeViewer, true);
                    TextView textView = ((TextViewerComponent)textNodeViewer.getViewerComponent()).getMainView();
                    EditorPane editorPane = textNodeViewer.getEditor();
                    editorPane.gotoPosition(this.getLine(), 1, false, 2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private Gutter a(boolean bl, boolean bl2, Browser browser, boolean bl3) {
        FileNode fileNode;
        Url url;
        Gutter gutter = null;
        if (browser == null) {
            browser = Browser.getActiveBrowser();
        }
        if ((url = this.h()) != null && browser != null && DebugInfoManager.isDebuggableTextFileNode(fileNode = bl3 ? browser.getActiveProject().getNode(url) : this.getModel().getProject().getNode(url))) {
            if (this.g() == null) {
                this.a(fileNode);
            }
            try {
                TextNodeViewer textNodeViewer;
                if (bl2) {
                    browser.setActiveNode(fileNode, true);
                }
                if (browser.isOpenNode(fileNode) && (textNodeViewer = (TextNodeViewer)browser.getViewerOfType(fileNode, k == null ? (k = LineBreakpointTreeNode.a("com.borland.primetime.viewer.TextNodeViewer")) : k)) != null) {
                    TextView textView = ((TextViewerComponent)textNodeViewer.getViewerComponent()).getMainView();
                    if (bl && bl2) {
                        EditorPane editorPane = textNodeViewer.getEditor();
                        editorPane.gotoPosition(this.getLine(), 1, false, 2);
                    }
                    gutter = textView.getGutter();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return gutter;
    }

    public Gutter getGutterForClosedNode(Browser browser) {
        Project project = browser.getActiveProject();
        boolean bl = this.getModel().getProject() != project && project != null;
        return this.a(false, false, browser, bl);
    }

    private boolean a(boolean bl, Gutter gutter, boolean bl2, Browser browser) {
        boolean bl3 = false;
        if (gutter == null) {
            gutter = this.a(bl, bl2, browser, false);
        }
        if (gutter != null) {
            if (bl) {
                this.checkFileName(gutter.getEditor());
                BreakpointMark breakpointMark = new BreakpointMark(this.getLine(), gutter.getEditor());
                try {
                    gutter.addMark(this.getLine(), breakpointMark);
                    this.setLineMark(breakpointMark);
                    bl3 = true;
                }
                catch (Exception exception) {}
            } else if (this.getLineMark() != null) {
                gutter.removeMark(this.getLineMark());
                this.setLineMark(null);
            }
            this.a(gutter);
        } else if (!bl) {
            this.setLineMark(null);
        }
        return bl3;
    }

    public boolean markLine(boolean bl, Gutter gutter, boolean bl2) {
        return this.a(bl, gutter, bl2, null);
    }

    public void updateLineMark() {
        if (this.getLineMark() != null) {
            this.getLineMark().update(this.isEnabled(), this.isValid(), this.isVerified());
        }
    }

    public void clearVisualBreakpoint(Gutter gutter) {
        this.markLine(false, gutter, false);
    }

    private void a(Gutter gutter) {
        DebugJavaProcessTracker debugJavaProcessTracker;
        if (gutter == null) {
            gutter = this.a(false, false, null, false);
        }
        if (gutter != null && (debugJavaProcessTracker = this.getModel().getTracker()) != null && debugJavaProcessTracker.debugJavaProcessIsSuspended()) {
            debugJavaProcessTracker.checkUpdateExecutionPoint(gutter, this.getLine());
        }
    }

    public void updateVisualBreakpoint() {
        super.updateVisualBreakpoint();
        this.updateLineMark();
        this.a((Gutter)null);
    }

    public void indicateVerifiedBreakpoint() {
        if (!this.isVerified()) {
            this.setVerified(true);
            this.updateVisualBreakpoint();
        }
    }

    public void indicateValidBreakpoint(boolean bl) {
        if (bl != this.isValid()) {
            this.setValid(bl);
            if (!this.isVerified()) {
                this.setVerified(true);
            }
            this.updateVisualBreakpoint();
        }
    }

    public void addBreakpointRequest(ReferenceType referenceType, int n2) {
        boolean bl = false;
        try {
            List list = this.f ? this.e().locationsOfLine(referenceType, n2) : referenceType.locationsOfLine(n2);
            if (list.size() > 0) {
                this.indicateVerifiedBreakpoint();
                Location location = (Location)list.get(0);
                BreakpointRequest breakpointRequest = location.virtualMachine().eventRequestManager().createBreakpointRequest(location);
                breakpointRequest.putProperty(DebugEventDelegate.KEY, new hd(this));
                breakpointRequest.setEnabled(this.isEnabled());
                this.addEventRequest(breakpointRequest);
                this.updateLineMark();
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.indicateValidBreakpoint(bl);
    }

    public void addLoadedClassRequest(VirtualMachine virtualMachine) {
        if (this.f) {
            this.e().nonJavaAddLoadedClassRequest(virtualMachine);
        } else {
            ClassPrepareRequest classPrepareRequest = virtualMachine.eventRequestManager().createClassPrepareRequest();
            classPrepareRequest.addClassFilter(this.fixedInnerClassName(this.j, virtualMachine));
            classPrepareRequest.putProperty(DebugEventDelegate.KEY, new id(this));
            classPrepareRequest.enable();
            this.addClassPrepareRequest(classPrepareRequest);
        }
    }

    private boolean b(Browser browser) {
        return this.l.get(browser) != null;
    }

    protected void removeBrowserListener(Browser browser) {
        browser.removeBrowserListener(this);
        this.l.remove(browser);
    }

    protected void addBrowserListener(Browser browser) {
        Browser[] browserArray;
        if (browser == null && (browserArray = Browser.getBrowsers()) != null && browserArray.length > 0) {
            browser = browserArray[0];
        }
        if (browser != null) {
            browser.addBrowserListener(this);
            this.l.put(browser, "");
        }
    }

    public LineBreakpointTreeNode(String string, int n2, FileNode fileNode, BreakpointTreeModel breakpointTreeModel) {
        super(breakpointTreeModel);
        this.l = new HashMap(5);
        this.j = string;
        this.h = n2;
        this.f = false;
        this.a(fileNode);
        this.addBrowserListener(Browser.getActiveBrowser());
    }

    public LineBreakpointTreeNode(String string, int n2, Url url, BreakpointTreeModel breakpointTreeModel) {
        super(breakpointTreeModel);
        this.l = new HashMap(5);
        this.j = string;
        this.h = n2;
        this.f = false;
        this.setUrl(url);
        this.addBrowserListener(Browser.getActiveBrowser());
    }
}

