/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.enterprise;

import com.borland.jbuilder.enterprise.ejb.AppServer;
import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.paths.ProjectPathSet;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.properties.GlobalProperty;
import com.borland.primetime.properties.MultipleNodeProperty;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import com.borland.primetime.vfs.ui.UrlChooser;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JTextField;

public class EnterpriseUtils {
    public static String getDeployableArchives(ArrayList arrayList, Node[] nodeArray, AppServer appServer) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < nodeArray.length; ++i2) {
            Node node = nodeArray[i2];
            FileNode fileNode = appServer.getDeployableNode(node);
            if (fileNode == null || arrayList.contains(fileNode)) continue;
            arrayList.add(fileNode);
            if (VFS.exists(fileNode.getUrl())) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(fileNode.getUrl().getName());
        }
        return stringBuffer.length() == 0 ? null : stringBuffer.toString();
    }

    public static boolean isPathInPathList(Url url, Url[] urlArray) {
        if (url == null || urlArray == null || urlArray.length == 0) {
            return false;
        }
        boolean bl = false;
        for (int i2 = 0; i2 < urlArray.length && !bl; ++i2) {
            if (!urlArray[i2].equals(url)) continue;
            bl = true;
        }
        return bl;
    }

    public static Url[] removePathsFromFullClassPath(Url[] urlArray, Url[] urlArray2) {
        ArrayList<Url> arrayList = new ArrayList<Url>();
        if (urlArray2 != null) {
            for (int i2 = 0; i2 < urlArray.length; ++i2) {
                Url url = urlArray[i2];
                boolean bl = EnterpriseUtils.isPathInPathList(url, urlArray2);
                if (bl) continue;
                arrayList.add(url);
            }
        }
        return arrayList.toArray(new Url[arrayList.size()]);
    }

    public static void modifyProjectLibraryList(String string, Project project, boolean bl) {
        ProjectPathSet projectPathSet;
        String[] stringArray;
        if (!(project instanceof JBProject) || project == null) {
            return;
        }
        JBProject jBProject = (JBProject)project;
        if (string != null && !string.equals("") && (stringArray = (projectPathSet = jBProject.getPaths()).getRequiredNames()) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl) {
                arrayList.add(string);
            }
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (stringArray[i2].equals(string)) continue;
                arrayList.add(stringArray[i2]);
            }
            projectPathSet.setRequired(arrayList.toArray(new String[arrayList.size()]));
            jBProject.check();
        }
    }

    public static String terminatePath(String string) {
        String string2 = string;
        if (string != null && !string.endsWith("/")) {
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf('/')));
        }
        return string2;
    }

    public static String getPropertyValue(Node node, MultipleNodeProperty multipleNodeProperty, GlobalProperty globalProperty, String string) {
        String string2 = null;
        if (multipleNodeProperty != null) {
            string2 = multipleNodeProperty.getValue(node);
        }
        if (string2 == null || string2.equals("")) {
            if (globalProperty != null) {
                string2 = globalProperty.getValue();
            }
            if (string != null && (string2 == null || string2.equals(""))) {
                string2 = string;
            }
        }
        return string2;
    }

    public static String getPropertyValue(Node node, MultipleNodeProperty multipleNodeProperty, GlobalProperty globalProperty) {
        return EnterpriseUtils.getPropertyValue(node, multipleNodeProperty, globalProperty, null);
    }

    public static String getUrlNameNoExtension(Url url) {
        String string = "";
        if (url != null) {
            string = url.getName();
            int n2 = string.indexOf(46);
            string = n2 == -1 ? string : string.substring(0, n2);
        }
        return string;
    }

    public static boolean setTextFieldFromUrlSelection(Component component, JTextField jTextField, String string) {
        boolean bl = false;
        String string2 = jTextField.getText();
        Url url = string2.equals("") ? null : new Url("file", string2);
        Url url2 = UrlChooser.promptForDir(component, url, string);
        if (url2 != null) {
            jTextField.setText(url2.getFile());
            bl = true;
        }
        return bl;
    }

    public static void addPathsToPathBuffer(Url[] urlArray, StringBuffer stringBuffer) {
        if (urlArray != null && stringBuffer != null) {
            int n2 = stringBuffer.length();
            if (n2 > 0 && File.pathSeparatorChar != stringBuffer.charAt(n2 - 1)) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            for (int i2 = 0; i2 < urlArray.length; ++i2) {
                String string = urlArray[i2].getFileObject().getAbsolutePath();
                stringBuffer.append(string);
                stringBuffer.append(File.pathSeparatorChar);
            }
        }
    }

    public static String doQuote(String string) {
        String string2 = string;
        if (string.indexOf(32) > -1) {
            string2 = String.valueOf(String.valueOf(new StringBuffer("\"").append(string).append("\"")));
        }
        return string2;
    }
}

