/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.enterprise.ejb;

import com.borland.enterprise.xml.api.IAccessibleBean;
import com.borland.enterprise.xml.api.IEjbJar;
import com.borland.enterprise.xml.api.IJdbc1Datasource;
import com.borland.enterprise.xml.api.IResourceRef;
import com.borland.enterprise.xml.util.DescriptorPair;
import com.borland.jbuilder.build.BuildMessage;
import com.borland.jbuilder.build.BuildReport;
import com.borland.jbuilder.enterprise.ejb.DeploymentDescriptor;
import com.borland.jbuilder.enterprise.ejb.EjbGrpUtils;
import com.borland.jbuilder.enterprise.ejb.EjbPropertyElement;
import com.borland.jbuilder.enterprise.ejb.EjbReference;
import com.borland.jbuilder.enterprise.ejb.a;
import com.borland.jbuilder.jot.JotClassSource;
import com.borland.jbuilder.jot.JotMethod;
import com.borland.jbuilder.jot.JotPackages;
import com.borland.jbuilder.jot.JotSourceFile;
import com.borland.jbuilder.node.EJBGRPFileNode;
import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.node.JavaFileNode;
import com.borland.jbuilder.wizard.ejb.EJBInterfaceGenerator;
import com.borland.primetime.ide.MessageCategory;
import com.borland.primetime.ide.MessageView;
import com.borland.primetime.util.AssertionException;
import com.borland.primetime.util.Strings;
import com.borland.primetime.vfs.Url;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractDescriptorConversion {
    protected long descriptorDate;
    protected DeploymentDescriptor ddGeneric;
    protected DescriptorPair descriptorPair;
    protected IEjbJar iEjbJar;
    protected BuildReport report;
    protected EJBGRPFileNode ejbGrpNode;
    protected DeploymentDescriptor[] dds;

    public static String getBeanDataSourceName(IAccessibleBean iAccessibleBean) {
        String string;
        block1: {
            IResourceRef iResourceRef;
            string = null;
            Collection collection = iAccessibleBean.getResourceRefList();
            if (collection == null || collection.isEmpty()) break block1;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext() && (!"javax.sql.DataSource".equals((iResourceRef = (IResourceRef)iterator.next()).getResType()) || (string = iResourceRef.getJndiName()) == null)) {
            }
        }
        return string;
    }

    public static IJdbc1Datasource getBeanDataSource(IAccessibleBean iAccessibleBean, IEjbJar iEjbJar) {
        String string = AbstractDescriptorConversion.getBeanDataSourceName(iAccessibleBean);
        if (string != null && iEjbJar != null) {
            try {
                Collection collection = iEjbJar.getDatasourceList();
                if (collection != null) {
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        IJdbc1Datasource iJdbc1Datasource = (IJdbc1Datasource)iterator.next();
                        if (!string.equals(iJdbc1Datasource.getJndiName())) continue;
                        IJdbc1Datasource iJdbc1Datasource2 = iJdbc1Datasource;
                        return iJdbc1Datasource2;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    protected static JotMethod[] getJotMethods(JavaFileNode javaFileNode) {
        if (javaFileNode != null) {
            try {
                JBProject jBProject = (JBProject)javaFileNode.getProject();
                JotPackages jotPackages = jBProject.getJotPackages();
                JotSourceFile jotSourceFile = jotPackages.getSourceFile(javaFileNode.getUrl());
                if (jotPackages.checkReread(jotSourceFile)) {
                    jotSourceFile = (JotSourceFile)jotPackages.getFile(javaFileNode.getUrl());
                }
                JotClassSource jotClassSource = EJBInterfaceGenerator.getPublicClass(jotSourceFile);
                JotMethod[] jotMethodArray = AbstractDescriptorConversion.a(jotClassSource);
                return jotMethodArray;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return new JotMethod[0];
    }

    private static JotMethod[] a(JotClassSource jotClassSource) {
        ArrayList<JotMethod> arrayList = new ArrayList<JotMethod>();
        if (jotClassSource != null) {
            JotMethod[] jotMethodArray = jotClassSource.isInterface() ? jotClassSource.getDeclaredMethods() : jotClassSource.getMethods();
            block3: for (int i2 = 0; i2 < jotMethodArray.length; ++i2) {
                switch (jotMethodArray[i2].getModifiers()) {
                    case 2: 
                    case 4: 
                    case 8: {
                        continue block3;
                    }
                    default: {
                        arrayList.add(jotMethodArray[i2]);
                    }
                }
            }
        }
        return arrayList.toArray(new JotMethod[arrayList.size()]);
    }

    protected static JavaFileNode getEjbNode(JBProject jBProject, String string) {
        return EjbGrpUtils.getEjbNode(jBProject, string);
    }

    protected void addWarningMessage(String string) {
        if (this.report != null) {
            this.report.addBuildWarning(new BuildMessage(string, 1));
        } else {
            System.out.println(string);
        }
    }

    protected void addErrorMessage(String string) {
        if (this.report != null) {
            this.report.addBuildError(new BuildMessage(string, 2));
        } else {
            System.err.println(string);
        }
    }

    protected DeploymentDescriptor findDescriptor(DeploymentDescriptor[] deploymentDescriptorArray, String string) {
        for (int i2 = 0; i2 < deploymentDescriptorArray.length; ++i2) {
            if (!string.equals(deploymentDescriptorArray[i2].getName())) continue;
            return deploymentDescriptorArray[i2];
        }
        return null;
    }

    protected void updateEjbModule(DeploymentDescriptor[] deploymentDescriptorArray) throws Exception {
        if (this.ejbGrpNode != null) {
            try {
                Url url = this.ejbGrpNode.getUrl();
                EjbGrpUtils.replaceGroupFile(url, EjbGrpUtils.mergeWithGroupFile(url, deploymentDescriptorArray));
            }
            catch (IOException iOException) {
                throw new AssertionException(iOException.getMessage());
            }
        }
    }

    protected String getGenericDDName() {
        return "ejb-jar.xml";
    }

    protected boolean needToUpdate(DeploymentDescriptor[] deploymentDescriptorArray) {
        boolean bl = false;
        for (int i2 = 0; i2 < deploymentDescriptorArray.length; ++i2) {
            DeploymentDescriptor deploymentDescriptor;
            if (deploymentDescriptorArray[i2].getName().equals(this.getGenericDDName()) || (deploymentDescriptor = this.findDescriptor(this.dds, deploymentDescriptorArray[i2].getName())) != null && this.descriptorDate <= deploymentDescriptor.getTimestamp()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean createInterfaceFromDescriptors(boolean bl) {
        this.ddGeneric = null;
        this.descriptorDate = 0L;
        this.iEjbJar = null;
        DeploymentDescriptor[] deploymentDescriptorArray = EjbGrpUtils.filterDescriptors(this.dds);
        for (int i2 = 0; i2 < deploymentDescriptorArray.length; ++i2) {
            DeploymentDescriptor deploymentDescriptor = deploymentDescriptorArray[i2];
            if (deploymentDescriptor.getName().equals(this.getGenericDDName())) {
                this.ddGeneric = deploymentDescriptor;
            }
            if (deploymentDescriptor.getTimestamp() <= this.descriptorDate) continue;
            this.descriptorDate = deploymentDescriptor.getTimestamp();
        }
        if (this.ddGeneric == null) {
            if (bl) {
                this.addErrorMessage(Strings.format(a.a(101), this.getGenericDDName()));
            }
            return false;
        }
        this.iEjbJar = EjbGrpUtils.getEjbJarDescriptor(deploymentDescriptorArray);
        if (this.iEjbJar == null) {
            if (bl) {
                this.addErrorMessage(a.a(84));
            }
            return false;
        }
        this.descriptorPair = this.iEjbJar.getIModule().getDescriptorPair();
        return true;
    }

    protected JBProject getProject() {
        if (this.ejbGrpNode != null) {
            return (JBProject)this.ejbGrpNode.getProject();
        }
        return null;
    }

    public static EjbPropertyElement[] getPropertyNamesToSurface(EjbReference ejbReference) {
        return null;
    }

    public DeploymentDescriptor[] convert(boolean bl, boolean bl2) throws Exception {
        if (!this.createInterfaceFromDescriptors(bl2)) {
            return null;
        }
        ArrayList<DeploymentDescriptor> arrayList = new ArrayList<DeploymentDescriptor>();
        arrayList.add(this.ddGeneric);
        this.generate(arrayList);
        DeploymentDescriptor[] deploymentDescriptorArray = arrayList.toArray(new DeploymentDescriptor[arrayList.size()]);
        if (bl) {
            if (this.needToUpdate(deploymentDescriptorArray)) {
                this.updateEjbModule(deploymentDescriptorArray);
            } else {
                ArrayList<DeploymentDescriptor> arrayList2 = new ArrayList<DeploymentDescriptor>();
                for (int i2 = 0; i2 < deploymentDescriptorArray.length; ++i2) {
                    DeploymentDescriptor deploymentDescriptor = this.findDescriptor(this.dds, deploymentDescriptorArray[i2].getName());
                    if (deploymentDescriptor == null) continue;
                    arrayList2.add(deploymentDescriptor);
                }
                deploymentDescriptorArray = arrayList2.toArray(new DeploymentDescriptor[arrayList2.size()]);
            }
            this.patchForAppServer(deploymentDescriptorArray);
        }
        return deploymentDescriptorArray;
    }

    protected void patchForAppServer(DeploymentDescriptor[] deploymentDescriptorArray) {
    }

    protected abstract void generate(ArrayList var1) throws Exception;

    public abstract void verifyDeploymentDescriptors(MessageView var1, MessageCategory var2) throws Exception;

    public AbstractDescriptorConversion(DeploymentDescriptor[] deploymentDescriptorArray, EJBGRPFileNode eJBGRPFileNode, BuildReport buildReport) {
        this.dds = deploymentDescriptorArray;
        this.ejbGrpNode = eJBGRPFileNode;
        this.report = buildReport;
    }
}

