/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.enterprise.ejb.websphere;

import com.borland.enterprise.xml.api.IAccessibleBean;
import com.borland.enterprise.xml.api.IEjbJar;
import com.borland.enterprise.xml.api.IEnterpriseBean;
import com.borland.enterprise.xml.api.IJdbc1Datasource;
import com.borland.enterprise.xml.api.IProperty;
import com.borland.jbuilder.JBuilderHelp;
import com.borland.jbuilder.build.ExternalBuildTask;
import com.borland.jbuilder.enterprise.EnterpriseUtils;
import com.borland.jbuilder.enterprise.ejb.AbstractDescriptorConversion;
import com.borland.jbuilder.enterprise.ejb.AppServer;
import com.borland.jbuilder.enterprise.ejb.AppServerManager;
import com.borland.jbuilder.enterprise.ejb.CommandLineDeployDialog;
import com.borland.jbuilder.enterprise.ejb.CommandLineDeploySettings;
import com.borland.jbuilder.enterprise.ejb.CommandLineEjbDeployer;
import com.borland.jbuilder.enterprise.ejb.EjbGrpUtils;
import com.borland.jbuilder.enterprise.ejb.EjbReference;
import com.borland.jbuilder.enterprise.ejb.websphere.WebSphereAppServer35;
import com.borland.jbuilder.enterprise.ejb.websphere.WebSphereDeployDialog35;
import com.borland.jbuilder.enterprise.ejb.websphere.WebSphereDeployOptionsControls35;
import com.borland.jbuilder.enterprise.ejb.websphere.WebSphereDeploySettings35;
import com.borland.jbuilder.enterprise.ejb.websphere.WebSpherePropertyGroup;
import com.borland.jbuilder.enterprise.ejb.websphere.h;
import com.borland.jbuilder.info.JBuilderInfo;
import com.borland.jbuilder.node.EJBGRPFileNode;
import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.paths.PathSet;
import com.borland.jbuilder.runtime.ejb.DeployJavaProcessTracker;
import com.borland.jbuilder.runtime.servlet.XmlConfigHelper;
import com.borland.primetime.help.ZipHelpTopic;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.node.UrlNode;
import com.borland.primetime.properties.GlobalBooleanProperty;
import com.borland.primetime.properties.GlobalProperty;
import com.borland.primetime.properties.MultipleNodeProperty;
import com.borland.primetime.properties.ProjectAutoArrayProperty;
import com.borland.primetime.runtime.RunConfiguration;
import com.borland.primetime.util.Strings;
import com.borland.primetime.util.XmlDocumentImpl;
import com.borland.primetime.vfs.Buffer;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class WebSphereEjbDeployer35
extends CommandLineEjbDeployer {
    protected static String LIST_DEPLOYED_EJBS_TITLE = h.a(60);

    protected WebSphereDeployOptionsControls35 createDeployOptionsControls() {
        return new WebSphereDeployOptionsControls35();
    }

    public static String getDeployExportXmlName(JBProject jBProject) {
        StringBuffer stringBuffer = new StringBuffer();
        if (jBProject != null) {
            stringBuffer.append(jBProject.getPaths().getWorkingDirectory().getFile());
            stringBuffer.append('/');
            stringBuffer.append("deploy_export.xml");
        }
        return stringBuffer.toString();
    }

    public static String getDeployXmlName(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append('/');
        stringBuffer.append("deploy");
        if (stringArray != null && stringArray.length == 1 && !"".equals(stringArray[0])) {
            stringBuffer.append('_');
            Url url = new Url("file", stringArray[0]);
            String string2 = url.getName();
            stringBuffer.append(string2.substring(0, string2.indexOf(46)));
        }
        stringBuffer.append(".xml");
        return stringBuffer.toString();
    }

    protected Element getElementWithTagAndName(Element element, String string, String string2) {
        NodeList nodeList;
        Element element2 = null;
        if (element != null && (nodeList = element.getElementsByTagName(string)) != null && nodeList.getLength() > 0) {
            for (int i2 = 0; i2 < nodeList.getLength() && element2 == null; ++i2) {
                Element element3 = (Element)nodeList.item(i2);
                if (!string2.equals(element3.getAttribute("name"))) continue;
                element2 = element3;
            }
        }
        return element2;
    }

    private Element a(Element element, String string) {
        NodeList nodeList;
        Element element2 = null;
        if (element != null && (nodeList = element.getElementsByTagName(string)) != null && nodeList.getLength() > 0) {
            element2 = (Element)nodeList.item(0);
        }
        return element2;
    }

    private void a(NodeList nodeList, DeployJavaProcessTracker deployJavaProcessTracker) {
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            Element element = (Element)nodeList.item(i2);
            String string = Strings.format(h.a(25), element.getAttribute("name"));
            deployJavaProcessTracker.javaProcessSent(null, string, false);
            Element element2 = this.a(element, "jar-file");
            NodeList nodeList2 = element2.getChildNodes();
            if (nodeList2 == null || nodeList2.getLength() <= 0) continue;
            String string2 = Strings.format(h.a(24), nodeList2.item(0).getNodeValue());
            deployJavaProcessTracker.javaProcessSent(null, string2, false);
        }
    }

    protected void finishListDeployAction(DeployJavaProcessTracker deployJavaProcessTracker, JBProject jBProject) {
        String string = WebSphereEjbDeployer35.getDeployExportXmlName(jBProject);
        try {
            Url url = new Url("file", string);
            if (VFS.exists(url)) {
                deployJavaProcessTracker.javaProcessSent(null, LIST_DEPLOYED_EJBS_TITLE, false);
                byte[] byArray = XmlConfigHelper.stripDtdFromXml(url);
                InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputSource);
                WebSphereDeploySettings35 webSphereDeploySettings35 = (WebSphereDeploySettings35)this.readSettings(jBProject);
                NodeList nodeList = null;
                Element element = document.getDocumentElement();
                if (element != null) {
                    if ((element = this.getElementWithTagAndName(element, "node", webSphereDeploySettings35.getDeployNodeName())) != null && (element = this.getElementWithTagAndName(element, "application-server", webSphereDeploySettings35.getDeployAppServerName())) != null && (element = this.getElementWithTagAndName(element, "container", webSphereDeploySettings35.getDeployContainerName())) != null && (nodeList = element.getElementsByTagName("ejb")) != null) {
                        this.a(nodeList, deployJavaProcessTracker);
                    }
                } else {
                    deployJavaProcessTracker.javaProcessSent(null, h.a(53), true);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            deployJavaProcessTracker.javaProcessSent(null, h.a(56), true);
        }
    }

    protected Element addAttributesElement(String string, String[][] stringArray, Element element, Document document) {
        Element element2 = null;
        if (stringArray != null && stringArray.length > 0) {
            element2 = document.createElement(string);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String[] stringArray2 = stringArray[i2];
                element2.setAttribute(stringArray2[0], stringArray2[1]);
            }
            element.appendChild(element2);
        }
        return element2;
    }

    protected Element addEjbTextElement(String string, String string2, Element element, Document document) {
        Element element2 = null;
        if (string2 != null) {
            element2 = document.createElement(string);
            Text text = document.createTextNode(string);
            text.setNodeValue(string2);
            element2.appendChild(text);
            element.appendChild(element2);
        }
        return element2;
    }

    private String a(String string, Collection collection) {
        String string2 = null;
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext() && string2 == null) {
                IProperty iProperty = (IProperty)iterator.next();
                if (!iProperty.getPropName().equals(string)) continue;
                string2 = iProperty.getPropValue();
            }
        }
        return string2;
    }

    private void a(String string, Element element, Document document, IAccessibleBean iAccessibleBean) {
        String string2 = this.a(string, iAccessibleBean.getPropertyList());
        if (string2 != null) {
            this.addEjbTextElement(string, string2, element, document);
        }
    }

    private void a(String string, Element element, Document document, IAccessibleBean iAccessibleBean, EJBGRPFileNode eJBGRPFileNode) {
        IJdbc1Datasource iJdbc1Datasource;
        IEjbJar iEjbJar = EjbGrpUtils.getEjbJarDescriptor(eJBGRPFileNode.getUrl());
        if (iEjbJar != null && (iJdbc1Datasource = AbstractDescriptorConversion.getBeanDataSource(iAccessibleBean, iEjbJar)) != null) {
            this.addAttributesElement("data-source", new String[][]{{"name", iJdbc1Datasource.getJndiName()}}, element, document);
            this.addEjbTextElement("user-id", iJdbc1Datasource.getUsername(), element, document);
            this.addEjbTextElement("password", iJdbc1Datasource.getPassword(), element, document);
            this.a("create-db-table", element, document, iAccessibleBean);
            this.a("primary-key-check", element, document, iAccessibleBean);
            this.a("db-exclusive-access", element, document, iAccessibleBean);
        }
    }

    private void a(Element element, Document document, IAccessibleBean iAccessibleBean, EJBGRPFileNode eJBGRPFileNode) {
        String string = AbstractDescriptorConversion.getBeanDataSourceName(iAccessibleBean);
        if (string != null && !"".equals(string)) {
            this.a(string, element, document, iAccessibleBean, eJBGRPFileNode);
        }
        this.a("find-for-update", element, document, iAccessibleBean);
        this.a("minimum-pool-size", element, document, iAccessibleBean);
        this.a("maximum-pool-size", element, document, iAccessibleBean);
    }

    protected void fillEjbElementBasicInfo(Element element, Document document, IAccessibleBean iAccessibleBean, String string) {
        String string2 = iAccessibleBean.getJndiHomeName();
        if (string2 == null) {
            string2 = "";
        }
        this.addEjbTextElement("jar-file", string, element, document);
        this.addEjbTextElement("home-name", string2, element, document);
    }

    protected void fillXmlDocumentExportPartial(XmlDocumentImpl xmlDocumentImpl, WebSphereDeploySettings35 webSphereDeploySettings35, JBProject jBProject) throws IOException {
        try {
            xmlDocumentImpl.setDoctype("websphere-sa-config SYSTEM", "$server_root$$dsep$bin$dsep$xmlconfig.dtd");
            Element element = xmlDocumentImpl.createElement("websphere-sa-config");
            xmlDocumentImpl.appendChild(element);
            Element element2 = this.addAttributesElement("node", new String[][]{{"name", webSphereDeploySettings35.getDeployNodeName()}, {"action", "locate"}}, element, (Document)((Object)xmlDocumentImpl));
            Element element3 = this.addAttributesElement("application-server", new String[][]{{"name", webSphereDeploySettings35.getDeployAppServerName()}, {"action", "locate"}}, element2, (Document)((Object)xmlDocumentImpl));
            Element element4 = this.addAttributesElement("container", new String[][]{{"name", webSphereDeploySettings35.getDeployContainerName()}, {"action", "export"}}, element3, (Document)((Object)xmlDocumentImpl));
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
            String string = Strings.format(h.a(3), dOMException.getMessage());
            throw new IOException(string);
        }
    }

    protected String checkRemoteJarName(String string, String string2) {
        String string3 = string;
        if (string2 != null && !"".equals(string2)) {
            Url url = new Url("file", string);
            Url url2 = new Url("file", string2);
            String string4 = url.getName();
            String string5 = string2.replace('\\', '/');
            if (!string5.endsWith("/")) {
                string5 = String.valueOf(String.valueOf(string5)).concat(String.valueOf(String.valueOf('/')));
            }
            string3 = String.valueOf(String.valueOf(string5)).concat(String.valueOf(String.valueOf(string4)));
        }
        return string3;
    }

    protected void fillXmlDocument(XmlDocumentImpl xmlDocumentImpl, WebSphereDeploySettings35 webSphereDeploySettings35, JBProject jBProject) throws IOException {
        try {
            String[] stringArray = webSphereDeploySettings35.getDeployJarNames();
            xmlDocumentImpl.setDoctype("websphere-sa-config SYSTEM", "$server_root$$dsep$bin$dsep$xmlconfig.dtd");
            Element element = xmlDocumentImpl.createElement("websphere-sa-config");
            xmlDocumentImpl.appendChild(element);
            if (webSphereDeploySettings35.getDeployAction().equals("start appserver")) {
                Element element2 = this.addAttributesElement("node", new String[][]{{"name", webSphereDeploySettings35.getDeployNodeName()}, {"action", "locate"}}, element, (Document)((Object)xmlDocumentImpl));
                Element element3 = this.addAttributesElement("application-server", new String[][]{{"name", webSphereDeploySettings35.getDeployAppServerName()}, {"action", "start"}}, element2, (Document)((Object)xmlDocumentImpl));
            } else if (webSphereDeploySettings35.getDeployAction().equals("stop container")) {
                Element element4 = this.addAttributesElement("node", new String[][]{{"name", webSphereDeploySettings35.getDeployNodeName()}, {"action", "locate"}}, element, (Document)((Object)xmlDocumentImpl));
                Element element5 = this.addAttributesElement("application-server", new String[][]{{"name", webSphereDeploySettings35.getDeployAppServerName()}, {"action", "locate"}}, element4, (Document)((Object)xmlDocumentImpl));
                this.addAttributesElement("container", new String[][]{{"name", webSphereDeploySettings35.getDeployContainerName()}, {"action", "stop"}}, element5, (Document)((Object)xmlDocumentImpl));
            } else if (webSphereDeploySettings35.getDeployAction().equals("start container")) {
                Element element6 = this.addAttributesElement("node", new String[][]{{"name", webSphereDeploySettings35.getDeployNodeName()}, {"action", "locate"}}, element, (Document)((Object)xmlDocumentImpl));
                Element element7 = this.addAttributesElement("application-server", new String[][]{{"name", webSphereDeploySettings35.getDeployAppServerName()}, {"action", "locate"}}, element6, (Document)((Object)xmlDocumentImpl));
                this.addAttributesElement("container", new String[][]{{"name", webSphereDeploySettings35.getDeployContainerName()}, {"action", "start"}}, element7, (Document)((Object)xmlDocumentImpl));
            } else {
                Element element8 = this.addAttributesElement("node", new String[][]{{"name", webSphereDeploySettings35.getDeployNodeName()}, {"action", "update"}}, element, (Document)((Object)xmlDocumentImpl));
                Element element9 = this.addAttributesElement("application-server", new String[][]{{"name", webSphereDeploySettings35.getDeployAppServerName()}, {"action", "update"}}, element8, (Document)((Object)xmlDocumentImpl));
                Element element10 = this.addAttributesElement("container", new String[][]{{"name", webSphereDeploySettings35.getDeployContainerName()}, {"action", "update"}}, element9, (Document)((Object)xmlDocumentImpl));
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    EjbReference[] ejbReferenceArray;
                    EJBGRPFileNode eJBGRPFileNode = EjbGrpUtils.findEjbGroup(stringArray[i2], jBProject);
                    if (eJBGRPFileNode == null || (ejbReferenceArray = EjbGrpUtils.getEjbDescriptors(eJBGRPFileNode)) == null) continue;
                    for (int i3 = 0; i3 < ejbReferenceArray.length; ++i3) {
                        Element element11;
                        IEnterpriseBean iEnterpriseBean = ejbReferenceArray[i3].getBean();
                        if (!(iEnterpriseBean instanceof IAccessibleBean)) continue;
                        IAccessibleBean iAccessibleBean = (IAccessibleBean)iEnterpriseBean;
                        String string = webSphereDeploySettings35.getDeployAction();
                        String string2 = iAccessibleBean.getJndiHomeName();
                        String string3 = this.checkRemoteJarName(stringArray[i2], webSphereDeploySettings35.getDeployRemoteJarLocation());
                        if (string2 == null) {
                            string2 = "";
                        }
                        if ("delete".equals(string) || "update".equals(string)) {
                            element11 = this.addAttributesElement("ejb", new String[][]{{"name", string2}, {"action", "stop"}}, element10, (Document)((Object)xmlDocumentImpl));
                            this.fillEjbElementBasicInfo(element11, (Document)((Object)xmlDocumentImpl), iAccessibleBean, string3);
                        }
                        element11 = this.addAttributesElement("ejb", new String[][]{{"name", string2}, {"action", string}}, element10, (Document)((Object)xmlDocumentImpl));
                        this.fillEjbElementBasicInfo(element11, (Document)((Object)xmlDocumentImpl), iAccessibleBean, string3);
                        this.a(element11, (Document)((Object)xmlDocumentImpl), iAccessibleBean, eJBGRPFileNode);
                        if (!"create".equals(string) && !"update".equals(string)) continue;
                        Element element12 = this.addAttributesElement("ejb", new String[][]{{"name", string2}, {"action", "start"}}, element10, (Document)((Object)xmlDocumentImpl));
                        this.fillEjbElementBasicInfo(element12, (Document)((Object)xmlDocumentImpl), iAccessibleBean, string3);
                    }
                }
            }
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
            String string = Strings.format(h.a(3), dOMException.getMessage());
            throw new IOException(string);
        }
    }

    protected ProjectAutoArrayProperty getDeployJarNamesGlobalProperty() {
        return WebSpherePropertyGroup.DEPLOY_JAR_NAMES_35;
    }

    protected GlobalProperty getDeployOptionsGlobalProperty() {
        return WebSpherePropertyGroup.DEPLOY_OPTIONS_35;
    }

    protected GlobalProperty getDeployActionGlobalProperty() {
        return WebSpherePropertyGroup.DEPLOY_ACTION_35;
    }

    protected GlobalBooleanProperty getGenerateXmlGlobalProperty() {
        return WebSpherePropertyGroup.DEPLOY_GENERATE_XML_35;
    }

    protected GlobalProperty getRemoteJarLocationGlobalProperty() {
        return WebSpherePropertyGroup.DEPLOY_REMOTE_JAR_LOCATION_35;
    }

    protected GlobalProperty getContainerNameGlobalProperty() {
        return WebSpherePropertyGroup.DEPLOY_CONTAINER_NAME_35;
    }

    protected GlobalProperty getAppServerNameGlobalProperty() {
        return WebSpherePropertyGroup.DEPLOY_APP_SERVER_NAME_35;
    }

    protected GlobalProperty getNodeNameGlobalProperty() {
        return WebSpherePropertyGroup.DEPLOY_NODE_NAME_35;
    }

    protected MultipleNodeProperty getGenerateXmlNodeProperty() {
        return WebSpherePropertyGroup.DEPLOY_NODE_GENERATE_XML_35;
    }

    protected MultipleNodeProperty getRemoteJarLocationNodeProperty() {
        return WebSpherePropertyGroup.DEPLOY_NODE_REMOTE_JAR_LOCATION_35;
    }

    protected MultipleNodeProperty getContainerNameNodeProperty() {
        return WebSpherePropertyGroup.DEPLOY_NODE_CONTAINER_NAME_35;
    }

    protected MultipleNodeProperty getAppServerNameNodeProperty() {
        return WebSpherePropertyGroup.DEPLOY_NODE_APP_SERVER_NAME_35;
    }

    protected MultipleNodeProperty getNodeNameNodeProperty() {
        return WebSpherePropertyGroup.DEPLOY_NODE_NODE_NAME_35;
    }

    protected void addDeployedArchiveToList(String string, ArrayList arrayList, String string2, JBProject jBProject) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("deployedEJBs/Deployed");
        Url url = new Url("file", string);
        String string3 = url.getName();
        stringBuffer.append(string3);
        arrayList.add(new Url("zip", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('['))).append(stringBuffer.toString()).append(']')))));
    }

    private void a(JBProject jBProject, String[] stringArray) {
        AppServer appServer = AppServerManager.getAppServer(jBProject);
        if (appServer != null) {
            int n2;
            int n3;
            ArrayList arrayList = new ArrayList();
            String string = appServer.getHomeDirectory().getFile();
            String string2 = string.endsWith("/") ? string : String.valueOf(String.valueOf(string)).concat(String.valueOf(String.valueOf('/')));
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.addDeployedArchiveToList(stringArray[i2], arrayList, string2, jBProject);
            }
            PathSet pathSet = appServer.createClientLibrary(string);
            ArrayList<Url> arrayList2 = new ArrayList<Url>();
            Url[] urlArray = pathSet.getClassPath();
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                Url url = (Url)arrayList.get(n3);
                boolean bl = false;
                for (n2 = 0; n2 < urlArray.length && !bl; ++n2) {
                    if (!url.equals(urlArray[n2])) continue;
                    bl = true;
                }
                if (bl) continue;
                arrayList2.add(url);
            }
            n3 = arrayList2.size();
            int n4 = urlArray.length;
            if (n3 > 0) {
                Url[] urlArray2 = new Url[n4 + n3];
                for (n2 = 0; n2 < n4; ++n2) {
                    urlArray2[n2] = urlArray[n2];
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    urlArray2[n4 + n2] = (Url)arrayList2.get(n2);
                }
                pathSet.setClassPath(urlArray2);
                pathSet.save();
            }
            appServer.ensureProjectContainsAppServerClientLibrary(jBProject);
        }
    }

    protected Node getParentNode(String string, JBProject jBProject) {
        return EjbGrpUtils.findEjbGroup(string, jBProject);
    }

    protected boolean generateDeployXml(JBProject jBProject, WebSphereDeploySettings35 webSphereDeploySettings35) {
        Object object;
        boolean bl = false;
        if (webSphereDeploySettings35 == null) {
            webSphereDeploySettings35 = (WebSphereDeploySettings35)this.readSettings(jBProject);
        }
        if (!webSphereDeploySettings35.getGenerateXml()) {
            return true;
        }
        if ("list".equals(webSphereDeploySettings35.getDeployAction()) && !this.usePartialExport()) {
            return true;
        }
        String[] stringArray = webSphereDeploySettings35.getDeployJarNames();
        String string = WebSphereEjbDeployer35.getDeployXmlName(stringArray, jBProject.getPaths().getWorkingDirectory().getFile());
        Node node = jBProject;
        if (stringArray != null && stringArray.length == 1 && !"".equals(stringArray[0])) {
            node = this.getParentNode(stringArray[0], jBProject);
        }
        if (node != null) {
            Object object2;
            object = null;
            Buffer buffer = null;
            try {
                Node node2;
                object2 = new Url("file", string);
                if (VFS.exists((Url)object2)) {
                    VFS.delete((Url)object2);
                }
                buffer = VFS.getBuffer((Url)object2);
                object = buffer.getOutputStream();
                FileNode fileNode = jBProject.getNode((Url)object2);
                if (fileNode.getParent() == null) {
                    fileNode.setParent(node);
                }
                if ((node2 = fileNode.getParent()).equals(node) && node2 instanceof UrlNode) {
                    ExternalBuildTask.recordGeneratedFile("websphere.xmlconfig.deploy.xml", (UrlNode)node2, (Url)object2, 0);
                }
                fileNode.check();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (object != null) {
                try {
                    object2 = new XmlDocumentImpl();
                    if ("list".equals(webSphereDeploySettings35.getDeployAction())) {
                        this.fillXmlDocumentExportPartial((XmlDocumentImpl)((Object)object2), webSphereDeploySettings35, jBProject);
                    } else {
                        this.fillXmlDocument((XmlDocumentImpl)((Object)object2), webSphereDeploySettings35, jBProject);
                    }
                    if (object2.hasChildNodes()) {
                        ((XmlDocumentImpl)((Object)object2)).write((OutputStream)object);
                    }
                    ((OutputStream)object).close();
                    buffer.save(true);
                    bl = true;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        if (!bl) {
            object = Strings.format(h.a(46), string);
            JOptionPane.showMessageDialog(Browser.getActiveBrowser(), object, Strings.format(h.a(22), this.getVersionString()), 2);
        }
        return bl;
    }

    public void finishDeployAction(DeployJavaProcessTracker deployJavaProcessTracker, JBProject jBProject) {
        String string = this.getDeployActionGlobalProperty().getValue();
        if ("list".equals(string)) {
            this.finishListDeployAction(deployJavaProcessTracker, jBProject);
        }
    }

    protected GlobalProperty getVmParametersGlobalProperty() {
        return WebSpherePropertyGroup.DEPLOY_VM_PARAMETERS_35;
    }

    protected GlobalProperty getOptionsGlobalProperty() {
        return WebSpherePropertyGroup.DEPLOY_OPTIONS_35;
    }

    protected MultipleNodeProperty getVmParametersNodeProperty() {
        return WebSpherePropertyGroup.DEPLOY_NODE_VM_PARAMETERS_35;
    }

    protected MultipleNodeProperty getOptionsNodeProperty() {
        return WebSpherePropertyGroup.DEPLOY_NODE_OPTIONS_35;
    }

    protected void saveSettingsForSelectedNode(CommandLineDeploySettings commandLineDeploySettings, FileNode fileNode) {
        if (!(commandLineDeploySettings instanceof WebSphereDeploySettings35)) {
            return;
        }
        WebSphereDeploySettings35 webSphereDeploySettings35 = (WebSphereDeploySettings35)commandLineDeploySettings;
        AppServer appServer = AppServerManager.getAppServer(fileNode.getProject());
        Node node = appServer.getCompanionNode(fileNode);
        Node[] nodeArray = node == null ? new Node[]{fileNode} : new Node[]{fileNode, node};
        this.getNodeNameNodeProperty().setValue(nodeArray, webSphereDeploySettings35.getDeployNodeName());
        this.getAppServerNameNodeProperty().setValue(nodeArray, webSphereDeploySettings35.getDeployAppServerName());
        this.getContainerNameNodeProperty().setValue(nodeArray, webSphereDeploySettings35.getDeployContainerName());
        this.getOptionsNodeProperty().setValue(nodeArray, webSphereDeploySettings35.getDeployOptions());
        this.getRemoteJarLocationNodeProperty().setValue(nodeArray, webSphereDeploySettings35.getDeployRemoteJarLocation());
        this.getVmParametersNodeProperty().setValue(nodeArray, webSphereDeploySettings35.getDeployVmParameters());
        this.getGenerateXmlNodeProperty().setValue(nodeArray, webSphereDeploySettings35.getGenerateXml() ? "1" : "0");
    }

    protected String getDeployMainClass() {
        return "com.ibm.websphere.xmlconfig.XMLConfig";
    }

    protected boolean usePartialExport() {
        return true;
    }

    protected CommandLineDeploySettings customizeSettingsForDeployCommand(CommandLineDeploySettings commandLineDeploySettings, JBProject jBProject, ArrayList arrayList) {
        String string;
        WebSphereDeploySettings35 webSphereDeploySettings35 = (WebSphereDeploySettings35)commandLineDeploySettings.copy();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(" -adminNodeName ");
        stringBuffer.append(webSphereDeploySettings35.getDeployNodeName());
        String string2 = jBProject.getPaths().getWorkingDirectory().getFile();
        String string3 = WebSphereEjbDeployer35.getDeployXmlName(webSphereDeploySettings35.getDeployJarNames(), string2);
        String string4 = webSphereDeploySettings35.getDeployAction();
        WebSpherePropertyGroup.DEPLOY_ACTION_35.setValue(string4);
        if ("list".equals(string4)) {
            stringBuffer.append(" -export ");
            stringBuffer.append(EnterpriseUtils.doQuote(WebSphereEjbDeployer35.getDeployExportXmlName(jBProject)));
            if (this.usePartialExport()) {
                stringBuffer.append(" -partial ");
                stringBuffer.append(EnterpriseUtils.doQuote(string3));
            }
        } else {
            stringBuffer.append(" -import ");
            stringBuffer.append(EnterpriseUtils.doQuote(string3));
        }
        if ((string = webSphereDeploySettings35.getDeployOptions()) != null && !string.equals("")) {
            stringBuffer.append(' ');
            stringBuffer.append(string);
        }
        webSphereDeploySettings35.setDeployOptions(stringBuffer.toString());
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.getDeployVmParameters(commandLineDeploySettings, jBProject));
        stringBuffer2.append(' ');
        stringBuffer2.append(this.getDeployClassPathVmParameter(jBProject, arrayList));
        webSphereDeploySettings35.setDeployVmParameters(stringBuffer2.toString());
        return webSphereDeploySettings35;
    }

    protected void restoreSettingsForSelectedNode(CommandLineDeploySettings commandLineDeploySettings, FileNode fileNode) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        if (!(commandLineDeploySettings instanceof WebSphereDeploySettings35)) {
            return;
        }
        WebSphereDeploySettings35 webSphereDeploySettings35 = (WebSphereDeploySettings35)commandLineDeploySettings;
        webSphereDeploySettings35.setDeployJarNames(new String[]{fileNode.getUrl().getFile()});
        String string7 = this.getNodeNameNodeProperty().getValue(fileNode);
        if (string7 != null && !string7.equals("")) {
            webSphereDeploySettings35.setDeployNodeName(string7);
        }
        if ((string6 = this.getAppServerNameNodeProperty().getValue(fileNode)) != null && !string6.equals("")) {
            webSphereDeploySettings35.setDeployAppServerName(string6);
        }
        if ((string5 = this.getContainerNameNodeProperty().getValue(fileNode)) != null && !string5.equals("")) {
            webSphereDeploySettings35.setDeployContainerName(string5);
        }
        if ((string4 = this.getOptionsNodeProperty().getValue(fileNode)) != null && !string4.equals("")) {
            webSphereDeploySettings35.setDeployOptions(string4);
        }
        if ((string3 = this.getRemoteJarLocationNodeProperty().getValue(fileNode)) != null && !string3.equals("")) {
            webSphereDeploySettings35.setDeployRemoteJarLocation(string3);
        }
        if ((string2 = this.getVmParametersNodeProperty().getValue(fileNode)) != null && !string2.equals("")) {
            webSphereDeploySettings35.setDeployVmParameters(string2);
        }
        if ((string = this.getGenerateXmlNodeProperty().getValue(fileNode)) != null && !string.equals("")) {
            webSphereDeploySettings35.setGenerateXml("1".equals(string));
        }
    }

    protected Url[] getDeployLibraryFullClassPath(String string, AppServer appServer) {
        Url[] urlArray = new Url[]{};
        if (appServer instanceof WebSphereAppServer35) {
            WebSphereAppServer35 webSphereAppServer35 = (WebSphereAppServer35)appServer;
            urlArray = webSphereAppServer35.getFullLibraryClassPath(webSphereAppServer35.getXmlConfigLibraryName(), webSphereAppServer35.getXmlConfigLibraryClassPath(string));
        }
        return urlArray;
    }

    protected String getDeployActionString(int n2) {
        String string = "create";
        switch (n2) {
            case 2: {
                string = "update";
                break;
            }
            case 4: {
                string = "delete";
                break;
            }
            case 8: {
                string = "list";
                break;
            }
            case 16: {
                string = "start appserver";
                break;
            }
            case 32: {
                string = "stop container";
                break;
            }
            case 64: {
                string = "start container";
            }
        }
        return string;
    }

    protected String getVersionString() {
        return AppServer.makeFullName(WebSphereAppServer35.APP_SERVER_NAME, WebSphereAppServer35.APP_SERVER_VERSION);
    }

    public CommandLineDeploySettings readSettings(Project project) {
        WebSphereDeploySettings35 webSphereDeploySettings35 = (WebSphereDeploySettings35)this.createDeploySettings();
        webSphereDeploySettings35.setDeployJarNames(this.getDeployJarNamesGlobalProperty().getValues(project));
        webSphereDeploySettings35.setDeployAction(this.getDeployActionGlobalProperty().getValue());
        webSphereDeploySettings35.setDeployNodeName(this.getNodeNameGlobalProperty().getValue());
        webSphereDeploySettings35.setDeployAppServerName(this.getAppServerNameGlobalProperty().getValue());
        webSphereDeploySettings35.setDeployContainerName(this.getContainerNameGlobalProperty().getValue());
        webSphereDeploySettings35.setDeployOptions(this.getOptionsGlobalProperty().getValue());
        webSphereDeploySettings35.setDeployRemoteJarLocation(this.getRemoteJarLocationGlobalProperty().getValue());
        webSphereDeploySettings35.setDeployVmParameters(this.getVmParametersGlobalProperty().getValue());
        webSphereDeploySettings35.setGenerateXml(this.getGenerateXmlGlobalProperty().getBoolean());
        return webSphereDeploySettings35;
    }

    public void writeSettings(CommandLineDeploySettings commandLineDeploySettings, Project project) {
        if (!(commandLineDeploySettings instanceof WebSphereDeploySettings35)) {
            return;
        }
        WebSphereDeploySettings35 webSphereDeploySettings35 = (WebSphereDeploySettings35)commandLineDeploySettings;
        this.getDeployJarNamesGlobalProperty().setValues(project, webSphereDeploySettings35.getDeployJarNames());
        this.getDeployActionGlobalProperty().setValue(webSphereDeploySettings35.getDeployAction());
        this.getNodeNameGlobalProperty().setValue(webSphereDeploySettings35.getDeployNodeName());
        this.getAppServerNameGlobalProperty().setValue(webSphereDeploySettings35.getDeployAppServerName());
        this.getContainerNameGlobalProperty().setValue(webSphereDeploySettings35.getDeployContainerName());
        this.getDeployOptionsGlobalProperty().setValue(webSphereDeploySettings35.getDeployOptions());
        this.getRemoteJarLocationGlobalProperty().setValue(webSphereDeploySettings35.getDeployRemoteJarLocation());
        this.getVmParametersGlobalProperty().setValue(webSphereDeploySettings35.getDeployVmParameters());
        this.getGenerateXmlGlobalProperty().setBoolean(webSphereDeploySettings35.getGenerateXml());
    }

    protected CommandLineDeployDialog createDeployDialog(Browser browser, JBProject jBProject, String[] stringArray, CommandLineDeploySettings commandLineDeploySettings, CommandLineEjbDeployer commandLineEjbDeployer) {
        return new WebSphereDeployDialog35(browser, jBProject, stringArray, (WebSphereDeploySettings35)commandLineDeploySettings, (WebSphereEjbDeployer35)commandLineEjbDeployer, true);
    }

    public ZipHelpTopic getHelpTopic() {
        return JBuilderHelp.TOPIC_DWebsphereDeploySettings35;
    }

    public RunConfiguration buildRunConfiguration(CommandLineDeploySettings commandLineDeploySettings, JBProject jBProject, ArrayList arrayList) {
        RunConfiguration runConfiguration = super.buildRunConfiguration(commandLineDeploySettings, jBProject, arrayList);
        if (runConfiguration != null) {
            WebSphereDeploySettings35 webSphereDeploySettings35 = (WebSphereDeploySettings35)commandLineDeploySettings;
            this.getDeployActionGlobalProperty().setValue(webSphereDeploySettings35.getDeployAction());
            this.generateDeployXml(jBProject, webSphereDeploySettings35);
            this.a(jBProject, commandLineDeploySettings.getDeployJarNames());
        }
        return runConfiguration;
    }

    protected CommandLineDeploySettings createDeploySettings() {
        return new WebSphereDeploySettings35();
    }

    public WebSphereEjbDeployer35() {
        super(true);
    }

    public static void initOpenTool(byte by, byte by2) {
        if (JBuilderInfo.isEnterpriseEnabled()) {
            AppServerManager.registerEjbDeployer(new WebSphereEjbDeployer35(), WebSphereAppServer35.APP_SERVER_NAME, WebSphereAppServer35.APP_SERVER_VERSION);
        }
    }
}

