/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.uml.manager;

import com.borland.jbuilder.java.JavaNames;
import com.borland.jbuilder.java.SourceInfo;
import com.borland.jbuilder.node.ClassFileNode;
import com.borland.jbuilder.node.ClassStubSource;
import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.node.JavaFileNode;
import com.borland.jbuilder.node.PackageNode;
import com.borland.jbuilder.uml.UmlListener;
import com.borland.jbuilder.uml.manager.a;
import com.borland.jbuilder.uml.manager.b;
import com.borland.jbuilder.uml.manager.c;
import com.borland.jbuilder.uml.manager.e;
import com.borland.jbuilder.uml.model.ClassNotInRepository;
import com.borland.jbuilder.uml.model.PackageNotInRepository;
import com.borland.jbuilder.uml.model.UmlClass;
import com.borland.jbuilder.uml.model.UmlField;
import com.borland.jbuilder.uml.model.UmlMetaClass;
import com.borland.jbuilder.uml.model.UmlModel;
import com.borland.jbuilder.uml.model.UmlObject;
import com.borland.jbuilder.uml.model.UmlOperation;
import com.borland.jbuilder.uml.ui.UmlComponent;
import com.borland.jbuilder.uml.ui.UmlRootPane;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import com.borland.primetime.viewer.AbstractTextNodeViewer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.util.AbstractCollection;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;

public abstract class UmlManager {
    static Class d;
    static Class c;
    private ArrayList a;
    private static final ArrayList b;
    public static final int UNIT_SCROLL_INCREMENT = 16;
    public static final String DEFAULT_PACKAGE_NAME;

    static {
        DEFAULT_PACKAGE_NAME = e.a(0);
        UNIT_SCROLL_INCREMENT = 16;
        b = new ArrayList();
    }

    static ArrayList d() {
        return b;
    }

    static void a(UmlRootPane umlRootPane, JScrollPane jScrollPane) {
        UmlManager.b(umlRootPane, jScrollPane);
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static String getPackageName(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 > -1) {
            return string.substring(0, n2);
        }
        return DEFAULT_PACKAGE_NAME;
    }

    public static String getPackageName(PackageNode packageNode) {
        String string = packageNode.getName();
        if (string.length() == 0) {
            string = DEFAULT_PACKAGE_NAME;
        }
        return string;
    }

    public static String makeTabName(String string) {
        return UmlComponent.shorten(string).replace('$', '.');
    }

    public static AbstractTextNodeViewer getSourceViewer(Node node) {
        Browser browser = Browser.getActiveBrowser();
        AbstractTextNodeViewer abstractTextNodeViewer = (AbstractTextNodeViewer)browser.getViewerOfType(node, c == null ? (c = UmlManager.a("com.borland.primetime.viewer.TextNodeViewer")) : c);
        if (abstractTextNodeViewer != null) {
            return abstractTextNodeViewer;
        }
        abstractTextNodeViewer = (AbstractTextNodeViewer)browser.getViewerOfType(node, d == null ? (d = UmlManager.a("com.borland.jbuilder.viewer.ClassNodeViewer")) : d);
        return abstractTextNodeViewer;
    }

    public static SourceInfo getSourceInfo(Node node, AbstractTextNodeViewer abstractTextNodeViewer) {
        if (abstractTextNodeViewer != null) {
            try {
                if (node instanceof JavaFileNode) {
                    JavaFileNode javaFileNode = (JavaFileNode)node;
                    SourceInfo sourceInfo = new SourceInfo(javaFileNode.getBuffer().getUrl(), javaFileNode.getEncoding());
                    return sourceInfo;
                }
                EditorPane editorPane = abstractTextNodeViewer.getEditor();
                Document document = editorPane.getDocument();
                SourceInfo sourceInfo = new SourceInfo(UmlManager.a(document));
                return sourceInfo;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static SourceInfo getSourceInfo(Node node) {
        AbstractTextNodeViewer abstractTextNodeViewer = UmlManager.getSourceViewer(node);
        if (abstractTextNodeViewer != null) {
            SourceInfo sourceInfo = UmlManager.getSourceInfo(node, abstractTextNodeViewer);
            return sourceInfo;
        }
        if (node instanceof JavaFileNode) {
            try {
                JavaFileNode javaFileNode = (JavaFileNode)node;
                SourceInfo sourceInfo = new SourceInfo(javaFileNode.getBuffer().getUrl(), javaFileNode.getEncoding());
                return sourceInfo;
            }
            catch (Exception exception) {}
        } else if (node instanceof ClassFileNode) {
            try {
                byte[] byArray = ((ClassFileNode)node).getBuffer().getContent();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                ClassStubSource classStubSource = new ClassStubSource(byteArrayInputStream);
                SourceInfo sourceInfo = new SourceInfo(classStubSource.toString());
                return sourceInfo;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static String a(Document document) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        try {
            Element element = document.getDefaultRootElement();
            Segment segment = new Segment();
            int n2 = element.getElementCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Element element2 = element.getElement(i2);
                int n3 = element2.getStartOffset();
                int n4 = element2.getEndOffset();
                document.getText(n3, n4 - n3, segment);
                stringBuffer.append(segment.toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static boolean canMove(UmlObject umlObject) {
        if (umlObject != null && umlObject instanceof UmlMetaClass) {
            Node node = umlObject.getMyNode();
            if (node == null) {
                return false;
            }
            JBProject jBProject = (JBProject)umlObject.getDiagramNode().getProject();
            Url[] urlArray = jBProject.getPaths().getSourcePath();
            if (!(node instanceof FileNode)) {
                return false;
            }
            Url url = ((FileNode)node).getUrl();
            if (!VFS.exists(url) || VFS.isReadOnly(url)) {
                return false;
            }
            String string = JavaNames.getShortClassName(umlObject.getName());
            if (!String.valueOf(String.valueOf(string)).concat(".java").equals(url.getName())) {
                return false;
            }
            for (int i2 = 0; i2 < urlArray.length; ++i2) {
                if (!urlArray[i2].isChild(url)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canRename(UmlObject umlObject) {
        if (umlObject != null) {
            if (umlObject instanceof UmlField) {
                return UmlManager.canRename(((UmlField)umlObject).getUmlClass());
            }
            if (umlObject instanceof UmlOperation) {
                return UmlManager.canRename(((UmlOperation)umlObject).getUmlClass());
            }
            Node node = umlObject.getMyNode();
            if (node == null) {
                return false;
            }
            JBProject jBProject = (JBProject)umlObject.getDiagramNode().getProject();
            Url[] urlArray = jBProject.getPaths().getSourcePath();
            if (node instanceof PackageNode) {
                String string = umlObject.getName().replace('.', '/');
                for (int i2 = 0; i2 < urlArray.length; ++i2) {
                    Url url = urlArray[i2].getRelativeUrl(string);
                    if (url == null || !VFS.exists(url) && jBProject.findNode(url) == null || VFS.isReadOnly(url)) continue;
                    return true;
                }
                return false;
            }
            if (umlObject instanceof UmlClass && JavaNames.isAnonymousClassName(umlObject.getName())) {
                return false;
            }
            if (!(node instanceof FileNode)) {
                return false;
            }
            Url url = ((FileNode)node).getUrl();
            if (!VFS.exists(url) || VFS.isReadOnly(url)) {
                return false;
            }
            for (int i3 = 0; i3 < urlArray.length; ++i3) {
                if (!urlArray[i3].isChild(url)) continue;
                return true;
            }
        }
        return false;
    }

    private static void b(UmlRootPane umlRootPane, JScrollPane jScrollPane) {
        Point point;
        UmlComponent umlComponent = umlRootPane.getSelectComponent();
        if (umlComponent == null) {
            umlRootPane.getCenterComponent();
        }
        if (umlComponent != null && (point = umlComponent.getAbsoluteOffset()) != null) {
            point.x -= 10;
            Dimension dimension = umlComponent.getSize();
            dimension.width += 10;
            Rectangle rectangle = new Rectangle(point, dimension);
            rectangle.x -= jScrollPane.getViewport().getViewPosition().x;
            rectangle.y -= jScrollPane.getViewport().getViewPosition().y;
            jScrollPane.getViewport().scrollRectToVisible(rectangle);
        }
    }

    public void selectClassAndMakeVisible(int n2) {
        UmlRootPane[] umlRootPaneArray = this.getRootPanes();
        if (n2 > -1 && umlRootPaneArray.length > n2) {
            UmlRootPane umlRootPane = umlRootPaneArray[n2];
            SwingUtilities.invokeLater(new a(umlRootPane));
        }
    }

    public void viewLostFocus(int n2) {
        UmlRootPane[] umlRootPaneArray = this.getRootPanes();
        if (n2 > -1 && umlRootPaneArray.length > n2) {
            umlRootPaneArray[n2].viewLostFocus();
        }
    }

    public void requestFocus(int n2) {
        UmlRootPane[] umlRootPaneArray = this.getRootPanes();
        if (n2 > -1 && umlRootPaneArray.length > n2) {
            umlRootPaneArray[n2].getGlassPane().requestFocus();
        }
    }

    public void shutdown() {
        this.clearRootPanes();
    }

    protected void clearRootPanes() {
        if (this.a != null) {
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                ((UmlRootPane)this.a.get(i2)).shutdown();
            }
            this.a.clear();
        }
    }

    protected void addRootPane(UmlRootPane umlRootPane) {
        if (this.a == null) {
            this.a = new ArrayList();
        }
        this.a.add(umlRootPane);
    }

    public UmlRootPane[] getRootPanes() {
        if (this.a == null) {
            this.a = new ArrayList();
        }
        return this.a.toArray(new UmlRootPane[this.a.size()]);
    }

    public static void fireViewOptionChanged(Object object) {
        if (SwingUtilities.isEventDispatchThread()) {
            for (int i2 = 0; i2 < b.size(); ++i2) {
                ((UmlListener)b.get(i2)).viewOptionChanged(object);
            }
        } else {
            try {
                SwingUtilities.invokeLater(new b(object));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void fireRepositoryChanged(Project project) {
        if (SwingUtilities.isEventDispatchThread()) {
            for (int i2 = 0; i2 < b.size(); ++i2) {
                ((UmlListener)b.get(i2)).repositoryChanged(project);
            }
        } else {
            try {
                SwingUtilities.invokeLater(new c(project));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void removeUmlListener(UmlListener umlListener) {
        ((AbstractCollection)b).remove(umlListener);
        while (b.contains(umlListener)) {
            ((AbstractCollection)b).remove(umlListener);
        }
    }

    public static void addUmlListener(UmlListener umlListener) {
        b.add(umlListener);
    }

    abstract JComponent buildDiagram();

    abstract UmlModel buildModel(Node var1) throws ClassNotInRepository, PackageNotInRepository;
}

