/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbuilder.web;

import com.borland.jbuilder.node.JBProject;
import com.borland.jbuilder.paths.PathSet;
import com.borland.jbuilder.paths.PathSetCollection;
import com.borland.jbuilder.runtime.servlet.ServerSetup;
import com.borland.jbuilder.web.WebServerPropertyGroup;
import com.borland.jbuilder.web.g;
import com.borland.jbuilder.wizard.archive.DependencyPropertyGroup;
import com.borland.jbuilder.wizard.common.ProjectUtil;
import com.borland.primetime.node.Node;
import com.borland.primetime.util.AssertionException;

public class ServletLibraryUtils {
    public static final String LIBRARY_NAME = "Servlet";

    static {
        LIBRARY_NAME = LIBRARY_NAME;
    }

    public static void updateProject(JBProject jBProject) {
        String[] stringArray = jBProject.getPaths().getRequiredNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!LIBRARY_NAME.equals(stringArray[i2])) continue;
            ServletLibraryUtils.verifyServletLibrary(jBProject);
            return;
        }
    }

    public static PathSet verifyServletLibrary(JBProject jBProject) {
        ServerSetup serverSetup = WebServerPropertyGroup.getWebServerSetup(jBProject);
        if (!serverSetup.isConfigured()) {
            serverSetup.attemptDefaultConfiguration();
        }
        PathSet pathSet = serverSetup.getServletApiPathSet();
        String string = jBProject.getPaths().getName();
        PathSetCollection[] pathSetCollectionArray = jBProject.getPaths().getFullLibPath();
        PathSetCollection pathSetCollection = null;
        for (int i2 = 0; i2 < pathSetCollectionArray.length; ++i2) {
            if (!string.equals(pathSetCollectionArray[i2].getName())) continue;
            pathSetCollection = pathSetCollectionArray[i2];
        }
        if (pathSetCollection == null) {
            throw new AssertionException(g.a(8));
        }
        PathSet pathSet2 = pathSetCollection.lookupLibrary(LIBRARY_NAME);
        if (pathSet2 == null || !LIBRARY_NAME.equals(pathSet2.getName())) {
            pathSet2 = new PathSet(LIBRARY_NAME);
            pathSet2.setCollection(pathSetCollection);
        }
        String[] stringArray = pathSet2.getRequiredNames();
        boolean bl = false;
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            if (!stringArray[i3].equals(pathSet.getName())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            pathSet2.setRequired(pathSet.getName());
            pathSet2.save();
        }
        jBProject.getPaths().setFullLibPath(pathSetCollectionArray);
        return pathSet2;
    }

    public static void initDependencies(Node node) {
        if (DependencyPropertyGroup.getDefaultLibraryType(node) != 3) {
            DependencyPropertyGroup.setDefaultLibraryType(node, 3);
            JBProject jBProject = (JBProject)node.getProject();
            ServletLibraryUtils.verifyServletLibrary(jBProject);
            ProjectUtil.addLibraryToProject(jBProject, LIBRARY_NAME);
            DependencyPropertyGroup.setNodeLibraryToType(node, LIBRARY_NAME, 0);
        }
    }

    private ServletLibraryUtils() {
    }
}

