/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.jbuilder.debugger.BreakpointMark;
import com.borland.jbuilder.debugger.ExecutionPointMark;
import com.borland.jbuilder.editor.JavaScanner;
import com.borland.primetime.build.BrowserBuildListener;
import com.borland.primetime.editor.BasicStyleMap;
import com.borland.primetime.editor.ColorPropertyGroup;
import com.borland.primetime.editor.EditorDocument;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.Gutter;
import com.borland.primetime.editor.GutterMark;
import com.borland.primetime.editor.LineMark;
import com.borland.primetime.editor.MasterStyleContext;
import com.borland.primetime.editor.a;
import com.borland.primetime.editor.h;
import com.borland.primetime.editor.ih;
import com.borland.primetime.editor.nh;
import com.borland.primetime.help.HelpTopic;
import com.borland.primetime.help.PrimetimeHelp;
import com.borland.primetime.properties.PropertyPage;
import com.borland.primetime.ui.ColorBox;
import com.borland.primetime.ui.ColorBoxSelection;
import com.borland.primetime.ui.EdgeBorder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;

public class ColorPropertyPage
extends PropertyPage
implements ColorBoxSelection,
MouseListener,
ListSelectionListener,
ItemListener,
ActionListener {
    protected int selectedIndex = -1;
    protected ColorBox backColor;
    protected ColorBox foreColor;
    protected JCheckBox backgroundCheck;
    protected JCheckBox foregroundCheck;
    protected JCheckBox italicCheck;
    protected JCheckBox boldCheck;
    protected JList elementList;
    protected JComboBox schemeCombo;
    protected JLabel schemeLabel;
    protected EditorPane sampleEditor;
    protected ArrayList tempSchemes;
    protected MasterStyleContext context;
    protected String[] sampleTextStrings;
    private static final String x;
    private static final String w;
    private static final String t;
    private static final String v;
    private static final String a;
    private static final String s;
    private static final String m;
    private static final String k;
    private static final String d;
    private static final String j;
    private static final String c;
    protected ColorBox[] bgCustomColorBoxes;
    protected ColorBox[] bgFixedColorBoxes;
    protected ColorBox[] fgCustomColorBoxes;
    protected ColorBox[] fgFixedColorBoxes;
    protected Color[] fixedColors = ColorPropertyGroup.fixedColors;
    public static final int BACKGROUND = 1;
    public static final int FOREGROUND = 0;

    static {
        FOREGROUND = 0;
        BACKGROUND = 1;
        c = com.borland.primetime.editor.a.a(290);
        j = com.borland.primetime.editor.a.a(298);
        d = com.borland.primetime.editor.a.a(269);
        k = com.borland.primetime.editor.a.a(164);
        m = com.borland.primetime.editor.a.a(153);
        s = com.borland.primetime.editor.a.a(118);
        a = com.borland.primetime.editor.a.a(316);
        v = com.borland.primetime.editor.a.a(95);
        t = com.borland.primetime.editor.a.a(117);
        w = com.borland.primetime.editor.a.a(91);
        x = com.borland.primetime.editor.a.a(1);
    }

    public HelpTopic getHelpTopic() {
        return PrimetimeHelp.TOPIC_OColor;
    }

    public void readProperties() {
        String string = ColorPropertyGroup.CURRENT_SCHEME.getValue();
        int n2 = -1;
        this.tempSchemes = new ArrayList();
        ArrayList arrayList = ColorPropertyGroup.getSchemeList();
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            ColorPropertyGroup.SchemeDefinition schemeDefinition = (ColorPropertyGroup.SchemeDefinition)arrayList.get(i2);
            this.tempSchemes.add(new PageSchemeDefinition(this, schemeDefinition));
            if (!string.equals(schemeDefinition.getSchemeName())) continue;
            n2 = i2;
        }
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (int i3 = 0; i3 < this.tempSchemes.size(); ++i3) {
            PageSchemeDefinition pageSchemeDefinition = (PageSchemeDefinition)this.tempSchemes.get(i3);
            defaultComboBoxModel.addElement(pageSchemeDefinition.getDisplayName());
        }
        this.schemeCombo.removeActionListener(this);
        this.schemeCombo.setModel(defaultComboBoxModel);
        if (n2 > -1) {
            this.schemeCombo.setSelectedIndex(n2);
        }
        this.syncToSelectedScheme();
        this.schemeCombo.addActionListener(this);
    }

    public void writeProperties() {
        String[] stringArray = new String[this.tempSchemes.size()];
        for (int i2 = 0; i2 < this.tempSchemes.size(); ++i2) {
            PageSchemeDefinition pageSchemeDefinition = (PageSchemeDefinition)this.tempSchemes.get(i2);
            pageSchemeDefinition.writeElementProperties();
            stringArray[i2] = pageSchemeDefinition.getSchemeAsText();
        }
        ColorPropertyGroup.SCHEMES.setValues(stringArray);
        PageSchemeDefinition pageSchemeDefinition = this.getSelectedScheme();
        ColorPropertyGroup.CURRENT_SCHEME.setValue(pageSchemeDefinition.getSchemeName());
        ColorPropertyGroup.readProperties();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n2;
        int n3;
        EditorDocument editorDocument = (EditorDocument)this.sampleEditor.getDocument();
        LineMark[] lineMarkArray = editorDocument.getLineMarks((n3 = this.sampleEditor.getLineNumber(n2 = this.sampleEditor.viewToModel(mouseEvent.getPoint()))) - 1);
        if (lineMarkArray.length > 0) {
            LineMark lineMark = lineMarkArray[0];
            if (lineMark.getStyle() != null) {
                String string = lineMark.getStyle().getName();
                this.a(string);
            }
        } else if (n2 >= this.sampleEditor.getSelectionStart() && n2 < this.sampleEditor.getSelectionEnd()) {
            this.a("selection");
        } else {
            Element element = editorDocument.getDefaultRootElement();
            int n4 = element.getElementIndex(n2);
            EditorDocument.StyledLeafElement styledLeafElement = (EditorDocument.StyledLeafElement)element.getElement(n4);
            this.a(styledLeafElement.getStyle(n2).getName());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private void a(String string) {
        Style style = this.context.getStyle(string);
        String string2 = (String)style.getAttribute("DisplayName");
        ih ih2 = new ih(this, string, string2);
        this.elementList.setSelectedValue(ih2, true);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.selectedIndex != this.elementList.getSelectedIndex()) {
            this.selectedIndex = this.elementList.getSelectedIndex();
            this.syncToSelectedElement();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.boldCheck) {
            PageSchemeDefinition pageSchemeDefinition = this.getSelectedScheme();
            ih ih2 = (ih)this.elementList.getSelectedValue();
            PageSchemeElement pageSchemeElement = pageSchemeDefinition.getElement(ih2.a);
            pageSchemeElement.setBold(this.boldCheck.isSelected());
            this.sampleEditor.repaint();
        } else if (object == this.italicCheck) {
            PageSchemeDefinition pageSchemeDefinition = this.getSelectedScheme();
            ih ih3 = (ih)this.elementList.getSelectedValue();
            PageSchemeElement pageSchemeElement = pageSchemeDefinition.getElement(ih3.a);
            pageSchemeElement.setItalic(this.italicCheck.isSelected());
            this.sampleEditor.repaint();
        } else if (object == this.foregroundCheck) {
            this.setDefaultColor(this.foregroundCheck.isSelected(), 0);
        } else if (object == this.backgroundCheck) {
            this.setDefaultColor(this.backgroundCheck.isSelected(), 1);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.schemeCombo) {
            this.syncToSelectedScheme();
        }
    }

    public void setCustomColor(int n2, Color color) {
        PageSchemeDefinition pageSchemeDefinition = this.getSelectedScheme();
        Color[] colorArray = pageSchemeDefinition.getCustomColors();
        colorArray[n2 - this.fixedColors.length] = color;
        this.syncToSelectedScheme();
    }

    protected void setDefaultColor(boolean bl, int n2) {
        PageSchemeDefinition pageSchemeDefinition = this.getSelectedScheme();
        ih ih2 = (ih)this.elementList.getSelectedValue();
        PageSchemeElement pageSchemeElement = pageSchemeDefinition.getElement(ih2.a);
        switch (n2) {
            case 0: {
                pageSchemeElement.setFgDefault(bl);
                Color color = pageSchemeElement.getForegroundColor();
                this.foreColor.setColor(color);
                if (!pageSchemeElement.getElementName().equals("whitespace")) break;
                this.sampleEditor.setForeground(color);
                break;
            }
            case 1: {
                pageSchemeElement.setBgDefault(bl);
                Color color = pageSchemeElement.getBackgroundColor();
                this.backColor.setColor(color);
                if (!pageSchemeElement.getElementName().equals("whitespace")) break;
                this.sampleEditor.setBackground(color);
                break;
            }
        }
        this.sampleEditor.updateColors(this.context);
        this.sampleEditor.repaint();
    }

    public void setElementColor(Color color, int n2, int n3) {
        PageSchemeDefinition pageSchemeDefinition = this.getSelectedScheme();
        ih ih2 = (ih)this.elementList.getSelectedValue();
        PageSchemeElement pageSchemeElement = pageSchemeDefinition.getElement(ih2.a);
        switch (n3) {
            case 0: {
                pageSchemeElement.setFgColorIndex(n2);
                pageSchemeElement.setFgDefault(false);
                this.foreColor.setColor(color);
                this.foregroundCheck.setSelected(false);
                if (!pageSchemeElement.getElementName().equals("whitespace")) break;
                this.sampleEditor.setForeground(color);
                break;
            }
            case 1: {
                pageSchemeElement.setBgColorIndex(n2);
                pageSchemeElement.setBgDefault(false);
                this.backColor.setColor(color);
                this.backgroundCheck.setSelected(false);
                if (!pageSchemeElement.getElementName().equals("whitespace")) break;
                this.sampleEditor.setBackground(color);
            }
        }
        this.sampleEditor.updateColors(this.context);
        this.sampleEditor.repaint();
    }

    protected void setCustomColors(Color[] colorArray) {
        for (int i2 = 0; i2 < this.fgCustomColorBoxes.length; ++i2) {
            this.fgCustomColorBoxes[i2].setColor(colorArray[i2]);
            this.bgCustomColorBoxes[i2].setColor(colorArray[i2]);
        }
    }

    protected void syncToSelectedElement() {
        PageSchemeDefinition pageSchemeDefinition = this.getSelectedScheme();
        ih ih2 = (ih)this.elementList.getSelectedValue();
        PageSchemeElement pageSchemeElement = pageSchemeDefinition.getElement(ih2.a);
        if (pageSchemeElement == null) {
            DefaultListModel defaultListModel = (DefaultListModel)this.elementList.getModel();
            if (defaultListModel.size() > 1) {
                int n2 = defaultListModel.indexOf(ih2);
                defaultListModel.removeElement(ih2);
                if (n2 >= defaultListModel.getSize()) {
                    n2 = 0;
                }
                this.elementList.setSelectedValue(defaultListModel.getElementAt(n2), true);
                this.syncToSelectedElement();
            }
            return;
        }
        this.boldCheck.setSelected(pageSchemeElement.isBold());
        this.italicCheck.setSelected(pageSchemeElement.isItalic());
        this.foreColor.setColor(pageSchemeElement.getForegroundColor());
        this.backColor.setColor(pageSchemeElement.getBackgroundColor());
        this.foregroundCheck.setSelected(pageSchemeElement.isFgDefault());
        this.backgroundCheck.setSelected(pageSchemeElement.isBgDefault());
    }

    protected void syncToSelectedScheme() {
        PageSchemeDefinition pageSchemeDefinition = this.getSelectedScheme();
        pageSchemeDefinition.initStyleContext(this.context);
        this.setCustomColors(pageSchemeDefinition.getCustomColors());
        this.syncToSelectedElement();
        PageSchemeElement pageSchemeElement = pageSchemeDefinition.getElement("whitespace");
        this.sampleEditor.setForeground(pageSchemeElement.getForegroundColor());
        this.sampleEditor.setBackground(pageSchemeElement.getBackgroundColor());
        this.sampleEditor.updateColors(this.context);
        this.sampleEditor.repaint();
    }

    protected PageSchemeDefinition getSelectedScheme() {
        int n2 = this.schemeCombo.getSelectedIndex();
        return (PageSchemeDefinition)this.tempSchemes.get(n2);
    }

    protected Component buildSampleEditor() {
        Serializable serializable;
        int n2;
        this.sampleEditor = EditorManager.createEditor(null);
        this.sampleEditor.setEditable(false);
        String string = "";
        for (n2 = 0; n2 < this.sampleTextStrings.length; ++n2) {
            string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(this.sampleTextStrings[n2]).append("\n")));
        }
        n2 = string.indexOf("@@");
        string = String.valueOf(String.valueOf(string.substring(0, n2))).concat(String.valueOf(String.valueOf(string.substring(n2 + 2))));
        int n3 = string.indexOf("@@");
        string = String.valueOf(String.valueOf(string.substring(0, n3))).concat(String.valueOf(String.valueOf(string.substring(n3 + 2))));
        this.sampleEditor.setText(string);
        Caret caret = this.sampleEditor.getCaret();
        caret.setDot(n2);
        caret.moveDot(n3);
        EditorDocument editorDocument = (EditorDocument)this.sampleEditor.getDocument();
        editorDocument.setStyleMap(new BasicStyleMap(this.context));
        editorDocument.setScanner(new JavaScanner());
        editorDocument.setLineMark(10, new MarkWrapper(this, new EditorPane.HighlightMark()));
        editorDocument.setLineMark(11, new MarkWrapper(this, new BreakpointMark(true, false, true)));
        editorDocument.setLineMark(12, new MarkWrapper(this, new ExecutionPointMark().getCurrentMarker()));
        editorDocument.setLineMark(13, new MarkWrapper(this, new BreakpointMark(true, true, true)));
        editorDocument.setLineMark(14, new MarkWrapper(this, new BreakpointMark(false, false, true)));
        editorDocument.setLineMark(15, new MarkWrapper(this, BrowserBuildListener.CompilerErrorMark.SHARED_INSTANCE));
        editorDocument.setLineMark(16, new MarkWrapper(this, new LineMark(false, editorDocument.getStyleMap().getStyle(16))));
        editorDocument.setLineMark(17, new MarkWrapper(this, new LineMark(false, editorDocument.getStyleMap().getStyle(15))));
        this.sampleEditor.addMouseListener(this);
        this.sampleEditor.addKeyListener(new nh());
        if (caret instanceof DefaultCaret) {
            serializable = (DefaultCaret)caret;
            this.sampleEditor.removeFocusListener((FocusListener)((Object)serializable));
            this.sampleEditor.removeMouseListener((MouseListener)((Object)serializable));
            this.sampleEditor.removeMouseMotionListener((MouseMotionListener)((Object)serializable));
            ((DefaultCaret)serializable).setVisible(true);
            ((DefaultCaret)serializable).setBlinkRate(500);
        }
        serializable = new h();
        ((Gutter)serializable).setEditor(this.sampleEditor);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setRowHeaderView((Component)serializable);
        jScrollPane.getViewport().add(this.sampleEditor);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        return jScrollPane;
    }

    protected void initializeColorBoxes() {
        int n2;
        for (n2 = 0; n2 < this.fgFixedColorBoxes.length; ++n2) {
            this.fgFixedColorBoxes[n2] = new ColorBox(this, this.fixedColors[n2], n2, 0);
            this.bgFixedColorBoxes[n2] = new ColorBox(this, this.fixedColors[n2], n2, 1);
        }
        for (n2 = 0; n2 < this.fgCustomColorBoxes.length; ++n2) {
            this.fgCustomColorBoxes[n2] = new ColorBox(this, Color.orange, n2 + this.fgFixedColorBoxes.length, 0);
            this.bgCustomColorBoxes[n2] = new ColorBox(this, Color.orange, n2 + this.fgFixedColorBoxes.length, 1);
        }
    }

    protected Component buildColorPanel() {
        this.initializeColorBoxes();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(com.borland.primetime.editor.a.a(13));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 0, new Insets(0, 0, 0, 2), 0, 0));
        jPanel.add((Component)this.boldCheck, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 17, 2, new Insets(0, 2, 0, 2), 0, 0));
        jPanel.add((Component)this.italicCheck, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.1, 17, 2, new Insets(0, 2, 0, 0), 0, 0));
        this.boldCheck.setMnemonic(com.borland.primetime.editor.a.a(32).charAt(0));
        this.italicCheck.setMnemonic(com.borland.primetime.editor.a.a(156).charAt(0));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 8, 2, 2));
        for (int i2 = 0; i2 < this.fgFixedColorBoxes.length; ++i2) {
            jPanel2.add(this.fgFixedColorBoxes[i2]);
        }
        JPanel jPanel3 = new JPanel(new GridLayout(2, 4, 2, 2));
        EdgeBorder edgeBorder = new EdgeBorder(240);
        Border border = BorderFactory.createEmptyBorder(0, 4, 0, 0);
        jPanel3.setBorder(BorderFactory.createCompoundBorder(edgeBorder, border));
        for (int i3 = 0; i3 < this.fgCustomColorBoxes.length; ++i3) {
            jPanel3.add(this.fgCustomColorBoxes[i3]);
        }
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        JLabel jLabel2 = new JLabel(com.borland.primetime.editor.a.a(132));
        jPanel4.add((Component)jLabel2, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 0, new Insets(0, 0, 2, 2), 0, 0));
        jPanel4.add((Component)this.foreColor, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 10, 2, new Insets(0, 2, 2, 2), 0, 0));
        jPanel4.add((Component)this.foregroundCheck, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.1, 17, 0, new Insets(0, 2, 2, 0), 0, 0));
        jPanel4.add((Component)jPanel2, new GridBagConstraints(0, 1, 2, 1, 0.1, 0.1, 10, 0, new Insets(2, 0, 0, 2), 0, 0));
        jPanel4.add((Component)jPanel3, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.1, 17, 0, new Insets(2, 2, 0, 0), 0, 0));
        this.foregroundCheck.setMnemonic(com.borland.primetime.editor.a.a(131).charAt(0));
        JPanel jPanel5 = new JPanel(new GridLayout(2, 8, 2, 2));
        for (int i4 = 0; i4 < this.bgFixedColorBoxes.length; ++i4) {
            jPanel5.add(this.bgFixedColorBoxes[i4]);
        }
        JPanel jPanel6 = new JPanel(new GridLayout(2, 4, 2, 2));
        EdgeBorder edgeBorder2 = new EdgeBorder(240);
        Border border2 = BorderFactory.createEmptyBorder(0, 4, 0, 0);
        jPanel6.setBorder(BorderFactory.createCompoundBorder(edgeBorder2, border2));
        for (int i5 = 0; i5 < this.bgCustomColorBoxes.length; ++i5) {
            jPanel6.add(this.bgCustomColorBoxes[i5]);
        }
        JPanel jPanel7 = new JPanel(new GridBagLayout());
        JLabel jLabel3 = new JLabel(com.borland.primetime.editor.a.a(15));
        jPanel7.add((Component)jLabel3, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 17, 0, new Insets(0, 0, 2, 2), 0, 0));
        jPanel7.add((Component)this.backColor, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.1, 10, 2, new Insets(0, 2, 2, 2), 0, 0));
        jPanel7.add((Component)this.backgroundCheck, new GridBagConstraints(2, 0, 1, 1, 0.1, 0.1, 17, 0, new Insets(0, 2, 2, 0), 0, 0));
        jPanel7.add((Component)jPanel5, new GridBagConstraints(0, 1, 2, 1, 0.1, 0.1, 10, 0, new Insets(2, 0, 0, 2), 0, 0));
        jPanel7.add((Component)jPanel6, new GridBagConstraints(2, 1, 1, 1, 0.1, 0.1, 17, 0, new Insets(2, 2, 0, 0), 0, 0));
        this.backgroundCheck.setMnemonic(com.borland.primetime.editor.a.a(14).charAt(0));
        JPanel jPanel8 = new JPanel(new GridBagLayout());
        jPanel8.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.1, 0.1, 10, 2, new Insets(0, 0, 2, 0), 0, 0));
        jPanel8.add((Component)jPanel4, new GridBagConstraints(0, 1, 1, 1, 0.1, 0.1, 10, 0, new Insets(2, 0, 2, 0), 0, 0));
        jPanel8.add((Component)jPanel7, new GridBagConstraints(0, 2, 1, 1, 0.1, 0.1, 10, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.boldCheck.addItemListener(this);
        this.italicCheck.addItemListener(this);
        this.foregroundCheck.addItemListener(this);
        this.backgroundCheck.addItemListener(this);
        return jPanel8;
    }

    protected Component buildElementPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane(this.elementList);
        jScrollPane.setMinimumSize(new Dimension(130, 100));
        JLabel jLabel = new JLabel(com.borland.primetime.editor.a.a(221));
        jPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 2, 0), 0, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.1, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        DefaultListModel<ih> defaultListModel = new DefaultListModel<ih>();
        ArrayList arrayList = MasterStyleContext.sourceElements;
        ArrayList<ih> arrayList2 = new ArrayList<ih>();
        Collections.sort(arrayList);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            String string = arrayList.get(i2).toString();
            Style style = this.context.getStyle(string);
            String string2 = (String)style.getAttribute("DisplayName");
            ih ih2 = new ih(this, string, string2);
            arrayList2.add(ih2);
            defaultListModel.addElement(ih2);
        }
        this.elementList.setModel(defaultListModel);
        this.elementList.setSelectedIndex(0);
        this.elementList.addListSelectionListener(this);
        this.elementList.setSelectionMode(0);
        jPanel.setMinimumSize(new Dimension(130, 100));
        jLabel.setLabelFor(this.elementList);
        jLabel.setDisplayedMnemonic(com.borland.primetime.editor.a.a(222).charAt(0));
        return jPanel;
    }

    protected Component buildSchemePanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.schemeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0));
        jPanel.add((Component)this.schemeCombo, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
        this.schemeLabel.setLabelFor(this.schemeCombo);
        this.schemeLabel.setDisplayedMnemonic(com.borland.primetime.editor.a.a(73).charAt(0));
        return jPanel;
    }

    void g() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.buildSchemePanel(), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 2, new Insets(8, 8, 4, 8), 0, 0));
        this.add(this.buildElementPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(4, 8, 4, 4), 0, 0));
        this.add(this.buildColorPanel(), new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 11, 0, new Insets(4, 4, 4, 8), 0, 0));
        this.add(this.buildSampleEditor(), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(4, 8, 8, 8), 0, 0));
    }

    public ColorPropertyPage() {
        this.fgFixedColorBoxes = new ColorBox[16];
        this.fgCustomColorBoxes = new ColorBox[8];
        this.bgFixedColorBoxes = new ColorBox[16];
        this.bgCustomColorBoxes = new ColorBox[8];
        this.sampleTextStrings = new String[]{"// ".concat(String.valueOf(String.valueOf(c))), "public class CoreLogic extends SubLogic {", "", "  /** @merge workspace*/", "  void ResolveEvent(TraceEvent e) {", "    int number, i, x;", "    number = 120416;", String.valueOf(String.valueOf(new StringBuffer("    e.info = \"").append(j).append(" \" + new String(number);"))), "", String.valueOf(String.valueOf(new StringBuffer("    // @@").append(d).append("@@"))), "    // ".concat(String.valueOf(String.valueOf(k))), "    // ".concat(String.valueOf(String.valueOf(m))), "    for (int i = 0; i <= number; i++) { // ".concat(String.valueOf(String.valueOf(s))), "      x++; // ".concat(String.valueOf(String.valueOf(a))), "      x--; // ".concat(String.valueOf(String.valueOf(v))), "      x + 1.0; // ".concat(String.valueOf(String.valueOf(t))), "      x += 2.0; // ".concat(String.valueOf(String.valueOf(w))), "      x += 3.0; // ".concat(String.valueOf(String.valueOf(x))), "    }", "  }", "}"};
        this.context = EditorManager.getStyleContext().createCopy();
        this.tempSchemes = new ArrayList();
        this.schemeLabel = new JLabel(com.borland.primetime.editor.a.a(72));
        this.schemeCombo = new JComboBox();
        this.elementList = new JList();
        this.boldCheck = new JCheckBox(com.borland.primetime.editor.a.a(31));
        this.italicCheck = new JCheckBox(com.borland.primetime.editor.a.a(155));
        this.foregroundCheck = new JCheckBox(com.borland.primetime.editor.a.a(314));
        this.backgroundCheck = new JCheckBox(com.borland.primetime.editor.a.a(314));
        this.foreColor = new ColorBox(Color.black);
        this.backColor = new ColorBox(Color.white);
        try {
            this.g();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected class MarkWrapper
    extends GutterMark {
        public MarkWrapper(ColorPropertyPage colorPropertyPage, LineMark lineMark) {
            super(lineMark instanceof GutterMark ? ((GutterMark)lineMark).getIcon() : null);
            Style style = lineMark.getStyle();
            if (style != null) {
                Style style2 = colorPropertyPage.context.getStyle(style.getName());
                this.setStyle(style2);
            }
        }
    }

    protected class PageSchemeElement
    extends ColorPropertyGroup.SchemeElement {
        Style a;

        public void setItalic(boolean bl) {
            this.isItalic = bl;
            StyleConstants.setItalic(this.a, bl);
        }

        public void setBold(boolean bl) {
            this.isBold = bl;
            StyleConstants.setBold(this.a, bl);
        }

        public boolean isItalic() {
            return this.isItalic;
        }

        public boolean isBold() {
            return this.isBold;
        }

        public void setBgDefault(boolean bl) {
            this.bgDefault = bl;
            StyleConstants.setBackground(this.a, this.getBackgroundColor());
        }

        public void setFgDefault(boolean bl) {
            this.fgDefault = bl;
            StyleConstants.setForeground(this.a, this.getForegroundColor());
        }

        public boolean isBgDefault() {
            return this.bgDefault;
        }

        public boolean isFgDefault() {
            return this.fgDefault;
        }

        public void setBgColorIndex(int n2) {
            this.bgColorIndex = n2;
            StyleConstants.setBackground(this.a, this.getBackgroundColor());
        }

        public void setFgColorIndex(int n2) {
            this.fgColorIndex = n2;
            StyleConstants.setForeground(this.a, this.getForegroundColor());
        }

        public PageSchemeElement(ColorPropertyPage colorPropertyPage, PageSchemeDefinition pageSchemeDefinition, ColorPropertyGroup.SchemeElement schemeElement) {
            super(pageSchemeDefinition);
            this.elementName = schemeElement.elementName;
            this.isBold = schemeElement.isBold;
            this.isItalic = schemeElement.isItalic;
            this.fgDefault = schemeElement.fgDefault;
            this.bgDefault = schemeElement.bgDefault;
            this.fgColorIndex = schemeElement.fgColorIndex;
            this.bgColorIndex = schemeElement.bgColorIndex;
            this.fgDefaultColor = schemeElement.fgDefaultColor;
            this.bgDefaultColor = schemeElement.bgDefaultColor;
            this.a = colorPropertyPage.context.getStyle(this.elementName);
        }
    }

    protected class PageSchemeDefinition
    extends ColorPropertyGroup.SchemeDefinition {
        HashMap a = new HashMap();

        public PageSchemeElement getElement(Object object) {
            return (PageSchemeElement)this.a.get(object);
        }

        public PageSchemeDefinition(ColorPropertyPage colorPropertyPage, ColorPropertyGroup.SchemeDefinition schemeDefinition) {
            this.schemeName = schemeDefinition.schemeName;
            this.displayName = schemeDefinition.displayName;
            this.elementProperties = schemeDefinition.elementProperties;
            System.arraycopy(schemeDefinition.customColors, 0, this.customColors, 0, this.customColors.length);
            for (int i2 = 0; i2 < schemeDefinition.schemeElements.size(); ++i2) {
                ColorPropertyGroup.SchemeElement schemeElement = (ColorPropertyGroup.SchemeElement)schemeDefinition.schemeElements.get(i2);
                ColorPropertyPage colorPropertyPage2 = colorPropertyPage;
                colorPropertyPage2.getClass();
                PageSchemeElement pageSchemeElement = new PageSchemeElement(colorPropertyPage2, this, schemeElement);
                this.schemeElements.add(pageSchemeElement);
                this.a.put(pageSchemeElement.getElementName(), pageSchemeElement);
            }
        }
    }
}

