/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.primetime.editor.a;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;

public class DefaultKeymap
implements Keymap {
    protected Keymap master;
    protected Action defaultAction;
    protected Hashtable bindings;
    protected Keymap parent;
    protected String nm;

    public String toString() {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(a.a(163)))).append(this.nm).append("]").append(this.bindings)));
    }

    public void setMaster(Keymap keymap) {
        this.master = keymap;
    }

    public Keymap getMaster() {
        return this.master;
    }

    public void setResolveParent(Keymap keymap) {
        this.parent = keymap;
    }

    public Keymap getResolveParent() {
        return this.parent;
    }

    public void setBindings(Hashtable hashtable) {
        this.bindings.clear();
        this.bindings = hashtable;
    }

    public Hashtable getBindings() {
        return this.bindings;
    }

    public void removeBindings() {
        this.bindings.clear();
    }

    public void removeKeyStrokeBinding(KeyStroke keyStroke) {
        this.bindings.remove(keyStroke);
    }

    public void addActionForKeyStroke(KeyStroke keyStroke, Action action) {
        this.bindings.put(keyStroke, action);
    }

    public boolean isLocallyDefined(KeyStroke keyStroke) {
        return this.bindings.containsKey(keyStroke);
    }

    public KeyStroke[] getKeyStrokesForAction(Action action) {
        if (action == null) {
            return null;
        }
        Object[] objectArray = null;
        Vector vector = null;
        KeyStroke[] keyStrokeArray = this.bindings.keys();
        while (keyStrokeArray.hasMoreElements()) {
            Object k2 = keyStrokeArray.nextElement();
            if (this.bindings.get(k2) != action) continue;
            if (vector == null) {
                vector = new Vector();
            }
            vector.addElement(k2);
        }
        if (this.parent != null && (keyStrokeArray = this.parent.getKeyStrokesForAction(action)) != null) {
            int n2;
            int n3 = 0;
            for (n2 = keyStrokeArray.length - 1; n2 >= 0; --n2) {
                if (!this.isLocallyDefined(keyStrokeArray[n2])) continue;
                keyStrokeArray[n2] = null;
                ++n3;
            }
            if (n3 > 0 && n3 < keyStrokeArray.length) {
                if (vector == null) {
                    vector = new Vector();
                }
                for (n2 = keyStrokeArray.length - 1; n2 >= 0; --n2) {
                    if (keyStrokeArray[n2] == null) continue;
                    vector.addElement(keyStrokeArray[n2]);
                }
            } else if (n3 == 0) {
                if (vector == null) {
                    objectArray = keyStrokeArray;
                } else {
                    objectArray = new KeyStroke[vector.size() + keyStrokeArray.length];
                    vector.copyInto(objectArray);
                    System.arraycopy(keyStrokeArray, 0, objectArray, vector.size(), keyStrokeArray.length);
                    vector = null;
                }
            }
        }
        if (vector != null) {
            objectArray = new KeyStroke[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public Action[] getBoundActions() {
        Action[] actionArray = new Action[this.bindings.size()];
        int n2 = 0;
        Enumeration enumeration = this.bindings.elements();
        while (enumeration.hasMoreElements()) {
            actionArray[n2++] = (Action)enumeration.nextElement();
        }
        return actionArray;
    }

    public KeyStroke[] getBoundKeyStrokes() {
        KeyStroke[] keyStrokeArray = new KeyStroke[this.bindings.size()];
        int n2 = 0;
        Enumeration enumeration = this.bindings.keys();
        while (enumeration.hasMoreElements()) {
            keyStrokeArray[n2++] = (KeyStroke)enumeration.nextElement();
        }
        return keyStrokeArray;
    }

    public Action getAction(KeyStroke keyStroke) {
        Action action = (Action)this.bindings.get(keyStroke);
        if (action == null && this.parent != null) {
            action = this.parent.getAction(keyStroke);
        }
        return action;
    }

    public String getName() {
        return this.nm;
    }

    public void setDefaultAction(Action action) {
        this.defaultAction = action;
    }

    public Action getDefaultAction() {
        if (this.defaultAction != null) {
            return this.defaultAction;
        }
        return this.parent != null ? this.parent.getDefaultAction() : null;
    }

    public DefaultKeymap(String string, Keymap keymap) {
        this.nm = string;
        this.parent = keymap;
        this.bindings = new Hashtable();
    }
}

