/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.primetime.editor.EditorAction;
import com.borland.primetime.editor.EditorActions;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.jd;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;

public class EditorCaret
extends DefaultCaret
implements MouseListener,
FocusListener {
    protected int pressClickCount = 0;
    protected static Highlighter.HighlightPainter noHighlightPainter = new jd();

    protected void fireStateChanged() {
        this.setMagicCaretPosition(null);
        super.fireStateChanged();
    }

    public void moveDot(int n2) {
        this.setMagicCaretPosition(null);
        super.moveDot(n2);
    }

    public void setDot(int n2) {
        this.setMagicCaretPosition(null);
        super.setDot(n2);
    }

    public void paint(Graphics graphics) {
        if (this.isVisible()) {
            try {
                TextUI textUI = this.getComponent().getUI();
                Rectangle rectangle = textUI.modelToView(this.getComponent(), this.getDot());
                graphics.setColor(this.getComponent().getCaretColor());
                if (EditorManager.isInsertMode()) {
                    graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height - 1);
                } else {
                    Document document = this.getComponent().getDocument();
                    String string = document.getLength() > this.getDot() ? document.getText(this.getDot(), 1) : " ";
                    Font font = this.getComponent().getFont();
                    FontMetrics fontMetrics = graphics.getFontMetrics(font);
                    char c2 = string.charAt(0);
                    int n2 = c2 == '\n' || c2 == '\r' || c2 == '\t' ? fontMetrics.charWidth(' ') : fontMetrics.charWidth(c2);
                    graphics.fillRect(rectangle.x, rectangle.y, n2, ((EditorPane)this.getComponent()).getFontHeight());
                    graphics.setColor(Color.white);
                    graphics.setFont(font);
                    if (!Character.isIdentifierIgnorable(c2) && !Character.isWhitespace(c2)) {
                        graphics.drawString(string, rectangle.x, rectangle.y + fontMetrics.getAscent());
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.pressClickCount = 0;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            if (this.getComponent().isEnabled()) {
                this.getComponent().requestFocus();
            }
            if (mouseEvent.isShiftDown()) {
                this.moveCaret(mouseEvent);
            } else {
                this.positionCaret(mouseEvent);
            }
            if (mouseEvent.getClickCount() == 2) {
                this.pressClickCount = 2;
                EditorAction editorAction = EditorActions.ACTION_SelectWord;
                editorAction.actionPerformed(null);
            } else if (mouseEvent.getClickCount() == 3) {
                this.pressClickCount = 3;
                EditorAction editorAction = EditorActions.ACTION_SelectLine;
                editorAction.actionPerformed(null);
            }
        } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            if (this.getDot() == this.getMark()) {
                this.positionCaret(mouseEvent);
            } else {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                int n2 = this.getComponent().getUI().viewToModel(this.getComponent(), point);
                if (n2 >= 0 && (n2 < Math.min(this.getDot(), this.getMark()) || n2 > Math.max(this.getDot(), this.getMark()))) {
                    this.positionCaret(mouseEvent);
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setVisible(false);
        this.setSelectionVisible(focusEvent.isTemporary());
    }

    public void focusGained(FocusEvent focusEvent) {
        this.setVisible(true);
        this.setSelectionVisible(true);
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return noHighlightPainter;
    }

    protected synchronized void damage(Rectangle rectangle) {
        if (rectangle != null) {
            this.x = rectangle.x - 4;
            this.y = rectangle.y;
            this.width = ((EditorPane)this.getComponent()).getFontWidth() * 2 + 4;
            this.height = rectangle.height;
            this.repaint();
        }
    }

    public EditorCaret() {
        if (EditorManager.isBooleanOptionValue("blinkCaret")) {
            this.setBlinkRate(500);
        } else {
            this.setBlinkRate(0);
        }
        this.x = 0;
        this.y = 0;
        this.width = 10;
        this.height = 40;
    }
}

