/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import java.util.ArrayList;
import java.util.Stack;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

public class JBUndoManager
implements UndoableEditListener {
    protected Stack undoGroupStack;
    protected UndoGroup activeUndoGroup;
    private int b = 0;
    private ArrayList c = new ArrayList();
    private static int h;
    public static final int OVERWRITE = 3;
    public static final int REMOVE = 2;
    public static final int INSERT = 1;
    public static final int UNKNOWN = 0;

    static {
        UNKNOWN = 0;
        INSERT = 1;
        REMOVE = 2;
        OVERWRITE = 3;
        h = 1000;
    }

    public synchronized void endUndoGroup(int n2, int n3) {
        this.activeUndoGroup.setEndOffsets(n2, n3);
        this.activeUndoGroup.end();
        UndoGroup undoGroup = this.activeUndoGroup;
        this.undoGroupStack.pop();
        this.activeUndoGroup = this.undoGroupStack.isEmpty() ? null : (UndoGroup)this.undoGroupStack.peek();
        this.addEdit(undoGroup);
    }

    public synchronized void startUndoGroup(int n2, int n3) {
        this.activeUndoGroup = new UndoGroup(this);
        this.activeUndoGroup.setStartOffsets(n2, n3);
        this.undoGroupStack.push(this.activeUndoGroup);
    }

    public synchronized void endUndoSegment(int n2, int n3) {
        this.endUndoGroup(n2, n3);
    }

    public synchronized void startUndoSegment(int n2, int n3, int n4) {
        this.activeUndoGroup = new UndoSegment(this, n2, n3, n4);
        this.undoGroupStack.push(this.activeUndoGroup);
    }

    protected void trimForLimit() {
        while (this.c.size() > h) {
            UndoableEdit undoableEdit = (UndoableEdit)this.c.remove(0);
            undoableEdit.die();
        }
    }

    protected void trimEdits(int n2) {
        for (int i2 = this.c.size() - 1; i2 >= n2; --i2) {
            UndoableEdit undoableEdit = (UndoableEdit)this.c.remove(i2);
            undoableEdit.die();
        }
        if (this.b > this.c.size()) {
            this.b = this.c.size();
        }
    }

    protected UndoGroup getCurrentRedoEdit() {
        if (this.b < this.c.size()) {
            UndoGroup undoGroup = (UndoGroup)this.c.get(this.b);
            return undoGroup;
        }
        return null;
    }

    protected UndoGroup getCurrentUndoEdit() {
        if (this.b > 0) {
            UndoGroup undoGroup = (UndoGroup)this.c.get(this.b - 1);
            return undoGroup;
        }
        return null;
    }

    protected UndoGroup getLastEdit() {
        if (this.c.size() > 0) {
            return (UndoGroup)this.c.get(this.c.size() - 1);
        }
        return null;
    }

    public synchronized int getRedoEndMark() {
        UndoGroup undoGroup = this.getCurrentRedoEdit();
        return undoGroup != null ? undoGroup.getEndMark() : -1;
    }

    public synchronized int getRedoEndPoint() {
        UndoGroup undoGroup = this.getCurrentRedoEdit();
        return undoGroup != null ? undoGroup.getEndPoint() : -1;
    }

    public synchronized int getRedoStartMark() {
        UndoGroup undoGroup = this.getCurrentRedoEdit();
        return undoGroup != null ? undoGroup.getStartMark() : -1;
    }

    public synchronized int getRedoStartPoint() {
        UndoGroup undoGroup = this.getCurrentRedoEdit();
        return undoGroup != null ? undoGroup.getStartPoint() : -1;
    }

    public synchronized int getUndoEndMark() {
        UndoGroup undoGroup = this.getCurrentUndoEdit();
        return undoGroup != null ? undoGroup.getEndMark() : -1;
    }

    public synchronized int getUndoEndPoint() {
        UndoGroup undoGroup = this.getCurrentUndoEdit();
        return undoGroup != null ? undoGroup.getEndPoint() : -1;
    }

    public synchronized int getUndoStartMark() {
        UndoGroup undoGroup = this.getCurrentUndoEdit();
        return undoGroup != null ? undoGroup.getStartMark() : -1;
    }

    public synchronized int getUndoStartPoint() {
        UndoGroup undoGroup = this.getCurrentUndoEdit();
        return undoGroup != null ? undoGroup.getStartPoint() : -1;
    }

    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.addEdit(undoableEditEvent.getEdit());
    }

    public synchronized void discardAllEdits() {
        for (int i2 = this.c.size() - 1; i2 >= 0; --i2) {
            UndoableEdit undoableEdit = (UndoableEdit)this.c.get(i2);
            undoableEdit.die();
        }
        this.b = 0;
        this.c.clear();
    }

    public synchronized boolean addEdit(UndoableEdit undoableEdit) {
        if (this.activeUndoGroup != null) {
            return this.activeUndoGroup.addEdit(undoableEdit);
        }
        this.trimEdits(this.b);
        if (undoableEdit instanceof UndoSegment) {
            UndoGroup undoGroup = this.getLastEdit();
            if (undoGroup != null) {
                if (undoGroup.addEdit(undoableEdit)) {
                    return true;
                }
                undoGroup.end();
            }
            this.c.add(undoableEdit);
        } else if (undoableEdit instanceof UndoGroup) {
            this.c.add(undoableEdit);
        } else if (undoableEdit instanceof AbstractDocument.DefaultDocumentEvent) {
            AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = (AbstractDocument.DefaultDocumentEvent)undoableEdit;
            UndoGroup undoGroup = new UndoGroup(this);
            DocumentEvent.EventType eventType = defaultDocumentEvent.getType();
            if (eventType == DocumentEvent.EventType.INSERT) {
                undoGroup.setStartOffsets(defaultDocumentEvent.getOffset(), -1);
                undoGroup.addEdit(defaultDocumentEvent);
                undoGroup.setEndOffsets(defaultDocumentEvent.getOffset() + defaultDocumentEvent.getLength(), -1);
            } else if (eventType == DocumentEvent.EventType.REMOVE) {
                undoGroup.setStartOffsets(defaultDocumentEvent.getOffset(), -1);
                undoGroup.addEdit(defaultDocumentEvent);
                undoGroup.setEndOffsets(defaultDocumentEvent.getOffset(), -1);
            }
            undoGroup.end();
            this.c.add(undoGroup);
        } else {
            System.err.println("[JBUndoManager] addEdit got an undefined edit: ".concat(String.valueOf(String.valueOf(undoableEdit))));
        }
        this.trimForLimit();
        this.b = this.c.size();
        return true;
    }

    public synchronized void redo() throws CannotRedoException {
        UndoGroup undoGroup = this.getCurrentRedoEdit();
        if (undoGroup == null) {
            throw new CannotRedoException();
        }
        ++this.b;
        undoGroup.redo();
    }

    public synchronized void undo() throws CannotUndoException {
        UndoGroup undoGroup = this.getCurrentUndoEdit();
        if (undoGroup == null) {
            throw new CannotUndoException();
        }
        --this.b;
        undoGroup.end();
        undoGroup.undo();
    }

    public synchronized boolean canRedo() {
        return this.b < this.c.size();
    }

    public synchronized boolean canUndo() {
        return this.b > 0;
    }

    public synchronized int getCurrentUndoHashCode() {
        UndoGroup undoGroup = this.getCurrentUndoEdit();
        if (undoGroup != null) {
            return undoGroup.hashCode();
        }
        return -1;
    }

    public JBUndoManager() {
        this.undoGroupStack = new Stack();
    }

    protected class UndoSegment
    extends UndoGroup {
        private int a = 0;

        public boolean canChain(UndoSegment undoSegment) {
            switch (this.a) {
                case 0: {
                    return false;
                }
                case 1: {
                    return undoSegment.getType() == 1 && this.endPoint == undoSegment.getStartPoint();
                }
                case 2: {
                    return undoSegment.getType() == 2 && (this.endPoint == undoSegment.getStartPoint() || this.endPoint == undoSegment.getStartMark());
                }
                case 3: {
                    return false;
                }
            }
            return false;
        }

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof UndoSegment) {
                UndoSegment undoSegment = (UndoSegment)undoableEdit;
                if (this.canChain(undoSegment)) {
                    this.edits.addElement(undoSegment);
                    this.endPoint = undoSegment.getEndPoint();
                    this.endMark = undoSegment.getEndMark();
                    return true;
                }
            } else if (undoableEdit instanceof AbstractDocument.DefaultDocumentEvent) {
                this.edits.addElement(undoableEdit);
                return true;
            }
            return false;
        }

        public int getType() {
            return this.a;
        }

        public UndoSegment(JBUndoManager jBUndoManager, int n2, int n3, int n4) {
            super(jBUndoManager);
            super.setStartOffsets(n2, n3);
            this.a = n4;
        }
    }

    protected class UndoGroup
    extends CompoundEdit {
        protected int endMark = -1;
        protected int endPoint = -1;
        protected int startMark = -1;
        protected int startPoint = -1;

        public int hashCode() {
            if (this.lastEdit() != null) {
                return this.lastEdit().hashCode();
            }
            return super.hashCode();
        }

        public int getEndMark() {
            return this.endMark;
        }

        public int getEndPoint() {
            return this.endPoint;
        }

        public int getStartMark() {
            return this.startMark;
        }

        public int getStartPoint() {
            return this.startPoint;
        }

        public void setEndOffsets(int n2, int n3) {
            this.endPoint = n2;
            this.endMark = n3;
        }

        public void setStartOffsets(int n2, int n3) {
            this.startPoint = n2;
            this.startMark = n3;
        }

        protected UndoGroup(JBUndoManager jBUndoManager) {
        }
    }
}

