/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.TrackingKeymap;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;

public class ModalKeymap
extends TrackingKeymap {
    protected Map modeKeymaps = new HashMap();
    public static final int DEFAULT = 0;

    static {
        DEFAULT = 0;
    }

    protected boolean dispatchAction(EditorPane editorPane, KeyEvent keyEvent, Action action) {
        if (action != null) {
            String string = null;
            if (keyEvent.getKeyChar() != '\uffff') {
                string = String.valueOf(keyEvent.getKeyChar());
            }
            ActionEvent actionEvent = new ActionEvent(editorPane, 1001, string, keyEvent.getModifiers());
            action.actionPerformed(actionEvent);
            keyEvent.consume();
            return true;
        }
        return false;
    }

    protected Action getActionForKeyStroke(int n2, KeyEvent keyEvent) {
        Action action;
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        Keymap keymap = this.getKeymapForMode(n2);
        if (keymap == null) {
            keymap = this;
        }
        if ((action = keymap.getAction(keyStroke)) == null && keyEvent.getID() == 400) {
            action = keymap.getDefaultAction();
        }
        return action;
    }

    public void processKeyEvent(EditorPane editorPane, KeyEvent keyEvent) {
        ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
        int n2 = modeStateInfo.mode;
        boolean bl = false;
        Action action = null;
        int n3 = keyEvent.getID();
        switch (n3) {
            case 401: {
                action = this.getActionForKeyStroke(n2, keyEvent);
                modeStateInfo.processedKeyPressed = bl = this.dispatchAction(editorPane, keyEvent, action);
                break;
            }
            case 400: {
                if (modeStateInfo.processedKeyPressed) break;
                action = this.getActionForKeyStroke(n2, keyEvent);
                bl = this.dispatchAction(editorPane, keyEvent, action);
                break;
            }
            case 402: {
                if (!modeStateInfo.processedKeyPressed) {
                    action = this.getActionForKeyStroke(n2, keyEvent);
                }
                bl = this.dispatchAction(editorPane, keyEvent, action);
            }
        }
        if (n2 != 0 && bl) {
            modeStateInfo.mode = 0;
        }
    }

    public Keymap getKeymapForMode(int n2) {
        return (Keymap)this.modeKeymaps.get(new Integer(n2));
    }

    public void registerKeymapForMode(Keymap keymap, int n2) {
        this.modeKeymaps.put(new Integer(n2), keymap);
    }

    public ModeStateInfo createStateInfo(EditorPane editorPane) {
        return new ModeStateInfo(editorPane);
    }

    public ModalKeymap(String string, Keymap keymap) {
        super(string, keymap);
    }

    public static class ModeStateInfo {
        public boolean hasModalSelection = false;
        public boolean processedKeyPressed = false;
        public int mode = 0;
        protected EditorPane editor;
        public static final int INC_CHAR_SELECTION = 8;
        public static final int CHAR_SELECTION = 4;
        public static final int COLUMN_SELECTION = 2;
        public static final int LINE_SELECTION = 1;
        public static final int DEFAULT = 0;

        static {
            DEFAULT = 0;
            LINE_SELECTION = 1;
            COLUMN_SELECTION = 2;
            CHAR_SELECTION = 4;
            INC_CHAR_SELECTION = 8;
        }

        public void setMode(int n2) {
            this.mode = n2;
        }

        public int getMode() {
            return this.mode;
        }

        public ModeStateInfo(EditorPane editorPane) {
            this.editor = editorPane;
        }
    }
}

