/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor;

import com.borland.primetime.actions.ActionGroup;
import com.borland.primetime.actions.UpdateAction;
import com.borland.primetime.audio.AudioClipPlayer;
import com.borland.primetime.editor.ConfirmReplaceDialog;
import com.borland.primetime.editor.EditorAction;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.IncrementalSearchHandler;
import com.borland.primetime.editor.NoMatchSearchDialog;
import com.borland.primetime.editor.SearchOptions;
import com.borland.primetime.editor.SearchResultsListener;
import com.borland.primetime.editor.TextUtilities;
import com.borland.primetime.editor.a;
import com.borland.primetime.ide.Browser;
import com.borland.primetime.ide.BrowserIcons;
import com.borland.primetime.ide.GutterIcons;
import com.borland.primetime.ide.Message;
import com.borland.primetime.ide.MessageCategory;
import com.borland.primetime.ide.MessageView;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.properties.GlobalArrayProperty;
import com.borland.primetime.properties.GlobalBooleanProperty;
import com.borland.primetime.properties.ProjectAutoArrayProperty;
import com.borland.primetime.util.RegularExpression;
import com.borland.primetime.util.Strings;
import com.borland.primetime.util.VetoException;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import com.borland.primetime.viewer.NodeViewMap;
import com.borland.primetime.viewer.TextNodeViewer;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;

public class SearchManager {
    static Class b;
    public static final SearchMessageCategory CATEGORY_SEARCH;
    private static boolean c;
    private static SearchOptions a;
    private static final int m = 32;
    private static final GlobalBooleanProperty i;
    private static final GlobalBooleanProperty d;
    private static final GlobalBooleanProperty g;
    private static final GlobalBooleanProperty e;
    private static final GlobalBooleanProperty f;
    private static final GlobalBooleanProperty j;
    private static final ProjectAutoArrayProperty n;
    private static final ProjectAutoArrayProperty l;
    private static final GlobalArrayProperty k;
    private static final GlobalArrayProperty h;
    private static final String p = "editor.search";

    static {
        p = p;
        h = new GlobalArrayProperty(p, "search_history");
        k = new GlobalArrayProperty(p, "replace_history");
        l = new ProjectAutoArrayProperty(p, "path_history");
        n = new ProjectAutoArrayProperty(p, "file_filter_history");
        j = new GlobalBooleanProperty(p, "case_sensitive", false);
        f = new GlobalBooleanProperty(p, "regular_expressions", true);
        e = new GlobalBooleanProperty(p, "selected_text", false);
        g = new GlobalBooleanProperty(p, "origin", false);
        d = new GlobalBooleanProperty(p, "whole_words_only", false);
        i = new GlobalBooleanProperty(p, "forward", true);
        m = 32;
        c = true;
        CATEGORY_SEARCH = new SearchMessageCategory();
    }

    static void a(Browser browser, Project project, Url[] urlArray, SearchOptions searchOptions, Message message) {
        SearchManager.b(browser, project, urlArray, searchOptions, message);
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String a(char[] cArray, int n2, boolean bl) {
        int n3 = 0;
        int n4 = cArray.length - 1;
        for (n3 = n2; n3 >= 0 && cArray[n3] != '\n'; --n3) {
        }
        ++n3;
        for (n4 = n2; n4 < cArray.length && cArray[n4] != '\n'; ++n4) {
        }
        String string = new String(cArray, n3, n4 - n3);
        return bl ? string.trim() : string;
    }

    public static int showNoMatchDialog(Component component, String string, boolean bl) {
        AudioClipPlayer.playClipNamed("find_failed");
        String string2 = com.borland.primetime.editor.a.a(246);
        if (!EditorManager.isShowSearchDialog()) {
            EditorManager.showStatusMessage(EditorAction.getFocusedEditor(), Strings.format(string2, string), false, true);
            return 0;
        }
        if (!bl) {
            JOptionPane.showMessageDialog(component, Strings.format(string2, string), com.borland.primetime.editor.a.a(236), 1);
            return 0;
        }
        String string3 = SearchManager.a.forwardSearch ? com.borland.primetime.editor.a.a(231) : com.borland.primetime.editor.a.a(230);
        NoMatchSearchDialog noMatchSearchDialog = new NoMatchSearchDialog(Strings.format(string2, string), string3);
        ((Component)noMatchSearchDialog).setVisible(true);
        return noMatchSearchDialog.getResult();
    }

    public static void showNoMatchDialog(Component component, String string) {
        SearchManager.showNoMatchDialog(component, string, false);
    }

    public static void searchInputStream(Browser browser, Project project, InputStream inputStream, Url url, SearchOptions searchOptions, Message message) {
        String string = searchOptions.getSearchText();
        int n2 = string.length();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        if (n2 > 1024) {
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[4096];
            try {
                int n3;
                while ((n3 = inputStreamReader.read(cArray, 0, cArray.length)) != -1) {
                    stringBuffer = stringBuffer.append(cArray, 0, n3);
                }
            }
            catch (IOException iOException) {
                System.err.println("Exception in searchInputStream: ".concat(String.valueOf(String.valueOf(iOException.getMessage()))));
                return;
            }
            char[] cArray2 = new char[stringBuffer.length()];
            stringBuffer.getChars(0, stringBuffer.length(), cArray2, 0);
            RegularExpression regularExpression = new RegularExpression(searchOptions.getEscapedSearchText(), searchOptions.isCaseSensitive());
            regularExpression.setPatternMatch(searchOptions.isRegExp());
            RegularExpression.MatchResult matchResult = regularExpression.findSubstringMatch(cArray2, 0, cArray2.length);
            if (matchResult != RegularExpression.NO_MATCH) {
                MessageView messageView = browser.getMessageView();
                if (!CATEGORY_SEARCH.isCancelling()) {
                    messageView.addMessage((MessageCategory)CATEGORY_SEARCH, message, new SearchPathResultMessage(project, messageView, url, searchOptions));
                }
            }
        } else {
            char[] cArray = new char[8192];
            int n4 = 0;
            try {
                int n5;
                RegularExpression regularExpression = new RegularExpression(searchOptions.getEscapedSearchText(), searchOptions.isCaseSensitive());
                regularExpression.setPatternMatch(searchOptions.isRegExp());
                while ((n5 = inputStreamReader.read(cArray, n4, cArray.length - n4)) > 0) {
                    RegularExpression.MatchResult matchResult = regularExpression.findSubstringMatch(cArray, 0, n5 += n4);
                    if (matchResult != RegularExpression.NO_MATCH) {
                        MessageView messageView = browser.getMessageView();
                        if (!CATEGORY_SEARCH.isCancelling()) {
                            messageView.addMessage((MessageCategory)CATEGORY_SEARCH, message, new SearchPathResultMessage(project, messageView, url, searchOptions));
                        }
                        break;
                    }
                    if (n2 < n5) {
                        System.arraycopy(cArray, n5 - n2, cArray, 0, n2);
                        n4 = n2;
                        continue;
                    }
                    n4 = n5;
                }
            }
            catch (IOException iOException) {
                System.err.println("Exception in searchInputStream: ".concat(String.valueOf(String.valueOf(iOException.getMessage()))));
                return;
            }
        }
    }

    private static void a(Browser browser, Project project, Url url, SearchOptions searchOptions, Message message) {
        int n2;
        Url[] urlArray;
        if (CATEGORY_SEARCH.isCancelling()) {
            return;
        }
        if (searchOptions.recurseDirectories) {
            urlArray = VFS.getChildren(url, 1);
            for (n2 = 0; n2 < urlArray.length; ++n2) {
                SearchManager.a(browser, project, urlArray[n2], searchOptions, message);
            }
        }
        urlArray = VFS.getChildren(url, searchOptions.filenameFilters, 2);
        for (n2 = 0; n2 < urlArray.length; ++n2) {
            if (CATEGORY_SEARCH.isCancelling()) {
                return;
            }
            try {
                InputStream inputStream = VFS.getInputStream(urlArray[n2]);
                SearchManager.searchInputStream(browser, project, inputStream, urlArray[n2], searchOptions, message);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void b(Browser browser, Project project, Url[] urlArray, SearchOptions searchOptions, Message message) {
        for (int i2 = 0; i2 < urlArray.length; ++i2) {
            if (CATEGORY_SEARCH.isCancelling()) {
                return;
            }
            SearchManager.a(browser, project, urlArray[i2], searchOptions, message);
        }
    }

    public static void searchPaths(Browser browser, Project project, Url[] urlArray, SearchOptions searchOptions) {
        Object object;
        MessageView messageView = browser.getMessageView();
        Message message = messageView.addMessage((MessageCategory)CATEGORY_SEARCH, Strings.format(com.borland.primetime.editor.a.a(237), searchOptions.getSearchText()), BrowserIcons.ICON_SEARCHRESULTS);
        ActionGroup actionGroup = new ActionGroup();
        RemoveMessageAction removeMessageAction = new RemoveMessageAction(messageView, message);
        actionGroup.add(removeMessageAction);
        StopSearchAction stopSearchAction = new StopSearchAction();
        actionGroup.add(stopSearchAction);
        message.setContextAction(actionGroup);
        if (c) {
            object = new ActionGroup();
            ((ActionGroup)object).add(stopSearchAction);
            messageView.addContextAction(CATEGORY_SEARCH, (Action)object);
            c = false;
        }
        object = new BackgroundSearchThread(browser, project, urlArray, searchOptions, message);
        Thread thread = new Thread((Runnable)object);
        thread.setPriority(1);
        thread.start();
    }

    public static void findMatches(EditorPane editorPane, InputStream inputStream, SearchOptions searchOptions, SearchResultsListener searchResultsListener) {
        String string = searchOptions.getSearchText();
        boolean bl = searchOptions.isCaseSensitive();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[4096];
        try {
            int n2;
            while ((n2 = inputStreamReader.read(cArray, 0, cArray.length)) != -1) {
                stringBuffer = stringBuffer.append(cArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            System.err.println("Exception in findMatches: ".concat(String.valueOf(String.valueOf(iOException.getMessage()))));
            return;
        }
        char[] cArray2 = new char[stringBuffer.length()];
        stringBuffer.getChars(0, stringBuffer.length(), cArray2, 0);
        RegularExpression regularExpression = new RegularExpression(searchOptions.getEscapedSearchText(), bl);
        regularExpression.setPatternMatch(searchOptions.isRegExp());
        RegularExpression.MatchResult matchResult = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        int n6 = 1;
        boolean bl2 = false;
        while ((matchResult = regularExpression.findSubstringMatch(cArray2, n3, cArray2.length)) != RegularExpression.NO_MATCH) {
            int n7;
            n4 = matchResult.getStartIndex();
            block9: for (n7 = n3; n7 < n4; ++n7) {
                switch (cArray2[n7]) {
                    case '\n': {
                        if (bl2) break;
                        ++n5;
                        n6 = 1;
                        break;
                    }
                    case '\r': {
                        bl2 = true;
                        ++n5;
                        n6 = 1;
                        continue block9;
                    }
                    case '\f': {
                        ++n5;
                        n6 = 1;
                        break;
                    }
                    default: {
                        ++n6;
                    }
                }
                bl2 = false;
            }
            searchResultsListener.matchFound(editorPane, n5, n6, matchResult.getLength(), string, SearchManager.a(cArray2, n4, true));
            n3 = n4 + matchResult.getLength();
            for (n7 = n4; n7 < n3; ++n7) {
                if (cArray2[n7] == '\n') {
                    ++n5;
                    n6 = 1;
                    continue;
                }
                ++n6;
            }
        }
    }

    public static void findMatches(EditorPane editorPane, InputStream inputStream, SearchOptions searchOptions) {
        boolean bl = searchOptions.isCaseSensitive();
        SearchListener searchListener = new SearchListener(editorPane, searchOptions.getSearchText());
        SearchManager.findMatches(editorPane, inputStream, searchOptions, searchListener);
    }

    public static void repeatReplace(EditorPane editorPane) {
        if (a == null) {
            a = SearchManager.getSavedOptions();
        }
        SearchManager.a(editorPane, a, true, true);
    }

    public static void repeatSearch(EditorPane editorPane) {
        int n2;
        Document document = editorPane.getDocument();
        if (a == null) {
            a = SearchManager.getSavedOptions();
        }
        String string = a.getSearchText();
        int n3 = a.isForwardSearch() ? editorPane.getCaretPosition() : 0;
        RegularExpression.MatchResult matchResult = SearchManager.search(document, a, n3, n2 = a.isForwardSearch() ? document.getLength() : editorPane.getCaretPosition());
        if (matchResult != RegularExpression.NO_MATCH) {
            editorPane.startUndoGroup();
            if (a.isForwardSearch()) {
                editorPane.gotoOffset(matchResult.getStartIndex(), false, 6);
                editorPane.moveCaretPosition(matchResult.getStartIndex() + matchResult.getLength());
            } else {
                editorPane.gotoOffset(matchResult.getStartIndex() + matchResult.getLength(), false, 6);
                editorPane.moveCaretPosition(matchResult.getStartIndex());
            }
            editorPane.endUndoGroup();
        } else {
            SearchManager.showNoMatchDialog(editorPane.getParent(), string, false);
        }
    }

    public static void incrementalSearch(EditorPane editorPane, boolean bl) {
        if (editorPane.isPopupEnabled()) {
            if (a == null) {
                a = SearchManager.getSavedOptions();
            }
            a.setForwardSearch(bl);
            new IncrementalSearchHandler(editorPane);
        }
    }

    public static void replaceAllText(EditorPane editorPane, SearchOptions searchOptions) {
        SearchManager.a(editorPane, searchOptions, true, false);
    }

    public static void replaceText(EditorPane editorPane, SearchOptions searchOptions) {
        SearchManager.a(editorPane, searchOptions, false, false);
    }

    private static void a(EditorPane editorPane, SearchOptions searchOptions, boolean bl, boolean bl2) {
        int n2;
        int n3;
        char[] cArray;
        Document document = editorPane.getDocument();
        String string = searchOptions.getSearchText();
        String string2 = searchOptions.getReplaceText();
        int n4 = 0;
        boolean bl3 = false;
        try {
            cArray = document.getText(0, document.getLength()).toCharArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        if (bl2) {
            n3 = searchOptions.isForwardSearch() ? editorPane.getCaretPosition() : 0;
            n2 = searchOptions.isForwardSearch() ? document.getLength() : editorPane.getCaretPosition();
        } else if (searchOptions.isGlobalSearch()) {
            if (searchOptions.isFromCursor()) {
                if (searchOptions.isForwardSearch()) {
                    n3 = Math.min(editorPane.getSelectionStart(), editorPane.getSelectionEnd());
                    n2 = document.getLength();
                    if (n3 != 0) {
                        bl3 = true;
                    }
                } else {
                    n3 = 0;
                    n2 = Math.max(editorPane.getSelectionStart(), editorPane.getSelectionEnd());
                    if (n2 != document.getLength()) {
                        bl3 = true;
                    }
                }
            } else {
                n3 = 0;
                n2 = document.getLength();
            }
        } else {
            n3 = editorPane.getSelectionStart();
            n2 = editorPane.getSelectionEnd();
        }
        boolean bl4 = true;
        boolean bl5 = searchOptions.isPromptReplace();
        editorPane.startUndoGroup();
        do {
            int n5;
            RegularExpression.MatchResult matchResult;
            if ((matchResult = SearchManager.search(cArray, searchOptions, n3, n2)) != RegularExpression.NO_MATCH) {
                if (bl5) {
                    ConfirmReplaceDialog.showConfirmReplaceDialog(editorPane, bl, matchResult, cArray, searchOptions, n3, n2);
                    break;
                }
                n5 = matchResult.getStartIndex() + n4;
                if (searchOptions.isForwardSearch()) {
                    editorPane.setCaretPosition(n5);
                    editorPane.moveCaretPosition(n5 + matchResult.getLength());
                } else {
                    editorPane.setCaretPosition(n5 + matchResult.getLength());
                    editorPane.moveCaretPosition(n5);
                }
                editorPane.replaceSelection(string2);
                if (searchOptions.isForwardSearch()) {
                    editorPane.gotoOffset(n5 + string2.length(), false, 6);
                    n3 = matchResult.getStartIndex() + matchResult.getLength();
                } else {
                    editorPane.gotoOffset(n5, false, 6);
                    n2 = n5;
                }
                n4 = n4 - matchResult.getLength() + string2.length();
                bl4 = false;
                continue;
            }
            n5 = 0;
            if (bl4) {
                n5 = SearchManager.showNoMatchDialog(editorPane.getParent(), string, bl3);
            }
            if (n5 != 1) break;
            n3 = 0;
            n2 = document.getLength();
            bl4 = true;
            bl3 = false;
        } while (bl);
        editorPane.endUndoGroup();
        cArray = null;
    }

    public static void findText(EditorPane editorPane, SearchOptions searchOptions) {
        int n2;
        int n3;
        Document document = editorPane.getDocument();
        String string = searchOptions.getSearchText();
        boolean bl = false;
        if (searchOptions.isGlobalSearch()) {
            if (searchOptions.isFromCursor()) {
                if (searchOptions.isForwardSearch()) {
                    n3 = Math.min(editorPane.getSelectionStart(), editorPane.getSelectionEnd());
                    if (n3 != 0) {
                        bl = true;
                    }
                    n2 = document.getLength();
                } else {
                    n3 = 0;
                    n2 = Math.max(editorPane.getSelectionStart(), editorPane.getSelectionEnd());
                    if (n2 != document.getLength()) {
                        bl = true;
                    }
                }
            } else {
                n3 = 0;
                n2 = document.getLength();
            }
        } else {
            n3 = editorPane.getSelectionStart();
            n2 = editorPane.getSelectionEnd();
        }
        while (true) {
            int n4 = 0;
            RegularExpression.MatchResult matchResult = SearchManager.search(document, searchOptions, n3, n2);
            if (matchResult != RegularExpression.NO_MATCH) {
                editorPane.startUndoGroup();
                if (searchOptions.isForwardSearch()) {
                    editorPane.gotoOffset(matchResult.getStartIndex(), false, 6);
                    editorPane.moveCaretPosition(matchResult.getStartIndex() + matchResult.getLength());
                } else {
                    editorPane.gotoOffset(matchResult.getStartIndex() + matchResult.getLength(), false, 6);
                    editorPane.moveCaretPosition(matchResult.getStartIndex());
                }
                editorPane.endUndoGroup();
            } else {
                n4 = SearchManager.showNoMatchDialog(editorPane.getParent(), string, bl);
            }
            if (n4 != 1) break;
            bl = false;
            n3 = 0;
            n2 = document.getLength();
        }
    }

    public static RegularExpression.MatchResult search(char[] cArray, SearchOptions searchOptions, int n2, int n3) {
        boolean bl = searchOptions.isCaseSensitive();
        boolean bl2 = searchOptions.isForwardSearch();
        boolean bl3 = searchOptions.isGlobalSearch();
        try {
            RegularExpression regularExpression = new RegularExpression(searchOptions.getEscapedSearchText(), bl);
            regularExpression.setPatternMatch(searchOptions.isRegExp());
            RegularExpression.MatchResult matchResult = RegularExpression.NO_MATCH;
            while (true) {
                RegularExpression.MatchResult matchResult2;
                if ((matchResult2 = regularExpression.findSubstringMatch(cArray, n2, n3)) != RegularExpression.NO_MATCH && searchOptions.wholeWordsOnly) {
                    int n4 = matchResult2.getStartIndex() - 1;
                    if (n4 > 0 && !TextUtilities.isSkipCharacter(cArray[n4], true)) {
                        n2 = matchResult2.getStartIndex() + matchResult2.getLength();
                        continue;
                    }
                    n4 = matchResult2.getStartIndex() + matchResult2.getLength();
                    if (n4 < cArray.length && !TextUtilities.isSkipCharacter(cArray[n4], true)) {
                        n2 = matchResult2.getStartIndex() + matchResult2.getLength();
                        continue;
                    }
                }
                if (bl2) {
                    RegularExpression.MatchResult matchResult3 = matchResult2;
                    return matchResult3;
                }
                if (matchResult2 == RegularExpression.NO_MATCH) break;
                matchResult = matchResult2;
                n2 = matchResult2.getStartIndex() + matchResult2.getLength();
            }
            RegularExpression.MatchResult matchResult4 = matchResult;
            return matchResult4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return RegularExpression.NO_MATCH;
        }
    }

    public static RegularExpression.MatchResult search(Document document, SearchOptions searchOptions, int n2, int n3) {
        try {
            char[] cArray = document.getText(0, document.getLength()).toCharArray();
            RegularExpression.MatchResult matchResult = SearchManager.search(cArray, searchOptions, n2, n3);
            return matchResult;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return RegularExpression.NO_MATCH;
        }
    }

    private static void a(ProjectAutoArrayProperty projectAutoArrayProperty, String string) {
        Project project = Browser.getActiveBrowser().getActiveProject();
        List<String> list = Arrays.asList(projectAutoArrayProperty.getValues(project));
        ArrayList arrayList = SearchManager.a(list, string);
        projectAutoArrayProperty.setValues(project, arrayList.toArray(new String[arrayList.size()]));
    }

    private static void a(GlobalArrayProperty globalArrayProperty, String string) {
        List<String> list = Arrays.asList(globalArrayProperty.getValues());
        ArrayList arrayList = SearchManager.a(list, string);
        globalArrayProperty.setValues(arrayList.toArray(new String[arrayList.size()]));
    }

    private static ArrayList a(List list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        int n2 = arrayList.indexOf(string);
        if (n2 != -1) {
            arrayList.remove(n2);
            arrayList.add(0, string);
        } else {
            arrayList.add(0, string);
            if (arrayList.size() > 32) {
                arrayList.remove(32);
            }
        }
        return arrayList;
    }

    public static ComboBoxModel getFileFilterHistory() {
        Project project = Browser.getActiveBrowser().getActiveProject();
        return new DefaultComboBoxModel<String>(n.getValues(project));
    }

    public static ComboBoxModel getPathHistory() {
        Project project = Browser.getActiveBrowser().getActiveProject();
        return new DefaultComboBoxModel<String>(l.getValues(project));
    }

    public static ComboBoxModel getReplaceHistory() {
        return new DefaultComboBoxModel<String>(k.getValues());
    }

    public static ComboBoxModel getSearchHistory() {
        return new DefaultComboBoxModel<String>(h.getValues());
    }

    public static void addFileFilterText(String string) {
        SearchManager.a(n, string);
    }

    public static void addPathText(String string) {
        SearchManager.a(l, string);
    }

    public static void addReplaceText(String string) {
        SearchManager.a(k, string);
    }

    public static void addSearchText(String string) {
        SearchManager.a(h, string);
    }

    public static SearchOptions getSavedOptions() {
        if (a == null) {
            a = new SearchOptions();
            SearchManager.a.caseSensitive = j.getBoolean();
            SearchManager.a.forwardSearch = i.getBoolean();
            SearchManager.a.fromCursor = g.getBoolean();
            SearchManager.a.globalSearch = e.getBoolean();
            SearchManager.a.regExp = f.getBoolean();
            SearchManager.a.wholeWordsOnly = d.getBoolean();
        }
        return a;
    }

    public static void setOptions(SearchOptions searchOptions) {
        a = searchOptions;
    }

    public static void setSavedOptions(SearchOptions searchOptions) {
        a = searchOptions;
        j.setBoolean(SearchManager.a.caseSensitive);
        i.setBoolean(SearchManager.a.forwardSearch);
        g.setBoolean(SearchManager.a.fromCursor);
        e.setBoolean(SearchManager.a.globalSearch);
        f.setBoolean(SearchManager.a.regExp);
        d.setBoolean(SearchManager.a.wholeWordsOnly);
    }

    public static class SearchMessageCategory
    extends MessageCategory {
        private boolean b;
        private int a = 0;
        private static final String d;
        private static final String c;

        static {
            c = com.borland.primetime.editor.a.a(245);
            d = com.borland.primetime.editor.a.a(248);
        }

        public synchronized void categoryClosing() throws VetoException {
            if (this.a > 0) {
                if (JOptionPane.showConfirmDialog(null, com.borland.primetime.editor.a.a(54), com.borland.primetime.editor.a.a(55), 0) != 0) {
                    throw new VetoException();
                }
                this.cancel();
            }
        }

        public synchronized boolean isSearching() {
            return this.a > 0 && !this.b;
        }

        public boolean isCancelling() {
            return this.b;
        }

        public synchronized void cancel() {
            if (this.a > 0) {
                this.b = true;
            }
        }

        public synchronized void searchStopped() {
            --this.a;
            if (this.a == 0) {
                this.setTitle(c);
                AudioClipPlayer.playClipNamed("find_in_path");
                this.b = false;
            }
        }

        public synchronized void searchStarted() {
            if (this.a == 0) {
                this.setTitle(d);
            }
            ++this.a;
        }

        public SearchMessageCategory() {
            super(c);
        }
    }

    public static class StopSearchAction
    extends UpdateAction {
        public void update(Object object) {
            this.setEnabled(CATEGORY_SEARCH.isSearching());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CATEGORY_SEARCH.cancel();
        }

        public StopSearchAction() {
            super(com.borland.primetime.editor.a.a(283), com.borland.primetime.editor.a.a(285).charAt(0), com.borland.primetime.editor.a.a(284));
        }
    }

    public static class RemoveMessageAction
    extends UpdateAction {
        MessageView a;
        Message b;

        public void actionPerformed(ActionEvent actionEvent) {
            this.a.removeMessage(CATEGORY_SEARCH, this.b);
        }

        public void update(Object object) {
            this.setShortText(Strings.format(com.borland.primetime.editor.a.a(207), this.b.getText()));
            this.setEnabled(true);
        }

        public RemoveMessageAction(MessageView messageView, Message message) {
            super(com.borland.primetime.editor.a.a(204), com.borland.primetime.editor.a.a(206).charAt(0), com.borland.primetime.editor.a.a(205));
            this.a = messageView;
            this.b = message;
        }
    }

    public static class SearchPathResultMessage
    extends Message
    implements SearchResultsListener {
        SearchOptions c;
        Url b;
        MessageView d;
        Project a;

        public void matchFound(EditorPane editorPane, int n2, int n3, int n4, String string, String string2) {
            try {
                int n5 = editorPane.calcCaretPosition(n2, n3);
                Position position = editorPane.getDocument().createPosition(n5);
                if (!CATEGORY_SEARCH.isCancelling()) {
                    this.d.addMessage((MessageCategory)CATEGORY_SEARCH, (Message)this, new FindAllMessage(editorPane, position, n2, n3, n4, string, string2));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void fetchChildren(Browser browser) {
            this.a(browser);
        }

        public void messageAction(Browser browser) {
            FileNode fileNode = this.a.getNode(this.b);
            try {
                browser.setActiveNode(fileNode, false);
                TextNodeViewer textNodeViewer = (TextNodeViewer)browser.getViewerOfType(fileNode, b == null ? (b = SearchManager.a("com.borland.primetime.viewer.TextNodeViewer")) : b);
                browser.setActiveViewer(fileNode, textNodeViewer, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void a(Browser browser) {
            try {
                FileNode fileNode = this.a.getNode(this.b);
                browser.setActiveNode(fileNode, false);
                TextNodeViewer textNodeViewer = (TextNodeViewer)browser.getViewerOfType(fileNode, b == null ? (b = SearchManager.a("com.borland.primetime.viewer.TextNodeViewer")) : b);
                browser.setActiveViewer(fileNode, textNodeViewer, false);
                EditorPane editorPane = textNodeViewer.getEditor();
                InputStream inputStream = VFS.getInputStream(this.b);
                SearchManager.findMatches(editorPane, inputStream, this.c, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public SearchPathResultMessage(Project project, MessageView messageView, Url url, SearchOptions searchOptions) {
            super(url.getName(), BrowserIcons.ICON_SEARCHRESULTS, url.getFile());
            this.a = project;
            this.d = messageView;
            this.b = url;
            this.c = new SearchOptions(searchOptions);
            ActionGroup actionGroup = new ActionGroup();
            actionGroup.add(new RemoveMessageAction(messageView, this));
            actionGroup.add(new StopSearchAction());
            this.setContextAction(actionGroup);
            this.setLazyFetchChildren(true);
        }
    }

    public static class FindAllMessage
    extends Message {
        String d;
        String a;
        int f;
        int g;
        int e;
        Position b;
        Node c;

        public void messageAction(Browser browser) {
            this.a(browser, true);
        }

        public void selectAction(Browser browser) {
            this.a(browser, false);
        }

        private void a(Browser browser, boolean bl) {
            try {
                browser.setActiveNode(this.c, bl);
                TextNodeViewer textNodeViewer = (TextNodeViewer)browser.getViewerOfType(this.c, b == null ? (b = SearchManager.a("com.borland.primetime.viewer.TextNodeViewer")) : b);
                browser.setActiveViewer(this.c, textNodeViewer, bl);
                EditorPane editorPane = textNodeViewer.getEditor();
                Component component = Browser.getActiveBrowser().getFocusOwner();
                editorPane.requestFocus();
                editorPane.gotoOffset(this.b.getOffset());
                editorPane.moveCaretPosition(this.b.getOffset() + this.f);
                if (!bl && component != null) {
                    component.requestFocus();
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }

        public FindAllMessage(EditorPane editorPane, Position position, int n2, int n3, int n4, String string, String string2) {
            super(string2, GutterIcons.ICON_EXECLINE);
            this.c = NodeViewMap.getNode(editorPane);
            this.b = position;
            this.e = n2;
            this.g = n3;
            this.f = n4;
            this.a = string;
            this.d = string2;
        }
    }

    public static class SearchListener
    implements SearchResultsListener {
        Message a;
        MessageView b;
        EditorPane c;

        public void matchFound(EditorPane editorPane, int n2, int n3, int n4, String string, String string2) {
            try {
                int n5 = editorPane.calcCaretPosition(n2, n3);
                Position position = editorPane.getDocument().createPosition(n5);
                if (!CATEGORY_SEARCH.isCancelling()) {
                    this.b.addMessage((MessageCategory)CATEGORY_SEARCH, this.a, new FindAllMessage(editorPane, position, n2, n3, n4, string, string2));
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public SearchListener(EditorPane editorPane, String string) {
            this.c = editorPane;
            FileNode fileNode = NodeViewMap.getNode(editorPane);
            Browser browser = NodeViewMap.getBrowser(editorPane);
            this.b = browser.getMessageView();
            this.a = this.b.addMessage((MessageCategory)CATEGORY_SEARCH, Strings.format(com.borland.primetime.editor.a.a(244), string, ((Node)fileNode).getDisplayName()), BrowserIcons.ICON_SEARCHRESULTS);
        }
    }

    public static class BackgroundSearchThread
    implements Runnable {
        Message c;
        SearchOptions d;
        Url[] b;
        Project a;
        Browser e;

        public void run() {
            CATEGORY_SEARCH.searchStarted();
            try {
                SearchManager.a(this.e, this.a, this.b, this.d, this.c);
                Object var2_1 = null;
                CATEGORY_SEARCH.searchStopped();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                CATEGORY_SEARCH.searchStopped();
                throw throwable;
            }
        }

        BackgroundSearchThread(Browser browser, Project project, Url[] urlArray, SearchOptions searchOptions, Message message) {
            this.e = browser;
            this.a = project;
            this.b = urlArray;
            this.d = searchOptions;
            this.c = message;
        }
    }
}

