/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor.emacs;

import com.borland.primetime.editor.EditorAction;
import com.borland.primetime.editor.EditorActions;
import com.borland.primetime.editor.EditorManager;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.TextUtilities;
import com.borland.primetime.editor.emacs.EmacsAction;
import com.borland.primetime.editor.emacs.EmacsActionNames;
import com.borland.primetime.editor.emacs.KillRing;
import com.borland.primetime.editor.emacs.a;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import javax.swing.text.Utilities;

public class EmacsActions
extends EditorActions
implements EmacsActionNames {
    public static final Action[] customActions;
    public static EditorAction ACTION_IndentRegion;
    public static EditorAction ACTION_DowncaseRegion;
    public static EditorAction ACTION_UpcaseRegion;
    public static EditorAction ACTION_CapitalizeWord;
    public static EditorAction ACTION_UpcaseWord;
    public static EditorAction ACTION_DowncaseWord;
    public static EditorAction ACTION_DeleteBlankLines;
    public static EditorAction ACTION_DeleteHorizontalSpace;
    public static EditorAction ACTION_ClipboardYank;
    public static EditorAction ACTION_ClipboardKillRingSave;
    public static EditorAction ACTION_ClipboardKillRegion;
    public static EditorAction ACTION_YankPop;
    public static EditorAction ACTION_Yank;
    public static EditorAction ACTION_KillRingSave;
    public static EditorAction ACTION_KillRegion;
    public static EditorAction ACTION_KillLine;
    public static EditorAction ACTION_BackwardKillWord;
    public static EditorAction ACTION_KillWord;
    public static EditorAction ACTION_BackToIndentation;
    public static EditorAction ACTION_EndBuffer;
    public static EditorAction ACTION_BeginBuffer;
    public static EditorAction ACTION_MarkWholeBuffer;
    public static EditorAction ACTION_MarkPage;
    public static EditorAction ACTION_ExchangePointAndMark;
    public static EditorAction ACTION_SetMark;
    public static EditorAction ACTION_KeyboardQuit;
    public static EditorAction ACTION_SetEscKey;
    public static EditorAction ACTION_SetControlX;
    public static EditorAction ACTION_DefaultEsc;

    static {
        ACTION_DefaultEsc = new DefaultEscAction("emacs-default-escape");
        ACTION_SetControlX = new SetControlXAction("emacs-set-control-x");
        ACTION_SetEscKey = new SetEscKeyAction("emacs-set-escape");
        ACTION_KeyboardQuit = new KeyboardQuitAction("emacs-keyboard-clear");
        ACTION_SetMark = new SetMarkAction("emacs-set-mark");
        ACTION_ExchangePointAndMark = new ExchangePointAndMarkAction("emacs-exchange-point-mark");
        ACTION_MarkPage = new MarkPageAction("emacs-mark-page");
        ACTION_MarkWholeBuffer = new MarkPageAction("emacs-mark-buffer");
        ACTION_BeginBuffer = new BeginBufferAction("emacs-begin-buffer", false);
        ACTION_EndBuffer = new EndBufferAction("emacs-end-buffer", false);
        ACTION_BackToIndentation = new BackToIndentationAction("emacs-back-to-indentation");
        ACTION_KillWord = new KillWordAction("emacs-kill-word");
        ACTION_BackwardKillWord = new BackwardKillWordAction("emacs-backward-kill-word");
        ACTION_KillLine = new KillLineAction("emacs-kill-line");
        ACTION_KillRegion = new KillRegionAction("emacs-kill-region", true, true);
        ACTION_KillRingSave = new KillRegionAction("emacs-kill-ring-save", false, true);
        ACTION_Yank = new YankAction("emacs-yank", false);
        ACTION_YankPop = new YankPopAction("emacs-yank-pop");
        ACTION_ClipboardKillRegion = new KillRegionAction("emacs-clipboard-kill-region", true, true);
        ACTION_ClipboardKillRingSave = new KillRegionAction("emacs-clipboard-kill-ring-save", false, true);
        ACTION_ClipboardYank = new YankAction("emacs-clipboard-yank", true);
        ACTION_DeleteHorizontalSpace = new DeleteHorizontalSpaceAction("emacs-delete-horizontal-space");
        ACTION_DeleteBlankLines = new DeleteBlankLinesAction("emacs-delete-blank-lines");
        ACTION_DowncaseWord = new ChangeCaseWordAction("emacs-downcase-word", true);
        ACTION_UpcaseWord = new ChangeCaseWordAction("emacs-upcase-word", false);
        ACTION_CapitalizeWord = new CapitalizeWordAction("emacs-capitalize-word");
        ACTION_UpcaseRegion = new ChangeCaseRegionAction("emacs-upcase-region", false);
        ACTION_DowncaseRegion = new ChangeCaseRegionAction("emacs-downcase-region", true);
        ACTION_IndentRegion = new IndentRegionAction("emacs-indent-region");
        customActions = new Action[]{ACTION_DefaultEsc, ACTION_SetControlX, ACTION_SetEscKey, ACTION_KeyboardQuit, ACTION_SetMark, ACTION_ExchangePointAndMark, ACTION_MarkPage, ACTION_MarkWholeBuffer, ACTION_BeginBuffer, ACTION_EndBuffer, ACTION_BackToIndentation, ACTION_KillWord, ACTION_BackwardKillWord, ACTION_KillLine, ACTION_KillRegion, ACTION_KillRingSave, ACTION_Yank, ACTION_YankPop, ACTION_ClipboardKillRegion, ACTION_ClipboardKillRingSave, ACTION_ClipboardYank, ACTION_DeleteHorizontalSpace, ACTION_DeleteBlankLines, ACTION_DowncaseWord, ACTION_UpcaseWord, ACTION_CapitalizeWord, ACTION_UpcaseRegion, ACTION_DowncaseRegion, ACTION_IndentRegion};
    }

    public static Action[] getActions() {
        return TextAction.augmentList(EditorActions.getActions(), customActions);
    }

    public static class IndentRegionAction
    extends EmacsAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                if (!editorPane.isEditable() || !editorPane.isEnabled()) {
                    return;
                }
                if (editorPane.getSelectionStart() != editorPane.getSelectionEnd()) {
                    EditorActions.ACTION_IndentBlock.actionPerformed(actionEvent);
                    return;
                }
                editorPane.startUndoGroup();
                try {
                    String string;
                    Object object;
                    if (!EditorManager.isBooleanOptionValue("useTabChar")) {
                        object = new char[EditorManager.getBlockIndent()];
                        for (int i2 = 0; i2 < ((char[])object).length; ++i2) {
                            object[i2] = 32;
                        }
                        string = new String((char[])object);
                    } else {
                        string = new String("");
                    }
                    object = editorPane.getDocument();
                    Element element = object.getDefaultRootElement();
                    int n2 = editorPane.getCaretPosition();
                    int n3 = this.getStateInfo(editorPane).getEmacsMark();
                    if (n2 == n3) {
                        return;
                    }
                    int n4 = n2 < n3 ? n2 : n3;
                    int n5 = n2 > n3 ? n2 : n3;
                    int n6 = element.getElementIndex(n4);
                    int n7 = element.getElementIndex(n5);
                    Element element2 = element.getElement(n7);
                    int n8 = element2.getStartOffset();
                    if (n5 == n8) {
                        --n7;
                    }
                    Segment segment = new Segment();
                    int n9 = EditorManager.getBlockIndent();
                    int n10 = EditorManager.getTabSize();
                    for (int i3 = n7; i3 >= n6; --i3) {
                        element2 = element.getElement(i3);
                        n8 = element2.getStartOffset();
                        if (EditorManager.isBooleanOptionValue("useTabChar")) {
                            int n11;
                            int n12;
                            int n13 = element2.getEndOffset();
                            int n14 = n13 - n8;
                            object.getText(n8, n14, segment);
                            int n15 = 0;
                            int n16 = -1;
                            for (n12 = segment.offset; n12 < segment.offset + segment.count; ++n12) {
                                if (i3 == n6 && n16 < 0 && n12 - segment.offset >= n4 - n8) {
                                    n16 = n15;
                                }
                                if ((n11 = segment.array[n12]) == 9) {
                                    n15 += n10 - n15 % n10;
                                    continue;
                                }
                                if (n11 != 32) break;
                                ++n15;
                            }
                            n11 = (n15 += n9) / n10 + n15 % n10;
                            char[] cArray = new char[n11];
                            for (int i4 = 0; i4 < n11; ++i4) {
                                cArray[i4] = i4 < n15 / n10 ? 9 : 32;
                            }
                            if ((n12 -= segment.offset) > 0) {
                                object.remove(n8, n12);
                            }
                            object.insertString(n8, new String(cArray), null);
                            continue;
                        }
                        object.insertString(n8, string, null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
                editorPane.endUndoGroup();
            }
        }

        public IndentRegionAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(9));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class YankPopAction
    extends EmacsAction
    implements EmacsYankAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    if (!KillRing.activeYank) {
                        return;
                    }
                    Document document = editorPane.getDocument();
                    int n2 = editorPane.getCaretPosition();
                    int n3 = this.getStateInfo(editorPane).getEmacsMark();
                    String string = KillRing.getPrevious();
                    editorPane.startUndoGroup();
                    document.remove(n3, n2 - n3);
                    document.insertString(n3, string, null);
                    editorPane.setCaretPosition(n3 + string.length());
                    this.getStateInfo(editorPane).setEmacsMark(n3);
                    editorPane.endUndoGroup();
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public YankPopAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(30));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class YankAction
    extends EmacsAction
    implements EmacsYankAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable()) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    if (this.a) {
                        editorPane.paste();
                    } else {
                        Document document = editorPane.getDocument();
                        String string = KillRing.get();
                        if (string == null) {
                            return;
                        }
                        editorPane.startUndoGroup();
                        document.insertString(n2, string, null);
                        editorPane.setCaretPosition(n2 + string.length());
                        editorPane.endUndoGroup();
                    }
                    this.getStateInfo(editorPane).setEmacsMark(n2);
                    KillRing.activeYank = true;
                    KillRing.activeKillPosition = -1;
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public YankAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.emacs.a.a(28));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.emacs.a.a(29));
            }
            this.putValue("ActionGroup", com.borland.primetime.editor.emacs.a.a(25));
        }
    }

    public static class KillRegionAction
    extends EmacsAction
    implements EmacsKillAction {
        private boolean b;
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    int n3 = this.getStateInfo(editorPane).getEmacsMark();
                    if (n2 != n3) {
                        Document document = editorPane.getDocument();
                        int n4 = n3 < n2 ? n3 : n2;
                        int n5 = n3 < n2 ? n2 : n3;
                        String string = document.getText(n4, n5 - n4);
                        if (this.b) {
                            editorPane.setCaretPosition(n4);
                            editorPane.moveCaretPosition(n5);
                            editorPane.copy();
                        }
                        if (this.a) {
                            if (editorPane.isEditable()) {
                                KillRing.add(string);
                                KillRing.activeKillPosition = n4;
                                editorPane.startUndoGroup();
                                document.remove(n4, n5 - n4);
                                editorPane.setCaretPosition(n4);
                                editorPane.endUndoGroup();
                            }
                        } else {
                            KillRing.add(string);
                            KillRing.activeKillPosition = -1;
                            editorPane.setCaretPosition(n2);
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public KillRegionAction(String string, boolean bl, boolean bl2) {
            super(string);
            this.a = bl;
            this.b = bl2;
            if (bl2 && bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.emacs.a.a(13));
            } else if (bl2 && !bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.emacs.a.a(15));
            } else if (!bl2 && bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.emacs.a.a(14));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.emacs.a.a(12));
            }
            this.putValue("ActionGroup", com.borland.primetime.editor.emacs.a.a(25));
        }
    }

    public static class ChangeCaseRegionAction
    extends EmacsAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable()) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    int n3 = this.getStateInfo(editorPane).getEmacsMark();
                    if (n2 != n3) {
                        Document document = editorPane.getDocument();
                        int n4 = n3 < n2 ? n3 : n2;
                        int n5 = n3 < n2 ? n2 : n3;
                        String string = document.getText(n4, n5 - n4);
                        string = this.a ? string.toLowerCase() : string.toUpperCase();
                        editorPane.startUndoGroup();
                        document.remove(n4, n5 - n4);
                        document.insertString(n4, string, null);
                        if (n3 < n2) {
                            this.getStateInfo(editorPane).setEmacsMark(n3);
                        } else {
                            editorPane.setCaretPosition(n2);
                        }
                        editorPane.endUndoGroup();
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public ChangeCaseRegionAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.emacs.a.a(17));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.emacs.a.a(26));
            }
            this.putValue("ActionGroup", com.borland.primetime.editor.emacs.a.a(25));
        }
    }

    public static class CapitalizeWordAction
    extends EmacsAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable()) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    int n3 = TextUtilities.getWordEnd(editorPane, n2);
                    if (n2 < n3) {
                        Document document = editorPane.getDocument();
                        String string = document.getText(n2, n3 - n2);
                        string = string.toLowerCase();
                        char[] cArray = string.toCharArray();
                        cArray[0] = Character.toUpperCase(cArray[0]);
                        string = new String(cArray);
                        editorPane.startUndoGroup();
                        document.remove(n2, n3 - n2);
                        document.insertString(n2, string, null);
                        editorPane.setCaretPosition(n3);
                        editorPane.endUndoGroup();
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public CapitalizeWordAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(3));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class ChangeCaseWordAction
    extends EmacsAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable()) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    int n3 = TextUtilities.getWordEnd(editorPane, n2);
                    if (n2 < n3) {
                        Document document = editorPane.getDocument();
                        String string = document.getText(n2, n3 - n2);
                        string = this.a ? string.toLowerCase() : string.toUpperCase();
                        editorPane.startUndoGroup();
                        document.remove(n2, n3 - n2);
                        document.insertString(n2, string, null);
                        editorPane.setCaretPosition(n3);
                        editorPane.endUndoGroup();
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public ChangeCaseWordAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.emacs.a.a(18));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.emacs.a.a(27));
            }
            this.putValue("ActionGroup", com.borland.primetime.editor.emacs.a.a(25));
        }
    }

    public static class DeleteBlankLinesAction
    extends EmacsAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable()) {
                try {
                    Document document = editorPane.getDocument();
                    Element element = document.getDefaultRootElement();
                    int n2 = editorPane.getCaretPosition();
                    int n3 = element.getElementIndex(n2);
                    int n4 = element.getElementCount();
                    Element element2 = element.getElement(n3);
                    if (TextUtilities.isBlankLine(editorPane, element2)) {
                        boolean bl;
                        int n5 = n3 - 1;
                        int n6 = n3 + 1;
                        Element element3 = n5 >= 0 ? element.getElement(n5--) : null;
                        Element element4 = n6 < n4 ? element.getElement(n6++) : null;
                        boolean bl2 = element3 != null && TextUtilities.isBlankLine(editorPane, element3);
                        boolean bl3 = bl = element4 != null && TextUtilities.isBlankLine(editorPane, element4);
                        if (bl2 || bl) {
                            int n7;
                            int n8;
                            Position position = editorPane.getDocument().createPosition(element2.getStartOffset());
                            editorPane.startUndoGroup();
                            if (bl) {
                                n8 = element4.getStartOffset();
                                n7 = Math.min(element4.getEndOffset(), document.getLength());
                                while (n6 < n4 && TextUtilities.isBlankLine(editorPane, element4 = element.getElement(n6++))) {
                                    n7 = Math.min(element4.getEndOffset(), document.getLength());
                                }
                                document.remove(n8, n7 - n8);
                            }
                            if (bl2) {
                                n8 = element3.getStartOffset();
                                n7 = element3.getEndOffset();
                                while (n5 >= 0 && TextUtilities.isBlankLine(editorPane, element3 = element.getElement(n5--))) {
                                    n8 = element3.getStartOffset();
                                }
                                document.remove(n8, n7 - n8);
                            }
                            editorPane.setCaretPosition(position.getOffset());
                            editorPane.endUndoGroup();
                        } else {
                            int n9 = element2.getStartOffset();
                            int n10 = Math.min(element2.getEndOffset(), document.getLength());
                            editorPane.startUndoGroup();
                            document.remove(n9, n10 - n9);
                            editorPane.endUndoGroup();
                        }
                    } else {
                        Element element5;
                        int n11 = n3 + 1;
                        if (n11 < n4 && TextUtilities.isBlankLine(editorPane, element5 = element.getElement(n11++))) {
                            int n12 = element5.getStartOffset();
                            int n13 = Math.min(element5.getEndOffset(), document.getLength());
                            while (n11 < n4 && TextUtilities.isBlankLine(editorPane, element5 = element.getElement(n11++))) {
                                n13 = Math.min(element5.getEndOffset(), document.getLength());
                            }
                            editorPane.startUndoGroup();
                            document.remove(n12, n13 - n12);
                            editorPane.setCaretPosition(n2);
                            editorPane.endUndoGroup();
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public DeleteBlankLinesAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(5));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class DeleteHorizontalSpaceAction
    extends EmacsAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable()) {
                try {
                    int n2;
                    int n3;
                    int n4 = n3 = editorPane.getCaretPosition();
                    int n5 = n3;
                    Element element = TextUtilities.getLineElement(editorPane, n3);
                    int n6 = element.getStartOffset();
                    int n7 = Math.min(element.getEndOffset(), editorPane.getDocument().getLength());
                    String string = editorPane.getText(n6, n7 - n6);
                    char[] cArray = string.toCharArray();
                    for (n2 = n3 - n6 - 1; n2 >= 0; --n2) {
                        if (cArray[n2] != ' ' && cArray[n2] != '\t') {
                            n4 = Math.min(n6 + n2 + 1, n3);
                            break;
                        }
                        if (n2 != 0) continue;
                        n4 = n6;
                    }
                    for (n2 = n3 - n6; n2 < cArray.length; ++n2) {
                        if (cArray[n2] == ' ' || cArray[n2] == '\t') continue;
                        n5 = n6 + n2;
                        break;
                    }
                    if (n4 != n5) {
                        editorPane.startUndoGroup();
                        editorPane.getDocument().remove(n4, n5 - n4);
                        editorPane.setCaretPosition(n4);
                        editorPane.endUndoGroup();
                    }
                    editorPane.replaceSelection(null);
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public DeleteHorizontalSpaceAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(6));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class KillLineAction
    extends EmacsAction
    implements EmacsKillAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable()) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    int n3 = Utilities.getRowEnd(editorPane, n2);
                    if (n2 == n3) {
                        n3 = Math.min(editorPane.getDocument().getLength() - 1, n3 + 1);
                    }
                    if (n2 != n3) {
                        if (KillRing.activeKillPosition == n2) {
                            KillRing.addFollowing(editorPane.getText(n2, n3 - n2));
                        } else {
                            KillRing.add(editorPane.getText(n2, n3 - n2));
                            KillRing.activeKillPosition = n2;
                        }
                        editorPane.startUndoGroup();
                        editorPane.getDocument().remove(n2, n3 - n2);
                        editorPane.setCaretPosition(n2);
                        editorPane.endUndoGroup();
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public KillLineAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(11));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class BackwardKillWordAction
    extends EmacsAction
    implements EmacsKillAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable()) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    int n3 = TextUtilities.getWordStart(editorPane, n2);
                    if (n2 != n3) {
                        if (KillRing.activeKillPosition == n2) {
                            KillRing.addPrevious(editorPane.getText(n3, n2 - n3));
                        } else {
                            KillRing.add(editorPane.getText(n3, n2 - n3));
                        }
                        KillRing.activeKillPosition = n3;
                        editorPane.startUndoGroup();
                        editorPane.getDocument().remove(n3, n2 - n3);
                        editorPane.setCaretPosition(n3);
                        editorPane.endUndoGroup();
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public BackwardKillWordAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(1));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class KillWordAction
    extends EmacsAction
    implements EmacsKillAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null && editorPane.isEditable()) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    int n3 = TextUtilities.getWordEnd(editorPane, n2);
                    if (n2 != n3) {
                        if (KillRing.activeKillPosition == n2) {
                            KillRing.addFollowing(editorPane.getText(n2, n3 - n2));
                        } else {
                            KillRing.add(editorPane.getText(n2, n3 - n2));
                            KillRing.activeKillPosition = n2;
                        }
                        editorPane.startUndoGroup();
                        editorPane.getDocument().remove(n2, n3 - n2);
                        editorPane.setCaretPosition(n2);
                        editorPane.endUndoGroup();
                    }
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public KillWordAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(16));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class BackToIndentationAction
    extends EmacsAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    Document document = editorPane.getDocument();
                    Element element = document.getDefaultRootElement();
                    int n3 = element.getElementIndex(n2);
                    Element element2 = element.getElement(n3);
                    int n4 = element2.getStartOffset();
                    int n5 = element2.getEndOffset();
                    int n6 = n5 - n4;
                    if (n6 <= 0) {
                        return;
                    }
                    int n7 = n4;
                    Segment segment = new Segment();
                    document.getText(n4, n6, segment);
                    for (int i2 = segment.offset; i2 < segment.offset + segment.count; ++i2) {
                        char c2 = segment.array[i2];
                        if (c2 == ' ' || c2 == '\t') continue;
                        n7 = n4 + i2 - segment.offset;
                        break;
                    }
                    editorPane.setCaretPosition(n7);
                }
                catch (BadLocationException badLocationException) {
                    editorPane.getToolkit().beep();
                }
            }
        }

        public BackToIndentationAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(0));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class EndBufferAction
    extends EmacsAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    this.getStateInfo(editorPane).setEmacsMark(editorPane.getCaretPosition());
                    Document document = editorPane.getDocument();
                    int n2 = document.getLength();
                    if (this.a) {
                        editorPane.moveCaretPosition(n2);
                    } else {
                        editorPane.setCaretPosition(n2);
                    }
                    EditorManager.showStatusMessage(editorPane, com.borland.primetime.editor.emacs.a.a(31), false, true);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        public EndBufferAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.emacs.a.a(21));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.emacs.a.a(7));
            }
            this.putValue("ActionGroup", com.borland.primetime.editor.emacs.a.a(25));
        }
    }

    public static class BeginBufferAction
    extends EmacsAction {
        private boolean a;

        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    this.getStateInfo(editorPane).setEmacsMark(editorPane.getCaretPosition());
                    if (this.a) {
                        editorPane.moveCaretPosition(0);
                    } else {
                        editorPane.setCaretPosition(0);
                    }
                    EditorManager.showStatusMessage(editorPane, com.borland.primetime.editor.emacs.a.a(31), false, true);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        public BeginBufferAction(String string, boolean bl) {
            super(string);
            this.a = bl;
            if (bl) {
                this.putValue("LongDescription", com.borland.primetime.editor.emacs.a.a(20));
            } else {
                this.putValue("LongDescription", com.borland.primetime.editor.emacs.a.a(2));
            }
            this.putValue("ActionGroup", com.borland.primetime.editor.emacs.a.a(25));
        }
    }

    public static class MarkPageAction
    extends EmacsAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    Document document = editorPane.getDocument();
                    int n2 = document.getLength();
                    this.getStateInfo(editorPane).setEmacsMark(n2);
                    editorPane.setCaretPosition(0);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        public MarkPageAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(19));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class ExchangePointAndMarkAction
    extends EmacsAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    int n3 = this.getStateInfo(editorPane).getEmacsMark();
                    editorPane.setCaretPosition(n3);
                    this.getStateInfo(editorPane).setEmacsMark(n2);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        public ExchangePointAndMarkAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(8));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class SetMarkAction
    extends EmacsAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                try {
                    int n2 = editorPane.getCaretPosition();
                    this.getStateInfo(editorPane).setEmacsMark(n2);
                    EditorManager.showStatusMessage(editorPane, a.a(31), false, true);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        }

        public SetMarkAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(24));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class KeyboardQuitAction
    extends EmacsAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                this.getStateInfo((EditorPane)editorPane).mode = 0;
                editorPane.getToolkit().beep();
            }
        }

        public KeyboardQuitAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(10));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class SetEscKeyAction
    extends EmacsAction
    implements EditorActions.KeymapSwitchAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                editorPane.setKeymap(EditorManager.getKeymap("Escape"));
                EditorManager.showStatusMessage(editorPane, "Escape ", false, false);
            }
        }

        public SetEscKeyAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(23));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class SetControlXAction
    extends EmacsAction
    implements EditorActions.KeymapSwitchAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                editorPane.setKeymap(EditorManager.getKeymap("Control-X"));
                EditorManager.showStatusMessage(editorPane, "Ctrl-X ", false, false);
            }
        }

        public SetControlXAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(22));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static class DefaultEscAction
    extends EmacsAction {
        public void actionPerformed(ActionEvent actionEvent) {
            EditorPane editorPane = this.getEditorTarget(actionEvent);
            if (editorPane != null) {
                editorPane.setKeymap(EditorManager.getKeymap("Emacs"));
                EditorManager.showStatusMessage(editorPane, " ", false, false);
            }
        }

        public DefaultEscAction(String string) {
            super(string);
            this.putValue("LongDescription", a.a(4));
            this.putValue("ActionGroup", a.a(25));
        }
    }

    public static interface EmacsUniversalArgAction {
    }

    public static interface EmacsYankAction {
    }

    public static interface EmacsKillAction {
    }
}

