/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.editor.emacs;

import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.editor.ModalKeymap;
import com.borland.primetime.editor.emacs.EmacsActions;
import com.borland.primetime.editor.emacs.EmacsStateInfo;
import com.borland.primetime.editor.emacs.KillRing;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.text.Keymap;

public class EmacsKeymap
extends ModalKeymap {
    public static final int EMACS_CONTROL_C = 4;
    public static final int EMACS_CONTROL_X = 2;
    public static final int EMACS_ESCAPE = 1;
    public static final int EMACS_DEFAULT = 0;

    static {
        EMACS_DEFAULT = 0;
        EMACS_ESCAPE = 1;
        EMACS_CONTROL_X = 2;
        EMACS_CONTROL_C = 4;
    }

    public void processKeyEvent(EditorPane editorPane, KeyEvent keyEvent) {
        ModalKeymap.ModeStateInfo modeStateInfo = editorPane.getKeymapStateInfo();
        int n2 = modeStateInfo.mode;
        boolean bl = false;
        Action action = null;
        int n3 = keyEvent.getID();
        switch (n3) {
            case 401: {
                action = this.getActionForKeyStroke(n2, keyEvent);
                modeStateInfo.processedKeyPressed = bl = this.dispatchAction(editorPane, keyEvent, action);
                break;
            }
            case 400: {
                if (modeStateInfo.processedKeyPressed) break;
                action = this.getActionForKeyStroke(n2, keyEvent);
                bl = this.dispatchAction(editorPane, keyEvent, action);
                break;
            }
            case 402: {
                if (!modeStateInfo.processedKeyPressed) {
                    action = this.getActionForKeyStroke(n2, keyEvent);
                }
                bl = this.dispatchAction(editorPane, keyEvent, action);
            }
        }
        if (bl && !(action instanceof EmacsActions.EmacsKillAction)) {
            KillRing.activeKillPosition = -1;
        }
        if (bl && !(action instanceof EmacsActions.EmacsYankAction)) {
            KillRing.activeYank = false;
        }
        if (n2 != 0 && bl) {
            modeStateInfo.mode = 0;
        }
    }

    public EmacsKeymap(String string, Keymap keymap) {
        super(string, keymap);
    }

    public ModalKeymap.ModeStateInfo createStateInfo(EditorPane editorPane) {
        return new EmacsStateInfo(editorPane);
    }
}

