/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.node;

import com.borland.primetime.ide.BrowserIcons;
import com.borland.primetime.node.DuplicateNodeException;
import com.borland.primetime.node.FileType;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.Project;
import com.borland.primetime.node.UrlNode;
import com.borland.primetime.util.AssertionException;
import com.borland.primetime.vfs.Buffer;
import com.borland.primetime.vfs.InvalidUrlException;
import com.borland.primetime.vfs.NewFilesystem;
import com.borland.primetime.vfs.ReadOnlyException;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import com.borland.primetime.vfs.VFSException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Icon;

public class FileNode
extends UrlNode {
    static Class f;
    static Class c;
    static Class e;
    static Class d;
    static Class b;
    private Url a;
    private SoftReference g;

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void check() {
        Buffer buffer = this.findBuffer();
        if (buffer != null) {
            buffer.check();
        }
    }

    public int getDisplaySequence() {
        return 500;
    }

    public String getLongDisplayName() {
        if (this.a.getFilesystem() == NewFilesystem.FILESYSTEM) {
            return this.getDisplayName();
        }
        return this.a.getFile();
    }

    public String getDisplayName() {
        return this.a.getName();
    }

    public Icon getDisplayIcon() {
        return BrowserIcons.ICON_FILEBINARY;
    }

    public synchronized void save() throws IOException, InvalidUrlException {
        if (this.a.getProtocol() == "new") {
            throw new InvalidUrlException();
        }
        this.getBuffer().save(true);
    }

    public void saveAs(Url url) throws IOException, InvalidUrlException, DuplicateNodeException {
        if (url.equals(this.a)) {
            return;
        }
        if (FileNode.findFileNodeClass(url) != this.getClass()) {
            throw new InvalidUrlException();
        }
        Buffer buffer = this.getBuffer();
        Url url2 = this.getUrl();
        this.setUrl(url);
        try {
            VFS.copy(url2, url);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        buffer.revert();
        this.getBuffer().save();
        this.fireNodeRenamed();
    }

    public void rename(Url url) throws IOException, InvalidUrlException, DuplicateNodeException, ReadOnlyException {
        if (FileNode.findFileNodeClass(url) != this.getClass()) {
            throw new InvalidUrlException();
        }
        VFS.rename(this.a, url);
        this.setUrl(url);
        this.fireNodeRenamed();
    }

    public void revert() throws IOException {
        Buffer buffer = this.findBuffer();
        if (buffer != null) {
            buffer.revert();
        }
    }

    public boolean isModified() {
        Buffer buffer = this.findBuffer();
        if (buffer != null) {
            return buffer.isModified();
        }
        return false;
    }

    public boolean isNew() {
        return this.a.getFilesystem() == NewFilesystem.FILESYSTEM;
    }

    public boolean isReadOnly() {
        Buffer buffer = this.findBuffer();
        if (buffer != null) {
            return buffer.isReadOnly();
        }
        return VFS.isReadOnly(this.getUrl());
    }

    public OutputStream getOutputStream() throws IOException, VFSException {
        return VFS.getOutputStream(this.getUrl(), true);
    }

    public InputStream getInputStream() throws IOException {
        return VFS.getInputStream(this.getUrl());
    }

    public long getTimestamp() {
        Buffer buffer = this.findBuffer();
        if (buffer != null) {
            return buffer.getLastModified();
        }
        return Long.MIN_VALUE;
    }

    public synchronized Buffer findBuffer() {
        Buffer buffer = this.g == null ? null : (Buffer)this.g.get();
        if (buffer == null && (buffer = VFS.findBuffer(this.getUrl())) != null) {
            this.g = new SoftReference<Buffer>(buffer);
        }
        return buffer;
    }

    public synchronized Buffer getBuffer() throws IOException {
        Buffer buffer = this.g == null ? null : (Buffer)this.g.get();
        if (buffer == null) {
            buffer = VFS.getBuffer(this.getUrl());
            this.g = new SoftReference<Buffer>(buffer);
        }
        return buffer;
    }

    static synchronized FileNode a(Project project, Node node, Url url) throws DuplicateNodeException {
        try {
            Constructor constructor = FileNode.findFileNodeClass(url).getConstructor(d == null ? (d = FileNode.a("com.borland.primetime.node.Project")) : d, e == null ? (e = FileNode.a("com.borland.primetime.node.Node")) : e, b == null ? (b = FileNode.a("com.borland.primetime.vfs.Url")) : b);
            FileNode fileNode = (FileNode)constructor.newInstance(project, node, url);
            return fileNode;
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof DuplicateNodeException) {
                throw (DuplicateNodeException)invocationTargetException.getTargetException();
            }
            invocationTargetException.printStackTrace(System.err);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        throw new AssertionException();
    }

    public static Class findFileNodeClass(String string, boolean bl) {
        Class clazz;
        FileType fileType;
        int n2 = string.length();
        if (bl && n2 > 0 && string.charAt(n2 - 1) == '~') {
            int n3 = 0;
            while (n3 < 2 && string.indexOf(126) != -1) {
                if (string.charAt(n2 - 1) == '~') {
                    ++n3;
                }
                string = string.substring(0, n2 - 1);
                --n2;
            }
        }
        if ((fileType = FileType.getFileType(string)) == null) {
            return c == null ? (c = FileNode.a("com.borland.primetime.node.TextFileNode")) : c;
        }
        if (!(f == null ? (f = FileNode.a("com.borland.primetime.node.FileNode")) : f).isAssignableFrom(clazz = fileType.getNodeType())) {
            clazz = null;
        }
        Class clazz2 = clazz == null ? (c == null ? (c = FileNode.a("com.borland.primetime.node.TextFileNode")) : c) : clazz;
        return clazz2;
    }

    public static Class findFileNodeClass(Url url, boolean bl) {
        return FileNode.findFileNodeClass(url.getFileExtension(), bl);
    }

    public static Class findFileNodeClass(Url url) {
        return FileNode.findFileNodeClass(url, true);
    }

    public static void registerFileNodeClass(String string, String string2, Class clazz, Icon icon) {
        FileType.registerFileType(string, new FileType(string2, clazz, f == null ? (f = FileNode.a("com.borland.primetime.node.FileNode")) : f, icon));
    }

    protected void setUrl(Url url) throws DuplicateNodeException {
        Project project = this.getProject();
        synchronized (project) {
            if (!this.getProject().c(this)) {
                throw new AssertionException();
            }
            Url url2 = this.a;
            this.a = url;
            this.g = null;
            try {
                this.getProject().b(this);
                Node node = this.getParent();
                if (node != null) {
                    this.getProject().fireChildrenChanged(node);
                }
            }
            catch (DuplicateNodeException duplicateNodeException) {
                this.a = url2;
                this.getProject().b(this);
                throw duplicateNodeException;
            }
        }
    }

    public Url getUrl() {
        return this.a;
    }

    public FileNode(Project project, Node node, Url url) throws DuplicateNodeException {
        super(project, node);
        this.a = url;
        project.b(this);
        if (node != null) {
            project.fireChildrenChanged(node);
        }
    }
}

