/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class CheckBoxCellRenderer
extends JLabel
implements ItemSelectable {
    static Class b;
    protected boolean selected = true;
    protected boolean checkVisible = true;
    protected int alignment = 2;
    protected static final int HGAP = 4;
    protected int checkStyle = 0;
    protected int boxSize = 12;
    public static final int XMARK = 1;
    public static final int CHECKMARK = 0;

    static {
        CHECKMARK = 0;
        XMARK = 1;
        HGAP = 4;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        ItemEvent itemEvent2 = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (b == null ? CheckBoxCellRenderer.class$("java.awt.event.ItemListener") : b)) continue;
            if (itemEvent2 == null) {
                itemEvent2 = new ItemEvent(this, 701, this, itemEvent.getStateChange());
            }
            ((ItemListener)objectArray[i2 + 1]).itemStateChanged(itemEvent2);
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(b == null ? (b = CheckBoxCellRenderer.class$("java.awt.event.ItemListener")) : b, itemListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(b == null ? (b = CheckBoxCellRenderer.class$("java.awt.event.ItemListener")) : b, itemListener);
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray;
        if (this.selected) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.getText();
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    public void setCheckVisible(boolean bl) {
        this.checkVisible = bl;
    }

    public boolean isCheckVisible() {
        return this.checkVisible;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        this.selected = bl;
        ItemEvent itemEvent = bl ? new ItemEvent(this, 701, this, 1) : new ItemEvent(this, 701, null, 2);
        this.fireItemStateChanged(itemEvent);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.checkVisible) {
            dimension.width += this.boxSize + 4;
        }
        dimension.width += 2;
        dimension.height += 2;
        return dimension;
    }

    protected void drawCheck(Graphics graphics, int n2, int n3, int n4, int n5) {
        Color color = graphics.getColor();
        ++n2;
        ++n3;
        graphics.setColor(Color.black);
        if (this.checkStyle == 0) {
            int n6 = n5 / 3;
            int n7 = n2 + n4 / 3 - 1;
            for (int i2 = 1; i2 <= n6; ++i2) {
                graphics.drawLine(n7, n3 + n5 - i2 - 2, n2, n3 + n6 - i2 + n5 / 2 - 2);
                graphics.drawLine(n7, n3 + n5 - i2 - 2, n2 + n4 - 3, n3 + n6 - i2);
            }
        } else if (this.checkStyle == 1) {
            graphics.drawLine(n2, n3, n2 + n4 - 3, n3 + n5 - 3);
            graphics.drawLine(n2 + 1, n3, n2 + n4 - 3, n3 + n5 - 4);
            graphics.drawLine(n2, n3 + 1, n2 + n4 - 4, n3 + n5 - 3);
            graphics.drawLine(n2, n3 + n5 - 3, n2 + n4 - 3, n3);
            graphics.drawLine(n2 + 1, n3 + n5 - 3, n2 + n4 - 3, n3 + 1);
            graphics.drawLine(n2, n3 + n5 - 4, n2 + n4 - 4, n3);
        }
        graphics.setColor(color);
    }

    protected void drawBox(Graphics graphics, int n2, int n3, int n4, int n5) {
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
        graphics.setColor(color);
    }

    protected void paintComponent(Graphics graphics) {
        if (this.checkVisible) {
            Rectangle rectangle = this.getBoxRectangle();
            this.drawBox(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            if (this.selected) {
                this.drawCheck(graphics, rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
            }
            super.paintBorder(graphics);
            graphics.translate(this.boxSize + 4, 0);
        }
        super.paintComponent(graphics);
    }

    protected Rectangle getBoxRectangle() {
        Rectangle rectangle = new Rectangle(0, 0, this.boxSize, this.boxSize);
        if (this.alignment == 2) {
            ++rectangle.x;
            rectangle.y = (this.getHeight() - this.boxSize) / 2;
        } else if (this.alignment == 0) {
            Dimension dimension = this.getPreferredSize();
            rectangle.x = (this.getWidth() - dimension.width) / 2;
            rectangle.y = (this.getHeight() - this.boxSize) / 2;
        }
        return rectangle;
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (!mouseEvent.isConsumed() && mouseEvent.getID() == 500 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.hitTest(mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void hitTest(int n2, int n3) {
        if (this.checkVisible) {
            Rectangle rectangle = this.getBoxRectangle();
            if (n2 >= rectangle.x && n2 <= rectangle.x + rectangle.width && n3 >= rectangle.y && n3 <= rectangle.y + rectangle.height) {
                this.setSelected(!this.selected);
            }
        }
    }

    public int getStyle() {
        return this.checkStyle;
    }

    public void setStyle(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException();
        }
        this.checkStyle = n2;
    }

    public int getBoxSize() {
        return this.boxSize;
    }

    public void setBoxSize(int n2) {
        this.boxSize = n2;
    }

    public CheckBoxCellRenderer(int n2, int n3) {
        this(n2);
        this.checkStyle = n3;
    }

    public CheckBoxCellRenderer(int n2) {
        this();
        this.boxSize = n2;
    }

    public CheckBoxCellRenderer() {
        this.enableEvents(16L);
    }
}

