/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.ui;

import com.borland.primetime.util.Icons;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class CheckCellRenderer
extends JLabel {
    protected static Border emptyBorder;
    protected boolean paintFocusRect = false;
    protected boolean drawsFocusBorderAroundIcon = false;
    private boolean a = true;
    protected boolean checkVisible = true;
    protected int alignment = 2;
    protected int checkStyle = 0;
    protected int boxSize = 12;
    public static final int XMARK = 1;
    public static final int CHECKMARK = 0;

    static {
        CHECKMARK = 0;
        XMARK = 1;
        emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
    }

    public void setIcon(Icon icon) {
        super.setIcon(icon);
        super.setDisabledIcon(Icons.getDisabledIcon(icon));
    }

    public void setCheckVisible(boolean bl) {
        this.checkVisible = bl;
    }

    public boolean isCheckVisible() {
        return this.checkVisible;
    }

    public boolean isSelected() {
        return this.a;
    }

    public void setSelected(boolean bl) {
        this.a = bl;
    }

    public boolean hitTest(int n2, int n3) {
        if (this.checkVisible && this.isEnabled()) {
            Rectangle rectangle = this.getBoxRectangle();
            return n2 >= rectangle.x && n2 <= rectangle.x + rectangle.width && n3 >= rectangle.y && n3 <= rectangle.y + rectangle.height;
        }
        return false;
    }

    public Insets getInsets(Insets insets) {
        Insets insets2 = super.getInsets(insets);
        if (this.checkVisible) {
            insets2.left += this.boxSize + this.getIconTextGap();
        }
        return insets2;
    }

    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (this.checkVisible) {
            insets.left += this.boxSize + this.getIconTextGap();
        }
        return insets;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width += 3;
        return dimension;
    }

    protected void drawCheck(Graphics graphics, int n2, int n3, int n4, int n5) {
        Color color = graphics.getColor();
        ++n2;
        ++n3;
        if (this.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.gray);
        }
        if (this.checkStyle == 0) {
            int n6 = n5 / 3;
            int n7 = n2 + n4 / 3 - 1;
            for (int i2 = 1; i2 <= n6; ++i2) {
                graphics.drawLine(n7, n3 + n5 - i2 - 2, n2, n3 + n6 - i2 + n5 / 2 - 2);
                graphics.drawLine(n7, n3 + n5 - i2 - 2, n2 + n4 - 3, n3 + n6 - i2);
            }
        } else if (this.checkStyle == 1) {
            graphics.drawLine(n2, n3, n2 + n4 - 3, n3 + n5 - 3);
            graphics.drawLine(n2 + 1, n3, n2 + n4 - 3, n3 + n5 - 4);
            graphics.drawLine(n2, n3 + 1, n2 + n4 - 4, n3 + n5 - 3);
            graphics.drawLine(n2, n3 + n5 - 3, n2 + n4 - 3, n3);
            graphics.drawLine(n2 + 1, n3 + n5 - 3, n2 + n4 - 3, n3 + 1);
            graphics.drawLine(n2, n3 + n5 - 4, n2 + n4 - 4, n3);
        }
        graphics.setColor(color);
    }

    protected void drawBox(Graphics graphics, int n2, int n3, int n4, int n5) {
        Color color = graphics.getColor();
        if (this.isEnabled()) {
            graphics.setColor(Color.black);
        } else {
            graphics.setColor(Color.gray);
        }
        graphics.drawRect(n2, n3, n4 - 1, n5 - 1);
        graphics.setColor(color);
    }

    private int b() {
        int n2 = this.checkVisible ? this.boxSize + this.getIconTextGap() : 0;
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return n2 + icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return n2;
    }

    public void setPaintFocusRect(boolean bl) {
        this.paintFocusRect = bl;
    }

    public void paint(Graphics graphics) {
        Object object;
        Serializable serializable;
        if (this.checkVisible) {
            serializable = this.getBoxRectangle();
            this.drawBox(graphics, serializable.x, serializable.y, serializable.width, serializable.height);
            if (this.a) {
                this.drawCheck(graphics, serializable.x + 1, serializable.y + 1, serializable.width - 2, serializable.height - 2);
            }
        }
        serializable = this.getBackground();
        int n2 = -1;
        if (serializable != null) {
            object = this.getIcon();
            n2 = this.b();
            graphics.setColor((Color)serializable);
            graphics.fillRect(n2, 0, this.getWidth() - 1 - n2, this.getHeight());
        }
        if (this.paintFocusRect) {
            n2 = this.b();
            object = UIManager.getColor("Tree.selectionBorderColor");
            if (object != null) {
                graphics.setColor((Color)object);
                graphics.drawRect(n2, 0, this.getWidth() - 1 - n2, this.getHeight() - 1);
            }
        }
        super.paint(graphics);
    }

    protected Rectangle getBoxRectangle() {
        Rectangle rectangle = new Rectangle(0, 0, this.boxSize, this.boxSize);
        if (this.alignment == 2) {
            ++rectangle.x;
            rectangle.y = (this.getHeight() - this.boxSize) / 2;
        } else if (this.alignment == 0) {
            Dimension dimension = this.getPreferredSize();
            rectangle.x = (this.getWidth() - dimension.width) / 2;
            rectangle.y = (this.getHeight() - this.boxSize) / 2;
        }
        return rectangle;
    }

    public int getStyle() {
        return this.checkStyle;
    }

    public void setStyle(int n2) {
        if (n2 != 0 && n2 != 1) {
            throw new IllegalArgumentException();
        }
        this.checkStyle = n2;
    }

    public int getBoxSize() {
        return this.boxSize;
    }

    public void setBoxSize(int n2) {
        this.boxSize = n2;
    }

    public CheckCellRenderer(int n2, int n3) {
        this(n2);
        this.checkStyle = n3;
    }

    public CheckCellRenderer(int n2) {
        this();
        this.boxSize = n2;
    }

    public CheckCellRenderer() {
        this.setBorder(emptyBorder);
    }
}

