/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.util;

import com.borland.primetime.util.Images;
import java.awt.Color;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class AuraImage {
    protected int alphaThreshold;
    protected int[] blendMap;
    protected int[] auraMap;
    protected int[] srcMap;
    protected int ih;
    protected int iw;
    protected int auraRGB = SystemColor.textHighlight.getRGB();
    protected boolean auraBlended = false;
    protected boolean auraCalculated = false;

    protected void blendAuraMap() {
        this.calcAuraMap();
        if (this.auraBlended) {
            return;
        }
        this.blendMap = new int[this.iw * this.ih];
        for (int i2 = 0; i2 < this.srcMap.length; ++i2) {
            this.blendMap[i2] = this.srcMap[i2] | this.auraMap[i2];
        }
        this.auraBlended = true;
    }

    protected void calcAuraMap() {
        if (this.auraCalculated) {
            return;
        }
        this.auraMap = new int[this.iw * this.ih];
        for (int i2 = 0; i2 < this.ih; ++i2) {
            for (int i3 = 0; i3 < this.iw; ++i3) {
                this.auraMap[i2 * this.iw + i3] = this.calcMapPixel(i3, i2);
            }
        }
        this.auraCalculated = true;
    }

    protected int calcMapPixel(int n2, int n3) {
        if (!this.testOpaque(n2, n3) && (this.testOpaque(n2 - 1, n3 - 1) || this.testOpaque(n2, n3 - 1) || this.testOpaque(n2 + 1, n3 - 1) || this.testOpaque(n2 - 1, n3) || this.testOpaque(n2 + 1, n3) || this.testOpaque(n2 - 1, n3 + 1) || this.testOpaque(n2, n3 + 1) || this.testOpaque(n2 + 1, n3 + 1))) {
            return this.auraRGB;
        }
        return 0;
    }

    protected final boolean testOpaque(int n2, int n3) {
        if (n2 < 0 || n2 >= this.iw || n3 < 0 || n3 >= this.ih) {
            return false;
        }
        return (this.srcMap[n3 * this.iw + n2] & 0xFF000000) != 0;
    }

    protected final void fetchPixels(Image image) {
        Images.waitForImage(image);
        this.iw = image.getWidth(null);
        this.ih = image.getHeight(null);
        this.srcMap = new int[this.iw * this.ih];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.iw, this.ih, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.srcMap = (int[])pixelGrabber.getPixels();
    }

    public void dumpPixelMaps() {
        this.calcAuraMap();
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("AuraImage.dumpMaps() : image size: (").append(this.iw).append(",").append(this.ih).append(")"))));
        System.out.println("key:\tO = opaque pixel\t+ = transparent pixel");
        System.out.println("left: source pixel data\tright: calculated aura pixel data");
        for (int i2 = 0; i2 < this.ih; ++i2) {
            int n2;
            int n3;
            for (n3 = 0; n3 < this.iw; ++n3) {
                n2 = this.srcMap[i2 * this.iw + n3] & 0xFF000000;
                System.out.print("".concat(String.valueOf(String.valueOf(n2 != 0 ? "O" : "+"))));
            }
            System.out.print("  ");
            for (n3 = 0; n3 < this.iw; ++n3) {
                n2 = this.auraMap[i2 * this.iw + n3] & 0xFF000000;
                System.out.print("".concat(String.valueOf(String.valueOf(n2 != 0 ? "O" : "+"))));
            }
            System.out.println();
        }
        System.out.println();
    }

    public int getAlphaThreshold() {
        return this.alphaThreshold;
    }

    public void setAlphaThreshold(int n2) {
        this.alphaThreshold = n2;
        this.auraCalculated = false;
        this.auraBlended = false;
    }

    public int getAuraRGB() {
        return this.auraRGB;
    }

    public void setAuraRGB(int n2) {
        this.auraRGB = n2;
        this.auraCalculated = false;
        this.auraBlended = false;
    }

    public Image getBlendedImage() {
        this.calcAuraMap();
        this.blendAuraMap();
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.iw, this.ih, this.blendMap, 0, this.iw));
    }

    public Image getAuraImage() {
        this.calcAuraMap();
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.iw, this.ih, this.auraMap, 0, this.iw));
    }

    public Image getSourceImage() {
        return Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(this.iw, this.ih, this.srcMap, 0, this.iw));
    }

    public AuraImage(int[] nArray, int n2, int n3, int n4) {
        this.srcMap = nArray;
        this.iw = n2;
        this.ih = n3;
        this.auraRGB = n4;
    }

    public AuraImage(Image image) {
        this(image, Color.green.getRGB());
    }

    public AuraImage(Image image, int n2) {
        if (image == null) {
            throw new IllegalArgumentException("Image cannot be null");
        }
        this.auraRGB = n2;
        this.fetchPixels(image);
    }

    public static Image createAuraImage(Image image) {
        AuraImage auraImage = new AuraImage(image, Color.green.getRGB());
        return auraImage.getBlendedImage();
    }

    public static Image createAuraImage(Image image, int n2) {
        AuraImage auraImage = new AuraImage(image, n2);
        return auraImage.getBlendedImage();
    }
}

