/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.vfs;

import com.borland.primetime.PrimeTime;
import com.borland.primetime.vfs.Buffer;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.VFS;
import com.borland.primetime.vfs.g;
import com.borland.primetime.vfs.h;
import com.borland.primetime.vfs.i;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class UnitTest {
    public static void childrenTests() throws Exception {
        System.out.println("\n-- Children Tests --\n");
        File file = new File("children.dir");
        File file2 = new File("children.dir/a");
        File file3 = new File("children.dir/b");
        File file4 = new File("children.dir/c");
        file.mkdir();
        file2.createNewFile();
        file3.createNewFile();
        file4.createNewFile();
        System.out.println("Listing FileFilesystem children...");
        Url url = new Url(file);
        Url[] urlArray = VFS.getChildren(url, 3);
        for (int i2 = 0; i2 < urlArray.length; ++i2) {
            System.out.println(urlArray[i2].getFileObject().getName());
        }
        File file5 = new File("children.zip");
        file5.delete();
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file5));
        zipOutputStream.putNextEntry(new ZipEntry("sub/dir/one.txt"));
        zipOutputStream.putNextEntry(new ZipEntry("sub/dir/two.txt"));
        zipOutputStream.putNextEntry(new ZipEntry("sub/dir/three.txt"));
        zipOutputStream.close();
        System.out.println("\nListing ZipFilesystem children...");
        Url url2 = new Url(new File(".")).getRelativeUrl("[children.zip]/sub/dir");
        Url[] urlArray2 = VFS.getChildren(VFS.getCanonicalUrl(url2), 3);
        for (int i3 = 0; i3 < urlArray2.length; ++i3) {
            System.out.println(urlArray2[i3].getName());
        }
        file2.delete();
        file3.delete();
        file4.delete();
        file.delete();
        file5.delete();
    }

    public static void bufferCheckTests() throws Exception {
        System.out.println("\n-- Buffer Check Tests --\n");
        g g2 = new g();
        File file = new File("buffer.check.test");
        Url url = new Url(file);
        file.createNewFile();
        Buffer buffer = VFS.getBuffer(url);
        buffer.addBufferListener(g2);
        g2.loaded = false;
        file.setLastModified(System.currentTimeMillis() + (long)2000);
        buffer.check();
        System.out.println("Unmodified buffer automatically updated <true>? ".concat(String.valueOf(String.valueOf(g2.loaded))));
        g2.loaded = false;
        buffer.setContent(new byte[0]);
        file.setLastModified(System.currentTimeMillis() + (long)4000);
        h h2 = new h();
        VFS.addVFSListener(h2);
        buffer.check();
        System.out.println("Modified buffers prompt for updates <true>? ".concat(String.valueOf(String.valueOf(h2.asked))));
        VFS.removeVFSListener(h2);
        file.delete();
    }

    public static void bufferGCTests() {
        System.out.println("\n-- Buffer GC Tests --\n");
        try {
            Url url = new Url("file", "c:/boot.ini");
            VFS.getBuffer(url);
            Buffer buffer = VFS.findBuffer(url);
            System.out.println("Pre-GC buffer cached <true>? ".concat(String.valueOf(String.valueOf(buffer != null))));
            buffer = null;
            System.gc();
            buffer = VFS.findBuffer(url);
            System.out.println("Post-GC buffer cached <false>? ".concat(String.valueOf(String.valueOf(buffer != null))));
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public static void bufferCacheTests() throws Exception {
        System.out.println("\n-- Buffer Cache Tests --\n");
        Buffer buffer = VFS.getBuffer(new Url("file", "c:/boot.ini"));
        Buffer buffer2 = VFS.getBuffer(new Url("file", "c:/boot.INI"));
        Buffer buffer3 = VFS.getBuffer(new Url("file", "c:/cool.jpg"));
        System.out.println("buffera == null <false>? ".concat(String.valueOf(String.valueOf(buffer == null))));
        System.out.println("bufferb == null <false>? ".concat(String.valueOf(String.valueOf(buffer2 == null))));
        System.out.println("bufferc == null <false>? ".concat(String.valueOf(String.valueOf(buffer3 == null))));
        System.out.println("buffera == bufferb <true>? ".concat(String.valueOf(String.valueOf(buffer == buffer2))));
        System.out.println("buffera == bufferc <false>? ".concat(String.valueOf(String.valueOf(buffer == buffer3))));
    }

    public static void zipTests() throws Exception {
        System.out.println("\n-- Zip Tests --\n");
        File file = new File("zip.tests.zip");
        String string = "This is a zip entry";
        file.delete();
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        zipOutputStream.putNextEntry(new ZipEntry("one/two/three.txt"));
        PrintStream printStream = new PrintStream(zipOutputStream);
        printStream.print(string);
        printStream.close();
        Url url = new Url(new File(".")).getRelativeUrl("[ZIP.testS.ZiP]/one/two/three.txt");
        Url url2 = new Url(new File(".")).getRelativeUrl("[ZIP.testS.ZiP]/one");
        Url url3 = new Url(new File(".")).getRelativeUrl("[ZIP.testS.ZiP]/one/two/three/four.txt");
        System.out.println("Testing existing zip entry...");
        Url url4 = VFS.getCanonicalUrl(url);
        Buffer buffer = VFS.getBuffer(url4);
        System.out.println("Entry exists <true>? ".concat(String.valueOf(String.valueOf(VFS.exists(url4)))));
        System.out.println("Entry is directory <false>? ".concat(String.valueOf(String.valueOf(VFS.isDirectory(url4)))));
        System.out.println("Entry read-only <true>? ".concat(String.valueOf(String.valueOf(VFS.isReadOnly(url4)))));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(VFS.getBuffer(url4).getInputStream()));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        System.out.println("Content of buffer correct <true>? ".concat(String.valueOf(String.valueOf(string2.equals(string)))));
        System.out.println("\nTesting nonexistant zip entry...");
        url4 = VFS.getCanonicalUrl(url3);
        System.out.println("Entry exists <false>? ".concat(String.valueOf(String.valueOf(VFS.exists(url4)))));
        System.out.println("Entry is directory <false>? ".concat(String.valueOf(String.valueOf(VFS.isDirectory(url4)))));
        System.out.println("Entry read-only <true>? ".concat(String.valueOf(String.valueOf(VFS.isReadOnly(url4)))));
        System.out.println("\nTesting zip directory...");
        url4 = VFS.getCanonicalUrl(url2);
        System.out.println("Entry exists <true>? ".concat(String.valueOf(String.valueOf(VFS.exists(url4)))));
        System.out.println("Entry is directory <true>? ".concat(String.valueOf(String.valueOf(VFS.isDirectory(url4)))));
        file.delete();
    }

    public static void fileTests() throws Exception {
        System.out.println("\n-- File Tests --\n");
        String string = "This is a test";
        File file = new File("file.test.exists");
        file.delete();
        file.createNewFile();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        ((Writer)fileWriter).close();
        Url url = new Url(file);
        Url url2 = new Url(new File("file.tests.doesnotexist"));
        Url url3 = new Url(new File("."));
        System.out.println("Testing existing file...");
        System.out.println("File exists <true>? ".concat(String.valueOf(String.valueOf(VFS.exists(url)))));
        System.out.println("File is directory <false>? ".concat(String.valueOf(String.valueOf(VFS.isDirectory(url)))));
        System.out.println("File read-only <false>? ".concat(String.valueOf(String.valueOf(VFS.isReadOnly(url)))));
        System.out.println("Last modified correct <true>? ".concat(String.valueOf(String.valueOf(VFS.getLastModified(url) == file.lastModified()))));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(VFS.getBuffer(url).getInputStream()));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        System.out.println("Content of buffer correct <true>? ".concat(String.valueOf(String.valueOf(string2.equals(string)))));
        System.out.println("\nTesting nonexistant file...");
        System.out.println("File exists <false>? ".concat(String.valueOf(String.valueOf(VFS.exists(url2)))));
        System.out.println("File is directory <false>? ".concat(String.valueOf(String.valueOf(VFS.isDirectory(url2)))));
        System.out.println("File read-only <false>? ".concat(String.valueOf(String.valueOf(VFS.isReadOnly(url2)))));
        System.out.println("Last modified == MODIFIED_NEVER <true>? ".concat(String.valueOf(String.valueOf(VFS.getLastModified(url2) == Long.MIN_VALUE))));
        System.out.println("\nTesting directory...");
        System.out.println("File exists <true>? ".concat(String.valueOf(String.valueOf(VFS.exists(url3)))));
        System.out.println("File is directory <true>? ".concat(String.valueOf(String.valueOf(VFS.isDirectory(url3)))));
        file.delete();
    }

    public static void lockTests() throws Exception {
    }

    public static void eventTests() throws Exception {
        System.out.println("\n-- Event Tests --\n");
        i i2 = new i();
        File file = new File("event.tests");
        File file2 = new File("event.tests.nonexistant");
        File file3 = new File("event.tests.ro");
        file.delete();
        file.createNewFile();
        file3.delete();
        file3.createNewFile();
        file3.setReadOnly();
        System.out.println("\nWriting to a file with a listener...");
        Buffer buffer = VFS.getBuffer(new Url(file));
        buffer.addBufferListener(i2);
        PrintStream printStream = new PrintStream(buffer.getOutputStream());
        printStream.print("This is a change");
        printStream.close();
        buffer.removeBufferListener(i2);
        file.delete();
        file3.delete();
    }

    public static void readWriteTests() throws Exception {
        System.out.println("\n-- Read/Write Tests --\n");
        File file = new File("read.write.tests");
        File file2 = new File("read.write.tests~");
        Url url = new Url(file);
        VFS.delete(url);
        Buffer buffer = VFS.getBuffer(url);
        OutputStream outputStream = buffer.getOutputStream();
        outputStream.write(65);
        outputStream.close();
        buffer.save();
        System.out.println("Wrote 'A'...");
        byte[] byArray = new byte[]{0};
        InputStream inputStream = buffer.getInputStream();
        inputStream.read(byArray);
        if (byArray[0] == 65) {
            System.out.println("good JOB!");
        }
        outputStream = buffer.getOutputStream();
        outputStream.write(66);
        outputStream.close();
        buffer.save();
        System.out.println("Wrote 'B'...");
        outputStream = buffer.getOutputStream();
        outputStream.write(67);
        outputStream.close();
        buffer.save();
        System.out.println("Wrote 'C'...");
        System.out.println("File exists <true>? ".concat(String.valueOf(String.valueOf(file.exists()))));
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        String string = bufferedReader.readLine();
        bufferedReader.close();
        System.out.println("File contains 'C' <true>? ".concat(String.valueOf(String.valueOf(string.equals("C")))));
        System.out.println("Backup exists <true>? ".concat(String.valueOf(String.valueOf(file2.exists()))));
        bufferedReader = new BufferedReader(new FileReader(file2));
        string = bufferedReader.readLine();
        bufferedReader.close();
        System.out.println("Backup contains 'B' <true>? ".concat(String.valueOf(String.valueOf(string.equals("B")))));
        file.delete();
        file2.delete();
    }

    public static void javaUrlTests() throws Exception {
        System.out.println("\n-- Java URL Tests --\n");
        Url url = new Url("zip", "[d:/jbuilder3/lib/jbuilder.zip]/com/inprise/jbuilder/ide/image/faces.gif");
        URL uRL = url.toURL();
        System.out.println(uRL.getContent());
    }

    public static void urlTestHelper(Url url, String string) throws Exception {
        Url url2 = url.getRelativeUrl(string);
        System.out.println(String.valueOf(String.valueOf(url2)).concat(" ... "));
        String string2 = url.getRelativePath(url2);
        if (!string2.equals(string)) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("DIFFERENT: ").append(string).append(" vs. ").append(string2))));
        }
    }

    public static void urlTests() throws Exception {
        System.out.println("\n-- Url Tests --\n");
        Url url = new Url(new File("c:/foo/bar/baz.html"));
        Url url2 = new Url("file:///c:/foo/blat#100");
        Url url3 = new Url(new File("d:/foo/bark"));
        Url url4 = new Url("zip:///[d:/foo/bark.zip]/src");
        UnitTest.urlTestHelper(url2, "test.html");
        UnitTest.urlTestHelper(url2, "test.html#22");
        UnitTest.urlTestHelper(url2, "./test.html");
        UnitTest.urlTestHelper(url2, "../blax/test.html");
        UnitTest.urlTestHelper(url2, "../../../../../test.html");
        UnitTest.urlTestHelper(url2, "[../blax.zip]/test.html");
        UnitTest.urlTestHelper(url2, "f:/this/that/test.html");
        UnitTest.urlTestHelper(url4, "test.html");
        UnitTest.urlTestHelper(url4, "../test.html");
        UnitTest.urlTestHelper(url4, "../../test.html");
        UnitTest.urlTestHelper(url4, "[/sdk/jdk1.2/src.jar]/src");
    }

    public static void main(String[] stringArray) {
        PrimeTime.initializeOpenTools("Core");
        long l2 = System.currentTimeMillis();
        try {
            for (int i2 = 0; i2 < 1; ++i2) {
                try {
                    UnitTest.urlTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.javaUrlTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.readWriteTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.eventTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.lockTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.fileTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.zipTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.bufferCacheTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.bufferGCTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.bufferCheckTests();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
                try {
                    UnitTest.childrenTests();
                    continue;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace(System.err);
                }
            }
            Object var8_15 = null;
        }
        catch (Throwable throwable) {
            Object var8_16 = null;
            long l3 = System.currentTimeMillis();
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("Finished in ").append(l3 - l2).append("ms"))));
            throw throwable;
        }
        long l4 = System.currentTimeMillis();
        System.out.println(String.valueOf(String.valueOf(new StringBuffer("Finished in ").append(l4 - l2).append("ms"))));
    }
}

