/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.vfs;

import com.borland.primetime.PrimeTime;
import com.borland.primetime.util.Strings;
import com.borland.primetime.vfs.FileFilesystem;
import com.borland.primetime.vfs.Filesystem;
import com.borland.primetime.vfs.InvalidUrlException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Url
implements Comparable {
    private Object e;
    private int c = -1;
    private static boolean a;
    private static HashMap d;
    private String g;
    private String b;
    private String h;
    private Filesystem f;
    private static final String l = "java.protocol.handler.pkgs";
    private static final char k;
    public static final Strings.StringEncoding URL_ENCODING;
    private static final String i = "\rr\nn\bb\tt\ff#N;S:|";
    public static final Url[] EMPTY_ARRAY;

    static {
        EMPTY_ARRAY = new Url[0];
        i = i;
        URL_ENCODING = new Strings.StringEncoding(i, '%');
        k = File.separatorChar;
        l = l;
        d = new HashMap();
        a = false;
        Properties properties = System.getProperties();
        properties.setProperty(l, String.valueOf(String.valueOf(properties.getProperty(l))).concat("|com.borland.primetime"));
    }

    public void setFilesystemObject(Object object) {
        this.e = object;
    }

    public Object getFilesystemObject() {
        return this.e;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.f.getProtocol());
        stringBuffer.append("://");
        stringBuffer.append(URL_ENCODING.encode(this.b));
        stringBuffer.append('/');
        stringBuffer.append(URL_ENCODING.encode(this.g));
        if (this.h != null) {
            stringBuffer.append('#');
            stringBuffer.append(URL_ENCODING.encode(this.h));
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        if (this.c == -1) {
            int n2 = this.f.hashCode();
            int n3 = this.b.hashCode();
            int n4 = this.f.fileHashCode(this);
            int n5 = this.h == null ? 0 : this.h.hashCode();
            this.c = n2 ^ n3 ^ n4 ^ n5;
            if (this.c == -1) {
                this.c = -2;
            }
        }
        return this.c;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Url)) {
            return false;
        }
        Url url = (Url)object;
        if (url != null && this.f == url.f && this.b == url.b && this.h == url.h) {
            return this.f.fileEquals(this, url);
        }
        return false;
    }

    public int compareTo(Object object) {
        int n2;
        if (object == null) {
            return 1;
        }
        Url url = (Url)object;
        if (this.f != url.f && (n2 = this.getProtocol().compareTo(url.getProtocol())) != 0) {
            return n2;
        }
        if (this.b != url.b && (n2 = this.b.compareTo(url.b)) != 0) {
            return n2;
        }
        if (this.g != url.g && (n2 = this.f.fileEquals(this, url) ? 0 : this.g.compareTo(url.g)) != 0) {
            return n2;
        }
        if (this.h != url.h) {
            if (this.h == null) {
                return -1;
            }
            if (url.h == null) {
                return 1;
            }
            return this.h.compareTo(url.h);
        }
        return 0;
    }

    public URL toURL() {
        try {
            URL uRL = new URL("vfs", "", URL_ENCODING.decode(this.toString()));
            return uRL;
        }
        catch (MalformedURLException malformedURLException) {
            URL uRL = null;
            return uRL;
        }
    }

    public String getFullName() {
        return this.f.getFullName(this);
    }

    public String getName() {
        return this.f.getName(this);
    }

    public Url getParent() {
        return this.f.getParent(this);
    }

    public String getAnchor() {
        return this.h;
    }

    public File getFileObject() {
        return this.f.getFileObject(this);
    }

    public String getFileExtension() {
        int n2 = this.g.lastIndexOf(46);
        int n3 = this.g.lastIndexOf(47);
        return n2 == -1 || n2 < n3 ? "" : this.g.substring(n2 + 1);
    }

    public String getFile() {
        return this.g;
    }

    public String getHost() {
        return this.b;
    }

    public String getProtocol() {
        return this.f.getProtocol();
    }

    public Filesystem getFilesystem() {
        return this.f;
    }

    public String getRelativePath(Url[] urlArray, int n2) throws InvalidUrlException {
        String string = "";
        for (int i2 = 0; i2 < urlArray.length; ++i2) {
            String string2 = this.getRelativePath(urlArray[i2], n2);
            string = i2 == 0 ? string2 : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(';').append(string2)));
        }
        return string;
    }

    public String getRelativePath(Url[] urlArray) throws InvalidUrlException {
        return this.getRelativePath(urlArray, 0);
    }

    public static Url[] parseRelativePath(Url url, String string) throws InvalidUrlException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        Url[] urlArray = new Url[stringTokenizer.countTokens()];
        for (int i2 = 0; i2 < urlArray.length; ++i2) {
            urlArray[i2] = url.getRelativeUrl(stringTokenizer.nextToken());
        }
        return urlArray;
    }

    public static String getPath(Url[] urlArray) {
        String string = "";
        for (int i2 = 0; i2 < urlArray.length; ++i2) {
            String string2 = urlArray[i2].toString();
            string = i2 == 0 ? string2 : String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(';').append(string2)));
        }
        return string;
    }

    public static Url[] parsePath(String string) throws InvalidUrlException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        Url[] urlArray = new Url[stringTokenizer.countTokens()];
        for (int i2 = 0; i2 < urlArray.length; ++i2) {
            urlArray[i2] = new Url(stringTokenizer.nextToken());
        }
        return urlArray;
    }

    public Url withAnchor(String string) {
        if (string != null) {
            string = string.intern();
        }
        if (string == this.h) {
            return this;
        }
        return new Url(this.f, this.b, this.g, string);
    }

    public boolean isChild(Url url) {
        return this.getRelativePath(url, 1) != null;
    }

    public String getRelativePath(Url url, int n2) {
        String string = url.getAnchor();
        Url url2 = this.withAnchor(null);
        url = url.withAnchor(null);
        String string2 = URL_ENCODING.encode(this.f.getRelativePath(url2, url, n2));
        if (string != null) {
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf('#')).concat(String.valueOf(String.valueOf(URL_ENCODING.encode(string)))))));
        }
        return string2;
    }

    public String getRelativePath(Url url) {
        return this.getRelativePath(url, 0);
    }

    public Url getRelativeUrl(String string) {
        int n2 = string.indexOf(35);
        Url url = n2 == -1 ? this.f.getRelativeUrl(this, URL_ENCODING.decode(string)).withAnchor(null) : this.f.getRelativeUrl(this, URL_ENCODING.decode(string.substring(0, n2))).withAnchor(URL_ENCODING.decode(string.substring(n2 + 1)));
        return url;
    }

    public static synchronized Filesystem findFilesystem(String string) {
        if (!a) {
            a = true;
            PrimeTime.initializeOpenTools("VFS");
        }
        return (Filesystem)d.get(string.intern());
    }

    public static synchronized void registerFilesystem(Filesystem filesystem) {
        String string = filesystem.getProtocol().intern();
        d.put(string, filesystem);
    }

    public Url(String string) throws InvalidUrlException {
        int n2 = string.indexOf("://");
        int n3 = string.indexOf(47, n2 + 3);
        int n4 = string.indexOf(35, n3 + 1);
        if (k != '/' && string.indexOf(k) != -1) {
            throw new InvalidUrlException();
        }
        if (n2 == -1 || n3 == -1) {
            throw new InvalidUrlException();
        }
        this.f = Url.findFilesystem(string.substring(0, n2));
        this.b = URL_ENCODING.decode(string.substring(n2 + 3, n3)).intern();
        if (n4 == -1) {
            this.g = URL_ENCODING.decode(string.substring(n3 + 1));
        } else {
            this.g = URL_ENCODING.decode(string.substring(n3 + 1, n4));
            this.h = URL_ENCODING.decode(string.substring(n4 + 1)).intern();
        }
    }

    public Url(Filesystem filesystem, String string, String string2, String string3) {
        this.f = filesystem;
        this.b = string.intern();
        this.g = string2;
        this.h = string3 == null ? null : string3.intern();
        int n2 = this.g.length() - 1;
        if (n2 >= 0 && this.g.charAt(n2) == '/') {
            this.g = this.g.substring(0, n2);
        }
    }

    public Url(String string, String string2, String string3, String string4) {
        this(Url.findFilesystem(string), string2, string3, string4);
    }

    public Url(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public Url(String string, String string2) {
        this(string, "", string2);
    }

    public Url(File file) {
        this.f = FileFilesystem.FILESYSTEM;
        this.b = "";
        file = file.getAbsoluteFile();
        this.g = file.getPath().replace(k, '/');
        this.e = file;
        int n2 = this.g.length() - 1;
        if (n2 >= 0 && this.g.charAt(n2) == '/') {
            this.g = this.g.substring(0, n2);
        }
        this.h = null;
    }
}

