/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.vfs;

import com.borland.primetime.info.InfoStore;
import com.borland.primetime.util.RegularExpression;
import com.borland.primetime.util.Strings;
import com.borland.primetime.util.ZipIndex;
import com.borland.primetime.util.ZipIndexEntry;
import com.borland.primetime.vfs.AbstractFilesystem;
import com.borland.primetime.vfs.FileFilesystem;
import com.borland.primetime.vfs.Filesystem;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.vfs.a;
import com.borland.primetime.vfs.b;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class ZipFilesystem
extends AbstractFilesystem
implements Filesystem {
    static Class a;
    static Class b;
    public static final ZipFilesystem FILESYSTEM;
    public static final String PROTOCOL = "zip";

    static {
        PROTOCOL = PROTOCOL;
        FILESYSTEM = new ZipFilesystem();
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static String stripArchivePrefix(String string) {
        int n2 = string.indexOf("]");
        return n2 < 0 ? string : string.substring(n2 + 1);
    }

    public String getRelativePath(Url url, Url url2, int n2) {
        String string;
        if (url2.getFilesystem() instanceof FileFilesystem) {
            url = new Url(FileFilesystem.FILESYSTEM, url.getHost(), url.getFile().substring(1), url.getAnchor());
        }
        if ((string = super.getRelativePath(url, url2, n2)) == null) {
            return null;
        }
        if (string.indexOf(93) != -1 && string.indexOf(91) != 0) {
            string = String.valueOf(String.valueOf('[')).concat(String.valueOf(String.valueOf(string)));
        }
        return string;
    }

    public boolean isValid(Url url) {
        if (url.getHost().length() == 0 && super.isValid(url)) {
            String string = url.getFile();
            int n2 = string.indexOf(93);
            return string.indexOf(91) == 0 && n2 != -1;
        }
        return false;
    }

    public boolean fileEquals(Url url, Url url2) {
        a a2 = new a(url);
        String string = a2.b();
        String string2 = a2.a();
        if (string == null || string2 == null) {
            return false;
        }
        a a3 = new a(url2);
        String string3 = a3.b();
        String string4 = a3.a();
        if (string3 == null || string4 == null) {
            return false;
        }
        if (string2.equals(string4)) {
            return new File(string).equals(new File(string3));
        }
        return false;
    }

    public int fileHashCode(Url url) {
        a a2 = new a(url);
        String string = a2.b();
        String string2 = a2.a();
        int n2 = string == null ? 0 : new File(string).hashCode();
        int n3 = string2 == null ? 0 : string2.hashCode();
        return n2 ^ n3;
    }

    public Url getRelativeUrl(Url url, String string) {
        if (string.length() >= 1 && string.charAt(0) == '[') {
            return super.getRelativeUrl(url, string.substring(1));
        }
        Url url2 = FileFilesystem.FILESYSTEM.getAbsoluteUrl("", string);
        if (url2 != null) {
            return url2;
        }
        return super.getRelativeUrl(url, string);
    }

    public File getFileObject(Url url) {
        a a2;
        String string;
        File file = (File)url.getFilesystemObject();
        if (file == null && (string = (a2 = new a(url)).b()) != null) {
            file = new File(string);
            url.setFilesystemObject(file);
        }
        return file;
    }

    public String getName(Url url) {
        String string = url.getFile();
        String string2 = super.getName(url);
        if (string.lastIndexOf(93) == string.length() - 1) {
            return string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public Url getAbsoluteUrl(String string, String string2) {
        File file;
        a a2 = new a(string2);
        String string3 = a2.b();
        if (string3 != null && (file = new File(string3)).isAbsolute()) {
            return new Url(this, string, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('['))).append(file.getAbsolutePath().replace(File.separatorChar, '/')).append(']').append('/').append(a2.a()))), null);
        }
        return null;
    }

    public Url getParent(Url url) {
        File file = new File(url.getFile().substring(1).replace('/', File.separatorChar));
        String string = file.getParent();
        if (string == null) {
            return null;
        }
        if (string.indexOf(93) == -1) {
            return new Url(FileFilesystem.FILESYSTEM, url.getHost(), string.replace(File.separatorChar, '/'), null);
        }
        return new Url(this, url.getHost(), String.valueOf(String.valueOf('[')).concat(String.valueOf(String.valueOf(string.replace(File.separatorChar, '/')))), null);
    }

    public Url[] getChildren(Url url, RegularExpression[] regularExpressionArray, int n2) {
        a a2 = new a(url);
        File file = new File(a2.b());
        ZipIndex zipIndex = ZipIndex.getZipIndex(file);
        String string = a2.a();
        ZipIndexEntry[] zipIndexEntryArray = zipIndex.getChildren(string);
        String string2 = url.getFile();
        if (!string2.endsWith("/")) {
            string2 = String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf('/')));
        }
        ArrayList<Url> arrayList = new ArrayList<Url>();
        if (regularExpressionArray == null) {
            for (int i2 = 0; i2 < zipIndexEntryArray.length; ++i2) {
                ZipIndexEntry zipIndexEntry = zipIndexEntryArray[i2];
                if (zipIndexEntry.isDirectory()) {
                    if (n2 != 3 && n2 != 1) continue;
                    arrayList.add(new Url(this, "", String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(zipIndexEntry.getName()))), null));
                    continue;
                }
                if (n2 != 3 && n2 != 2) continue;
                arrayList.add(new Url(this, "", String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(zipIndexEntry.getName()))), null));
            }
        } else {
            int n3 = regularExpressionArray.length;
            block1: for (int i3 = 0; i3 < zipIndexEntryArray.length; ++i3) {
                ZipIndexEntry zipIndexEntry = zipIndexEntryArray[i3];
                String string3 = zipIndexEntry.getName();
                if (zipIndexEntry.isDirectory()) {
                    if (n2 != 3 && n2 != 1) continue;
                    arrayList.add(new Url(this, "", String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string3))), null));
                    continue;
                }
                if (n2 != 3 && n2 != 2) continue;
                for (int i4 = 0; i4 < n3; ++i4) {
                    if (!regularExpressionArray[i4].exactMatch(string3)) continue;
                    arrayList.add(new Url(this, "", String.valueOf(String.valueOf(string2)).concat(String.valueOf(String.valueOf(string3))), null));
                    continue block1;
                }
            }
        }
        return arrayList.toArray(new Url[arrayList.size()]);
    }

    public boolean isDirectory(Url url) {
        a a2 = new a(url);
        File file = new File(a2.b());
        ZipIndex zipIndex = ZipIndex.getZipIndex(file);
        return zipIndex.isDirectory(a2.a());
    }

    public void delete(Url url) throws IOException {
        throw new IOException(Strings.format(com.borland.primetime.vfs.b.a(0), url.getFile()));
    }

    public boolean exists(Url url) {
        a a2 = new a(url);
        File file = new File(a2.b());
        ZipIndex zipIndex = ZipIndex.getZipIndex(file);
        return zipIndex.contains(a2.a());
    }

    public Url getCanonicalUrl(Url url) {
        try {
            a a2 = new a(url);
            String string = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf('['))).append(new File(a2.b()).getCanonicalPath().replace(File.separatorChar, '/')).append("]/").append(a2.a())));
            url = new Url(url.getProtocol(), url.getHost(), string, url.getAnchor());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return url;
    }

    public long getLastModified(Url url) {
        a a2 = new a(url);
        File file = new File(a2.b());
        ZipIndex zipIndex = ZipIndex.getZipIndex(file);
        ZipIndexEntry zipIndexEntry = zipIndex.getZipIndexEntry(a2.a());
        if (zipIndexEntry == null) {
            return Long.MIN_VALUE;
        }
        return zipIndex.getLastModified(zipIndexEntry);
    }

    public boolean isReadOnly(Url url) {
        return true;
    }

    public OutputStream getOutputStream(Url url) throws IOException {
        throw new IOException(Strings.format(com.borland.primetime.vfs.b.a(0), url.getFile()));
    }

    public OutputStream getOutputStream(Url url, boolean bl) throws IOException {
        throw new IOException(Strings.format(com.borland.primetime.vfs.b.a(0), url.getFile()));
    }

    public InputStream getInputStream(Url url) throws IOException {
        a a2 = new a(url);
        File file = new File(a2.b());
        ZipIndex zipIndex = ZipIndex.getZipIndex(file);
        byte[] byArray = zipIndex.read(a2.a());
        return new ByteArrayInputStream(byArray);
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    private ZipFilesystem() {
    }

    public static void initOpenTool(byte by, byte by2) {
        try {
            Method method = com.fourthpass.runtimejb.a.b(b == null ? (b = ZipFilesystem.a("com.borland.primetime.info.Key")) : b, "equals", new Class[]{a == null ? (a = ZipFilesystem.a("java.lang.Object")) : a});
            if (!Modifier.isFinal(method.getModifiers())) {
                return;
            }
            new InfoStore().equals("");
        }
        catch (RuntimeException runtimeException) {
            Url.registerFilesystem(FILESYSTEM);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

