/*
 * Decompiled with CFR 0.152.
 */
package com.borland.primetime.viewer;

import com.borland.primetime.editor.EditorAction;
import com.borland.primetime.editor.EditorPane;
import com.borland.primetime.ide.Context;
import com.borland.primetime.insight.Insight;
import com.borland.primetime.node.FileNode;
import com.borland.primetime.node.Node;
import com.borland.primetime.node.TextFileNode;
import com.borland.primetime.node.TextStructure;
import com.borland.primetime.util.WeakValueHashMap;
import com.borland.primetime.vfs.Buffer;
import com.borland.primetime.vfs.Url;
import com.borland.primetime.viewer.AbstractNodeViewer;
import com.borland.primetime.viewer.BufferNodeList;
import com.borland.primetime.viewer.NodeViewList;
import com.borland.primetime.viewer.TextStructureView;
import com.borland.primetime.viewer.TextView;
import com.borland.primetime.viewer.TextViewerComponent;
import com.borland.primetime.viewer.ec;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;

public abstract class AbstractTextNodeViewer
extends AbstractNodeViewer {
    private static Map c;
    private static Map b;
    private static ec a;

    static {
        a = new ec(null, null);
        b = new HashMap();
        c = new WeakValueHashMap();
    }

    protected abstract BufferNodeList createBufferNodeList(Buffer var1, FileNode var2);

    protected BufferNodeList getBufferNodeList(Buffer buffer, FileNode fileNode) {
        Map map = c;
        synchronized (map) {
            Url url = buffer.getUrl().withAnchor(null);
            BufferNodeList bufferNodeList = (BufferNodeList)c.get(url);
            if (bufferNodeList != null && !bufferNodeList.hasViews()) {
                c.remove(url);
                bufferNodeList = null;
            }
            if (bufferNodeList == null) {
                bufferNodeList = this.createBufferNodeList(buffer, fileNode);
                c.put(url, bufferNodeList);
            }
            BufferNodeList bufferNodeList2 = bufferNodeList;
            return bufferNodeList2;
        }
    }

    protected boolean hasNodeViewList(AbstractTextNodeViewer abstractTextNodeViewer, FileNode fileNode) {
        Map map = b;
        synchronized (map) {
            a.setValue(abstractTextNodeViewer, fileNode);
            NodeViewList nodeViewList = (NodeViewList)b.get(a);
            a.setValue(null, null);
            boolean bl = nodeViewList != null;
            return bl;
        }
    }

    protected NodeViewList getNodeViewList(AbstractTextNodeViewer abstractTextNodeViewer, FileNode fileNode) {
        Map map = b;
        synchronized (map) {
            Object object;
            a.setValue(abstractTextNodeViewer, fileNode);
            NodeViewList nodeViewList = (NodeViewList)b.get(a);
            if (nodeViewList == null) {
                object = new ec(abstractTextNodeViewer, fileNode);
                nodeViewList = new NodeViewList(this, fileNode);
                b.put(object, nodeViewList);
            }
            a.setValue(null, null);
            object = nodeViewList;
            return object;
        }
    }

    public void releaseViewer() {
        Node node = this.context.getNode();
        if (node instanceof FileNode) {
            FileNode fileNode = (FileNode)node;
            if (this.hasNodeViewList(this, fileNode)) {
                NodeViewList nodeViewList = this.getNodeViewList(this, fileNode);
                TextStructure textStructure = nodeViewList.getBufferNodeList().getTextStructure();
                if (textStructure != null) {
                    textStructure.setFileNode(null);
                }
                TextViewerComponent textViewerComponent = (TextViewerComponent)this.getViewerComponent();
                textViewerComponent.setFocusedView(null);
                nodeViewList.releaseViews();
            }
            b.remove(new ec(this, fileNode));
        }
    }

    public void browserActivated() {
        if (this.viewerComponent != null) {
            TextView textView = ((TextViewerComponent)this.viewerComponent).getFocusedView();
            EditorAction.setFocusedEditor(textView.getEditor());
        }
    }

    public void viewerActivated(boolean bl) {
        FileNode fileNode = (FileNode)this.context.getNode();
        TextStructure textStructure = this.getStructure(fileNode);
        if (textStructure != null) {
            textStructure.setFileNode(fileNode);
        }
        if (bl && this.viewerComponent != null) {
            TextView textView = ((TextViewerComponent)this.viewerComponent).getFocusedView();
            textView.getEditor().requestFocus();
        }
    }

    public JComponent createStructureComponent() {
        TextStructure textStructure = this.getStructure((FileNode)this.context.getNode());
        if (textStructure != null) {
            return new TextStructureView(textStructure);
        }
        return null;
    }

    public JComponent createViewerComponent() {
        TextViewerComponent textViewerComponent = new TextViewerComponent(this.context, this);
        return textViewerComponent;
    }

    public void viewerNodeChanged() {
        if (this.structureComponent instanceof TextStructureView) {
            TextStructureView textStructureView = (TextStructureView)this.structureComponent;
            TextStructure textStructure = this.getStructure((FileNode)this.context.getNode());
            if (textStructure != null) {
                textStructureView.setTextStructure(textStructure);
            }
        }
    }

    public boolean hasExistingEditor() {
        FileNode fileNode;
        if (this.viewerComponent == null) {
            return false;
        }
        Node node = this.context.getNode();
        return node instanceof FileNode && this.hasNodeViewList(this, fileNode = (FileNode)node);
    }

    public EditorPane getEditor() {
        TextViewerComponent textViewerComponent = (TextViewerComponent)this.getViewerComponent();
        return textViewerComponent.getFocusedView().getEditor();
    }

    public Insight getInsight(FileNode fileNode) {
        return this.getNodeViewList(this, fileNode).getInsight();
    }

    public TextStructure getStructure(FileNode fileNode) {
        return this.getNodeViewList(this, fileNode).getBufferNodeList().getTextStructure();
    }

    void a(TextView textView, FileNode fileNode) {
        this.getInsight(fileNode).release(textView.getEditor());
        this.getNodeViewList(this, fileNode).removeView(textView);
        textView.release(this.context.getBrowser());
    }

    void a(TextView textView, Context context, FileNode fileNode) {
        if (fileNode instanceof TextFileNode) {
            textView.getStatus().setEncodingStatus(((TextFileNode)fileNode).getEncoding());
        }
        this.getNodeViewList(this, fileNode).addView(textView);
        this.getInsight(fileNode).activate(textView.getEditor(), context, null);
    }

    public AbstractTextNodeViewer(Context context) {
        super(context);
    }
}

