/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CBase;
import ipworks.CIPPMsg;
import ipworks.CNetCode;
import ipworks.CRfc822String;
import ipworks.Http;
import ipworks.IPWorksException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;

class CHTTP
extends CIPPMsg {
    private static final int PORT = 80;
    private static final int TRANSFER_STATUSLINE = 0;
    private static final int TRANSFER_HEADERS = 1;
    private static final int TRANSFER_ENTITY = 2;
    private static final int FR_NEVER = 0;
    private static final int FR_SAME_SCHEME = 1;
    private static final int FR_ALWAYS = 2;
    static final int IDLE = 0;
    static final int GET = 1;
    static final int POST = 2;
    static final int HEAD = 3;
    static final int RESET = 4;
    static final int PUT = 5;
    static final int STOCK_NOT = 0;
    static final int STOCK_BUFFER = 1;
    static final int STOCK_FILE = 2;
    private int action = 0;
    private int transferState;
    private int stockMethod;
    private int bytesTransferred;
    private boolean toWriteToLocalFile = true;
    private String url;
    private String urlScheme;
    private String urlServer;
    private String urlPath;
    private String user;
    private String password;
    private String authorization;
    private String accept;
    private String from;
    private String ifModifiedSince;
    private String referer;
    private String pragma;
    private String otherHeaders;
    private String statusLine;
    private String httpVersion = "HTTP/1.0";
    private String userAgent = "/n software's HTTP Control";
    private int urlPort;
    private byte[] postData;
    private int postDataOffset;
    private int postDataLength;
    private String contentType;
    private String proxyServer = "";
    private int proxyPort = 80;
    private String httpMethod = "";
    private int followRedirects = 0;
    private int maxTransferredData = 4096;
    private Vector cookieNames = new Vector();
    private Vector cookieValues = new Vector();
    private String proxyUser;
    private String proxyPassword;
    private String proxyAuthorization;
    private StringBuffer transferredHeaders = new StringBuffer();
    private StringBuffer transferredData = new StringBuffer();
    private String redirectLocation = "";
    private CNetCode netcode = new CNetCode(null, new Object());
    private Http sink = null;

    CHTTP(Http http, Object object) {
        super(null, object);
        this.sink = http;
        try {
            this.setInBufferSize(20000);
            this.setMaxLineLength(20000);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
        this.netcode.format = 1;
        this.resetHeaders();
    }

    void do_Get(String string) throws IPWorksException {
        this.setURL(string);
        this.setAction(1);
    }

    void do_Head(String string) throws IPWorksException {
        this.setURL(string);
        this.setAction(3);
    }

    void do_Interrupt() throws IPWorksException {
        this.setAction(0);
    }

    void do_Post(String string) throws IPWorksException {
        this.setURL(string);
        this.setAction(2);
    }

    void do_Put(String string) throws IPWorksException {
        this.setURL(string);
        this.setAction(5);
    }

    void do_ResetHeaders() throws IPWorksException {
        this.setAction(4);
    }

    void do_AddCookie(String string, String string2) throws IPWorksException {
        this.cookieNames.addElement(string);
        this.cookieValues.addElement(string2);
    }

    private void sendRequestHeaders(String string) throws IPWorksException {
        this.setEOL(CBase.CRLFB);
        if (this.urlServer.length() == 0) {
            throw new IPWorksException(152);
        }
        if (this.proxyServer.length() > 0) {
            try {
                this.setRemoteHost(this.proxyServer);
                this.setRemotePort(this.proxyPort);
            }
            catch (IPWorksException iPWorksException) {}
        } else if (this.urlScheme.equalsIgnoreCase("http")) {
            try {
                this.setRemoteHost(this.urlServer);
                this.setRemotePort(this.urlPort);
            }
            catch (IPWorksException iPWorksException) {}
        } else {
            throw new IPWorksException(153);
        }
        this.blockConnect();
        StringBuffer stringBuffer = new StringBuffer(string + " ");
        if (this.proxyServer.length() > 0) {
            stringBuffer.append(this.urlScheme + "://" + this.urlServer);
            if (this.urlPort != 80) {
                stringBuffer.append(":" + this.urlPort);
            }
        }
        stringBuffer.append(this.urlPath + " " + this.httpVersion + "\r\n");
        if (this.authorization.length() > 0) {
            stringBuffer.append("Authorization: " + this.authorization + "\r\n");
        }
        if (this.accept.length() > 0) {
            stringBuffer.append("Accept: " + this.accept + "\r\n");
        }
        if (this.from.length() > 0) {
            stringBuffer.append("From: " + this.from + "\r\n");
        }
        if (this.userAgent.length() > 0) {
            stringBuffer.append("User-Agent: " + this.userAgent + "\r\n");
        }
        if (this.ifModifiedSince.length() > 0) {
            stringBuffer.append("If-Modified-Since: " + this.ifModifiedSince + "\r\n");
        }
        if (this.referer.length() > 0) {
            stringBuffer.append("Referer: " + this.referer + "\r\n");
        }
        if (this.pragma.length() > 0) {
            stringBuffer.append("Pragma: " + this.pragma + "\r\n");
        }
        if (this.getCookieCount() > 0) {
            stringBuffer.append("Cookie: ").append((String)this.cookieNames.elementAt(0)).append("=").append(this.cookieValues.elementAt(0));
            int n = this.getCookieCount();
            int n2 = 1;
            while (n2 < n) {
                stringBuffer.append("; ").append((String)this.cookieNames.elementAt(n2)).append("=").append(this.cookieValues.elementAt(n2));
                ++n2;
            }
            stringBuffer.append("\r\n");
        }
        if (this.otherHeaders.length() > 0) {
            stringBuffer.append(this.otherHeaders);
        }
        this.blockSend(stringBuffer.toString());
    }

    private void sendRequestWithoutData(String string) throws IPWorksException {
        this.sendRequestHeaders(string);
        this.blockSend(CBase.CRLFB);
        this.waitForReply();
        this.finalizeRequest();
    }

    private void sendRequestWithData(String string) throws IPWorksException {
        block14: {
            this.sendRequestHeaders(string);
            long l = (long)this.postDataLength + this.getAttachedFileSize();
            StringBuffer stringBuffer = new StringBuffer();
            if (this.contentType.length() > 0) {
                stringBuffer.append("Content-Type: " + this.contentType + "\r\n");
            }
            if (l > 0L) {
                stringBuffer.append("Content-Length: " + l + "\r\n");
            }
            stringBuffer.append("\r\n");
            try {
                Object object = this.syncObj;
                synchronized (object) {
                    this.lastReply = null;
                    this.setAcceptData(true);
                }
                this.blockSend(stringBuffer.toString());
                if (l > 0L) {
                    this.bytesSent = 0;
                    this.fireStartTransfer(0);
                    if (this.postDataLength > 0) {
                        this.blockSend(this.postData, this.postDataOffset, this.postDataLength, 2);
                    }
                    if (this.attachedFile.length() > 0) {
                        this.sendAttachedFile(true, 2);
                    }
                    this.fireEndTransfer(0);
                }
                Object object2 = this.syncObj;
                synchronized (object2) {
                    if (this.lastReply == null) {
                        this.waitForReply();
                    }
                }
                this.finalizeRequest();
            }
            catch (IPWorksException iPWorksException) {
                if (this.pendingException != null) break block14;
                this.pendingException = iPWorksException;
            }
        }
    }

    private void finalizeRequest() throws IPWorksException {
        this.closeLocalFile();
        this.statusLine = this.lastReply;
        try {
            this.waitForDisconnect();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.checkReply();
            throw throwable;
        }
        this.checkReply();
        if (this.transferState == 2) {
            this.fireEndTransfer(1);
        }
    }

    private void checkReply() throws IPWorksException {
        String string;
        int n = this.statusLine.indexOf(32);
        String string2 = string = n == -1 ? "No reply code from server." : this.statusLine.substring(n + 1);
        if (!string.startsWith("2")) {
            if (this.followRedirects == 0 || (this.action == 1 || this.action == 3) && (string.startsWith("304") || string.startsWith("305")) || this.followRedirects == 1 && !this.redirectLocation.startsWith(this.urlScheme + ":")) {
                this.redirectLocation = "";
            }
            throw new IPWorksException(151, string);
        }
    }

    private long getAttachedFileSize() {
        return new File(this.attachedFile).length();
    }

    void fireDataIn(byte[] byArray, boolean bl) {
        switch (this.transferState) {
            case 0: {
                super.fireDataIn(byArray, bl);
                this.transferState = 1;
                this.setAcceptData(true);
                break;
            }
            case 1: {
                if (byArray.length > 0) {
                    String string = new String(byArray);
                    this.transferredHeaders.append(string + "\r\n");
                    String string2 = CRfc822String.getField(string);
                    String string3 = CRfc822String.getValue(string);
                    this.fireHeader(string2, string3);
                    string2 = string2.toLowerCase();
                    if (this.followRedirects != 0 && string2.startsWith("location")) {
                        this.redirectLocation = string3;
                        break;
                    }
                    if (!string2.startsWith("set-cookie")) break;
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, ";");
                    String string4 = "";
                    String string5 = "";
                    String string6 = "";
                    boolean bl2 = false;
                    String string7 = "";
                    String string8 = "";
                    try {
                        String string9 = stringTokenizer.nextToken().trim();
                        int n = string9.indexOf("=");
                        string7 = string9.substring(0, n);
                        string8 = string9.substring(n + 1);
                        while (true) {
                            string9 = stringTokenizer.nextToken().trim();
                            n = string9.indexOf("=");
                            String string10 = string9.substring(0, n);
                            String string11 = string9.substring(n + 1);
                            if (string10.equalsIgnoreCase("expires")) {
                                string4 = string11;
                                continue;
                            }
                            if (string10.equalsIgnoreCase("domain")) {
                                string5 = string11;
                                continue;
                            }
                            if (string10.equalsIgnoreCase("path")) {
                                string6 = string11;
                                continue;
                            }
                            if (!string10.equalsIgnoreCase("secure")) continue;
                            bl2 = true;
                        }
                    }
                    catch (Exception exception) {
                        this.fireSetCookie(string7, string8, string4, string5, string6, bl2);
                        break;
                    }
                }
                this.transferState = 2;
                if (this.localFile.length() > 0) {
                    try {
                        this.openLocalFile();
                        this.stockMethod = 2;
                    }
                    catch (IPWorksException iPWorksException) {
                        this.stockMethod = 0;
                        this.fireError(iPWorksException);
                    }
                } else {
                    this.stockMethod = 1;
                }
                this.setEOL(CBase.BYTE0);
                this.bytesTransferred = 0;
                this.fireStartTransfer(1);
                break;
            }
            case 2: {
                this.bytesTransferred += byArray.length;
                if (this.stockMethod == 1) {
                    if (this.maxTransferredData == 0 || this.bytesTransferred <= this.maxTransferredData) {
                        this.transferredData.append(new String(byArray));
                    } else {
                        int n = this.maxTransferredData - (this.bytesTransferred - byArray.length);
                        if (n > 0) {
                            this.transferredData.append(new String(byArray, 0, n));
                        }
                    }
                } else if (this.stockMethod == 2) {
                    try {
                        this.writeToLocalFile(byArray);
                    }
                    catch (IPWorksException iPWorksException) {
                        this.stockMethod = 0;
                        this.fireError(iPWorksException);
                    }
                }
                this.fireTransfer(1, this.bytesTransferred, byArray);
            }
        }
    }

    private void resetHeaders() {
        this.urlPort = 80;
        this.postData = CBase.BYTE0;
        this.postDataOffset = 0;
        this.postDataLength = 0;
        this.localFile = "";
        this.attachedFile = "";
        this.statusLine = "";
        this.otherHeaders = "";
        this.pragma = "";
        this.referer = "";
        this.ifModifiedSince = "";
        this.from = "";
        this.accept = "";
        this.authorization = "";
        this.password = "";
        this.user = "";
        this.contentType = "";
        this.urlPath = "";
        this.urlServer = "";
        this.urlScheme = "";
        this.url = "";
        this.redirectLocation = "";
        this.proxyAuthorization = "";
        this.proxyPassword = "";
        this.proxyUser = "";
        this.httpMethod = "";
        try {
            this.setCookieCount(0);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
    }

    int getAction() {
        return this.action;
    }

    void setAction(int n) throws IPWorksException {
        this.setHTTPAction(n);
    }

    /*
     * Loose catch block
     */
    private void setHTTPAction(int n) throws IPWorksException {
        Object object;
        if (n == 0) {
            this.interrupt();
            return;
        }
        Object object2 = this.syncObj;
        synchronized (object2) {
            if (this.action != 0) {
                throw new IPWorksException(154);
            }
            this.restart();
            this.action = n;
        }
        this.statusLine = "";
        this.redirectLocation = "";
        this.transferState = 0;
        this.transferredHeaders.setLength(0);
        this.transferredData.setLength(0);
        try {
            switch (n) {
                case 1: {
                    this.sendRequestWithoutData("GET");
                    break;
                }
                case 2: {
                    this.sendRequestWithData("POST");
                    break;
                }
                case 5: {
                    this.sendRequestWithData("PUT");
                    break;
                }
                case 3: {
                    this.sendRequestWithoutData("HEAD");
                    break;
                }
                case 4: {
                    this.resetHeaders();
                }
            }
            Object var5_5 = null;
            this.closeLocalFile();
            object = this.syncObj;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.closeLocalFile();
            Object object3 = this.syncObj;
            synchronized (object3) {
                this.action = 0;
                if (this.pendingException != null) {
                    if (this.pendingException.getCode() == 151 && this.redirectLocation.length() > 0) {
                        this.setURL(this.redirectLocation);
                        try {
                            this.setConnected(false, 0L);
                        }
                        catch (IPWorksException iPWorksException) {
                            // empty catch block
                        }
                        this.setHTTPAction(n);
                    } else {
                        if (this.pendingException.getCode() == 201) {
                            try {
                                this.setConnected(false, 0L);
                            }
                            catch (IPWorksException iPWorksException) {
                                // empty catch block
                            }
                        }
                        throw this.pendingException;
                    }
                }
            }
            throw throwable;
        }
        synchronized (object) {
            this.action = 0;
            if (this.pendingException != null) {
                if (this.pendingException.getCode() == 151 && this.redirectLocation.length() > 0) {
                    this.setURL(this.redirectLocation);
                    try {
                        this.setConnected(false, 0L);
                    }
                    catch (IPWorksException iPWorksException) {
                        // empty catch block
                    }
                    this.setHTTPAction(n);
                } else {
                    if (this.pendingException.getCode() == 201) {
                        try {
                            this.setConnected(false, 0L);
                        }
                        catch (IPWorksException iPWorksException) {
                            // empty catch block
                        }
                    }
                    throw this.pendingException;
                }
            }
        }
        {
            catch (IPWorksException iPWorksException) {
                if (this.pendingException == null) {
                    this.pendingException = iPWorksException;
                }
                Object var5_6 = null;
                this.closeLocalFile();
                Object object4 = this.syncObj;
                synchronized (object4) {
                    this.action = 0;
                    if (this.pendingException != null) {
                        if (this.pendingException.getCode() == 151 && this.redirectLocation.length() > 0) {
                            this.setURL(this.redirectLocation);
                            try {
                                this.setConnected(false, 0L);
                            }
                            catch (IPWorksException iPWorksException2) {
                                // empty catch block
                            }
                            this.setHTTPAction(n);
                        } else {
                            if (this.pendingException.getCode() == 201) {
                                try {
                                    this.setConnected(false, 0L);
                                }
                                catch (IPWorksException iPWorksException3) {
                                    // empty catch block
                                }
                            }
                            throw this.pendingException;
                        }
                    }
                }
            }
        }
    }

    String getURL() {
        return this.url;
    }

    void setURL(String string) {
        this.url = string != null ? string : "";
        try {
            String string2;
            URL uRL = new URL(this.url);
            this.urlScheme = uRL.getProtocol();
            this.urlServer = uRL.getHost();
            this.urlPort = uRL.getPort();
            if (this.urlPort == -1) {
                this.urlPort = 80;
            }
            this.urlPath = uRL.getFile();
            if (this.urlPath.length() == 0) {
                this.urlPath = "/";
            }
            if ((string2 = uRL.getRef()) != null) {
                this.urlPath = this.urlPath + "#" + string2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    String getURLScheme() {
        return this.urlScheme;
    }

    void setURLScheme(String string) {
        this.urlScheme = string != null ? string : "";
    }

    String getURLServer() {
        return this.urlServer;
    }

    void setURLServer(String string) {
        this.urlServer = string != null ? string : "";
    }

    int getURLPort() {
        return this.urlPort;
    }

    void setURLPort(int n) {
        this.urlPort = n;
    }

    String getURLPath() {
        return this.urlPath;
    }

    void setURLPath(String string) {
        this.urlPath = string != null ? string : "";
    }

    String getProxyUser() {
        return this.proxyUser;
    }

    void setProxyUser(String string) {
        this.proxyUser = string == null ? "" : string;
    }

    String getProxyPassword() {
        return this.proxyPassword;
    }

    void setProxyPassword(String string) {
        this.proxyPassword = string == null ? "" : string;
    }

    String getProxyAuthorization() {
        return this.proxyAuthorization;
    }

    void setProxyAuthorization(String string) {
        this.proxyAuthorization = string == null ? "" : string;
    }

    String getProxyServer() {
        return this.proxyServer;
    }

    void setProxyServer(String string) {
        this.proxyServer = string != null ? string : "";
    }

    int getProxyPort() {
        return this.proxyPort;
    }

    void setProxyPort(int n) {
        this.proxyPort = n;
    }

    byte[] getPostData() {
        return this.postData;
    }

    void setPostData(byte[] byArray) {
        this.postData = byArray != null ? byArray : CBase.BYTE0;
        this.postDataOffset = 0;
        this.postDataLength = this.postData.length;
    }

    void setPostData(byte[] byArray, int n, int n2) throws IPWorksException {
        this.postData = byArray != null ? byArray : CBase.BYTE0;
        byte by = this.postData[n];
        by = this.postData[n + n2 - 1];
        this.postDataOffset = n;
        this.postDataLength = n2;
    }

    String getContentType() {
        return this.contentType;
    }

    void setContentType(String string) {
        this.contentType = string != null ? string : "";
    }

    private void updateAuthorization() {
        if (this.user.length() == 0 && this.password.length() == 0) {
            this.authorization = "";
        } else {
            this.netcode.setDecodedData((this.user + ":" + this.password).getBytes());
            try {
                this.netcode.setAction(4);
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
            this.authorization = "Basic " + new String(this.netcode.getEncodedData());
        }
    }

    String getUser() {
        return this.user;
    }

    void setUser(String string) {
        this.user = string != null ? string : "";
        this.updateAuthorization();
    }

    String getPassword() {
        return this.password;
    }

    void setPassword(String string) {
        this.password = string != null ? string : "";
        this.updateAuthorization();
    }

    String getAuthorization() {
        return this.authorization;
    }

    void setAuthorization(String string) {
        this.authorization = string != null ? string : "";
    }

    String getAccept() {
        return this.accept;
    }

    void setAccept(String string) {
        this.accept = string != null ? string : "";
    }

    String getFrom() {
        return this.from;
    }

    void setFrom(String string) {
        this.from = string != null ? string : "";
    }

    String getUserAgent() {
        return this.userAgent;
    }

    void setUserAgent(String string) {
        this.userAgent = string != null ? string : "";
    }

    String getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    void setIfModifiedSince(String string) {
        this.ifModifiedSince = string != null ? string : "";
    }

    String getReferer() {
        return this.referer;
    }

    void setReferer(String string) {
        this.referer = string != null ? string : "";
    }

    String getPragma() {
        return this.pragma;
    }

    void setPragma(String string) {
        this.pragma = string != null ? string : "";
    }

    String getOtherHeaders() {
        return this.otherHeaders;
    }

    void setOtherHeaders(String string) {
        this.otherHeaders = string != null ? CIPPMsg.toValidHeader(string) : "";
    }

    String getStatusLine() {
        return this.statusLine;
    }

    String getHTTPVersion() {
        return this.httpVersion;
    }

    void setHTTPVersion(String string) {
        this.httpVersion = string != null ? string : "";
    }

    int getFollowRedirects() {
        return this.followRedirects;
    }

    void setFollowRedirects(int n) {
        this.followRedirects = n;
    }

    int getMaxTransferredData() {
        return this.maxTransferredData;
    }

    void setMaxTransferredData(int n) {
        this.maxTransferredData = n > 0 ? n : 0;
    }

    int getCookieCount() {
        return this.cookieNames.size();
    }

    void setCookieCount(int n) throws IPWorksException {
        int n2 = n > 0 ? n : 0;
        this.cookieNames.setSize(n2);
        this.cookieValues.setSize(n2);
    }

    void checkCookieIndex(int n) throws IPWorksException {
        if (n < 0 || n >= this.cookieNames.size()) {
            throw new IPWorksException(301);
        }
    }

    String getCookieName(int n) throws IPWorksException {
        this.checkCookieIndex(--n);
        return (String)this.cookieNames.elementAt(n);
    }

    void setCookieName(int n, String string) throws IPWorksException {
        this.checkCookieIndex(--n);
        this.cookieNames.setElementAt(string, n);
    }

    String getCookieValue(int n) throws IPWorksException {
        this.checkCookieIndex(--n);
        return (String)this.cookieValues.elementAt(n);
    }

    void setCookieValue(int n, String string) throws IPWorksException {
        this.checkCookieIndex(--n);
        this.cookieValues.setElementAt(string, n);
    }

    String getHTTPMethod() {
        return this.httpMethod;
    }

    void setHTTPMethod(String string) {
        this.httpMethod = string == null ? "" : string;
    }

    byte[] getTransferredData() {
        return this.transferredData.toString().getBytes();
    }

    String getTransferredHeaders() {
        return this.transferredHeaders.toString();
    }

    void fireConnected(IPWorksException iPWorksException) {
        super.fireConnected(iPWorksException);
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireConnected(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireConnected(0, "OK");
            }
        }
    }

    void fireDisconnected(IPWorksException iPWorksException) {
        super.fireDisconnected(iPWorksException);
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireDisconnected(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireDisconnected(0, "OK");
            }
        }
    }

    void fireHeader(String string, String string2) {
        if (this.sink != null && this.pendingException == null) {
            this.sink.fireHeader(string, string2);
        }
    }

    void fireStartTransfer(int n) {
        if (this.sink != null && this.pendingException == null) {
            this.sink.fireStartTransfer(n);
        }
    }

    void fireTransfer(int n, byte[] byArray) {
        if (this.sink != null && this.pendingException == null) {
            this.sink.fireTransfer(0, n, byArray);
        }
    }

    void fireTransfer(int n, int n2, byte[] byArray) {
        if (this.sink != null && this.pendingException == null) {
            this.sink.fireTransfer(n, n2, byArray);
        }
    }

    void fireEndTransfer(int n) {
        if (this.sink != null && this.pendingException == null) {
            this.sink.fireEndTransfer(n);
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }

    void fireSetCookie(String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (this.sink != null && this.pendingException == null) {
            this.sink.fireSetCookie(string, string2, string3, string4, string5, bl);
        }
    }
}

