/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CIPPortNoFirewall;
import ipworks.IPWorksException;
import ipworks.Ipdaemon;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

class CIPDaemon {
    private static final int MAX_CONNECTIONS = 1000;
    protected Object syncObj;
    private Ipdaemon sink;
    private CListenerThread listenerThread;
    private CIPPortNoFirewall[] ipport = new CIPPortNoFirewall[1000];
    private String localHost = "";
    private int localPort;
    private int inBufferSize = 2048;
    private int outBufferSize = 2048;
    private int maxLineLength = 2048;
    private boolean listening = false;
    private boolean linger = true;
    private boolean keepAlive = false;
    private int connectionBacklog;
    private int currentId;
    private int connectionCount;
    private int timeout = 0;

    CIPDaemon(Ipdaemon ipdaemon, Object object) {
        this.sink = ipdaemon;
        this.syncObj = object;
    }

    void do_Disconnect(int n) throws IPWorksException {
        this.setConnected(n, false);
    }

    void do_Send(int n, byte[] byArray) throws IPWorksException {
        this.setDataToSend(n, byArray);
    }

    void setTimeout(int n) {
        Object object = this.syncObj;
        synchronized (object) {
            this.timeout = n;
            this.syncObj.notifyAll();
        }
    }

    int getTimeout() {
        return this.timeout;
    }

    void setListening(boolean bl) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (bl) {
                if (this.listening) {
                    throw new IPWorksException(105);
                }
                try {
                    this.listenerThread = new CListenerThread();
                    this.listenerThread.start();
                }
                catch (IOException iOException) {
                    throw new IPWorksException(127);
                }
            } else if (this.listening) {
                this.listenerThread.terminate();
            }
            this.listening = bl;
        }
    }

    int getConnectionCount() {
        return this.connectionCount;
    }

    int getConnectionBacklog() {
        return this.connectionBacklog;
    }

    void setConnectionBacklog(int n) throws IPWorksException {
        this.connectionBacklog = n > 0 ? n : 0;
    }

    void setLocalHost(String string) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.listening) {
                throw new IPWorksException(107);
            }
            this.localHost = string != null ? string : "";
        }
    }

    String getLocalHost() {
        return this.localHost;
    }

    boolean getListening() {
        return this.listening;
    }

    private boolean registerNewConnection(Socket socket) {
        Object object = this.syncObj;
        synchronized (object) {
            int n = this.currentId;
            while (this.ipport[this.currentId] != null) {
                ++this.currentId;
                if (this.currentId == 1000) {
                    this.currentId = 0;
                }
                if (this.currentId != n) continue;
                boolean bl = false;
                return bl;
            }
            CIPDaemonPort cIPDaemonPort = new CIPDaemonPort(this.currentId, socket);
            try {
                cIPDaemonPort.setInBufferSize(this.inBufferSize);
                cIPDaemonPort.setOutBufferSize(this.outBufferSize);
                cIPDaemonPort.setMaxLineLength(this.maxLineLength);
                cIPDaemonPort.setLinger(this.linger);
                cIPDaemonPort.setKeepAlive(this.keepAlive);
                this.ipport[this.currentId] = cIPDaemonPort;
                cIPDaemonPort.setConnected(true);
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
            boolean bl = true;
            return bl;
        }
    }

    void setConnected(int n, boolean bl) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (bl) {
                throw new IPWorksException(127);
            }
            if (this.ipport[n] == null) {
                throw new IPWorksException(127);
            }
            this.ipport[n].setConnected(bl);
        }
    }

    boolean getConnected(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.ipport[n] == null) {
                throw new IPWorksException(127);
            }
            boolean bl = this.ipport[n].getConnected();
            return bl;
        }
    }

    void setAcceptData(int n, boolean bl) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.ipport[n] == null) {
                throw new IPWorksException(127);
            }
            this.ipport[n].setAcceptData(bl);
        }
    }

    boolean getAcceptData(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.ipport[n] == null) {
                throw new IPWorksException(127);
            }
            boolean bl = this.ipport[n].getAcceptData();
            return bl;
        }
    }

    void setDataToSend(int n, byte[] byArray, int n2, int n3) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.ipport[n] == null) {
                throw new IPWorksException(127);
            }
            this.ipport[n].setDataToSend(byArray, n2, n3);
        }
    }

    void setDataToSend(int n, byte[] byArray) throws IPWorksException {
        this.setDataToSend(n, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    int getBytesSent(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.ipport[n] == null) {
                throw new IPWorksException(127);
            }
            int n2 = this.ipport[n].getBytesSent();
            return n2;
        }
    }

    void setEOL(int n, byte[] byArray, int n2, int n3) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.ipport[n] == null) {
                throw new IPWorksException(127);
            }
            this.ipport[n].setEOL(byArray);
        }
    }

    void setEOL(int n, byte[] byArray) throws IPWorksException {
        this.setEOL(n, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    byte[] getEOL(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.ipport[n] == null) {
                throw new IPWorksException(127);
            }
            byte[] byArray = this.ipport[n].getEOL();
            return byArray;
        }
    }

    void setMaxLineLength(int n) {
        if (n <= 0) {
            return;
        }
        this.maxLineLength = n;
    }

    int getMaxLineLength() {
        return this.maxLineLength;
    }

    void setLinger(boolean bl) {
        this.linger = bl;
    }

    boolean getLinger() {
        return this.linger;
    }

    void setKeepAlive(boolean bl) {
        this.keepAlive = bl;
    }

    boolean getKeepAlive() {
        return false;
    }

    void setInBufferSize(int n) {
        this.inBufferSize = n < 2048 ? 2048 : n;
    }

    int getInBufferSize() {
        return this.inBufferSize;
    }

    void setOutBufferSize(int n) {
        this.outBufferSize = n < 2048 ? 2048 : n;
    }

    int getOutBufferSize() {
        return this.outBufferSize;
    }

    String getLocalAddress(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.ipport[n] == null) {
                throw new IPWorksException(127);
            }
            String string = this.ipport[n].getLocalHost();
            return string;
        }
    }

    void setLocalPort(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.listening) {
                throw new IPWorksException(107);
            }
            this.localPort = n;
        }
    }

    int getLocalPort() {
        Object object = this.syncObj;
        synchronized (object) {
            int n = this.listening ? this.listenerThread.serverSocket.getLocalPort() : this.localPort;
            return n;
        }
    }

    String getRemoteHost(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.ipport[n] == null) {
                throw new IPWorksException(127);
            }
            String string = this.ipport[n].getRemoteHost();
            return string;
        }
    }

    int getRemotePort(int n) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.ipport[n] == null) {
                throw new IPWorksException(127);
            }
            int n2 = this.ipport[n].getRemotePort();
            return n2;
        }
    }

    void fireConnected(int n, IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireConnected(n, iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireConnected(n, 0, "OK");
            }
        }
    }

    void fireDataIn(int n, byte[] byArray, boolean bl) {
        if (this.sink != null) {
            this.sink.fireDataIn(n, byArray, bl);
        }
    }

    void fireDisconnected(int n, IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireDisconnected(n, iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireDisconnected(n, 0, "OK");
            }
        }
    }

    void fireReadyToSend(int n) {
        if (this.sink != null) {
            this.sink.fireReadyToSend(n);
        }
    }

    void fireError(int n, IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage() + " " + n);
            } else {
                this.sink.fireError(0, "OK " + n);
            }
        }
    }

    class CListenerThread
    extends Thread {
        ServerSocket serverSocket;

        CListenerThread() throws IOException {
            try {
                if (CIPDaemon.this.localHost.length() == 0) {
                    this.serverSocket = CIPDaemon.this.connectionBacklog == 0 ? new ServerSocket(CIPDaemon.this.localPort) : new ServerSocket(CIPDaemon.this.localPort, CIPDaemon.this.connectionBacklog);
                } else {
                    InetAddress inetAddress = InetAddress.getByName(CIPDaemon.this.localHost);
                    this.serverSocket = new ServerSocket(CIPDaemon.this.localPort, CIPDaemon.this.connectionBacklog > 0 ? CIPDaemon.this.connectionBacklog : 50, inetAddress);
                }
            }
            catch (Exception exception) {
                this.serverSocket = CIPDaemon.this.connectionBacklog > 0 ? new ServerSocket(CIPDaemon.this.localPort, CIPDaemon.this.connectionBacklog) : new ServerSocket(CIPDaemon.this.localPort);
            }
            this.serverSocket.setSoTimeout(100);
        }

        void terminate() {
            CIPDaemon.this.syncObj.notifyAll();
        }

        public void run() {
            while (CIPDaemon.this.listening) {
                try {
                    if (CIPDaemon.this.registerNewConnection(this.serverSocket.accept())) continue;
                    Object object = CIPDaemon.this.syncObj;
                    synchronized (object) {
                        CIPDaemon.this.syncObj.wait();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class CIPDaemonPort
    extends CIPPortNoFirewall {
        private int id;

        CIPDaemonPort(int n, Socket socket) {
            super(null, socket, CIPDaemon.this.syncObj);
            this.id = n;
            this.setTimeout(CIPDaemon.this.timeout);
        }

        void fireReadyToSend() {
            CIPDaemon.this.fireReadyToSend(this.id);
        }

        void fireDataIn(byte[] byArray, boolean bl) {
            CIPDaemon.this.fireDataIn(this.id, byArray, bl);
        }

        void fireConnected(IPWorksException iPWorksException) {
            if (iPWorksException != null) {
                ((CIPDaemon)CIPDaemon.this).ipport[this.id] = null;
            }
            if (CIPDaemon.this.listening) {
                if (iPWorksException == null) {
                    CIPDaemon.this.connectionCount++;
                }
                CIPDaemon.this.fireConnected(this.id, iPWorksException);
            } else if (iPWorksException == null) {
                try {
                    ((CIPDaemon)CIPDaemon.this).ipport[this.id] = null;
                    this.setConnected(false, 0L);
                }
                catch (IPWorksException iPWorksException2) {
                    // empty catch block
                }
            }
            if (CIPDaemon.this.ipport[this.id] == null) {
                CIPDaemon.this.syncObj.notifyAll();
            }
        }

        void fireDisconnected(IPWorksException iPWorksException) {
            if (CIPDaemon.this.ipport[this.id] != null) {
                CIPDaemon.this.connectionCount--;
                CIPDaemon.this.fireDisconnected(this.id, iPWorksException);
                ((CIPDaemon)CIPDaemon.this).ipport[this.id] = null;
                CIPDaemon.this.syncObj.notifyAll();
            }
        }

        void fireError(IPWorksException iPWorksException) {
            CIPDaemon.this.fireError(this.id, iPWorksException);
        }
    }
}

