/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CIPPort;
import ipworks.CRfc822FileInputStream;
import ipworks.IPWorksException;
import ipworks.Ipport;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.Socket;

class CIPPMsg
extends CIPPort {
    protected static final boolean normal = true;
    protected static final boolean rfc822 = false;
    static final int DIRECTION_CLIENT = 0;
    static final int DIRECTION_SERVER = 1;
    static final int DIRECTION_INFO = 2;
    private StringBuffer lastReplyBuffer = new StringBuffer();
    protected String lastReply = null;
    protected String localFile = "";
    protected String attachedFile = "";
    private FileOutputStream fos = null;
    protected long timestart;
    protected int bytesSent = 0;

    CIPPMsg(Ipport ipport, Object object) {
        super(ipport, object);
        this.setTimeout(60000);
    }

    CIPPMsg(Ipport ipport, Socket socket, Object object) {
        super(ipport, socket, object);
        this.setTimeout(60000);
    }

    void setTimeout(int n) {
        if (n == Integer.MAX_VALUE) {
            --n;
        }
        super.setTimeout(n == 0 ? 2147483 : n);
    }

    int getTimeout() {
        return super.getTimeout() == 2147483 ? 0 : this.timeout;
    }

    String getLastReply() {
        return this.lastReply;
    }

    String getLocalFile() {
        return this.localFile;
    }

    void setLocalFile(String string) {
        Object object = this.syncObj;
        synchronized (object) {
            this.localFile = string != null ? string : "";
        }
    }

    String getAttachedFile() {
        return this.attachedFile;
    }

    void setAttachedFile(String string) {
        Object object = this.syncObj;
        synchronized (object) {
            this.attachedFile = string != null ? string : "";
        }
    }

    void sendMessage(byte[] byArray) throws IPWorksException {
        this.setDataToSend(byArray, this.timestart, 1);
        this.waitForReply();
    }

    void sendCommand(String string, String string2) throws IPWorksException {
        if (string != null) {
            this.setDataToSend((string + string2).getBytes(), this.timestart, 1);
        }
        this.waitForReply();
    }

    void blockSend(String string, int n) throws IPWorksException {
        this.blockSend(string.getBytes(), n);
    }

    void blockSend(String string) throws IPWorksException {
        this.blockSend(string.getBytes(), 1);
    }

    void blockSend(byte[] byArray, int n, int n2, int n3) throws IPWorksException {
        this.setDataToSend(byArray, n, n2, this.timestart, n3);
    }

    void blockSend(byte[] byArray, int n) throws IPWorksException {
        this.setDataToSend(byArray, this.timestart, n);
    }

    void blockSend(byte[] byArray) throws IPWorksException {
        this.blockSend(byArray, 1);
    }

    void blockConnect() throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.getConnected()) {
                return;
            }
            this.setAcceptData(false);
            this.lastReplyBuffer.setLength(0);
            this.setConnected(true);
            while (!this.getConnected()) {
                this.waitWhileProcessingEvents(this.timestart);
            }
        }
    }

    void waitForDisconnect() throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            this.setAcceptData(true);
            while (this.getConnected()) {
                this.waitWhileProcessingEvents(this.timestart);
            }
        }
    }

    protected static String toValidHeader(String string) {
        String string2 = string.endsWith("\r") ? string + "\n\r\n" : string + "\r\n\r\n";
        int n = string2.indexOf("\r\n\r\n");
        return string2.substring(0, n + 2);
    }

    void interrupt() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null) {
                this.pendingException = new IPWorksException(301);
            }
            try {
                this.setConnected(false, 0L);
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
            this.syncObj.notifyAll();
        }
    }

    void restart() {
        Object object = this.syncObj;
        synchronized (object) {
            this.timestart = this.timeout == 0 ? 0L : System.currentTimeMillis();
            this.pendingException = null;
        }
    }

    void sendLocalFile(int n) throws IPWorksException {
        try {
            this.sendFile(new FileInputStream(this.localFile), n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IPWorksException(302);
        }
    }

    protected void sendAttachedFile(boolean bl, int n) throws IPWorksException {
        try {
            this.sendFile(bl ? new FileInputStream(this.attachedFile) : new CRfc822FileInputStream(this.attachedFile), n);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IPWorksException(302);
        }
    }

    protected void openLocalFile() throws IPWorksException {
        try {
            this.fos = new FileOutputStream(this.localFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IPWorksException(303);
        }
        catch (IOException iOException) {
            throw new IPWorksException(304);
        }
    }

    protected void writeToLocalFile(byte[] byArray) throws IPWorksException {
        if (this.fos != null) {
            try {
                this.fos.write(byArray);
            }
            catch (IOException iOException) {
                this.closeLocalFile();
                throw new IPWorksException(304);
            }
        }
    }

    private void sendFile(FileInputStream fileInputStream, int n) throws IPWorksException {
        byte[] byArray = new byte[20000];
        try {
            while (true) {
                int n2;
                try {
                    n2 = fileInputStream.read(byArray);
                }
                catch (IOException iOException) {
                    throw new IPWorksException(5);
                }
                if (n2 == -1) break;
                this.blockSend(byArray, 0, n2, n);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
    }

    protected void closeLocalFile() {
        if (this.fos != null) {
            try {
                this.fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fos = null;
    }

    protected void waitForReply() throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException != null) {
                throw this.pendingException;
            }
            if (this.lastReplyBuffer.length() > 0) {
                String string = new String(this.getEOL());
                int n = this.lastReplyBuffer.toString().indexOf(string);
                if (n != -1) {
                    this.lastReply = this.lastReplyBuffer.toString().substring(0, n);
                    this.lastReplyBuffer = new StringBuffer(this.lastReplyBuffer.toString().substring(n + string.length()));
                    return;
                }
            }
            this.lastReply = null;
            this.setAcceptData(true);
            while (this.lastReply == null) {
                if (!this.getConnected()) {
                    throw this.pendingException == null ? new IPWorksException(32000) : this.pendingException;
                }
                this.waitWhileProcessingEvents(this.timestart);
            }
        }
    }

    void fireConnected(IPWorksException iPWorksException) {
        this.notifyAllAndEventsProcessor();
    }

    void fireDisconnected(IPWorksException iPWorksException) {
        this.notifyAllAndEventsProcessor();
    }

    void fireDataIn(byte[] byArray, boolean bl) {
        int n = this.lastReplyBuffer.length();
        this.lastReplyBuffer.append(new String(byArray));
        if (n > 0) {
            int n2;
            byte[] byArray2 = this.getEOL();
            if (bl) {
                this.lastReplyBuffer.append(new String(byArray2));
            }
            if ((n2 = this.lastReplyBuffer.toString().indexOf(new String(byArray2))) != -1) {
                this.lastReply = this.lastReplyBuffer.toString().substring(0, n2);
                this.lastReplyBuffer = new StringBuffer(this.lastReplyBuffer.toString().substring(n2 + byArray2.length));
                this.setAcceptData(false);
                this.notifyAllAndEventsProcessor();
            }
            return;
        }
        if (bl) {
            this.lastReply = this.lastReplyBuffer.toString();
            this.lastReplyBuffer.setLength(0);
            this.setAcceptData(false);
            this.notifyAllAndEventsProcessor();
        }
    }

    void fireReadyToSend() {
        this.notifyAllAndEventsProcessor();
    }

    void fireDataOut(int n, byte[] byArray) {
        if (this.pendingException == null) {
            this.bytesSent += n;
            this.fireTransfer(this.bytesSent, byArray);
        }
    }

    void fireTransfer(int n, byte[] byArray) {
    }
}

