/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CBase;
import ipworks.CIPPMsg;
import ipworks.CRfc822String;
import ipworks.CTokenizer;
import ipworks.IPWorksException;
import ipworks.Nntp;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;

class CNNTP
extends CIPPMsg {
    static final int idle = 0;
    static final int connect = 1;
    static final int disconnect = 2;
    static final int listGroups = 3;
    static final int listNewGroups = 4;
    static final int groupOverview = 5;
    static final int getArticle = 6;
    static final int getArticleHeaders = 7;
    static final int getArticleBody = 8;
    static final int postArticle = 9;
    static final int resetHeaders = 10;
    static final int groupSearch = 11;
    static final int actionCommand = 12;
    static final int setBogusCurrentGroup = 13;
    static final int nntpDirectClient = 0;
    static final int nntpDirectServer = 1;
    static final int nntpDirectInfo = 2;
    static final int nntpTransProtocol = 0;
    static final int nntpTransHeaders = 1;
    static final int nntpTransBody = 2;
    static final int nntpTransGroupList = 3;
    static final int nntpTransOverview = 4;
    static final int nntpTransGroupSearch = 5;
    private static final int defaultPort = 119;
    private int bytesTransferred;
    private int action = 0;
    private int transferState = 0;
    private int maxLines = 0;
    private int maxHeaderLength = 80;
    private int firstArticle = 0;
    private int lastArticle = 0;
    private int articleCount = 0;
    private String from;
    private String replyTo;
    private String subject;
    private String newsgroups;
    private String references;
    private String organization;
    private String otherHeaders;
    private String command;
    private StringBuffer articleHeaders;
    private StringBuffer articleText;
    private String user = "";
    private String password = "";
    private String currentGroup = "";
    private String currentArticle = "";
    private String checkDate = "000101 000000";
    private String overviewRange = "-";
    private String searchHeader = "";
    private String searchPattern = "";
    private String searchRange = "";
    private StringBuffer allDataIn = null;
    private OutputStream fos;
    private boolean lastWasEndOfLine;
    private Nntp sink = null;

    CNNTP(Nntp nntp, Object object) {
        super(null, object);
        this.sink = nntp;
        try {
            this.setInBufferSize(20000);
            this.setMaxLineLength(20000);
            this.setRemotePort(119);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
        this.setEOL(CBase.CRLFB);
        this.doActionResetHeaders();
    }

    void do_Connect() throws IPWorksException {
        this.setAction(1);
    }

    void do_Disconnect() throws IPWorksException {
        this.setAction(2);
    }

    void do_FetchArticle() throws IPWorksException {
        this.setAction(6);
    }

    void do_FetchArticleBody() throws IPWorksException {
        this.setAction(8);
    }

    void do_FetchArticleHeaders() throws IPWorksException {
        this.setAction(7);
    }

    void do_GroupOverview() throws IPWorksException {
        this.setAction(5);
    }

    void do_GroupSearch() throws IPWorksException {
        this.setAction(11);
    }

    void do_Interrupt() throws IPWorksException {
        this.setAction(0);
    }

    void do_ListGroups() throws IPWorksException {
        this.setAction(3);
    }

    void do_ListNewGroups() throws IPWorksException {
        this.setAction(4);
    }

    void do_PostArticle() throws IPWorksException {
        this.setAction(9);
    }

    void do_ResetHeaders() throws IPWorksException {
        this.setAction(10);
    }

    void sendNNTPCommand(String string) throws IPWorksException {
        if (string != null) {
            this.firePITrail(0, string);
        }
        this.sendCommand(string, "\r\n");
        boolean bl = false;
        while (true) {
            this.firePITrail(1, this.lastReply);
            int n = this.lastReply.length();
            if (n <= 3 || this.lastReply.charAt(3) != '-') {
                if (n > 0) {
                    switch (this.lastReply.charAt(0)) {
                        case '1': {
                            break;
                        }
                        case '2': 
                        case '3': {
                            return;
                        }
                        default: {
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = true;
                }
            }
            if (bl) {
                throw new IPWorksException(181, this.lastReply);
            }
            this.waitForReply();
        }
    }

    private void handleTransferState(int n) throws IPWorksException {
        this.transferState = n;
        this.bytesTransferred = 0;
        this.allDataIn = new StringBuffer();
        this.setAcceptData(true);
        Object object = this.syncObj;
        synchronized (object) {
            while (this.transferState != 0) {
                if (!this.getConnected()) {
                    throw new IPWorksException(32000);
                }
                this.waitWhileProcessingEvents(this.timestart);
            }
        }
        this.setAcceptData(false);
        this.allDataIn = null;
    }

    private void doActionResetHeaders() {
        this.searchRange = "";
        this.searchPattern = "";
        this.searchHeader = "";
        this.command = "";
        this.attachedFile = "";
        this.otherHeaders = "";
        this.organization = "";
        this.references = "";
        this.newsgroups = "";
        this.subject = "";
        this.replyTo = "";
        this.from = "";
        this.articleText = null;
        this.articleHeaders = null;
    }

    private void doActionConnect() throws IPWorksException {
        if (!this.getConnected()) {
            this.firePITrail(2, "Connecting to news server.");
            this.blockConnect();
            try {
                this.sendNNTPCommand(null);
                if (this.user.length() > 0) {
                    this.sendNNTPCommand("AUTHINFO USER " + this.user);
                }
                if (this.password.length() > 0) {
                    this.sendNNTPCommand("AUTHINFO PASS " + this.password);
                }
            }
            catch (IPWorksException iPWorksException) {
                try {
                    this.doActionDisconnect();
                }
                catch (IPWorksException iPWorksException2) {
                    // empty catch block
                }
                throw iPWorksException;
            }
        }
    }

    private void doActionDisconnect() throws IPWorksException {
        if (this.getConnected()) {
            try {
                this.firePITrail(2, "Forcing disconnection from NNTP server.");
                this.sendNNTPCommand("QUIT");
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.setConnected(false);
                throw throwable;
            }
            this.setConnected(false);
            {
            }
        }
    }

    private void doActionPostArticle() throws IPWorksException {
        if (this.from.length() == 0) {
            throw new IPWorksException(184);
        }
        if (this.subject.length() == 0) {
            throw new IPWorksException(185);
        }
        if (this.newsgroups.length() == 0 && this.currentGroup.length() == 0) {
            throw new IPWorksException(186);
        }
        String string = this.newsgroups.length() > 0 ? this.newsgroups : this.currentGroup;
        this.sendNNTPCommand("POST");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("From: " + CRfc822String.getFolded(this.from, this.maxHeaderLength) + "\r\n");
        stringBuffer.append("Subject: " + CRfc822String.getFolded(this.subject, this.maxHeaderLength) + "\r\n");
        stringBuffer.append("Newsgroups: " + CRfc822String.getFolded(string, this.maxHeaderLength) + "\r\n");
        if (this.replyTo.length() > 0) {
            stringBuffer.append("Reply-To: " + CRfc822String.getFolded(this.replyTo, this.maxHeaderLength) + "\r\n");
        }
        if (this.references.length() > 0) {
            stringBuffer.append("References: " + CRfc822String.getFolded(this.references, this.maxHeaderLength) + "\r\n");
        }
        if (this.organization.length() > 0) {
            stringBuffer.append("Organization: " + CRfc822String.getFolded(this.organization, this.maxHeaderLength) + "\r\n");
        }
        if (this.otherHeaders.length() > 0) {
            stringBuffer.append(this.otherHeaders);
        }
        stringBuffer.append("\r\n");
        this.blockSend(stringBuffer.toString());
        String string2 = null;
        Object object = this.syncObj;
        synchronized (object) {
            if (this.articleText != null) {
                string2 = CRfc822String.getDoubleDoted(this.articleText.toString());
            }
        }
        if (string2 != null) {
            this.bytesSent = 0;
            this.fireStartTransfer();
            this.blockSend(string2 + "\r\n", 2);
            this.fireEndTransfer();
        }
        if (this.attachedFile.length() > 0) {
            this.bytesSent = 0;
            this.fireStartTransfer();
            this.sendAttachedFile(false, 2);
            this.fireEndTransfer();
        }
        this.blockSend("\r\n");
        this.sendNNTPCommand(".");
    }

    private void doActionGroupSearch() throws IPWorksException {
        String string = this.searchHeader + " " + this.searchRange + " " + this.searchPattern;
        this.sendNNTPCommand("XPAT " + string);
    }

    private void doActionCurrentGroup() throws IPWorksException {
        try {
            this.sendNNTPCommand("GROUP " + this.currentGroup);
            CTokenizer cTokenizer = new CTokenizer(this.lastReply, " ");
            cTokenizer.nextToken();
            this.articleCount = Integer.parseInt(cTokenizer.nextToken());
            this.firstArticle = Integer.parseInt(cTokenizer.nextToken());
            this.lastArticle = Integer.parseInt(cTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            this.currentGroup = "";
            throw new IPWorksException(181);
        }
        catch (IPWorksException iPWorksException) {
            this.currentGroup = "";
            throw iPWorksException;
        }
    }

    private void resetHeadersAndText() {
        if (this.timestart == 0L) {
            this.articleText = null;
            this.articleHeaders = null;
        } else {
            this.articleHeaders = new StringBuffer();
            this.articleText = new StringBuffer();
        }
    }

    private void parseGroupListData(String string) throws IPWorksException {
        CTokenizer cTokenizer = new CTokenizer(string, " ");
        String string2 = cTokenizer.nextToken();
        String string3 = cTokenizer.nextToken();
        String string4 = cTokenizer.nextToken();
        boolean bl = cTokenizer.nextToken().equalsIgnoreCase("Y");
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(string4);
            n2 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.fireGroupList(string2, n, n2, bl);
    }

    private void parseOverviewData(String string) throws IPWorksException {
        CTokenizer cTokenizer = new CTokenizer(string, "\t");
        String string2 = cTokenizer.nextToken();
        String string3 = cTokenizer.nextToken();
        String string4 = cTokenizer.nextToken();
        String string5 = cTokenizer.nextToken();
        String string6 = cTokenizer.nextToken();
        String string7 = cTokenizer.nextToken();
        String string8 = cTokenizer.nextToken();
        String string9 = cTokenizer.nextToken();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(string2);
            n2 = Integer.parseInt(string8);
            n3 = Integer.parseInt(string9);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.fireGroupOverview(n, string3, string4, string5, string6, string7, n2, n3, cTokenizer.getRemaining());
    }

    private void parseGroupSearchData(String string) throws IPWorksException {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n = Integer.parseInt(stringTokenizer.nextToken());
            this.fireGroupSearch(n, stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            throw new IPWorksException(exception);
        }
    }

    void setAction(int n) throws IPWorksException {
        this.setNNTPAction(n);
    }

    /*
     * Loose catch block
     */
    private void setNNTPAction(int n) throws IPWorksException {
        Object object;
        if (n == 0) {
            this.interrupt();
            return;
        }
        Object object2 = this.syncObj;
        synchronized (object2) {
            if (this.action != 0) {
                throw new IPWorksException(187);
            }
            this.restart();
            if (!this.getConnected() && n != 1 && n != 2) {
                this.doActionConnect();
            }
            this.action = n;
        }
        try {
            switch (n) {
                case 1: {
                    this.doActionConnect();
                    break;
                }
                case 2: {
                    this.doActionDisconnect();
                    break;
                }
                case 3: {
                    this.sendNNTPCommand("LIST");
                    this.handleTransferState(3);
                    break;
                }
                case 4: {
                    this.sendNNTPCommand("NEWGROUPS " + this.checkDate);
                    this.handleTransferState(3);
                    break;
                }
                case 5: {
                    this.sendNNTPCommand("XOVER " + this.overviewRange);
                    this.handleTransferState(4);
                    break;
                }
                case 6: {
                    this.resetHeadersAndText();
                    this.sendNNTPCommand("ARTICLE " + this.currentArticle);
                    this.handleTransferState(1);
                    break;
                }
                case 7: {
                    this.resetHeadersAndText();
                    this.sendNNTPCommand("HEAD " + this.currentArticle);
                    this.handleTransferState(1);
                    break;
                }
                case 8: {
                    this.resetHeadersAndText();
                    this.sendNNTPCommand("BODY " + this.currentArticle);
                    this.handleTransferState(2);
                    break;
                }
                case 10: {
                    this.doActionResetHeaders();
                    break;
                }
                case 9: {
                    this.doActionPostArticle();
                    break;
                }
                case 11: {
                    this.doActionGroupSearch();
                    this.handleTransferState(5);
                    break;
                }
                case 13: {
                    this.doActionCurrentGroup();
                    break;
                }
                case 12: {
                    if (this.command.length() <= 0) break;
                    this.sendNNTPCommand(this.command);
                }
            }
            Object var5_5 = null;
            object = this.syncObj;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            Object object3 = this.syncObj;
            synchronized (object3) {
                this.action = 0;
                if (this.pendingException != null) {
                    if (this.pendingException.getCode() == 201) {
                        try {
                            this.setConnected(false, 0L);
                        }
                        catch (IPWorksException iPWorksException) {
                            // empty catch block
                        }
                    }
                    throw this.pendingException;
                }
            }
            throw throwable;
        }
        synchronized (object) {
            this.action = 0;
            if (this.pendingException != null) {
                if (this.pendingException.getCode() == 201) {
                    try {
                        this.setConnected(false, 0L);
                    }
                    catch (IPWorksException iPWorksException) {
                        // empty catch block
                    }
                }
                throw this.pendingException;
            }
        }
        {
            catch (IPWorksException iPWorksException) {
                if (this.pendingException == null) {
                    this.pendingException = iPWorksException;
                }
                Object var5_6 = null;
                Object object4 = this.syncObj;
                synchronized (object4) {
                    this.action = 0;
                    if (this.pendingException != null) {
                        if (this.pendingException.getCode() == 201) {
                            try {
                                this.setConnected(false, 0L);
                            }
                            catch (IPWorksException iPWorksException2) {
                                // empty catch block
                            }
                        }
                        throw this.pendingException;
                    }
                }
            }
        }
    }

    int getAction() {
        return this.action;
    }

    String getNewsServer() {
        return this.getRemoteHost();
    }

    void setNewsServer(String string) throws IPWorksException {
        this.setRemoteHost(string);
    }

    int getNewsPort() {
        return this.getRemotePort();
    }

    void setNewsPort(int n) throws IPWorksException {
        this.setRemotePort(n);
    }

    String getUser() {
        return this.user;
    }

    void setUser(String string) {
        this.user = string != null ? string : "";
    }

    String getPassword() {
        return this.password;
    }

    void setPassword(String string) {
        this.password = string != null ? string : "";
    }

    String getFrom() {
        return this.from;
    }

    void setFrom(String string) {
        this.from = string != null ? string : "";
    }

    String getReplyTo() {
        return this.replyTo;
    }

    void setReplyTo(String string) {
        this.replyTo = string != null ? string : "";
    }

    String getSubject() {
        return this.subject;
    }

    void setSubject(String string) {
        this.subject = string != null ? string : "";
    }

    String getNewsgroups() {
        return this.newsgroups;
    }

    void setNewsgroups(String string) {
        this.newsgroups = string != null ? string : "";
    }

    String getReferences() {
        return this.references;
    }

    void setReferences(String string) {
        this.references = string != null ? string : "";
    }

    String getOrganization() {
        return this.organization;
    }

    void setOrganization(String string) {
        this.organization = string != null ? string : "";
    }

    String getOtherHeaders() {
        return this.otherHeaders;
    }

    void setOtherHeaders(String string) {
        this.otherHeaders = CIPPMsg.toValidHeader(string != null ? string : "");
    }

    String getArticleHeaders() {
        return this.articleHeaders == null ? "" : this.articleHeaders.toString();
    }

    void setArticleHeaders(String string) {
        this.articleHeaders = string == null ? null : new StringBuffer(string);
    }

    String getArticleText() {
        return this.articleText == null ? "" : this.articleText.toString();
    }

    void setArticleText(String string) {
        this.articleText = string == null ? null : new StringBuffer(string);
    }

    String getCheckDate() {
        return this.checkDate;
    }

    void setCheckDate(String string) {
        this.checkDate = string != null ? string : "";
    }

    String getCurrentGroup() {
        return this.currentGroup;
    }

    void setCurrentGroup(String string) throws IPWorksException {
        String string2 = this.currentGroup = string != null ? string : "";
        if (string.length() > 0) {
            this.setNNTPAction(13);
        }
    }

    int getFirstArticle() {
        return this.firstArticle;
    }

    int getLastArticle() {
        return this.lastArticle;
    }

    int getArticleCount() {
        return this.articleCount;
    }

    String getCurrentArticle() {
        return this.currentArticle;
    }

    void setCurrentArticle(String string) {
        this.currentArticle = string != null ? string : "";
    }

    String getOverviewRange() {
        return this.overviewRange;
    }

    void setOverviewRange(String string) {
        this.overviewRange = string != null ? string : "";
    }

    int getMaxHeaderLength() {
        return this.maxHeaderLength;
    }

    void setMaxHeaderLength(int n) {
        this.maxHeaderLength = n > 0 ? n : 0;
    }

    void setCommand(String string) throws IPWorksException {
        this.command = string != null ? string : "";
        this.setNNTPAction(12);
    }

    int getMaxLines() {
        return this.maxLines;
    }

    void setMaxLines(int n) throws IPWorksException {
        this.maxLines = n;
    }

    String getSearchHeader() {
        return this.searchHeader;
    }

    void setSearchHeader(String string) throws IPWorksException {
        this.searchHeader = string == null ? "" : string;
    }

    String getSearchPattern() {
        return this.searchPattern;
    }

    void setSearchPattern(String string) throws IPWorksException {
        this.searchPattern = string != null ? string : "";
    }

    String getSearchRange() {
        return this.searchRange;
    }

    void setSearchRange(String string) throws IPWorksException {
        this.searchRange = string != null ? string : "";
    }

    void fireConnected(IPWorksException iPWorksException) {
        super.fireConnected(iPWorksException);
        if (iPWorksException == null) {
            this.firePITrail(2, "Connected.");
        } else {
            this.fireError(new IPWorksException(182));
        }
    }

    void fireDisconnected(IPWorksException iPWorksException) {
        super.fireDisconnected(iPWorksException);
        if (iPWorksException == null) {
            this.firePITrail(2, "Disonnected.");
        } else {
            this.fireError(new IPWorksException(182));
        }
    }

    void fireDataIn(byte[] byArray, boolean bl) {
        switch (this.transferState) {
            case 0: {
                super.fireDataIn(byArray, bl);
                break;
            }
            case 1: {
                this.allDataIn.append(new String(byArray));
                if (!bl) break;
                if (this.allDataIn.length() == 0) {
                    if (this.localFile.length() > 0) {
                        try {
                            this.fos = new FileOutputStream(this.localFile);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.lastWasEndOfLine = true;
                    this.transferState = 2;
                    this.fireStartTransfer();
                    break;
                }
                if (this.allDataIn.length() == 1 && this.allDataIn.charAt(0) == '.') {
                    this.transferState = 0;
                    this.notifyAllAndEventsProcessor();
                    break;
                }
                String string = this.allDataIn.toString();
                this.fireHeader(CRfc822String.getField(string), CRfc822String.getValue(string));
                this.allDataIn = new StringBuffer();
                break;
            }
            case 2: {
                int n = byArray.length;
                if (this.lastWasEndOfLine && n > 0 && byArray[0] == 46) {
                    if (--n == 0) {
                        if (this.fos != null) {
                            try {
                                this.fos.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        this.fos = null;
                        this.fireEndTransfer();
                        this.transferState = 0;
                        this.notifyAllAndEventsProcessor();
                        break;
                    }
                    byte[] byArray2 = byArray;
                    byArray = new byte[n];
                    System.arraycopy(byArray2, 1, byArray, 0, n);
                }
                this.lastWasEndOfLine = bl;
                this.bytesTransferred += n;
                this.fireTransfer(this.bytesTransferred, byArray, bl);
                if (this.fos == null) break;
                try {
                    this.fos.write(byArray);
                    this.fos.write(CBase.CRLFB);
                }
                catch (IOException iOException) {
                    try {
                        this.fos.close();
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                    this.fos = null;
                }
                break;
            }
            case 3: {
                this.allDataIn.append(new String(byArray));
                if (this.allDataIn.length() == 0 || this.allDataIn.length() == 1 && this.allDataIn.charAt(0) == '.') {
                    this.transferState = 0;
                    this.notifyAllAndEventsProcessor();
                    break;
                }
                if (!bl) break;
                try {
                    this.parseGroupListData(this.allDataIn.toString());
                }
                catch (IPWorksException iPWorksException) {
                    this.fireError(iPWorksException);
                }
                this.allDataIn = new StringBuffer();
                break;
            }
            case 4: {
                this.allDataIn.append(new String(byArray));
                if (this.allDataIn.length() == 0 || this.allDataIn.length() == 1 && this.allDataIn.charAt(0) == '.') {
                    this.transferState = 0;
                    this.notifyAllAndEventsProcessor();
                    break;
                }
                if (!bl) break;
                try {
                    this.parseOverviewData(this.allDataIn.toString());
                }
                catch (IPWorksException iPWorksException) {
                    this.fireError(iPWorksException);
                }
                this.allDataIn = new StringBuffer();
                break;
            }
            case 5: {
                this.allDataIn.append(new String(byArray));
                if (this.allDataIn.length() == 0 || this.allDataIn.length() == 1 && this.allDataIn.charAt(0) == '.') {
                    this.transferState = 0;
                    this.notifyAllAndEventsProcessor();
                    break;
                }
                if (!bl) break;
                try {
                    this.parseOverviewData(this.allDataIn.toString());
                }
                catch (IPWorksException iPWorksException) {
                    this.fireError(iPWorksException);
                }
                this.allDataIn = new StringBuffer();
            }
        }
    }

    void firePITrail(int n, String string) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.firePITrail(n, string);
            }
        }
    }

    void fireStartTransfer() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.fireStartTransfer();
            }
        }
    }

    void fireTransfer(int n, byte[] byArray, boolean bl) {
        if (this.pendingException == null && this.sink != null) {
            this.sink.fireTransfer(n, byArray, bl);
        }
    }

    void fireEndTransfer() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.fireEndTransfer();
            }
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }

    void fireHeader(String string, String string2) {
        if (this.pendingException == null && this.sink != null) {
            this.sink.fireHeader(string, string2);
        }
    }

    void fireGroupList(String string, int n, int n2, boolean bl) {
        if (this.pendingException == null && this.sink != null) {
            this.sink.fireGroupList(string, n, n2, bl);
        }
    }

    void fireGroupOverview(int n, String string, String string2, String string3, String string4, String string5, int n2, int n3, String string6) {
        if (this.pendingException == null && this.sink != null) {
            this.sink.fireGroupOverview(n, string, string2, string3, string4, string5, n2, n3, string6);
        }
    }

    void fireGroupSearch(int n, String string) {
        if (this.pendingException == null && this.sink != null) {
            this.sink.fireGroupSearch(n, string);
        }
    }
}

