/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.IPWorksException;
import ipworks.Netcode;
import ipworks.StringInputStream;
import ipworks.StringOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;

class CNetCode {
    static final int UUE = 0;
    static final int B64 = 1;
    static final int QP = 2;
    static final int URL = 3;
    static final int IDLE = 0;
    static final int DECODE2FILE = 1;
    static final int ENCODE2FILE = 2;
    static final int DECODE2STRING = 3;
    static final int ENCODE2STRING = 4;
    private static final int findingBegin = 1;
    private static final int findingMode = 2;
    private static final int findingFileName = 3;
    protected static final byte[] BYTE0 = new byte[0];
    private Object syncObj;
    private Netcode sink = null;
    private int action;
    InputStream iStream;
    OutputStream oStream;
    private int progressStep = 1;
    private boolean overwrite = false;
    protected int format = 0;
    private String fileName = "";
    private String mode = "755";
    private byte[] encodedData = BYTE0;
    private byte[] decodedData = BYTE0;
    private boolean intellicode;
    private int maxFileSize;
    int current = 0;
    int inPoz;
    int outPoz;
    byte[][] preAllocBuf = new byte[][]{new byte[100], new byte[100]};
    byte[] inBuf = new byte[63];
    byte[] outBuf;
    private static final char[] map = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] pam = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, 99, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final int pamLength = pam.length;

    CNetCode(Netcode netcode, Object object) {
        this.sink = netcode;
        this.syncObj = object;
        this.outBuf = this.preAllocBuf[this.current];
    }

    void do_DecodeToFile() throws IPWorksException {
        this.setAction(1);
    }

    void do_DecodeToString() throws IPWorksException {
        this.setAction(3);
    }

    void do_EncodeToFile() throws IPWorksException {
        this.setAction(2);
    }

    void do_EncodeToString() throws IPWorksException {
        this.setAction(4);
    }

    int getProgressStep() {
        return this.progressStep;
    }

    void setProgressStep(int n) {
        this.progressStep = n > 0 ? n : 1;
    }

    String getFileName() {
        return this.fileName;
    }

    void setFileName(String string) {
        this.fileName = string != null ? string : "";
    }

    byte[] getDecodedData() {
        return this.decodedData;
    }

    void setDecodedData(byte[] byArray) {
        this.decodedData = byArray != null ? byArray : BYTE0;
    }

    byte[] getEncodedData() {
        return this.encodedData;
    }

    void setEncodedData(byte[] byArray) {
        this.encodedData = byArray != null ? byArray : BYTE0;
    }

    void setDecodedData(byte[] byArray, int n, int n2) throws IPWorksException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.setDecodedData(byArray2);
    }

    void setEncodedData(byte[] byArray, int n, int n2) throws IPWorksException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.setEncodedData(byArray2);
    }

    boolean getOverwrite() {
        return this.overwrite;
    }

    void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }

    boolean getIntelliCode() {
        return this.intellicode;
    }

    void setIntelliCode(boolean bl) throws IPWorksException {
        this.intellicode = bl;
    }

    int getFormat() {
        return this.format;
    }

    void setFormat(int n) {
        this.format = n;
    }

    int getMaxFileSize() {
        return this.maxFileSize;
    }

    void setMaxFileSize(int n) throws IPWorksException {
        throw new IPWorksException();
    }

    String getMode() {
        return this.mode;
    }

    void setMode(String string) {
        this.mode = string != null ? string : "";
    }

    private String getUUNextChunk(int n, int n2) throws IOException, IPWorksException {
        System.arraycopy(this.inBuf, n, this.inBuf, 0, n2);
        int n3 = this.iStream.read(this.inBuf, n2, 63 - n2);
        if (n3 == -1) {
            n3 = 0;
        }
        return new String(this.inBuf, 0, n3 + n2);
    }

    String skipUUHeaders() throws IOException, IPWorksException {
        StringBuffer stringBuffer = null;
        int n = 1;
        String string = new String(this.decodedData);
        String string2 = this.getUUNextChunk(0, 0);
        while (true) {
            switch (n) {
                case 1: {
                    int n2;
                    int n3 = string2.indexOf("begin ");
                    if (n3 != -1) {
                        n = 2;
                        n2 = string2.length() - (n3 + 6);
                        string2 = this.getUUNextChunk(n3 + 6, n2);
                        break;
                    }
                    if ((string2 = this.getUUNextChunk(string2.length() - 5, 5)).length() != 5) break;
                    throw new IPWorksException(1);
                }
                case 2: {
                    int n2;
                    int n3 = string2.indexOf(" ");
                    if (n3 != -1) {
                        this.mode = string2.substring(0, n3);
                        n = 3;
                        n2 = string2.length() - (n3 + 1);
                        stringBuffer = new StringBuffer();
                        string2 = this.getUUNextChunk(n3 + 1, n2);
                        break;
                    }
                    n = 1;
                    break;
                }
                case 3: {
                    int n2;
                    int n3 = string2.indexOf("\r\n");
                    if (n3 != -1) {
                        n2 = string2.length() - (n3 + 2);
                        this.getUUNextChunk(n3 + 2, n2);
                        string2 = stringBuffer.toString() + string2.substring(0, n3);
                        this.fileName = string.endsWith(File.separator) ? string + string2 : (string.length() > 0 ? string : (this.fileName.endsWith(File.separator) ? this.fileName + string2 : string2));
                        return this.fileName;
                    }
                    int n4 = string2.length();
                    stringBuffer.append(string2.substring(n4 - 1, n4));
                    string2 = this.getUUNextChunk(n4 - 1, 1);
                    if (string2.length() != 1) break;
                    throw new IPWorksException(1);
                }
            }
        }
    }

    private void createFileOutputStream(String string) throws IPWorksException {
        boolean bl = new File(string).exists();
        if (!this.overwrite && bl) {
            throw new IPWorksException(8, string);
        }
        try {
            this.oStream = new FileOutputStream(string);
        }
        catch (IOException iOException) {
            if (bl) {
                throw new IPWorksException(4, string);
            }
            throw new IPWorksException(3, string);
        }
    }

    private void closeStreams() {
        try {
            if (this.iStream != null) {
                this.iStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.oStream != null) {
                this.oStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.iStream = null;
        this.oStream = null;
    }

    int getFileCnt() {
        return 0;
    }

    int getAction() {
        return this.action;
    }

    void setAction(int n) throws IPWorksException {
        this.setNCAction(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setNCAction(int n) throws IPWorksException {
        if (this.action != 0) {
            return;
        }
        this.action = n;
        try {
            try {
                block4 : switch (n) {
                    case 1: {
                        try {
                            this.iStream = new FileInputStream(new String(this.encodedData));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            throw new IPWorksException(4, new String(this.encodedData));
                        }
                        this.createFileOutputStream(this.format == 0 ? this.skipUUHeaders() : new String(this.decodedData));
                        switch (this.format) {
                            case 0: {
                                this.uuDecode();
                                break block4;
                            }
                            case 1: {
                                this.b64Decode();
                                break block4;
                            }
                            case 2: {
                                this.qpDecode();
                                break block4;
                            }
                            case 3: {
                                this.urlDecode();
                                break block4;
                            }
                        }
                        break;
                    }
                    case 2: {
                        try {
                            this.iStream = new FileInputStream(new String(this.decodedData));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            throw new IPWorksException(4, new String(this.decodedData));
                        }
                        this.createFileOutputStream(new String(this.encodedData));
                        switch (this.format) {
                            case 0: {
                                if (this.fileName.length() == 0) {
                                    this.fileName = new String(this.encodedData);
                                }
                                this.uuEncode();
                                break block4;
                            }
                            case 1: {
                                this.b64Encode();
                                break block4;
                            }
                            case 2: {
                                this.qpEncode();
                                break block4;
                            }
                            case 3: {
                                this.urlEncode();
                                break block4;
                            }
                        }
                        break;
                    }
                    case 3: {
                        this.iStream = new StringInputStream(new String(this.encodedData));
                        this.oStream = new StringOutputStream();
                        switch (this.format) {
                            case 0: {
                                this.skipUUHeaders();
                                this.uuDecode();
                                break;
                            }
                            case 1: {
                                this.b64Decode();
                                break;
                            }
                            case 2: {
                                this.qpDecode();
                                break;
                            }
                            case 3: {
                                this.urlDecode();
                                break;
                            }
                        }
                        this.decodedData = ((StringOutputStream)this.oStream).getBytes();
                        break;
                    }
                    case 4: {
                        this.iStream = new StringInputStream(new String(this.decodedData));
                        this.oStream = new StringOutputStream();
                        switch (this.format) {
                            case 0: {
                                if (this.decodedData.length == 0) {
                                    throw new IPWorksException(7);
                                }
                                this.uuEncode();
                                break;
                            }
                            case 1: {
                                this.b64Encode();
                                break;
                            }
                            case 2: {
                                this.qpEncode();
                                break;
                            }
                            case 3: {
                                this.urlEncode();
                                break;
                            }
                        }
                        this.encodedData = ((StringOutputStream)this.oStream).getBytes();
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                throw new IPWorksException(iOException);
            }
            {
            }
            Object var4_5 = null;
            this.closeStreams();
            this.action = 0;
            return;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.closeStreams();
            this.action = 0;
            throw throwable;
        }
    }

    void b64Encode() throws IOException {
        int n;
        byte[] byArray = new byte[3];
        int n2 = 0;
        this.fireProgress(1);
        do {
            n = 0;
            while (n < 3) {
                int n3 = this.iStream.read();
                if (n3 == -1) break;
                byArray[n] = (byte)n3;
                ++n;
            }
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    this.oStream.write(map[byArray[0] >>> 2 & 0x3F]);
                    this.oStream.write(map[byArray[0] << 4 & 0x30]);
                    this.oStream.write(61);
                    this.oStream.write(61);
                    break;
                }
                case 2: {
                    this.oStream.write(map[byArray[0] >>> 2 & 0x3F]);
                    this.oStream.write(map[(byArray[0] << 4 & 0x30) + (byArray[1] >>> 4 & 0xF)]);
                    this.oStream.write(map[byArray[1] << 2 & 0x3C]);
                    this.oStream.write(61);
                    break;
                }
                case 3: {
                    this.oStream.write(map[byArray[0] >>> 2 & 0x3F]);
                    this.oStream.write(map[(byArray[0] << 4 & 0x30) + (byArray[1] >>> 4 & 0xF)]);
                    this.oStream.write(map[(byArray[1] << 2 & 0x3C) + (byArray[2] >>> 6 & 3)]);
                    this.oStream.write(map[byArray[2] & 0x3F]);
                }
            }
            if ((n2 += 4) != 76) continue;
            this.oStream.write(13);
            this.oStream.write(10);
            n2 = 0;
        } while (n == 3);
        this.fireProgress(100);
    }

    void b64Decode() throws IOException, IPWorksException {
        byte[] byArray = new byte[4];
        this.fireProgress(1);
        while (true) {
            int n = 0;
            while (n < 4) {
                int n2 = this.iStream.read();
                if (n2 == -1) {
                    this.fireProgress(100);
                    return;
                }
                if (n2 >= pamLength || pam[n2] < 0) continue;
                byArray[n++] = pam[n2];
            }
            int n3 = byArray[3] == 99 ? (byArray[2] == 99 ? 1 : 2) : 3;
            switch (n3) {
                case 1: {
                    this.oStream.write((byArray[0] << 2 | byArray[1] >>> 4) & 0xFF);
                    break;
                }
                case 2: {
                    this.oStream.write((byArray[0] << 2 | byArray[1] >>> 4) & 0xFF);
                    this.oStream.write((byArray[1] << 4 | byArray[2] >>> 2) & 0xFF);
                    break;
                }
                case 3: {
                    this.oStream.write((byArray[0] << 2 | byArray[1] >>> 4) & 0xFF);
                    this.oStream.write((byArray[1] << 4 | byArray[2] >>> 2) & 0xFF);
                    this.oStream.write((byArray[2] << 6 | byArray[3]) & 0xFF);
                }
            }
        }
    }

    void urlEncode() throws IOException, IPWorksException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[100];
        while ((n = this.iStream.read(byArray)) != -1) {
            stringBuffer.append(new String(byArray, 0, n));
        }
        this.fireProgress(50);
        String string = URLEncoder.encode(stringBuffer.toString());
        this.oStream.write(string.getBytes());
        this.fireProgress(100);
    }

    void urlDecode() throws IOException, IPWorksException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        byte[] byArray = new byte[100];
        while ((n = this.iStream.read(byArray)) != -1) {
            stringBuffer.append(new String(byArray, 0, n));
        }
        String string = stringBuffer.toString();
        this.fireProgress(50);
        int n2 = 0;
        while (n2 < stringBuffer.length()) {
            int n3;
            int n4 = n3 = string.charAt(n2);
            if (n3 == 37) {
                try {
                    n4 = Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16);
                    n2 += 2;
                }
                catch (Exception exception) {}
            } else if (n3 == 43) {
                n4 = 32;
            }
            this.oStream.write(n4);
            ++n2;
        }
        this.fireProgress(100);
    }

    void uuEncode() throws IOException, IPWorksException {
        int n;
        this.oStream.write(("begin " + this.mode + " " + this.fileName + "\r\n").getBytes());
        while ((n = this.iStream.read(this.inBuf, 0, 45)) != -1) {
            this.inBuf[n + 1] = 0;
            this.inBuf[n] = 0;
            this.outBuf[0] = (byte)(n + 32);
            this.inPoz = 0;
            this.outPoz = 1;
            while (this.inPoz < n) {
                int n2 = this.inBuf[this.inPoz] >>> 2;
                this.outBuf[this.outPoz++] = (byte)(n2 == 0 ? 96 : (byte)(n2 + 32));
                n2 = (this.inBuf[this.inPoz] & 3) << 4 | this.inBuf[this.inPoz + 1] >>> 4;
                this.outBuf[this.outPoz++] = (byte)(n2 == 0 ? 96 : (byte)(n2 + 32));
                n2 = (this.inBuf[this.inPoz + 1] & 0xF) << 2 | this.inBuf[this.inPoz + 2] >>> 6;
                this.outBuf[this.outPoz++] = (byte)(n2 == 0 ? 96 : (byte)(n2 + 32));
                n2 = this.inBuf[this.inPoz + 2] & 0x3F;
                this.outBuf[this.outPoz++] = (byte)(n2 == 0 ? 96 : (byte)(n2 + 32));
                this.inPoz += 3;
            }
            this.outBuf[this.outPoz++] = 13;
            this.outBuf[this.outPoz++] = 10;
            this.oStream.write(this.outBuf, 0, this.outPoz);
        }
        this.oStream.write("`\r\nend\r\n".getBytes());
    }

    void uuDecode() throws IOException, IPWorksException {
        while (this.inBuf[0] != 96) {
            int n = this.inBuf[0] - 32;
            this.inPoz = 1;
            this.outPoz = 0;
            while (this.outPoz < n) {
                int n2;
                n2 = (n2 = this.inBuf[this.inPoz++]) == 96 ? 0 : n2 - 32;
                int n3 = this.inBuf[this.inPoz++];
                n3 = n3 == 96 ? 0 : n3 - 32;
                this.outBuf[this.outPoz++] = (byte)((n2 << 2) + (n3 >>> 4));
                int n4 = this.inBuf[this.inPoz++];
                n4 = n4 == 96 ? 0 : n4 - 32;
                this.outBuf[this.outPoz++] = (byte)((n3 << 4) + (n4 >>> 2));
                int n5 = this.inBuf[this.inPoz++];
                n5 = n5 == 96 ? 0 : n5 - 32;
                this.outBuf[this.outPoz++] = (byte)((n4 << 6) + n5);
            }
            this.oStream.write(this.outBuf, 0, n);
            if (n < 45) {
                this.inPoz += 2;
                System.arraycopy(this.inBuf, this.inPoz, this.inBuf, 0, 63 - this.inPoz);
                this.iStream.read(this.inBuf, 63 - this.inPoz, this.inPoz);
                continue;
            }
            this.iStream.read(this.inBuf, 0, 63);
        }
        if (new String(this.inBuf, 0, 63).indexOf("end\r\n") == -1) {
            throw new IPWorksException(1);
        }
    }

    private static boolean isAsciiPresentable(int n) {
        return n >= 32 && n <= 60 || n >= 62 && n <= 126 || n == 9;
    }

    private void flushOut() throws IOException {
        int n = 75;
        this.current = 1 - this.current;
        byte[] byArray = this.preAllocBuf[this.current];
        if (this.outPoz > 76) {
            int n2 = 73;
            while (n2 < this.outPoz - 2) {
                if (this.outBuf[n2] == 61) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            this.outPoz -= n;
            System.arraycopy(this.outBuf, n, byArray, 0, this.outPoz);
            this.outBuf[n++] = 61;
        } else if (this.outPoz > 0) {
            n = this.outPoz;
            this.outPoz = 0;
            byte by = this.outBuf[n - 1];
            if (by == 32 || by == 9) {
                this.outBuf[n - 1] = 61;
                byArray[0] = by;
                this.outPoz = 1;
            }
        } else {
            n = 0;
        }
        this.outBuf[n++] = 13;
        this.outBuf[n++] = 10;
        this.oStream.write(this.outBuf, 0, n);
        this.outBuf = byArray;
    }

    void qpEncode() throws IOException, IPWorksException {
        int n = this.iStream.read();
        int n2 = 10;
        this.outPoz = 0;
        this.fireProgress(1);
        while (n != -1) {
            if (n == 13 && (n2 = this.iStream.read()) == 10) {
                this.flushOut();
                n = this.iStream.read();
                continue;
            }
            if (CNetCode.isAsciiPresentable(n)) {
                this.outBuf[this.outPoz++] = (byte)n;
            } else {
                String string = Integer.toHexString(n);
                this.outBuf[this.outPoz++] = 61;
                if (string.length() == 1) {
                    this.outBuf[this.outPoz++] = 0;
                    this.outBuf[this.outPoz++] = (byte)string.charAt(0);
                } else {
                    this.outBuf[this.outPoz++] = (byte)string.charAt(0);
                    this.outBuf[this.outPoz++] = (byte)string.charAt(1);
                }
            }
            if (this.outPoz > 76) {
                this.flushOut();
            }
            n = n2 == 10 ? this.iStream.read() : n2;
            n2 = 10;
        }
        if (this.outPoz > 0) {
            this.oStream.write(this.outBuf, 0, this.outPoz);
        }
        this.fireProgress(100);
    }

    void qpDecode() throws IOException, IPWorksException {
        int n;
        byte[] byArray = new byte[2];
        this.fireProgress(1);
        while ((n = this.iStream.read()) != -1) {
            if (n == 61) {
                int n2 = this.iStream.read(byArray);
                if (n2 != 2) {
                    throw new IPWorksException(1);
                }
                if (byArray[0] == 13 && byArray[1] == 10) continue;
                try {
                    int n3 = Integer.parseInt(new String(byArray), 16);
                    this.oStream.write(n3);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IPWorksException(1);
                }
            }
            this.oStream.write(n);
        }
        this.fireProgress(100);
    }

    void fireProgress(int n) {
        if (this.sink != null) {
            this.sink.fireProgress(n);
        }
    }
}

