/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CIPPMsg;
import ipworks.CRfc822String;
import ipworks.IPWorksException;
import ipworks.Pop;

class CPOP
extends CIPPMsg {
    private static final int DEFAULT_PORT = 110;
    private static final String POP_EOL = "\r\n";
    private static final int TRANSFER_PROTOCOL = 0;
    private static final int TRANSFER_HEADERS = 1;
    private static final int TRANSFER_BODY = 2;
    private static final int idle = 0;
    private static final int connect = 1;
    private static final int disconnect = 2;
    private static final int retrieve = 3;
    private static final int delete = 4;
    private static final int reset = 5;
    private static final int actionCommand = 6;
    private static final int UPDATE_TOTAL_AND_MESSAGE_COUNT = 7;
    private static final int GET_MESSAGE_SIZE = 8;
    private int action = 0;
    private int transferState = 0;
    private int messageCount = 0;
    private int totalSize = 0;
    private int messageNumber = 1;
    private int maxLines;
    private int bytesTransferred;
    private String command = "";
    private String user = "";
    private String password = "";
    private StringBuffer messageHeaders;
    private StringBuffer messageText;
    private boolean lastWasEndOfLine;
    private StringBuffer currentHeader = new StringBuffer();
    private Pop sink;

    CPOP(Pop pop, Object object) {
        super(null, object);
        this.sink = pop;
        this.setEOL(POP_EOL.getBytes());
        try {
            this.setInBufferSize(20000);
            this.setMaxLineLength(20000);
            this.setRemotePort(110);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
    }

    void do_Connect() throws IPWorksException {
        this.setAction(1);
    }

    void do_Delete() throws IPWorksException {
        this.setAction(4);
    }

    void do_Disconnect() throws IPWorksException {
        this.setAction(2);
    }

    void do_Interrupt() throws IPWorksException {
        this.setAction(0);
    }

    void do_Reset() throws IPWorksException {
        this.setAction(5);
    }

    void do_Retrieve() throws IPWorksException {
        this.setAction(3);
    }

    private void sendPOPCommand(String string) throws IPWorksException {
        if (string != null) {
            this.firePITrail(0, string);
        }
        this.sendCommand(string, POP_EOL);
        this.firePITrail(1, this.lastReply);
        if (!this.lastReply.startsWith("+")) {
            throw new IPWorksException(171, this.lastReply);
        }
    }

    private void doActionConnect() throws IPWorksException {
        if (!this.getConnected()) {
            this.firePITrail(2, "Connecting to mail server.");
            this.totalSize = 0;
            this.messageCount = 0;
            this.blockConnect();
            this.setMessageNumber(1);
            try {
                this.sendPOPCommand(null);
                this.sendPOPCommand("USER " + this.user);
                this.sendPOPCommand("PASS " + this.password);
            }
            catch (IPWorksException iPWorksException) {
                try {
                    this.doActionDisconnect();
                }
                catch (IPWorksException iPWorksException2) {
                    // empty catch block
                }
                throw iPWorksException;
            }
        }
    }

    private void doActionDisconnect() throws IPWorksException {
        if (this.getConnected()) {
            try {
                this.firePITrail(2, "Forcing disconnection from POP server.");
                this.sendPOPCommand("QUIT");
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.setConnected(false);
                throw throwable;
            }
            this.setConnected(false);
            {
            }
        }
    }

    private void doActionRetrieve() throws IPWorksException {
        String string;
        Object object = this.syncObj;
        synchronized (object) {
            if (this.timestart != 0L) {
                this.messageHeaders = new StringBuffer();
                this.messageText = new StringBuffer();
            } else {
                this.messageText = null;
                this.messageHeaders = null;
            }
            string = this.maxLines > 0 ? "TOP " + this.messageNumber + " " + this.maxLines : "RETR " + this.messageNumber;
        }
        this.sendPOPCommand(string);
        this.transferState = 1;
        this.bytesTransferred = 0;
        this.currentHeader.setLength(0);
        this.setAcceptData(true);
        Object object2 = this.syncObj;
        synchronized (object2) {
            while (this.transferState != 0) {
                if (!this.getConnected()) {
                    throw new IPWorksException(32000);
                }
                this.waitWhileProcessingEvents(this.timestart);
            }
        }
        this.setAcceptData(false);
    }

    private void doActionUpdateTotalAndMessageCount() throws IPWorksException {
        this.sendPOPCommand("STAT");
        int n = this.lastReply.indexOf(32, 5);
        String string = this.lastReply.substring(4, n);
        this.messageCount = Integer.parseInt(string);
        string = this.lastReply.substring(n + 1);
        this.totalSize = Integer.parseInt(string);
    }

    private void doGetMessageSize() throws IPWorksException {
        this.sendPOPCommand("LIST " + this.messageNumber);
    }

    void setAction(int n) throws IPWorksException {
        this.setPOPAction(n);
    }

    /*
     * Loose catch block
     */
    private void setPOPAction(int n) throws IPWorksException {
        Object object;
        if (n == 0) {
            this.interrupt();
            return;
        }
        Object object2 = this.syncObj;
        synchronized (object2) {
            if (this.action != 0) {
                throw new IPWorksException(174);
            }
            this.restart();
            this.action = n;
        }
        try {
            switch (n) {
                case 1: {
                    this.doActionConnect();
                    break;
                }
                case 2: {
                    this.doActionDisconnect();
                    break;
                }
                case 5: {
                    this.sendPOPCommand("RSET");
                    break;
                }
                case 4: {
                    this.sendPOPCommand("DELE " + this.messageNumber);
                    break;
                }
                case 3: {
                    this.doActionRetrieve();
                    break;
                }
                case 7: {
                    this.doActionUpdateTotalAndMessageCount();
                    break;
                }
                case 8: {
                    this.doGetMessageSize();
                    break;
                }
                case 6: {
                    if (this.command.length() <= 0) break;
                    this.sendPOPCommand(this.command);
                }
            }
            Object var5_5 = null;
            object = this.syncObj;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            Object object3 = this.syncObj;
            synchronized (object3) {
                this.action = 0;
                if (this.pendingException != null) {
                    if (this.pendingException.getCode() == 201) {
                        try {
                            this.setConnected(false, 0L);
                        }
                        catch (IPWorksException iPWorksException) {
                            // empty catch block
                        }
                    }
                    throw this.pendingException;
                }
            }
            throw throwable;
        }
        synchronized (object) {
            this.action = 0;
            if (this.pendingException != null) {
                if (this.pendingException.getCode() == 201) {
                    try {
                        this.setConnected(false, 0L);
                    }
                    catch (IPWorksException iPWorksException) {
                        // empty catch block
                    }
                }
                throw this.pendingException;
            }
        }
        {
            catch (IPWorksException iPWorksException) {
                if (this.pendingException == null) {
                    this.pendingException = iPWorksException;
                }
                Object var5_6 = null;
                Object object4 = this.syncObj;
                synchronized (object4) {
                    this.action = 0;
                    if (this.pendingException != null) {
                        if (this.pendingException.getCode() == 201) {
                            try {
                                this.setConnected(false, 0L);
                            }
                            catch (IPWorksException iPWorksException2) {
                                // empty catch block
                            }
                        }
                        throw this.pendingException;
                    }
                }
            }
        }
    }

    int getAction() {
        return this.action;
    }

    String getMailServer() {
        return this.getRemoteHost();
    }

    void setMailServer(String string) throws IPWorksException {
        this.setRemoteHost(string);
    }

    int getMailPort() {
        return this.getRemotePort();
    }

    void setMailPort(int n) throws IPWorksException {
        this.setRemotePort(n);
    }

    String getUser() {
        return this.user;
    }

    void setUser(String string) {
        this.user = string != null ? string : "";
    }

    String getPassword() {
        return this.password;
    }

    void setPassword(String string) {
        this.password = string != null ? string : "";
    }

    String getMessageUID() {
        return "";
    }

    int getMessageCount() {
        try {
            this.setPOPAction(7);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.messageCount;
    }

    int getTotalSize() {
        try {
            this.setPOPAction(7);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.totalSize;
    }

    int getMessageNumber() {
        return this.messageNumber;
    }

    void setMessageNumber(int n) {
        Object object = this.syncObj;
        synchronized (object) {
            this.messageNumber = n < 1 ? 1 : n;
            this.messageText = null;
            this.messageHeaders = null;
        }
    }

    int getMessageSize() {
        if (!this.getConnected()) {
            return 0;
        }
        try {
            this.setPOPAction(8);
            return Integer.parseInt(this.lastReply.substring(this.lastReply.indexOf(32, 4) + 1));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    int getMaxLines() {
        return this.maxLines;
    }

    void setMaxLines(int n) {
        this.maxLines = n > 0 ? n : 0;
    }

    void setCommand(String string) throws IPWorksException {
        this.command = string != null ? string : "";
        this.setPOPAction(6);
    }

    String getMessageHeaders() {
        Object object = this.syncObj;
        synchronized (object) {
            String string = this.messageHeaders != null ? this.messageHeaders.toString() : "";
            return string;
        }
    }

    String getMessageText() {
        Object object = this.syncObj;
        synchronized (object) {
            String string = this.messageText != null ? this.messageText.toString() : "";
            return string;
        }
    }

    void fireConnected(IPWorksException iPWorksException) {
        super.fireConnected(iPWorksException);
        if (iPWorksException == null) {
            this.firePITrail(2, "Connected.");
        } else {
            this.fireError(new IPWorksException(172));
        }
    }

    void fireDisconnected(IPWorksException iPWorksException) {
        super.fireDisconnected(iPWorksException);
        if (iPWorksException == null) {
            this.firePITrail(2, "Disonnected.");
        } else {
            this.fireError(new IPWorksException(172));
        }
    }

    void fireDataIn(byte[] byArray, boolean bl) {
        switch (this.transferState) {
            case 0: {
                super.fireDataIn(byArray, bl);
                break;
            }
            case 1: {
                this.currentHeader.append(new String(byArray));
                if (!bl) break;
                if (this.currentHeader.length() == 0) {
                    try {
                        this.openLocalFile();
                    }
                    catch (IPWorksException iPWorksException) {
                        this.fireError(iPWorksException);
                    }
                    this.lastWasEndOfLine = true;
                    this.transferState = 2;
                    this.fireStartTransfer();
                } else {
                    String string = this.currentHeader.toString();
                    if (this.messageHeaders != null) {
                        this.messageHeaders.append(string + POP_EOL);
                    }
                    this.fireHeader(CRfc822String.getField(string), CRfc822String.getValue(string));
                }
                this.currentHeader.setLength(0);
                break;
            }
            case 2: {
                int n = byArray.length;
                if (this.lastWasEndOfLine && n > 0 && byArray[0] == 46) {
                    if (--n == 0) {
                        this.closeLocalFile();
                        this.fireEndTransfer();
                        this.transferState = 0;
                        this.notifyAllAndEventsProcessor();
                        return;
                    }
                    byte[] byArray2 = byArray;
                    byArray = new byte[n];
                    System.arraycopy(byArray2, 1, byArray, 0, n);
                }
                this.lastWasEndOfLine = bl;
                this.bytesTransferred += n;
                if (this.messageText != null) {
                    this.messageText.append(new String(byArray)).append(bl ? POP_EOL : "");
                }
                this.fireTransfer(this.bytesTransferred, byArray, bl);
                try {
                    this.writeToLocalFile(byArray);
                    this.writeToLocalFile(POP_EOL.getBytes());
                    break;
                }
                catch (IPWorksException iPWorksException) {
                    this.fireError(iPWorksException);
                }
            }
        }
    }

    void firePITrail(int n, String string) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.firePITrail(n, string);
            }
        }
    }

    void fireHeader(String string, String string2) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.fireHeader(string, string2);
            }
        }
    }

    void fireStartTransfer() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.fireStartTransfer();
            }
        }
    }

    void fireTransfer(int n, byte[] byArray, boolean bl) {
        if (this.pendingException == null && this.sink != null) {
            this.sink.fireTransfer(n, byArray, bl);
        }
    }

    void fireEndTransfer() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.fireEndTransfer();
            }
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.pendingException == null && this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }
}

