/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CBase;
import ipworks.CRs;
import ipworks.IPWorksException;
import ipworks.Rcp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

class CRCP
extends CRs {
    private static String ZEROS = "\u0000";
    private static byte[] ZEROB = ZEROS.getBytes();
    static final int IDLE = 0;
    static final int GET_FILE = 1;
    static final int PUT_FILE = 2;
    static final int REXEC = 0;
    static final int RSHELL = 1;
    private String fileMode = "0600";
    private int fileSize = 0;
    private String remoteFile = "";
    private StringBuffer lastStderr = new StringBuffer();
    private FileOutputStream fos;
    private int protocol = 0;
    private int action = 0;
    private Rcp sink;

    CRCP(Rcp rcp, Object object) {
        super(object);
        this.sink = rcp;
    }

    void do_GetFile() throws IPWorksException {
        this.setAction(1);
    }

    void do_Interrupt() throws IPWorksException {
        this.setAction(0);
    }

    void do_PutFile() throws IPWorksException {
        this.setAction(2);
    }

    int getAction() {
        return this.action;
    }

    String getFileMode() {
        return this.fileMode;
    }

    void setFileMode(String string) throws IPWorksException {
        this.fileMode = string != null ? string : "";
    }

    String getRemoteFile() {
        return this.remoteFile;
    }

    void setRemoteFile(String string) throws IPWorksException {
        this.remoteFile = string != null ? string : "";
    }

    String getUser() {
        return this.getFirstAuthPiece();
    }

    void setUser(String string) {
        this.setFirstAuthPiece(string);
    }

    String getPassword() {
        return this.getSecondAuthPiece();
    }

    void setPassword(String string) {
        this.setSecondAuthPiece(string);
    }

    int getProtocol() {
        return this.protocol;
    }

    void setProtocol(int n) throws IPWorksException {
        switch (n) {
            case 0: {
                this.setRemotePort(512);
                break;
            }
            case 1: {
                this.setRemotePort(514);
                break;
            }
            default: {
                throw new IPWorksException(345);
            }
        }
        this.protocol = n;
    }

    void setAction(int n) throws IPWorksException {
        this.setRCPAction(n);
    }

    /*
     * Loose catch block
     */
    private void setRCPAction(int n) throws IPWorksException {
        Object object;
        if (n == 0) {
            this.interrupt();
            return;
        }
        Object object2 = this.syncObj;
        synchronized (object2) {
            if (this.action != 0) {
                throw new IPWorksException(9305);
            }
            this.restart();
            this.action = n;
        }
        try {
            if (this.getLocalFile().length() == 0) {
                throw new IPWorksException(306);
            }
            if (this.remoteFile.length() == 0) {
                throw new IPWorksException(307);
            }
            this.lastStderr.setLength(0);
            this.setEOL(CBase.LFB);
            this.fileSize = -1;
            switch (n) {
                case 1: {
                    this.setCommand("rcp -f " + this.remoteFile, false);
                    this.sendMessage(ZEROB);
                    if (this.lastReply.startsWith("D")) {
                        this.sendMessage(ZEROB);
                    }
                    if (!this.lastReply.startsWith("C")) {
                        throw new IPWorksException(9311, this.lastReply.startsWith(ZEROS) ? this.lastReply : this.lastStderr.toString());
                    }
                    int n2 = this.lastReply.indexOf(32) + 1;
                    int n3 = this.lastReply.indexOf(32, n2);
                    try {
                        this.fileSize = Integer.parseInt(this.lastReply.substring(n2, n3));
                    }
                    catch (Exception exception) {
                        throw new IPWorksException(9311, "Invalid server response");
                    }
                    try {
                        this.fos = new FileOutputStream(this.getLocalFile());
                    }
                    catch (IOException iOException) {
                        throw new IPWorksException(304);
                    }
                    this.setEOL(CBase.BYTE0);
                    this.setDataToSend(ZEROB);
                    this.setAcceptData(true);
                    this.waitForDisconnect();
                    break;
                }
                case 2: {
                    this.setCommand("rcp -t " + this.remoteFile, false);
                    File file = new File(this.localFile);
                    if (file == null) {
                        throw new IPWorksException(344);
                    }
                    this.setEOL(ZEROB);
                    this.sendMessage(("C" + this.fileMode + " " + String.valueOf(file.length()) + " " + this.remoteFile + "\n").getBytes());
                    if (this.lastReply.length() > 0) {
                        throw new IPWorksException(9311, this.lastReply);
                    }
                    this.sendLocalFile(1);
                    this.setConnected(false);
                }
            }
            Object var7_10 = null;
            if (this.errorMessage.length() > 0) {
                this.pendingException = new IPWorksException(311, this.errorMessage);
            }
            object = this.syncObj;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            if (this.errorMessage.length() > 0) {
                this.pendingException = new IPWorksException(311, this.errorMessage);
            }
            Object object3 = this.syncObj;
            synchronized (object3) {
                Exception exception2222;
                block46: {
                    this.action = 0;
                    if (this.fos != null) {
                        try {
                            this.fos.close();
                        }
                        catch (IOException exception2222) {
                            if (this.pendingException != null) break block46;
                            this.pendingException = new IPWorksException(310, exception2222.getMessage());
                        }
                    }
                }
                exception2222 = this.pendingException;
                this.interrupt();
                if (exception2222 != null) {
                    throw exception2222;
                }
            }
            throw throwable;
        }
        synchronized (object) {
            Exception exception3222;
            block44: {
                this.action = 0;
                if (this.fos != null) {
                    try {
                        this.fos.close();
                    }
                    catch (IOException exception3222) {
                        if (this.pendingException != null) break block44;
                        this.pendingException = new IPWorksException(310, exception3222.getMessage());
                    }
                }
            }
            exception3222 = this.pendingException;
            this.interrupt();
            if (exception3222 != null) {
                throw exception3222;
            }
        }
        {
            catch (IPWorksException iPWorksException) {
                if (this.pendingException == null) {
                    this.pendingException = iPWorksException;
                }
                Object var7_11 = null;
                if (this.errorMessage.length() > 0) {
                    this.pendingException = new IPWorksException(311, this.errorMessage);
                }
                Object object4 = this.syncObj;
                synchronized (object4) {
                    Exception exception4222;
                    block45: {
                        this.action = 0;
                        if (this.fos != null) {
                            try {
                                this.fos.close();
                            }
                            catch (IOException exception4222) {
                                if (this.pendingException != null) break block45;
                                this.pendingException = new IPWorksException(310, exception4222.getMessage());
                            }
                        }
                    }
                    exception4222 = this.pendingException;
                    this.interrupt();
                    if (exception4222 != null) {
                        throw exception4222;
                    }
                }
            }
        }
    }

    void fireDataIn(byte[] byArray, boolean bl) {
        if (this.fileSize == -1) {
            super.fireDataIn(byArray, bl);
            return;
        }
        try {
            this.fos.write(byArray);
        }
        catch (IOException iOException) {
            if (this.pendingException == null) {
                this.pendingException = new IPWorksException(310);
            }
            try {
                this.setConnected(false, 0L);
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
            return;
        }
        this.fileSize -= byArray.length;
        if (this.fileSize <= 0) {
            try {
                this.setDataToSend(ZEROB);
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
            try {
                this.setConnected(false);
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
        }
    }

    void fireStderr(byte[] byArray, boolean bl) {
        this.lastStderr.append(byArray);
    }
}

