/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CBase;
import ipworks.CIPPMsg;
import ipworks.CIPPort;
import ipworks.IPWorksException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

class CRs
extends CIPPMsg {
    private byte[] errEOL = CBase.LFB;
    private CErrPort errPort = null;
    private CListenerThread listenerThread = null;
    private boolean gotFirstByte;
    private int stderrPort;
    private boolean enableStderr = true;
    protected String command = "";
    protected String firstAuthPiece = "";
    protected String secondAuthPiece = "";
    protected String errorMessage = "";

    CRs(Object object) {
        super(null, object);
        this.setEOL(this.errEOL);
    }

    void do_Disconnect() throws IPWorksException {
        this.setCommand(null);
    }

    void do_Execute(String string) throws IPWorksException {
        this.setCommand(string);
    }

    void do_Send(byte[] byArray) throws IPWorksException {
        this.setStdin(byArray);
    }

    void setEnableStderr(boolean bl) throws IPWorksException {
        this.enableStderr = bl;
        if (!bl) {
            this.stderrPort = 0;
        }
    }

    boolean getEnableStderr() {
        return this.enableStderr;
    }

    void setStderrPort(int n) throws IPWorksException {
        this.stderrPort = n;
    }

    int getStderrPort() {
        return this.stderrPort;
    }

    private void connectFromSecurePort() throws IPWorksException {
        int n = 500 + (int)(System.currentTimeMillis() % 300L);
        if (n < 1000) {
            this.setLocalPort(n);
            this.blockConnect();
            return;
        }
        throw new IPWorksException(5001);
    }

    private ServerSocket createServerSocket(int n) throws IOException {
        ServerSocket serverSocket;
        InetAddress inetAddress = InetAddress.getByName(this.getLocalHost());
        try {
            serverSocket = new ServerSocket(n, 10, inetAddress);
        }
        catch (IOException iOException) {
            serverSocket = new ServerSocket(n);
        }
        serverSocket.setSoTimeout(100);
        return serverSocket;
    }

    private ServerSocket createServerSocket() throws IPWorksException {
        if (this.stderrPort > 0) {
            try {
                return this.createServerSocket(this.stderrPort);
            }
            catch (IOException iOException) {
            }
        } else {
            int n = 500;
            while (n < 1000) {
                try {
                    return this.createServerSocket(n);
                }
                catch (IOException iOException) {
                    ++n;
                }
            }
            this.stderrPort = 0;
        }
        throw new IPWorksException(5001);
    }

    void interrupt() {
        super.interrupt();
        this.command = "";
        Object object = this.syncObj;
        synchronized (object) {
            try {
                if (this.errPort != null) {
                    this.errPort.setConnected(false, 0L);
                }
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
        }
        this.stderrPort = 0;
        this.listenerThread = null;
        this.errPort = null;
    }

    String getCommand() {
        return this.command;
    }

    void setCommand(String string) throws IPWorksException {
        this.setCommand(string, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setCommand(String string, boolean bl) throws IPWorksException {
        Object object = this.syncObj;
        synchronized (object) {
            Object object2;
            if (string == null || string.length() == 0) {
                this.interrupt();
                return;
            }
            if (this.getConnected()) {
                throw new IPWorksException(5002);
            }
            this.restart();
            this.command = string;
            this.gotFirstByte = false;
            this.errorMessage = "";
            try {
                try {
                    this.connectFromSecurePort();
                    int n = 0;
                    if (this.enableStderr) {
                        ServerSocket serverSocket = this.createServerSocket();
                        n = serverSocket.getLocalPort();
                        this.listenerThread = new CListenerThread(serverSocket);
                        this.listenerThread.start();
                    }
                    this.setAcceptData(true);
                    this.blockSend(n + "\u0000" + this.firstAuthPiece + "\u0000" + this.secondAuthPiece + "\u0000" + string + "\u0000");
                    if (bl) {
                        this.waitForDisconnect();
                    }
                }
                catch (IPWorksException iPWorksException) {
                    if (this.pendingException == null) {
                        this.pendingException = iPWorksException;
                    }
                    Object var7_8 = null;
                    Object object4 = this.syncObj;
                    synchronized (object4) {
                        this.command = "";
                        if (this.pendingException == null) return;
                        if (this.pendingException.getCode() != 201) throw this.pendingException;
                        this.interrupt();
                        throw this.pendingException;
                    }
                }
                Object var7_7 = null;
                object2 = this.syncObj;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                Object object3 = this.syncObj;
                synchronized (object3) {
                    this.command = "";
                    if (this.pendingException == null) throw throwable;
                    if (this.pendingException.getCode() != 201) throw this.pendingException;
                    this.interrupt();
                    throw this.pendingException;
                }
            }
            synchronized (object2) {
                this.command = "";
                if (this.pendingException == null) return;
                if (this.pendingException.getCode() != 201) throw this.pendingException;
                this.interrupt();
                throw this.pendingException;
            }
        }
    }

    String getFirstAuthPiece() {
        return this.firstAuthPiece;
    }

    void setFirstAuthPiece(String string) {
        this.firstAuthPiece = string != null ? string : "";
    }

    String getSecondAuthPiece() {
        return this.secondAuthPiece;
    }

    void setSecondAuthPiece(String string) {
        this.secondAuthPiece = string != null ? string : "";
    }

    void setStdin(byte[] byArray) throws IPWorksException {
        this.restart();
        this.setDataToSend(byArray);
    }

    void setStdin(byte[] byArray, int n, int n2) throws IPWorksException {
        this.restart();
        this.setDataToSend(byArray, n, n2);
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    byte[] getErrEOL() {
        return this.errEOL;
    }

    void setErrEOL(byte[] byArray) {
        this.setErrEOL(byArray, 0, byArray == null ? 0 : byArray.length);
    }

    void setErrEOL(byte[] byArray, int n, int n2) {
        Object object = this.syncObj;
        synchronized (object) {
            if (byArray == null) {
                this.errEOL = CBase.BYTE0;
            } else {
                this.errEOL = new byte[n2];
                System.arraycopy(byArray, n, this.errEOL, 0, n2);
            }
            if (this.errPort != null) {
                this.errPort.setEOL(this.errEOL);
            }
        }
    }

    void fireDataIn(byte[] byArray, boolean bl) {
        if (!this.gotFirstByte) {
            this.gotFirstByte = true;
            int n = byArray.length;
            if (n > 0) {
                byte[] byArray2 = byArray;
                byArray = new byte[n - 1];
                System.arraycopy(byArray2, 1, byArray, 0, n - 1);
                if (byArray2[0] != 0) {
                    this.errorMessage = new String(byArray);
                }
            }
        }
        super.fireDataIn(byArray, bl);
        this.setAcceptData(true);
        this.fireStdout(byArray, bl);
    }

    void fireDisconnected(IPWorksException iPWorksException) {
        super.fireDisconnected(iPWorksException);
    }

    void fireStderr(byte[] byArray, boolean bl) {
    }

    void fireStdout(byte[] byArray, boolean bl) {
    }

    class CErrPort
    extends CIPPort {
        CErrPort(Socket socket, Object object) {
            super(null, socket, object);
            this.setEOL(CRs.this.errEOL);
        }

        void fireDataIn(byte[] byArray, boolean bl) {
            if (CRs.this.errPort == this) {
                CRs.this.fireStderr(byArray, bl);
            }
        }

        void fireDisconnected(IPWorksException iPWorksException) {
            if (CRs.this.errPort == this) {
                CRs.this.fireStderr("\u0000".getBytes(), true);
            }
        }
    }

    class CListenerThread
    extends Thread {
        private ServerSocket serverSocket;

        CListenerThread(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        public void run() {
            while (CRs.this.listenerThread == this) {
                try {
                    Socket socket = this.serverSocket.accept();
                    Object object = CRs.this.syncObj;
                    synchronized (object) {
                        if (CRs.this.listenerThread == this) {
                            CRs.this.errPort = new CErrPort(socket, CRs.this.syncObj);
                            try {
                                CRs.this.errPort.setConnected(true);
                            }
                            catch (IPWorksException iPWorksException) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                }
                catch (InterruptedIOException interruptedIOException) {
                }
                catch (IOException iOException) {
                    break;
                }
            }
            try {
                this.serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

