/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CIPPMsg;
import ipworks.CNetCode;
import ipworks.CRfc822String;
import ipworks.CToParser;
import ipworks.IPWorksException;
import ipworks.Smtp;
import java.net.InetAddress;
import java.net.UnknownHostException;

class CSMTP
extends CIPPMsg {
    static final int idle = 0;
    static final int connect = 1;
    static final int disconnect = 2;
    static final int send = 3;
    static final int resetHeaders = 4;
    static final int expand = 5;
    static final int verify = 6;
    static final int sendAndMail = 7;
    static final int sendOrMail = 8;
    static final int sendNoMail = 9;
    static final int actionCommand = 10;
    private int action = 0;
    private int maxHeaderLength = 72;
    private boolean allowExtensions = false;
    private static final int PORT = 25;
    private static final String smtpEOL = "\r\n";
    private String from;
    private String sendTo;
    private String cc;
    private String bCc;
    private String replyTo;
    private String date;
    private String subject;
    private String otherHeaders;
    private String messageText;
    private String hello = "";
    private String command = "";
    private String user = "";
    private String password = "";
    private Smtp sink = null;

    CSMTP(Smtp smtp, Object object) {
        super(null, object);
        this.sink = smtp;
        this.setEOL(smtpEOL.getBytes());
        try {
            this.setOutBufferSize(20000);
            this.setRemotePort(25);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
        this.doActionResetHeaders();
    }

    void do_Connect() throws IPWorksException {
        this.setAction(1);
    }

    void do_Disconnect() throws IPWorksException {
        this.setAction(2);
    }

    void do_Expand(String string) throws IPWorksException {
        this.setSendTo(string);
        this.setAction(5);
    }

    void do_Interrupt() throws IPWorksException {
        this.setAction(0);
    }

    void do_ResetHeaders() throws IPWorksException {
        this.setAction(4);
    }

    void do_Send() throws IPWorksException {
        this.setAction(3);
    }

    void do_SendToTerminalAndEmail() throws IPWorksException {
        this.setAction(7);
    }

    void do_SendToTerminalOnly() throws IPWorksException {
        this.setAction(9);
    }

    void do_SendToTerminalOrEmail() throws IPWorksException {
        this.setAction(8);
    }

    void do_Verify(String string) throws IPWorksException {
        this.setSendTo(string);
        this.setAction(6);
    }

    void sendSMTPCommand(String string) throws IPWorksException {
        if (string != null) {
            this.firePITrail(0, string);
        }
        this.sendCommand(string, smtpEOL);
        boolean bl = false;
        while (true) {
            this.firePITrail(1, this.lastReply);
            int n = this.lastReply.length();
            if (n > 0) {
                switch (this.lastReply.charAt(0)) {
                    case '1': {
                        break;
                    }
                    case '2': {
                        if (n > 3) {
                            if (this.action == 5) {
                                this.fireExpand(this.lastReply.substring(4));
                            }
                            if (this.lastReply.charAt(3) == '-') break;
                        }
                    }
                    case '3': {
                        return;
                    }
                    default: {
                        bl = true;
                        break;
                    }
                }
            } else {
                bl = true;
            }
            if (bl) {
                throw new IPWorksException(161, this.lastReply);
            }
            this.waitForReply();
        }
    }

    private String getCanonical(String string) {
        int n = string.indexOf(60) + 1;
        int n2 = string.indexOf(62);
        if (n2 == -1) {
            n2 = string.length();
        }
        if (n2 - n > 256) {
            n2 = n + 256;
        }
        return string.substring(n, n2);
    }

    private void sendMailMessage(String string) throws IPWorksException {
        if (this.from.length() == 0) {
            throw new IPWorksException(164);
        }
        if (this.sendTo.length() == 0) {
            throw new IPWorksException(165);
        }
        this.sendSMTPCommand("RSET");
        this.sendSMTPCommand(string + " FROM: <" + this.getCanonical(this.from) + ">");
        CToParser cToParser = new CToParser(this.sendTo);
        while (cToParser.hasMoreElements()) {
            this.sendSMTPCommand("RCPT TO: <" + cToParser.nextElement() + ">");
        }
        cToParser = new CToParser(this.cc);
        while (cToParser.hasMoreElements()) {
            this.sendSMTPCommand("RCPT TO: <" + cToParser.nextElement() + ">");
        }
        cToParser = new CToParser(this.bCc);
        while (cToParser.hasMoreElements()) {
            try {
                this.sendSMTPCommand("RCPT TO: <" + cToParser.nextElement() + ">");
            }
            catch (IPWorksException iPWorksException) {
                // empty catch block
            }
        }
        this.sendSMTPCommand("DATA");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("To: " + CRfc822String.getFolded(this.sendTo, this.maxHeaderLength) + smtpEOL);
        stringBuffer.append("From: " + CRfc822String.getFolded(this.from, this.maxHeaderLength) + smtpEOL);
        if (this.subject.length() > 0) {
            stringBuffer.append("Subject: " + CRfc822String.getFolded(this.subject, this.maxHeaderLength) + smtpEOL);
        }
        if (this.replyTo.length() > 0) {
            stringBuffer.append("Reply-To: " + CRfc822String.getFolded(this.replyTo, this.maxHeaderLength) + smtpEOL);
        }
        if (this.date.length() > 0) {
            stringBuffer.append("Date: " + CRfc822String.getFolded(this.date, this.maxHeaderLength) + smtpEOL);
        }
        if (this.cc.length() > 0) {
            stringBuffer.append("Cc: " + CRfc822String.getFolded(this.cc, this.maxHeaderLength) + smtpEOL);
        }
        if (this.otherHeaders.length() > 0) {
            stringBuffer.append(this.otherHeaders);
        }
        stringBuffer.append(smtpEOL);
        this.blockSend(stringBuffer.toString());
        if (this.messageText.length() > 0) {
            this.bytesSent = 0;
            this.fireStartTransfer();
            this.blockSend(CRfc822String.getDoubleDoted(this.messageText) + smtpEOL, 2);
            this.fireEndTransfer();
        }
        if (this.attachedFile.length() > 0) {
            this.bytesSent = 0;
            this.fireStartTransfer();
            this.sendAttachedFile(false, 2);
            this.fireEndTransfer();
        }
        this.blockSend(smtpEOL);
        this.sendSMTPCommand(".");
    }

    private void doActionSend(int n) throws IPWorksException {
        switch (n) {
            case 8: {
                this.sendMailMessage("SOML");
                break;
            }
            case 7: {
                this.sendMailMessage("SAML");
                break;
            }
            case 9: {
                this.sendMailMessage("SEND");
                break;
            }
            case 3: {
                this.sendMailMessage("MAIL");
            }
        }
    }

    private void doActionExpand() throws IPWorksException {
        this.sendSMTPCommand("EXPN " + CRfc822String.getFolded(this.sendTo, this.maxHeaderLength));
    }

    private void doActionVerify() throws IPWorksException {
        this.sendSMTPCommand("VRFY " + CRfc822String.getFolded(this.sendTo, this.maxHeaderLength));
        this.sendTo = this.lastReply;
    }

    private void doActionResetHeaders() {
        this.password = "";
        this.user = "";
        this.attachedFile = "";
        this.messageText = "";
        this.otherHeaders = "";
        this.subject = "";
        this.date = "";
        this.replyTo = "";
        this.bCc = "";
        this.cc = "";
        this.sendTo = "";
        this.from = "";
    }

    private void doActionConnect() throws IPWorksException {
        if (!this.getConnected()) {
            String string = this.hello;
            if (this.hello.length() == 0) {
                try {
                    string = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException unknownHostException) {
                    throw new IPWorksException(unknownHostException);
                }
            }
            this.firePITrail(2, "Connecting to mail server.");
            this.blockConnect();
            try {
                this.sendSMTPCommand(null);
                if (this.allowExtensions) {
                    try {
                        this.sendSMTPCommand("EHLO " + string);
                        return;
                    }
                    catch (IPWorksException iPWorksException) {
                        // empty catch block
                    }
                }
                this.sendSMTPCommand("HELO " + string);
                if (this.user.length() > 0 && this.password.length() > 0) {
                    this.sendSMTPCommand("AUTH LOGIN");
                    CNetCode cNetCode = new CNetCode(null, this.syncObj);
                    cNetCode.format = 1;
                    cNetCode.setDecodedData(this.user.getBytes());
                    cNetCode.setAction(4);
                    this.sendSMTPCommand(new String(cNetCode.getEncodedData()));
                    cNetCode.setDecodedData(this.password.getBytes());
                    cNetCode.setAction(4);
                    this.sendSMTPCommand(new String(cNetCode.getEncodedData()));
                }
            }
            catch (IPWorksException iPWorksException) {
                try {
                    this.doActionDisconnect();
                }
                catch (IPWorksException iPWorksException2) {
                    // empty catch block
                }
                throw iPWorksException;
            }
        }
    }

    private void doActionDisconnect() throws IPWorksException {
        if (this.getConnected()) {
            try {
                this.firePITrail(2, "Forcing disconnection from SMTP server.");
                this.sendSMTPCommand("QUIT");
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.setConnected(false);
                throw throwable;
            }
            this.setConnected(false);
            {
            }
        }
    }

    void setAction(int n) throws IPWorksException {
        this.setSMTPAction(n);
    }

    /*
     * Loose catch block
     */
    private void setSMTPAction(int n) throws IPWorksException {
        Object object;
        if (n == 0) {
            this.interrupt();
            return;
        }
        Object object2 = this.syncObj;
        synchronized (object2) {
            if (this.action != 0) {
                throw new IPWorksException(166);
            }
            this.restart();
            this.action = n;
        }
        try {
            switch (n) {
                case 3: 
                case 7: 
                case 8: 
                case 9: {
                    this.doActionConnect();
                    this.doActionSend(n);
                    break;
                }
                case 1: {
                    this.doActionConnect();
                    break;
                }
                case 2: {
                    this.doActionDisconnect();
                    break;
                }
                case 4: {
                    this.doActionResetHeaders();
                    break;
                }
                case 5: {
                    this.doActionConnect();
                    this.doActionExpand();
                    break;
                }
                case 6: {
                    this.doActionConnect();
                    this.doActionVerify();
                    break;
                }
                case 10: {
                    this.doActionConnect();
                    if (this.command.length() <= 0) break;
                    this.sendSMTPCommand(this.command);
                }
            }
            Object var5_5 = null;
            object = this.syncObj;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            Object object3 = this.syncObj;
            synchronized (object3) {
                this.action = 0;
                if (this.pendingException != null) {
                    if (this.pendingException.getCode() == 201) {
                        try {
                            this.setConnected(false, 0L);
                        }
                        catch (IPWorksException iPWorksException) {
                            // empty catch block
                        }
                    }
                    throw this.pendingException;
                }
            }
            throw throwable;
        }
        synchronized (object) {
            this.action = 0;
            if (this.pendingException != null) {
                if (this.pendingException.getCode() == 201) {
                    try {
                        this.setConnected(false, 0L);
                    }
                    catch (IPWorksException iPWorksException) {
                        // empty catch block
                    }
                }
                throw this.pendingException;
            }
        }
        {
            catch (IPWorksException iPWorksException) {
                if (this.pendingException == null) {
                    this.pendingException = iPWorksException;
                }
                Object var5_6 = null;
                Object object4 = this.syncObj;
                synchronized (object4) {
                    this.action = 0;
                    if (this.pendingException != null) {
                        if (this.pendingException.getCode() == 201) {
                            try {
                                this.setConnected(false, 0L);
                            }
                            catch (IPWorksException iPWorksException2) {
                                // empty catch block
                            }
                        }
                        throw this.pendingException;
                    }
                }
            }
        }
    }

    int getAction() {
        return this.action;
    }

    void setUser(String string) {
        this.user = string != null ? string : "";
    }

    String getUser() {
        return this.user;
    }

    void setPassword(String string) {
        this.password = string != null ? string : "";
    }

    String getPassword() {
        return this.password;
    }

    String getMailServer() {
        return this.getRemoteHost();
    }

    void setMailServer(String string) throws IPWorksException {
        this.setRemoteHost(string);
    }

    int getMailPort() {
        return this.getRemotePort();
    }

    void setMailPort(int n) throws IPWorksException {
        this.setRemotePort(n);
    }

    String getFrom() {
        return this.from;
    }

    void setFrom(String string) {
        this.from = string != null ? string : "";
    }

    String getSendTo() {
        return this.sendTo;
    }

    void setSendTo(String string) {
        this.sendTo = string != null ? string : "";
    }

    String getCc() {
        return this.cc;
    }

    void setCc(String string) {
        this.cc = string != null ? string : "";
    }

    String getBCc() {
        return this.bCc;
    }

    void setBCc(String string) {
        this.bCc = string != null ? string : "";
    }

    String getReplyTo() {
        return this.replyTo;
    }

    void setReplyTo(String string) {
        this.replyTo = string != null ? string : "";
    }

    String getMessageDate() {
        return this.date;
    }

    void setMessageDate(String string) {
        this.date = string != null ? string : "";
    }

    String getDate() {
        return this.date;
    }

    void setDate(String string) {
        this.date = string != null ? string : "";
    }

    String getSubject() {
        return CRfc822String.getFolded(this.subject, this.maxHeaderLength);
    }

    void setSubject(String string) {
        this.subject = string != null ? string : "";
    }

    String getOtherHeaders() {
        return this.otherHeaders;
    }

    void setOtherHeaders(String string) {
        this.otherHeaders = CIPPMsg.toValidHeader(string != null ? string : "");
    }

    String getMessageText() {
        return CRfc822String.getDoubleDoted(this.messageText);
    }

    void setMessageText(String string) {
        this.messageText = string != null ? string : "";
    }

    String getHello() {
        return this.hello;
    }

    void setHello(String string) {
        this.hello = string != null ? string : "";
    }

    int getMaxHeaderLength() {
        return this.maxHeaderLength;
    }

    void setMaxHeaderLength(int n) {
        this.maxHeaderLength = n > 0 ? n : 0;
    }

    void setCommand(String string) throws IPWorksException {
        this.command = string != null ? string : "";
        this.setSMTPAction(10);
    }

    boolean getAllowExtensions() {
        return this.allowExtensions;
    }

    void setAllowExtensions(boolean bl) {
        this.allowExtensions = bl;
    }

    void fireConnected(IPWorksException iPWorksException) {
        super.fireConnected(iPWorksException);
        if (iPWorksException == null) {
            this.firePITrail(2, "Connected.");
        } else {
            this.fireError(new IPWorksException(162));
        }
    }

    void fireDisconnected(IPWorksException iPWorksException) {
        super.fireDisconnected(iPWorksException);
        if (iPWorksException == null) {
            this.firePITrail(2, "Disonnected.");
        } else {
            this.fireError(new IPWorksException(162));
        }
    }

    void firePITrail(int n, String string) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.firePITrail(n, string);
            }
        }
    }

    void fireExpand(String string) {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.fireExpand(string);
            }
        }
    }

    void fireStartTransfer() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.fireStartTransfer();
            }
        }
    }

    void fireTransfer(int n, byte[] byArray) {
        if (this.pendingException == null && this.sink != null) {
            this.sink.fireTransfer(n);
        }
    }

    void fireEndTransfer() {
        Object object = this.syncObj;
        synchronized (object) {
            if (this.pendingException == null && this.sink != null) {
                this.sink.fireEndTransfer();
            }
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }
}

