/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CBase;
import ipworks.CHTTP;
import ipworks.CXMLp;
import ipworks.Http;
import ipworks.IPWorksException;
import ipworks.Soap;
import java.util.Vector;

class CSOAP
extends CHTTP {
    static final int IDLE = 0;
    static final int SEND_REQUEST = 1;
    static final int RESET = 2;
    static final int BUILD_PACKET = 3;
    static final int SEND_PACKET = 4;
    static final int EVAL_PACKET = 5;
    private static final String PREFIX0 = "SOAP-ENV";
    private static final String NAMESPACE0 = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String ENCODING = "http://schemas.xmlsoap.org/soap/encoding/";
    private static final int VF_TEXT = 0;
    private static final int VF_XML = 1;
    private static final int VF_FULL_XML = 2;
    private int action = 0;
    private int valueFormat = 0;
    private Vector prefixes = new Vector();
    private Vector namespaces = new Vector();
    private String encoding = "http://schemas.xmlsoap.org/soap/encoding/";
    private String header = "";
    private String methodName = "";
    private String methodURI = "";
    private String actionURI = "";
    private Vector paramNames = new Vector();
    private Vector paramValues = new Vector();
    private Vector paramAttrs = new Vector();
    private CXMLp xmlParser;
    private Soap sink;

    CSOAP(Soap soap, Object object) {
        super((Http)null, object);
        this.sink = soap;
        this.xmlParser = new CXMLp(null, object);
        try {
            this.xmlParser.setValidate(true);
            this.xmlParser.setBuildDOM(true);
            this.setParamCount(0);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
        this.prefixes.addElement(PREFIX0);
        this.namespaces.addElement(NAMESPACE0);
    }

    void do_BuildPacket() throws IPWorksException {
        this.setAction(3);
    }

    void do_EvalPacket() throws IPWorksException {
        this.setAction(5);
    }

    void do_Interrupt() throws IPWorksException {
        this.setAction(0);
    }

    void do_Reset() throws IPWorksException {
        this.setAction(2);
    }

    void do_SendPacket() throws IPWorksException {
        this.setAction(4);
    }

    void do_SendRequest() throws IPWorksException {
        this.setAction(1);
    }

    void do_AddParam(String string, String string2) throws IPWorksException {
        int n = this.getParamCount() + 1;
        this.setParamCount(n);
        this.setParamName(n, string);
        this.setParamValue(n, string2);
    }

    int getAction() {
        return this.action;
    }

    String getActionURI() {
        return this.actionURI;
    }

    void setActionURI(String string) throws IPWorksException {
        this.actionURI = string != null ? string : "";
    }

    String getMethod() {
        return this.methodName;
    }

    void setMethod(String string) throws IPWorksException {
        this.methodName = string != null ? string : "";
        this.actionURI = this.methodURI + "#" + this.methodName;
    }

    String getMethodURI() {
        return this.methodURI;
    }

    void setMethodURI(String string) throws IPWorksException {
        this.methodURI = string != null ? string : "";
        this.actionURI = this.methodURI + "#" + this.methodName;
    }

    private void checkNamespaceIndex(int n) throws IPWorksException {
        if (n < 0 || n >= this.namespaces.size()) {
            throw new IPWorksException(170);
        }
    }

    int getNamespaceCount() {
        return this.namespaces.size();
    }

    void setNamespaceCount(int n) {
        if (n < 0) {
            n = 0;
        }
        this.prefixes.setSize(n);
        this.namespaces.setSize(n);
    }

    String getPrefixes(int n) throws IPWorksException {
        this.checkNamespaceIndex(--n);
        return (String)this.prefixes.elementAt(n);
    }

    void setPrefixes(int n, String string) throws IPWorksException {
        this.checkNamespaceIndex(--n);
        this.prefixes.setElementAt(string, n);
    }

    String getNamespaces(int n) throws IPWorksException {
        this.checkNamespaceIndex(--n);
        return (String)this.namespaces.elementAt(n);
    }

    void setNamespaces(int n, String string) throws IPWorksException {
        this.checkNamespaceIndex(--n);
        this.namespaces.setElementAt(string, n);
    }

    int getParamCount() {
        return this.paramNames.size() - 1;
    }

    void setParamCount(int n) throws IPWorksException {
        if (++n < 0) {
            n = 0;
        }
        this.paramNames.setSize(n);
        this.paramValues.setSize(n);
        this.paramAttrs.setSize(n);
    }

    private void checkParamIndex(int n) throws IPWorksException {
        if (n < 0 || n >= this.paramNames.size()) {
            throw new IPWorksException(170);
        }
    }

    String getParamAttr(int n) throws IPWorksException {
        this.checkParamIndex(n);
        return (String)this.paramAttrs.elementAt(n);
    }

    void setParamAttr(int n, String string) throws IPWorksException {
        this.checkParamIndex(n);
        this.paramAttrs.setElementAt(string, n);
    }

    String getParamName(int n) throws IPWorksException {
        this.checkParamIndex(n);
        return (String)this.paramNames.elementAt(n);
    }

    void setParamName(int n, String string) throws IPWorksException {
        this.checkParamIndex(n);
        this.paramNames.setElementAt(string, n);
    }

    String getParamValue(int n) throws IPWorksException {
        this.checkParamIndex(n);
        return (String)this.paramValues.elementAt(n);
    }

    void setParamValue(int n, String string) throws IPWorksException {
        this.checkParamIndex(n);
        this.paramValues.setElementAt(string, n);
    }

    String getReturnValue() {
        try {
            return this.getParamValue(0);
        }
        catch (IPWorksException iPWorksException) {
            return "";
        }
    }

    String getSOAPEncoding() {
        return this.encoding;
    }

    void setSOAPEncoding(String string) throws IPWorksException {
        this.encoding = string != null ? string : "";
    }

    String getSOAPHeader() {
        return this.header;
    }

    void setSOAPHeader(String string) throws IPWorksException {
        this.header = string != null ? string : "";
    }

    String getSOAPPacket() {
        return new String(this.getPostData());
    }

    void setSOAPPacket(String string) throws IPWorksException {
        this.setPostData(string != null ? string.getBytes() : CBase.BYTE0);
    }

    int getValueFormat() {
        return this.valueFormat;
    }

    void setValueFormat(int n) throws IPWorksException {
        this.valueFormat = n;
    }

    int getFlags() {
        return this.xmlParser.getFlags();
    }

    void setFlags(int n) {
        this.xmlParser.setFlags(n);
    }

    int getXAttrCount() {
        return this.xmlParser.getAttrCount();
    }

    String getXAttrName(int n) {
        return this.xmlParser.getAttrName(n);
    }

    String getXAttrNamespace(int n) {
        return this.xmlParser.getAttrNamespace(n);
    }

    String getXAttrPrefix(int n) {
        return this.xmlParser.getAttrPrefix(n);
    }

    String getXAttrValue(int n) {
        return this.xmlParser.getAttrValue(n);
    }

    int getXChildren() {
        return this.xmlParser.getXChildren();
    }

    String getXElement() {
        return this.xmlParser.getXElement();
    }

    String getXNamespace() {
        return this.xmlParser.getXNamespace();
    }

    String getXParent() {
        return this.xmlParser.getXParent();
    }

    String getXPath() {
        return this.xmlParser.getXPath();
    }

    void setXPath(String string) throws IPWorksException {
        this.xmlParser.setXPath(string);
    }

    String getXPrefix() {
        return this.xmlParser.getXPrefix();
    }

    String getXText() {
        return this.xmlParser.getXText();
    }

    void setAction(int n) throws IPWorksException {
        this.setSOAPAction(n);
    }

    /*
     * Loose catch block
     */
    private void setSOAPAction(int n) throws IPWorksException {
        Object object;
        if (n == 0) {
            this.interrupt();
            return;
        }
        Object object2 = this.syncObj;
        synchronized (object2) {
            if (this.action != 0) {
                throw new IPWorksException(168);
            }
            this.restart();
            this.action = n;
        }
        try {
            switch (n) {
                case 1: {
                    this.buildPacket();
                    this.setOtherHeaders("SOAPAction: " + this.actionURI);
                    super.setAction(2);
                    this.evalPacket();
                    break;
                }
                case 2: {
                    this.setPostData(null);
                    this.xmlParser.reset();
                    this.setParamCount(0);
                    super.setAction(4);
                    break;
                }
                case 3: {
                    this.buildPacket();
                    break;
                }
                case 4: {
                    this.setOtherHeaders("SOAPAction: " + this.actionURI);
                    super.setAction(2);
                    break;
                }
                case 5: {
                    this.evalPacket();
                }
            }
            Object var5_5 = null;
            object = this.syncObj;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            Object object3 = this.syncObj;
            synchronized (object3) {
                this.action = 0;
                if (this.pendingException != null) {
                    if (this.pendingException.getCode() == 201) {
                        try {
                            this.setConnected(false, 0L);
                        }
                        catch (IPWorksException iPWorksException) {
                            // empty catch block
                        }
                    }
                    throw this.pendingException;
                }
            }
            throw throwable;
        }
        synchronized (object) {
            this.action = 0;
            if (this.pendingException != null) {
                if (this.pendingException.getCode() == 201) {
                    try {
                        this.setConnected(false, 0L);
                    }
                    catch (IPWorksException iPWorksException) {
                        // empty catch block
                    }
                }
                throw this.pendingException;
            }
        }
        {
            catch (IPWorksException iPWorksException) {
                if (this.pendingException == null) {
                    this.pendingException = iPWorksException;
                }
                Object var5_6 = null;
                Object object4 = this.syncObj;
                synchronized (object4) {
                    this.action = 0;
                    if (this.pendingException != null) {
                        if (this.pendingException.getCode() == 201) {
                            try {
                                this.setConnected(false, 0L);
                            }
                            catch (IPWorksException iPWorksException2) {
                                // empty catch block
                            }
                        }
                        throw this.pendingException;
                    }
                }
            }
        }
    }

    void buildPacket() throws IPWorksException {
        if (this.methodName.length() == 0) {
            throw new IPWorksException(11171);
        }
        if (this.methodURI.length() == 0) {
            throw new IPWorksException(11172);
        }
        String string = this.prefixes.size() == 0 ? PREFIX0 : (String)this.prefixes.elementAt(0);
        String string2 = this.namespaces.size() == 0 ? NAMESPACE0 : (String)this.namespaces.elementAt(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<" + string + ":Envelope xmlns:" + string + "=\"" + string2 + "\"");
        if (this.encoding.length() > 0) {
            stringBuffer.append(" " + string + ":encodingStyle=\"" + this.encoding + "\"");
        }
        int n = 1;
        while (n < this.namespaces.size()) {
            stringBuffer.append(" xmlns:" + (String)this.prefixes.elementAt(n) + "=\"" + (String)this.namespaces.elementAt(n) + "\"");
            ++n;
        }
        stringBuffer.append(">");
        if (this.header.length() > 0) {
            stringBuffer.append("<" + string + ":Header>" + this.header + "</" + string + ":Header>");
        }
        stringBuffer.append("<" + string + ":Body>" + "<m:" + this.methodName + " xmlns:m=\"" + this.methodURI + "\">");
        int n2 = 1;
        while (n2 < this.paramNames.size()) {
            String string3;
            String string4;
            String string5 = (String)this.paramNames.elementAt(n2);
            if (string5 == null) {
                string5 = "";
            }
            if ((string4 = (String)this.paramValues.elementAt(n2)) == null) {
                string4 = "";
            }
            string3 = (string3 = (String)this.paramAttrs.elementAt(n2)) != null ? (string3.length() != 0 ? " " + string3 : "") : "";
            stringBuffer.append("<" + string5 + string3 + ">" + string4);
            stringBuffer.append("</" + string5 + ">");
            ++n2;
        }
        stringBuffer.append("</m:" + this.methodName + ">" + "</" + string + ":Body>");
        stringBuffer.append("</" + string + ":Envelope>");
        this.setPostData(stringBuffer.toString().getBytes());
    }

    /*
     * Unable to fully structure code
     */
    void evalPacket() throws IPWorksException {
        this.xmlParser.reset();
        this.xmlParser.setInputText(this.getTransferredData());
        this.xmlParser.flush();
        try {
            this.xmlParser.setXPath("/Envelope/Body/Fault");
            throw new IPWorksException(11173);
        }
        catch (IPWorksException var1_1) {
            this.paramNames.setSize(0);
            this.paramValues.setSize(0);
            this.paramAttrs.setSize(0);
            var1_2 = this.xmlParser.getXChildren();
            var2_3 = 1;
            ** while (var2_3 <= var1_2)
        }
lbl-1000:
        // 1 sources

        {
            this.xmlParser.setXPath("/Envelope/Body/[1]/[" + var2_3 + "]");
            this.paramNames.addElement(this.xmlParser.getXElement());
            this.paramValues.addElement(this.xmlParser.getXText());
            this.paramAttrs.addElement("");
            ++var2_3;
            continue;
        }
lbl20:
        // 1 sources

    }

    String getFaultCode() {
        try {
            this.xmlParser.setXPath("/Envelope/Body/Fault/faultcode");
            return this.xmlParser.getXText();
        }
        catch (IPWorksException iPWorksException) {
            return "";
        }
    }

    String getFaultString() {
        try {
            this.xmlParser.setXPath("/Envelope/Body/Fault/faultstring");
            return this.xmlParser.getXText();
        }
        catch (IPWorksException iPWorksException) {
            return "";
        }
    }

    String getFaultActor() {
        try {
            this.xmlParser.setXPath("/Envelope/Body/Fault/faultactor");
            return this.xmlParser.getXText();
        }
        catch (IPWorksException iPWorksException) {
            return "";
        }
    }

    void fireConnected(IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireConnected(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireConnected(0, "OK");
            }
        }
    }

    void fireDisconnected(IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireDisconnected(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireDisconnected(0, "OK");
            }
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }

    void fireHeader(String string, String string2) {
        if (this.sink != null) {
            this.sink.fireHeader(string, string2);
        }
    }

    void fireSetCookie(String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (this.sink != null) {
            this.sink.fireSetCookie(string, string2, string3, string4, string5, bl);
        }
    }

    void fireStartTransfer(int n) {
        if (n == 1 && this.sink != null && this.pendingException == null) {
            this.sink.fireStartTransfer();
        }
    }

    void fireTransfer(int n, int n2, byte[] byArray) {
        if (n == 1 && this.sink != null && this.pendingException == null) {
            this.sink.fireTransfer(n2);
        }
    }

    void fireEndTransfer(int n) {
        if (n == 1 && this.sink != null && this.pendingException == null) {
            this.sink.fireEndTransfer();
        }
    }
}

