/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CIPPMsg;
import ipworks.IPWorksException;
import ipworks.Telnet;

class CTelnet
extends CIPPMsg {
    private static final byte TCMD_IAC = -1;
    private static final byte TCMD_DO = -3;
    private static final byte TCMD_DONT = -2;
    private static final byte TCMD_WILL = -5;
    private static final byte TCMD_WONT = -4;
    private static final byte TCMD_SUBOPT_START = -6;
    private static final byte TCMD_SUBOPT_END = -16;
    private static final int everyThing = 1;
    private static final int command = 2;
    private static final int subOption = 3;
    private static final int endSubOption = 4;
    private static final int commandDo = 5;
    private static final int commandDont = 6;
    private static final int commandWill = 7;
    private static final int commandWont = 8;
    private static final int PORT = 23;
    private int waitingFor = 1;
    private boolean transparent = false;
    private int start;
    private int len;
    private byte[] toFire;
    private byte[] dataIn;
    private Telnet sink = null;

    CTelnet(Telnet telnet, Object object) {
        super(null, object);
        this.sink = telnet;
        try {
            this.setRemotePort(23);
            this.setMaxLineLength(1);
        }
        catch (IPWorksException iPWorksException) {
            // empty catch block
        }
    }

    void do_Connect(String string) throws IPWorksException {
        this.setRemoteHost(string);
        this.setConnected(true);
    }

    void setUrgentData(byte[] byArray, int n, int n2) throws IPWorksException {
    }

    void sendOption(byte by, byte by2) throws IPWorksException {
        this.restart();
        byte[] byArray = new byte[]{-1, by, by2};
        this.setDataToSend(byArray);
    }

    void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    boolean getTransparent() {
        return this.transparent;
    }

    void setUrgentData(byte[] byArray) {
    }

    void setCommand(int n) throws IPWorksException {
        this.restart();
        byte[] byArray = new byte[]{-1, (byte)n};
        this.setDataToSend(byArray);
    }

    void setDoOption(int n) throws IPWorksException {
        this.sendOption((byte)-3, (byte)n);
    }

    void setDontOption(int n) throws IPWorksException {
        this.sendOption((byte)-2, (byte)n);
    }

    void setWillOption(int n) throws IPWorksException {
        this.sendOption((byte)-5, (byte)n);
    }

    void setWontOption(int n) throws IPWorksException {
        this.sendOption((byte)-4, (byte)n);
    }

    void setDoSubOption(byte[] byArray) throws IPWorksException {
        this.setDoSubOption(byArray, 0, byArray.length);
    }

    void setDoSubOption(byte[] byArray, int n, int n2) throws IPWorksException {
        this.restart();
        byte[] byArray2 = new byte[]{-1, -6};
        this.setDataToSend(byArray2);
        this.setDataToSend(byArray, n, n2);
        byte[] byArray3 = new byte[]{-1, -16};
        this.setDataToSend(byArray3);
    }

    private void joinToFireWithLastChunk(int n) {
        byte[] byArray = null;
        if (this.toFire != null) {
            byArray = new byte[this.toFire.length + this.len + n];
            System.arraycopy(this.toFire, 0, byArray, 0, this.toFire.length);
            System.arraycopy(this.dataIn, this.start, byArray, this.toFire.length, this.len);
        } else if (this.len + n > 0) {
            byArray = new byte[this.len + n];
            System.arraycopy(this.dataIn, this.start, byArray, 0, this.len);
        }
        this.toFire = byArray;
    }

    private void fireEventualDataIn() {
        this.joinToFireWithLastChunk(0);
        if (this.toFire != null) {
            this.fireDataIn(this.toFire);
            this.toFire = null;
        }
    }

    void fireDataIn(byte[] byArray, boolean bl) {
        this.len = 0;
        this.start = 0;
        this.toFire = null;
        this.dataIn = byArray;
        int n = 0;
        while (n < byArray.length) {
            if (this.transparent) {
                byte[] byArray2 = new byte[byArray.length - this.start];
                System.arraycopy(byArray, this.start, byArray2, 0, byArray2.length);
                this.fireDataIn(byArray2);
                return;
            }
            byte by = byArray[n];
            switch (this.waitingFor) {
                case 1: {
                    if (by == -1) {
                        this.waitingFor = 2;
                        break;
                    }
                    ++this.len;
                    break;
                }
                case 2: {
                    if (by == -1) {
                        this.joinToFireWithLastChunk(1);
                        this.toFire[this.toFire.length - 1] = -1;
                        this.start = n + 1;
                        this.len = 0;
                        this.waitingFor = 1;
                        break;
                    }
                    this.fireEventualDataIn();
                    if (by == -3) {
                        this.waitingFor = 5;
                        break;
                    }
                    if (by == -2) {
                        this.waitingFor = 6;
                        break;
                    }
                    if (by == -5) {
                        this.waitingFor = 7;
                        break;
                    }
                    if (by == -4) {
                        this.waitingFor = 8;
                        break;
                    }
                    if (by == -6) {
                        this.waitingFor = 3;
                        break;
                    }
                    this.fireCommand(by);
                    this.waitingFor = 1;
                    break;
                }
                case 5: {
                    this.fireDoDo(by);
                    this.start = n + 1;
                    this.len = 0;
                    this.waitingFor = 1;
                    break;
                }
                case 6: {
                    this.fireDont(by);
                    this.start = n + 1;
                    this.len = 0;
                    this.waitingFor = 1;
                    break;
                }
                case 7: {
                    this.fireWill(by);
                    this.start = n + 1;
                    this.len = 0;
                    this.waitingFor = 1;
                    break;
                }
                case 8: {
                    this.fireWont(by);
                    this.start = n + 1;
                    this.len = 0;
                    this.waitingFor = 1;
                    break;
                }
                case 3: {
                    if (by == -1) {
                        this.waitingFor = 4;
                        break;
                    }
                    ++this.len;
                    break;
                }
                case 4: {
                    if (by == -1) {
                        this.joinToFireWithLastChunk(1);
                        this.toFire[this.toFire.length - 1] = -1;
                        this.waitingFor = 3;
                        break;
                    }
                    if (by == -16) {
                        this.joinToFireWithLastChunk(0);
                        if (this.toFire != null) {
                            this.fireSubOption(this.toFire);
                            this.toFire = null;
                        }
                        this.start = n + 1;
                        this.len = 0;
                        this.waitingFor = 1;
                        break;
                    }
                    this.fireError(new IPWorksException(4001));
                    return;
                }
            }
            ++n;
        }
        this.fireEventualDataIn();
    }

    void fireCommand(int n) {
        if (this.sink != null) {
            this.sink.fireCommand(n);
        }
    }

    void fireConnected(IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireConnected(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireConnected(0, "OK");
            }
        }
    }

    void fireDataIn(byte[] byArray) {
        if (this.sink != null) {
            this.sink.fireDataIn(byArray);
        }
    }

    void fireDisconnected(IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireDisconnected(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireDisconnected(0, "OK");
            }
        }
    }

    void fireDoDo(int n) {
        if (this.sink != null) {
            this.sink.fireDoDo(n);
        }
    }

    void fireDont(int n) {
        if (this.sink != null) {
            this.sink.fireDont(n);
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }

    void fireReadyToSend() {
        super.fireReadyToSend();
        if (this.sink != null) {
            this.sink.fireReadyToSend();
        }
    }

    void fireSubOption(byte[] byArray) {
        if (this.sink != null) {
            this.sink.fireSubOption(byArray);
        }
    }

    void fireWill(int n) {
        if (this.sink != null) {
            this.sink.fireWill(n);
        }
    }

    void fireWont(int n) {
        if (this.sink != null) {
            this.sink.fireWont(n);
        }
    }
}

