/*
 * Decompiled with CFR 0.152.
 */
package ipworks;

import ipworks.CHTTP;
import ipworks.CMIME;
import ipworks.Http;
import ipworks.IPWorksException;
import ipworks.Webupload;
import java.io.File;

class CWebUpload
extends CHTTP {
    private static final int IDLE = 0;
    private static final int UPLOAD = 1;
    private static final int RESET = 2;
    private int action = 0;
    private String[] formVarNames = new String[0];
    private String[] formVarValues = new String[0];
    private String[] fileVarNames = new String[0];
    private String[] fileVarValues = new String[0];
    private int formVarCount;
    private int fileVarCount;
    protected CMIME mime;
    private Webupload sink;

    CWebUpload(Webupload webupload, Object object) {
        super((Http)null, object);
        this.sink = webupload;
        this.mime = new CMIME(null, object);
    }

    void do_AddFileVar(String string, String string2) throws IPWorksException {
        int n = this.getFileCount() + 1;
        this.setFileCount(n);
        this.setFileVarNames(n, string);
        this.setFileNames(n, string2);
    }

    void do_AddFormVar(String string, String string2) throws IPWorksException {
        int n = this.getFormVarCount() + 1;
        this.setFormVarCount(n);
        this.setFormVarNames(n, string);
        this.setFormVarValues(n, string2);
    }

    void do_Interrupt() throws IPWorksException {
        this.setAction(0);
    }

    void do_Reset() throws IPWorksException {
        this.setAction(2);
    }

    void do_Upload() throws IPWorksException {
        this.setAction(1);
    }

    void do_UploadTo(String string) throws IPWorksException {
        this.setURL(string);
        this.setAction(1);
    }

    private void checkFileIndex(int n) throws IPWorksException {
        if (n < 0 || n >= this.fileVarNames.length) {
            throw new IPWorksException(158);
        }
    }

    void setFileCount(int n) {
        int n2 = n < 0 ? 0 : n;
        String[] stringArray = this.fileVarNames;
        String[] stringArray2 = this.fileVarValues;
        Object object = this.syncObj;
        synchronized (object) {
            this.fileVarNames = new String[n2];
            this.fileVarValues = new String[n2];
            if (n2 > stringArray.length) {
                n2 = stringArray.length;
            }
            while (n2-- > 0) {
                this.fileVarNames[n2] = stringArray[n2];
                this.fileVarValues[n2] = stringArray2[n2];
            }
        }
    }

    int getFileCount() {
        return this.fileVarNames.length;
    }

    void setFileVarNames(int n, String string) throws IPWorksException {
        --n;
        Object object = this.syncObj;
        synchronized (object) {
            this.checkFileIndex(n);
            this.fileVarNames[n] = string;
        }
    }

    String getFileVarNames(int n) throws IPWorksException {
        this.checkFileIndex(--n);
        return this.fileVarNames[n];
    }

    void setFileNames(int n, String string) throws IPWorksException {
        --n;
        Object object = this.syncObj;
        synchronized (object) {
            this.checkFileIndex(n);
            this.fileVarValues[n] = string;
        }
    }

    String getFileNames(int n) throws IPWorksException {
        this.checkFileIndex(--n);
        return this.fileVarValues[n];
    }

    private void checkFormIndex(int n) throws IPWorksException {
        if (n < 0 || n >= this.formVarNames.length) {
            throw new IPWorksException(159);
        }
    }

    void setFormVarCount(int n) {
        int n2 = n < 0 ? 0 : n;
        String[] stringArray = this.formVarNames;
        String[] stringArray2 = this.formVarValues;
        Object object = this.syncObj;
        synchronized (object) {
            this.formVarNames = new String[n2];
            this.formVarValues = new String[n2];
            if (n2 > stringArray.length) {
                n2 = stringArray.length;
            }
            while (n2-- > 0) {
                this.formVarNames[n2] = stringArray[n2];
                this.formVarValues[n2] = stringArray2[n2];
            }
        }
    }

    int getFormVarCount() {
        return this.formVarNames.length;
    }

    void setFormVarNames(int n, String string) throws IPWorksException {
        --n;
        Object object = this.syncObj;
        synchronized (object) {
            this.checkFormIndex(n);
            this.formVarNames[n] = string;
        }
    }

    String getFormVarNames(int n) throws IPWorksException {
        this.checkFormIndex(--n);
        return this.formVarNames[n];
    }

    void setFormVarValues(int n, String string) throws IPWorksException {
        --n;
        Object object = this.syncObj;
        synchronized (object) {
            this.checkFormIndex(n);
            this.formVarValues[n] = string;
        }
    }

    String getFormVarValues(int n) throws IPWorksException {
        this.checkFormIndex(--n);
        return this.formVarValues[n];
    }

    int getAction() {
        return this.action;
    }

    void setAction(int n) throws IPWorksException {
        this.setWUAction(n);
    }

    /*
     * Loose catch block
     */
    private void setWUAction(int n) throws IPWorksException {
        if (n == 0) {
            this.interrupt();
            return;
        }
        Object object = this.syncObj;
        synchronized (object) {
            if (this.action != 0) {
                throw new IPWorksException(532);
            }
            this.restart();
            this.action = n;
        }
        switch (n) {
            case 2: {
                this.setFormVarCount(0);
                this.setFileCount(0);
                super.setAction(4);
                break;
            }
            case 1: {
                this.mime.setAction(5);
                int n2 = this.getFormVarCount();
                int n3 = this.getFileCount();
                this.mime.setPartCount(n2 + n3);
                int n4 = 0;
                while (n4 < n2) {
                    this.mime.setPartDecodedString(n4, this.formVarValues[n4].getBytes());
                    this.mime.setPartEncoding(n4, 0);
                    this.mime.setPartHeaders(n4, "Content-Disposition: form-data; name=\"" + this.formVarNames[n4] + "\"" + "\r\n");
                    ++n4;
                }
                int n5 = 0;
                while (n5 < n3) {
                    this.mime.setPartDecodedFile(n2 + n5, this.fileVarValues[n5]);
                    this.mime.setPartContentDisposition(n2 + n5, "form-data");
                    this.mime.setPartContentType(n2 + n5, "application/octet-stream");
                    this.mime.setPartEncoding(n2 + n5, 4);
                    this.mime.setPartHeaders(n5, "Content-Disposition: form-data; name=\"" + this.fileVarNames[n5] + "\"; filename=\"" + this.fileVarValues[n5] + "\"" + "\r\n" + "Content-Type: application/octet-stream" + "\r\n");
                    ++n5;
                }
                if (this.mime.getPartCount() < 2) {
                    this.mime.setPartCount(2);
                }
                this.mime.setMessage("wup.tmp".getBytes());
                this.mime.setAction(3);
                this.setContentType("multipart/form-data; boundary=\"" + this.mime.getBoundary() + "\"");
                this.setAttachedFile("wup.tmp");
                this.setPostData("\r\n\r\n".getBytes());
                super.setAction(2);
            }
        }
        Object var8_9 = null;
        try {
            new File("wup.tmp").delete();
        }
        catch (SecurityException object2) {
            // empty catch block
        }
        object2 = this.syncObj;
        synchronized (object2) {
            this.action = 0;
            if (this.pendingException != null) {
                if (this.pendingException.getCode() == 201) {
                    try {
                        this.setConnected(false, 0L);
                    }
                    catch (IPWorksException iPWorksException) {
                        // empty catch block
                    }
                }
                throw this.pendingException;
            }
        }
        {
            catch (IPWorksException iPWorksException) {
                if (this.pendingException == null) {
                    this.pendingException = iPWorksException;
                }
                Object var8_10 = null;
                try {
                    new File("wup.tmp").delete();
                }
                catch (SecurityException object3) {
                    // empty catch block
                }
                object3 = this.syncObj;
                synchronized (object3) {
                    this.action = 0;
                    if (this.pendingException != null) {
                        if (this.pendingException.getCode() == 201) {
                            try {
                                this.setConnected(false, 0L);
                            }
                            catch (IPWorksException iPWorksException2) {
                                // empty catch block
                            }
                        }
                        throw this.pendingException;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {
                new File("wup.tmp").delete();
            }
            catch (SecurityException object4) {
                // empty catch block
            }
            object4 = this.syncObj;
            synchronized (object4) {
                this.action = 0;
                if (this.pendingException != null) {
                    if (this.pendingException.getCode() == 201) {
                        try {
                            this.setConnected(false, 0L);
                        }
                        catch (IPWorksException iPWorksException) {
                            // empty catch block
                        }
                    }
                    throw this.pendingException;
                }
            }
            throw throwable;
        }
    }

    void fireConnected(IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireConnected(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireConnected(0, "OK");
            }
        }
    }

    void fireDisconnected(IPWorksException iPWorksException) {
        if (this.sink != null) {
            if (iPWorksException != null) {
                this.sink.fireDisconnected(iPWorksException.getCode(), iPWorksException.getMessage());
            } else {
                this.sink.fireDisconnected(0, "OK");
            }
        }
    }

    void fireError(IPWorksException iPWorksException) {
        if (this.sink != null) {
            this.sink.fireError(iPWorksException.getCode(), iPWorksException.getMessage());
        }
    }

    void fireHeader(String string, String string2) {
        if (this.sink != null) {
            this.sink.fireHeader(string, string2);
        }
    }

    void fireSetCookie(String string, String string2, String string3, String string4, String string5, boolean bl) {
        if (this.sink != null) {
            this.sink.fireSetCookie(string, string2, string3, string4, string5, bl);
        }
    }

    void fireStartTransfer(int n) {
        if (n == 0 && this.sink != null && this.pendingException == null) {
            this.sink.fireUploadProgress(0);
        }
        if (n == 1 && this.sink != null && this.pendingException == null) {
            this.sink.fireStartTransfer();
        }
    }

    void fireTransfer(int n, int n2, byte[] byArray) {
        if (n == 1 && this.sink != null && this.pendingException == null) {
            this.sink.fireTransfer(n2, byArray);
        }
    }

    void fireEndTransfer(int n) {
        if (n == 0 && this.sink != null && this.pendingException == null) {
            this.sink.fireUploadProgress(100);
        }
        if (n == 1 && this.sink != null && this.pendingException == null) {
            this.sink.fireEndTransfer();
        }
    }
}

