/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormBindingGroup;
import com.jformdesigner.model.FormBindingVisitor;
import com.jformdesigner.model.FormContainer;
import com.jformdesigner.model.FormLayoutManager;
import java.util.ArrayList;

public class FormRoot
extends FormContainer {
    private static final FormBindingGroup[] EMPTY_BINDING_GROUPS = new FormBindingGroup[0];
    private ArrayList<FormBindingGroup> bindingGroups;

    public FormRoot() {
        super((String)null, new FormLayoutManager(null));
    }

    FormRoot(FormRoot obj, int dummy) {
        super(obj, dummy);
    }

    public Object clone() {
        return new FormRoot(this, 0);
    }

    public int getBindingGroupCount() {
        return this.bindingGroups != null ? this.bindingGroups.size() : 0;
    }

    public FormBindingGroup getBindingGroup(int index) {
        return this.bindingGroups.get(index);
    }

    public FormBindingGroup getBindingGroup(String name) {
        if (this.bindingGroups == null) {
            return null;
        }
        for (FormBindingGroup bindingGroup : this.bindingGroups) {
            if (!name.equals(bindingGroup.getName())) continue;
            return bindingGroup;
        }
        return null;
    }

    public FormBindingGroup[] getBindingGroups() {
        return this.bindingGroups != null ? this.bindingGroups.toArray(new FormBindingGroup[this.bindingGroups.size()]) : EMPTY_BINDING_GROUPS;
    }

    public int getBindingGroupIndex(FormBindingGroup bindingGroup) {
        return this.bindingGroups.indexOf(bindingGroup);
    }

    public void addBindingGroup(FormBindingGroup bindingGroup) {
        this.addBindingGroup(bindingGroup, -1);
    }

    public void addBindingGroup(FormBindingGroup bindingGroup, int index) {
        if (this.bindingGroups == null) {
            this.bindingGroups = new ArrayList();
        }
        if (index < 0 || index == this.bindingGroups.size()) {
            index = this.bindingGroups.size();
            this.bindingGroups.add(bindingGroup);
        } else {
            this.bindingGroups.add(index, bindingGroup);
        }
        bindingGroup.setRoot(this);
        if (this.model != null && this.model.eventProvider != null) {
            this.model.eventProvider.fireBindingGroupAdded(this, bindingGroup, index);
        }
    }

    public void removeBindingGroup(FormBindingGroup bindingGroup) {
        if (this.bindingGroups == null) {
            return;
        }
        int index = this.bindingGroups.indexOf(bindingGroup);
        if (index >= 0) {
            this.removeBindingGroup(index);
        }
    }

    public void removeBindingGroup(int index) {
        if (this.bindingGroups == null) {
            return;
        }
        FormBindingGroup bindingGroup = this.bindingGroups.remove(index);
        bindingGroup.setRoot(null);
        if (this.model != null && this.model.eventProvider != null) {
            this.model.eventProvider.fireBindingGroupRemoved(this, bindingGroup, index);
        }
    }

    public boolean accept(FormBindingVisitor visitor) {
        if (this.bindingGroups == null) {
            return true;
        }
        int count = this.bindingGroups.size();
        for (int i = 0; i < count; ++i) {
            if (this.bindingGroups.get(i).accept(visitor)) continue;
            return false;
        }
        return true;
    }

    void updateReferences(String oldName, String newName) {
        super.updateReferences(oldName, newName);
        if (this.bindingGroups != null) {
            int count = this.bindingGroups.size();
            for (int i = 0; i < count; ++i) {
                this.bindingGroups.get(i).updateReferences(oldName, newName);
            }
        }
    }
}

