/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.runtime.AbstractLayoutCreator;
import com.jformdesigner.runtime.ComponentProvider;
import com.jformdesigner.runtime.FormCreator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jdesktop.layout.GroupLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupLayoutCreator
extends AbstractLayoutCreator {
    private static final int PADDING_SEPARATE = 1234;
    private static final int PADDING_SEPARATE_VALUE = 18;

    @Override
    public LayoutManager createLayoutManager(Container container, FormLayoutManager formLayout) throws InstantiationException, IllegalAccessException {
        boolean autocreateContainerGaps = formLayout.getPropertyBoolean("autocreateContainerGaps", false);
        boolean autocreateGaps = formLayout.getPropertyBoolean("autocreateGaps", false);
        boolean honorsVisibility = formLayout.getPropertyBoolean("honorsVisibility", true);
        GroupLayout layout = new GroupLayout(container);
        layout.setAutocreateContainerGaps(autocreateContainerGaps);
        layout.setAutocreateGaps(autocreateGaps);
        layout.setHonorsVisibility(honorsVisibility);
        return layout;
    }

    @Override
    public void addComponentToContainer(Container container, Component component, Object constraints, int index, FormLayoutConstraints formConstraints) {
    }

    @Override
    public void finishLayoutInitialization(Container container, FormLayoutManager formLayout) {
        String horizontalGroup = formLayout.getPropertyString("$horizontalGroup", "");
        String verticalGroup = formLayout.getPropertyString("$verticalGroup", "");
        FormCreator componentProvider = this.getFormCreator();
        HashMap<String, ArrayList<String>> hLinkSizeGroups = new HashMap<String, ArrayList<String>>();
        HashMap<String, ArrayList<String>> vLinkSizeGroups = new HashMap<String, ArrayList<String>>();
        GroupLayout layout = (GroupLayout)container.getLayout();
        layout.setHorizontalGroup(GroupLayoutCreator.composeHorizontalGroup(layout, horizontalGroup, componentProvider, hLinkSizeGroups));
        layout.setVerticalGroup(GroupLayoutCreator.composeVerticalGroup(layout, verticalGroup, componentProvider, vLinkSizeGroups));
        GroupLayoutCreator.composeLinks(layout, hLinkSizeGroups, 1, componentProvider);
        GroupLayoutCreator.composeLinks(layout, vLinkSizeGroups, 2, componentProvider);
    }

    public static GroupLayout.Group composeHorizontalGroup(GroupLayout layout, String str, ComponentProvider componentProvider, Map<String, ArrayList<String>> linkSizeGroups) {
        return GroupLayoutCreator.composeGroups(layout, str, componentProvider, true, linkSizeGroups);
    }

    public static GroupLayout.Group composeVerticalGroup(GroupLayout layout, String str, ComponentProvider componentProvider, Map<String, ArrayList<String>> linkSizeGroups) {
        return GroupLayoutCreator.composeGroups(layout, str, componentProvider, false, linkSizeGroups);
    }

    private static GroupLayout.Group composeGroups(GroupLayout layout, String str, ComponentProvider componentProvider, boolean isHorizontal, Map<String, ArrayList<String>> linkSizeGroups) {
        GroupLayout.Group rootGroup = null;
        String[] rootTokens = GroupLayoutCreator.toTokens(str, ';');
        for (int i = rootTokens.length - 1; i >= 0; --i) {
            GroupLayout.Group group = GroupLayoutCreator.composeGroup(layout, null, rootTokens[i], componentProvider, isHorizontal, true, true, linkSizeGroups);
            if (rootGroup == null) {
                rootGroup = group;
                continue;
            }
            if (!(rootGroup instanceof GroupLayout.ParallelGroup)) {
                GroupLayout.ParallelGroup parallelGroup = layout.createParallelGroup();
                parallelGroup.add(rootGroup);
                rootGroup = parallelGroup;
            }
            ((GroupLayout.ParallelGroup)rootGroup).add(group);
        }
        return rootGroup;
    }

    private static GroupLayout.Group composeGroup(GroupLayout layout, GroupLayout.Group parentGroup, String str, ComponentProvider componentProvider, boolean isHorizontal, boolean first, boolean last, Map<String, ArrayList<String>> linkSizeGroups) {
        GroupLayout.SequentialGroup group = null;
        String[] tokens = GroupLayoutCreator.toTokens(str, ' ');
        if (tokens.length == 0) {
            return layout.createSequentialGroup();
        }
        String token0 = tokens[0];
        boolean isParallel = "par".equals(token0);
        boolean isSequential = "seq".equals(token0);
        if (isParallel || isSequential) {
            String[] attrs;
            int attrIndex;
            int groupAlignment = 1;
            int alignment = 1;
            boolean resizable = true;
            int tokenIndex = 1;
            if (tokenIndex < tokens.length && !tokens[tokenIndex].startsWith("{") && (attrIndex = 0) < (attrs = GroupLayoutCreator.toTokens(tokens[tokenIndex++], ':')).length) {
                if (isParallel) {
                    groupAlignment = GroupLayoutCreator.decodeAlignment(attrs[attrIndex++]);
                }
                if (attrIndex < attrs.length) {
                    alignment = GroupLayoutCreator.decodeAlignment(attrs[attrIndex++]);
                    if (++attrIndex < attrs.length) {
                        resizable = GroupLayoutCreator.decodeSize(attrs[attrIndex++]) != -2;
                    }
                }
            }
            Object object = group = isParallel ? layout.createParallelGroup(groupAlignment, resizable) : layout.createSequentialGroup();
            if (tokenIndex < tokens.length) {
                String token = tokens[tokenIndex++];
                assert (token.startsWith("{"));
                assert (token.endsWith("}"));
                String[] subGroups = GroupLayoutCreator.toTokens(token.substring(1, token.length() - 1), ',');
                for (int i = 0; i < subGroups.length; ++i) {
                    boolean isLast = last && (!isSequential || i == subGroups.length - 1);
                    GroupLayoutCreator.composeGroup(layout, (GroupLayout.Group)group, subGroups[i].trim(), componentProvider, isHorizontal, first, isLast, linkSizeGroups);
                    if (!first || !isSequential) continue;
                    first = false;
                }
            }
            if (parentGroup != null) {
                if (parentGroup instanceof GroupLayout.SequentialGroup) {
                    ((GroupLayout.SequentialGroup)parentGroup).add((GroupLayout.Group)group);
                } else {
                    ((GroupLayout.ParallelGroup)parentGroup).add(alignment, (GroupLayout.Group)group);
                }
            }
        } else {
            String compId = null;
            int alignment = 1;
            int paddingType = 0;
            int minimumSize = -1;
            int preferredSize = -1;
            int maximumSize = -1;
            String[] attrs = tokens.length > 1 ? GroupLayoutCreator.toTokens(tokens[1], ':') : null;
            int attrIndex = 0;
            if ("comp".equals(token0)) {
                compId = attrs[attrIndex++];
                if (attrIndex < attrs.length) {
                    String linkSizeId;
                    if ((linkSizeId = attrs[attrIndex++]) != null) {
                        ArrayList<String> compIDs = linkSizeGroups.get(linkSizeId);
                        if (compIDs == null) {
                            compIDs = new ArrayList();
                            linkSizeGroups.put(linkSizeId, compIDs);
                        }
                        compIDs.add(compId);
                    }
                    if (attrIndex < attrs.length) {
                        alignment = GroupLayoutCreator.decodeAlignment(attrs[attrIndex++]);
                    }
                }
            } else if ("space".equals(token0)) {
                if (attrIndex < attrs.length) {
                    paddingType = GroupLayoutCreator.decodePaddingType(attrs[attrIndex++]);
                }
            } else {
                throw new IllegalArgumentException();
            }
            boolean explicitMinimumSize = false;
            boolean explicitPreferredSize = false;
            if (attrIndex < attrs.length) {
                explicitMinimumSize = attrs[attrIndex] != null;
                minimumSize = GroupLayoutCreator.decodeSize(attrs[attrIndex++]);
                if (attrIndex < attrs.length) {
                    explicitPreferredSize = attrs[attrIndex] != null;
                    preferredSize = GroupLayoutCreator.decodeSize(attrs[attrIndex++]);
                    if (attrIndex < attrs.length) {
                        maximumSize = GroupLayoutCreator.decodeSize(attrs[attrIndex++]);
                    }
                    if (preferredSize != -1 && preferredSize < 0) {
                        preferredSize = -1;
                    }
                }
            }
            if (parentGroup == null) {
                parentGroup = layout.createSequentialGroup();
                group = parentGroup;
            }
            if (compId != null) {
                Component comp = componentProvider.getComponent(compId);
                if (!explicitMinimumSize) {
                    if (isHorizontal && comp.getClass().getName().equals("javax.swing.JComboBox")) {
                        minimumSize = 0;
                    } else if (preferredSize >= 0) {
                        int dimMin;
                        Dimension dim = comp.getMinimumSize();
                        int n = dimMin = isHorizontal ? dim.width : dim.height;
                        if (dimMin > preferredSize) {
                            minimumSize = -2;
                        }
                    }
                }
                if (parentGroup instanceof GroupLayout.SequentialGroup) {
                    ((GroupLayout.SequentialGroup)parentGroup).add(comp, minimumSize, preferredSize, maximumSize);
                } else {
                    ((GroupLayout.ParallelGroup)parentGroup).add(alignment, comp, minimumSize, preferredSize, maximumSize);
                }
            } else if (!explicitMinimumSize || !explicitPreferredSize) {
                GroupLayout.SequentialGroup seqGroup = (GroupLayout.SequentialGroup)parentGroup;
                if (first || last) {
                    seqGroup.addContainerGap(preferredSize, maximumSize);
                } else if (paddingType == 0 || paddingType == 1) {
                    seqGroup.addPreferredGap(paddingType, preferredSize, maximumSize);
                } else if (paddingType == 1234) {
                    if (preferredSize == -1) {
                        preferredSize = 18;
                    }
                    if (maximumSize == -1) {
                        maximumSize = 18;
                    }
                    seqGroup.add(18, preferredSize, maximumSize);
                }
            } else {
                if (minimumSize < 0) {
                    minimumSize = preferredSize;
                }
                minimumSize = Math.min(minimumSize, preferredSize);
                maximumSize = Math.max(maximumSize, preferredSize);
                if (parentGroup instanceof GroupLayout.SequentialGroup) {
                    ((GroupLayout.SequentialGroup)parentGroup).add(minimumSize, preferredSize, maximumSize);
                } else {
                    ((GroupLayout.ParallelGroup)parentGroup).add(minimumSize, preferredSize, maximumSize);
                }
            }
        }
        return group;
    }

    private static int decodeAlignment(String str) {
        if (str == null) {
            return 1;
        }
        if (str.length() == 1) {
            switch (str.charAt(0)) {
                case 'l': {
                    return 1;
                }
                case 't': {
                    return 2;
                }
                case 'c': {
                    return 4;
                }
                case 'b': {
                    return 3;
                }
            }
        }
        return 1;
    }

    private static int decodeSize(String str) {
        if (str == null) {
            return -1;
        }
        if (str.length() == 1) {
            switch (str.charAt(0)) {
                case 'd': {
                    return -1;
                }
                case 'p': {
                    return -2;
                }
                case 'x': {
                    return Short.MAX_VALUE;
                }
            }
        }
        return Integer.parseInt(str);
    }

    private static int decodePaddingType(String str) {
        if (str == null) {
            return 0;
        }
        if (str.length() == 1) {
            switch (str.charAt(0)) {
                case 'u': {
                    return 1;
                }
                case 's': {
                    return 1234;
                }
                case 'i': {
                    return 3;
                }
            }
        }
        return 0;
    }

    private static void composeLinks(GroupLayout layout, Map<String, ArrayList<String>> linkSizeGroups, int axis, ComponentProvider componentProvider) {
        if (linkSizeGroups.isEmpty()) {
            return;
        }
        for (ArrayList<String> compIDs : linkSizeGroups.values()) {
            Component[] comps = new Component[compIDs.size()];
            for (int i = 0; i < comps.length; ++i) {
                comps[i] = componentProvider.getComponent(compIDs.get(i));
            }
            layout.linkSize(comps, axis);
        }
    }

    public static String[] toTokens(String str, char sep) {
        if (str == null || str.length() == 0) {
            return new String[0];
        }
        int tokenCount = 1;
        int depth = 0;
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == sep && depth == 0) {
                ++tokenCount;
                continue;
            }
            if (ch == '{') {
                ++depth;
                continue;
            }
            if (ch != '}') continue;
            --depth;
        }
        if (tokenCount == 1) {
            return new String[]{str};
        }
        int tokenIndex = 0;
        int beginIndex = 0;
        String[] tokens = new String[tokenCount];
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == sep && depth == 0) {
                if (i > beginIndex) {
                    tokens[tokenIndex] = str.substring(beginIndex, i);
                }
                ++tokenIndex;
                beginIndex = i + 1;
                continue;
            }
            if (ch == '{') {
                ++depth;
                continue;
            }
            if (ch != '}') continue;
            --depth;
        }
        if (beginIndex < length) {
            tokens[tokenIndex] = str.substring(beginIndex);
        }
        return tokens;
    }
}

