/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.runtime.AlignmentUtil;
import java.util.StringTokenizer;

public class TableSpec {
    public static final int CENTER = 0;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BOTTOM = 3;
    public static final int RIGHT = 4;
    public static final int FILL = 5;
    public static final int DEFAULT_ALIGN = 5;
    public static final double DEFAULT_SIZE = -2.0;
    private int defaultAlignment;
    private double size;

    public TableSpec() {
        this(5, -2.0);
    }

    public TableSpec(int defaultAlignment, double size) {
        this.defaultAlignment = defaultAlignment;
        this.size = size;
    }

    public TableSpec(String encodedDescription) {
        this();
        int alignment;
        StringTokenizer st = new StringTokenizer(encodedDescription, ":");
        if (!st.hasMoreTokens()) {
            throw new IllegalArgumentException(encodedDescription);
        }
        int tokenCount = st.countTokens();
        String token = st.nextToken();
        if (tokenCount >= 2 && (alignment = AlignmentUtil.toValue(token)) >= 0) {
            this.defaultAlignment = alignment;
            token = st.nextToken();
        }
        this.size = token.equals("fill") ? -1.0 : (token.equals("pref") ? -2.0 : (token.equals("min") ? -3.0 : Double.parseDouble(token)));
    }

    public int getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public double getSize() {
        return this.size;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.defaultAlignment != 5) {
            buf.append(AlignmentUtil.toName(this.defaultAlignment));
            buf.append(':');
        }
        if (this.size == -1.0) {
            buf.append("fill");
        } else if (this.size == -2.0) {
            buf.append("pref");
        } else if (this.size == -3.0) {
            buf.append("min");
        } else {
            buf.append(this.size);
        }
        return buf.toString();
    }

    public static String toString(int alignment) {
        return AlignmentUtil.toName(alignment);
    }

    public static TableSpec[] decodeSpecs(String encodedSpecs) {
        if (encodedSpecs == null) {
            return new TableSpec[0];
        }
        StringTokenizer st = new StringTokenizer(encodedSpecs, ", ");
        TableSpec[] specs = new TableSpec[st.countTokens()];
        for (int i = 0; i < specs.length; ++i) {
            specs[i] = new TableSpec(st.nextToken());
        }
        return specs;
    }

    public static String encodeSpecs(TableSpec[] specs) {
        StringBuffer buf = new StringBuffer(specs.length * 9);
        for (int i = 0; i < specs.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(specs[i].toString());
        }
        return buf.toString();
    }
}

