/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormModel;
import com.jformdesigner.runtime.FormLoader$ContextClassLoader;
import com.jformdesigner.runtime.FormLoader$ContextGetter;
import com.jformdesigner.runtime.FormLoader$FileHeaderInputStream;
import com.jformdesigner.runtime.FormLoader$JFDMLException;
import com.jformdesigner.runtime.MultiException;
import com.jformdesigner.runtime.V1FilterInputStream;
import com.jformdesigner.runtime.XMLExceptionListener;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.FactoryConfigurationError;

public class FormLoader {
    private FormLoader() {
    }

    public static FormModel load(String string) {
        ClassLoader classLoader = FormLoader.class.getClassLoader();
        try {
            Class<?>[] classArray;
            InputStream inputStream = classLoader.getResourceAsStream(string);
            if (inputStream == null && (classLoader = (classArray = new FormLoader$ContextGetter(null).getClassContext())[2].getClassLoader()) != FormLoader.class.getClassLoader()) {
                inputStream = classLoader.getResourceAsStream(string);
            }
            return FormLoader.load(inputStream, classLoader);
        }
        catch (MultiException multiException) {
            throw multiException.getExceptions()[0];
        }
    }

    public static FormModel load(String string, ClassLoader classLoader) {
        try {
            return FormLoader.load(classLoader.getResourceAsStream(string), classLoader);
        }
        catch (MultiException multiException) {
            throw multiException.getExceptions()[0];
        }
    }

    public static FormModel load(File file) {
        return FormLoader.load(new FileInputStream(file));
    }

    public static FormModel load(InputStream inputStream) {
        try {
            return FormLoader.load(inputStream, null);
        }
        catch (MultiException multiException) {
            throw multiException.getExceptions()[0];
        }
    }

    public static FormModel load(InputStream inputStream, ClassLoader classLoader) {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream is null.");
        }
        if (!(inputStream instanceof ByteArrayInputStream) && !(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        inputStream = new V1FilterInputStream(inputStream);
        FormLoader$FileHeaderInputStream formLoader$FileHeaderInputStream = new FormLoader$FileHeaderInputStream(inputStream);
        inputStream = formLoader$FileHeaderInputStream;
        Thread thread = Thread.currentThread();
        ClassLoader classLoader2 = null;
        if (classLoader != null) {
            classLoader2 = thread.getContextClassLoader();
            thread.setContextClassLoader(new FormLoader$ContextClassLoader(classLoader, classLoader2));
        }
        try {
            XMLExceptionListener xMLExceptionListener = new XMLExceptionListener();
            XMLDecoder xMLDecoder = new XMLDecoder(inputStream, null, xMLExceptionListener);
            Object object = xMLDecoder.readObject();
            xMLDecoder.close();
            Exception[] exceptionArray = xMLExceptionListener.getExceptions();
            if (exceptionArray != null) {
                throw new MultiException("Failed to decode.", exceptionArray);
            }
            FormModel formModel = (FormModel)object;
            if (classLoader != null) {
                formModel.set_ClassLoader(classLoader);
            }
            formModel.fileHeader = formLoader$FileHeaderInputStream.getFileHeader();
            FormModel formModel2 = formModel;
            return formModel2;
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new MultiException("Failed to decode.", new Exception[]{new InvocationTargetException(factoryConfigurationError)});
        }
        catch (FormLoader$JFDMLException formLoader$JFDMLException) {
            throw new MultiException("Form is in JFDML format and requires JFormDesigner 5.1 or later.", new Exception[0]);
        }
        finally {
            if (classLoader != null) {
                thread.setContextClassLoader(classLoader2);
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

